/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import jeus.tool.builder.inspector.mbean.JEUSManagerInsp;
import jeus.tool.builder.resource.ImgRscManager;

public class JEUSListCellRenderer
extends DefaultListCellRenderer {
    private static Icon bootIcon;
    private static Icon downIcon;
    private static Font selectionFont;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        if (isSelected) {
            this.setBackground(this.getSelectionBackground());
            this.setForeground(this.getSelectionForeground());
            if (selectionFont == null) {
                Font f = list.getFont();
                selectionFont = new Font(f.getFamily(), 1, f.getSize());
            }
            this.setFont(selectionFont);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setFont(list.getFont());
        }
        JEUSManagerInsp insp = (JEUSManagerInsp)value;
        if (insp.isBoot()) {
            this.setIcon(bootIcon);
        } else {
            this.setIcon(downIcon);
        }
        this.setText(insp.getName());
        this.setEnabled(list.isEnabled());
        this.setBorder(noFocusBorder);
        return this;
    }

    public Color getSelectionBackground() {
        return Color.decode("#597FBF");
    }

    public Color getSelectionForeground() {
        return Color.WHITE;
    }

    static {
        try {
            bootIcon = ImgRscManager.getImageIcon("/jeus/tool/resource/image/mbean/node_running.gif");
            downIcon = ImgRscManager.getImageIcon("/jeus/tool/resource/image/mbean/node_stopped.gif");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

