/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.tree;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jeus.management.enterprise.agent.MEJBUtility;
import jeus.tool.builder.inspector.mbean.BaseMBeanInspector;
import jeus.tool.builder.inspector.mbean.JEUSManagerInsp;
import jeus.tool.builder.inspector.mbean.MBeanInspector;
import jeus.tool.builder.inspector.mbean.MBeanInspectorUtils;
import jeus.tool.builder.inspector.mbean.ModuleMBeanInspector;
import jeus.tool.builder.resource.MsgRscManager;
import jeus.tool.builder.tree.JEUSList;
import jeus.tool.builder.tree.JEUSTreeCellRenderer;
import jeus.tool.builder.tree.JEUSTreeListener;
import jeus.tool.builder.tree.JEUSTreeNode;

public class JEUSTree
extends JTree
implements ActionListener {
    private JMenuItem start;
    private JMenuItem stop;
    private JMenuItem undeploy;
    private JMenuItem refresh;

    public JEUSTree(MBeanInspector insp) {
        this.setMBeanInspector(insp, false);
        this.setCellRenderer(new JEUSTreeCellRenderer());
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JEUSTree.this.handlePopupTrigger(e.getX(), e.getY());
                }
            }
        });
        this.start = new JMenuItem(MsgRscManager.getString("menu.popup.item.start"));
        this.stop = new JMenuItem(MsgRscManager.getString("menu.popup.item.stop"));
        this.undeploy = new JMenuItem(MsgRscManager.getString("menu.popup.item.undeploy"));
        this.refresh = new JMenuItem(MsgRscManager.getString("menu.popup.item.refresh"));
        this.start.addActionListener(this);
        this.stop.addActionListener(this);
        this.undeploy.addActionListener(this);
        this.refresh.addActionListener(this);
    }

    private void setMBeanInspector(MBeanInspector insp, boolean repaint) {
        JEUSTreeNode root = new JEUSTreeNode(insp);
        this.setModel(new DefaultTreeModel(root));
        if (repaint) {
            this.repaint();
        }
    }

    public void setMBeanInspector(MBeanInspector insp) {
        this.setMBeanInspector(insp, true);
    }

    public void addJEUSTreeListener(JEUSTreeListener lsnr) {
        this.listenerList.add(JEUSTreeListener.class, lsnr);
    }

    public void removeJEUSTreeListener(JEUSTreeListener lsnr) {
        this.listenerList.remove(JEUSTreeListener.class, lsnr);
    }

    public void fireStartModule(ObjectName objectName) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JEUSTreeListener.class) continue;
            ((JEUSTreeListener)listeners[i + 1]).startModule(objectName);
        }
    }

    public void fireStopModule(ObjectName objectName) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JEUSTreeListener.class) continue;
            ((JEUSTreeListener)listeners[i + 1]).stopModule(objectName);
        }
    }

    public void fireUndeployModule(ObjectName objectName) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != JEUSTreeListener.class) continue;
            ((JEUSTreeListener)listeners[i + 1]).undeployModule(objectName);
        }
    }

    private void handlePopupTrigger(int x, int y) {
        TreePath treePath = this.getClosestPathForLocation(x, y);
        if (treePath == null) {
            return;
        }
        this.setSelectionPath(treePath);
        JEUSTreeNode treeNode = (JEUSTreeNode)treePath.getLastPathComponent();
        this.showPopupMenu(treeNode, x, y);
    }

    private void showPopupMenu(JEUSTreeNode node, int x, int y) {
        JPopupMenu popup = new JPopupMenu();
        MBeanInspector insp = node.getMBeanInspector();
        if (insp instanceof ModuleMBeanInspector) {
            ModuleMBeanInspector minsp = (ModuleMBeanInspector)insp;
            ObjectName objectName = minsp.getObjectName();
            this.start.setEnabled(true);
            this.stop.setEnabled(true);
            this.undeploy.setEnabled(true);
            switch (minsp.getState().getState()) {
                case 1: {
                    this.start.setEnabled(false);
                    break;
                }
                case 3: {
                    this.stop.setEnabled(false);
                    break;
                }
                case 4: {
                    this.start.setEnabled(false);
                    this.stop.setEnabled(false);
                }
            }
            popup.add(this.start);
            popup.add(this.stop);
            if (minsp.getModuleType().equals(ModuleType.EAR) || objectName.getKeyProperty("J2EEApplication").equals("null")) {
                popup.add(this.undeploy);
            }
            popup.addSeparator();
        }
        popup.add(this.refresh);
        popup.show(this, x, y);
    }

    public void actionPerformed(ActionEvent e) {
        TreePath path;
        Object source = e.getSource();
        if (source == this.refresh) {
            this.refreshSelectedNode();
        }
        if ((path = this.getSelectionPath()) == null) {
            return;
        }
        JEUSTreeNode node = (JEUSTreeNode)path.getLastPathComponent();
        MBeanInspector insp = node.getMBeanInspector();
        if (insp instanceof ModuleMBeanInspector) {
            ObjectName objectName = ((ModuleMBeanInspector)insp).getObjectName();
            if (source == this.start) {
                this.fireStartModule(objectName);
            } else if (source == this.stop) {
                this.fireStopModule(objectName);
            } else if (source == this.undeploy) {
                this.fireUndeployModule(objectName);
            }
            this.refresh(objectName.getKeyProperty("j2eeType"), objectName.getKeyProperty("name"));
        }
    }

    public void setModel(TreeModel newModel) {
        if (!(newModel instanceof DefaultTreeModel)) {
            throw new UnsupportedOperationException("except for DefualtTreeModel, other tree model is not allowed.");
        }
        super.setModel(newModel);
    }

    public void refresh(JEUSTreeNode node) {
        node.refresh((DefaultTreeModel)this.getModel());
        this.repaint();
    }

    private void refreshSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return;
        }
        JEUSTreeNode node = (JEUSTreeNode)path.getLastPathComponent();
        this.refresh(node);
    }

    public void refresh() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        JEUSTreeNode root = (JEUSTreeNode)model.getRoot();
        this.refresh(root);
    }

    public void refresh(String j2eeType, String name) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        JEUSTreeNode root = (JEUSTreeNode)model.getRoot();
        this.__refresh(root, j2eeType, name);
        this.repaint();
    }

    private void __refresh(JEUSTreeNode node, String j2eeType, String name) {
        if (node.getMBeanInspector() instanceof BaseMBeanInspector) {
            BaseMBeanInspector insp = (BaseMBeanInspector)node.getMBeanInspector();
            ObjectName objName = insp.getObjectName();
            String _j2eeType = objName.getKeyProperty("j2eeType");
            String _name = objName.getKeyProperty("name");
            if (j2eeType.equals(_j2eeType) && name.equals(_name)) {
                node.refresh((DefaultTreeModel)this.getModel());
                return;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            JEUSTreeNode child = (JEUSTreeNode)node.getChildAt(i);
            this.__refresh(child, j2eeType, name);
        }
    }

    public void refresh(ObjectName objectName) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        JEUSTreeNode root = (JEUSTreeNode)model.getRoot();
        JEUSTreeNode found = null;
        found = this.compareObjectName(objectName, root) ? root : this.findJEUSTreeNode(root, objectName);
        if (found != null) {
            this.refresh(found);
        }
    }

    private boolean compareObjectName(ObjectName objectName, JEUSTreeNode node) {
        BaseMBeanInspector insp;
        return node.getMBeanInspector() instanceof BaseMBeanInspector && (insp = (BaseMBeanInspector)node.getMBeanInspector()).getObjectName().equals(objectName);
    }

    private JEUSTreeNode findJEUSTreeNode(JEUSTreeNode node, ObjectName objectName) {
        int i = 0;
        int cnt = node.getChildCount();
        if (i < cnt) {
            JEUSTreeNode child = (JEUSTreeNode)node.getChildAt(i);
            if (this.compareObjectName(objectName, child)) {
                return child;
            }
            return this.findJEUSTreeNode(child, objectName);
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("jeus.home", "D:/IdeaProjects/projects/jeus5");
        System.setProperty("jeus.baseport", "9736");
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.security.principal", "jeus");
        env.put("java.naming.security.credentials", "jeus");
        env.put("USE_SECURITY_FOR_MEJB_UTILITY", Boolean.TRUE);
        env.put("java.naming.factory.initial", "jeus.jndi.JNSContextFactory");
        MEJBUtility msc = MEJBUtility.getMEJBUtility(env);
        Object[] managers = MBeanInspectorUtils.getAllJEUSManagers((MBeanServerConnection)msc);
        if (managers.length == 0) {
            return;
        }
        final JEUSList list = new JEUSList(managers);
        final JEUSTree tree = new JEUSTree((MBeanInspector)managers[0]);
        tree.addJEUSTreeListener(new JEUSTreeListener(){

            public void startModule(ObjectName objectName) {
                System.err.println("start:" + objectName);
            }

            public void stopModule(ObjectName objectName) {
                System.err.println("stop:" + objectName);
            }

            public void undeployModule(ObjectName objectName) {
                System.err.println("undeploy:" + objectName);
            }
        });
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JEUSManagerInsp insp = (JEUSManagerInsp)list.getSelectedValue();
                tree.setMBeanInspector(insp);
            }
        });
        JFrame frame = new JFrame();
        frame.setSize(400, 600);
        JScrollPane listPane = new JScrollPane(list);
        JScrollPane pane = new JScrollPane(tree);
        JSplitPane split = new JSplitPane(0);
        split.setDividerSize(2);
        split.setTopComponent(listPane);
        split.setBottomComponent(pane);
        frame.getContentPane().add((Component)split, "Center");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.show();
    }
}

