/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jeus.deploy.archivist.AbstractArchive;
import jeus.service.descriptor.DescriptorFile;
import jeus.tool.builder.Constants;
import jeus.tool.builder.util.RuntimeDDAdjuster;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.ChangeHistory;
import jeus.tool.xmlui.util.XMLUtil;
import jeus.xml.util.DomProcessor;
import jeus.xml.util.ElementOrderTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WebserviceDlg
extends JDialog
implements ChangeListener {
    RuntimeDDAdjuster adjuster;
    AbstractArchive assemblyArchive = null;
    String j2eeDDFilePath;
    String jeusDDFilePath;
    DescriptorFile standardWebserviceDescriptor;
    DescriptorFile jeusWebserviceDescriptor;
    Element j2eeElement;
    Element jeusElement;
    XMLUIPanel j2eePanel;
    XMLUIPanel jeusPanel;
    JTabbedPane mainTabPane = new JTabbedPane();
    JPanel btnPanel = new JPanel();
    JButton btnOk = new JButton("Ok");
    JButton btnCancel = new JButton("Cancel");
    private static final String FS = Constants.FS;

    public WebserviceDlg(AbstractArchive assemblyArchive, RuntimeDDAdjuster adjuster, String j2eeDDFilePath, String jeusDDFilePath, DescriptorFile standardWebserviceDescriptor, DescriptorFile jeusWebserviceDescriptor, Element j2eeElement, Element jeusElement, XMLUIPanel j2eePanel, XMLUIPanel jeusPanel) {
        super((Frame)null, true);
        this.adjuster = adjuster;
        this.assemblyArchive = assemblyArchive;
        this.j2eeDDFilePath = j2eeDDFilePath;
        this.jeusDDFilePath = jeusDDFilePath;
        this.standardWebserviceDescriptor = standardWebserviceDescriptor;
        this.jeusWebserviceDescriptor = jeusWebserviceDescriptor;
        this.j2eeElement = j2eeElement;
        this.jeusElement = jeusElement;
        this.j2eePanel = j2eePanel;
        this.jeusPanel = jeusPanel;
        this.setTitle("Webservice");
        this.createGUIAndShow();
    }

    private void createGUIAndShow() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setBounds(330, 320, 640, 510);
        this.btnOk.setMnemonic('O');
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebserviceDlg.this.doOk();
            }
        });
        this.btnCancel.setMnemonic('C');
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebserviceDlg.this.doCancel();
            }
        });
        this.btnPanel.setLayout(new FlowLayout(4));
        this.btnPanel.add(this.btnOk);
        this.btnPanel.add(this.btnCancel);
        this.mainTabPane.add(this.j2eePanel);
        this.mainTabPane.add(this.jeusPanel);
        this.mainTabPane.addChangeListener(this);
        this.getContentPane().add((Component)this.mainTabPane, "Center");
        this.getContentPane().add((Component)this.btnPanel, "South");
    }

    private void doOk() {
        this.updateXML(this.mainTabPane.getSelectedComponent());
        this.writeStandardDescriptor();
        this.writeJeusDescriptor();
        this.dispose();
    }

    private void doCancel() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStandardDescriptor() {
        Document document = this.j2eeElement.getOwnerDocument();
        File file = null;
        FileOutputStream standardFOS = null;
        try {
            String standardFileName = this.assemblyArchive.getArchiveUri() + FS + this.j2eeDDFilePath;
            file = new File(standardFileName);
            standardFOS = new FileOutputStream(file);
            ElementOrderTable t = XMLUtil.getElementOrderTable(document, "http://java.sun.com/xml/ns/j2ee");
            XMLUtil.writeDocument(document, standardFOS, this.standardWebserviceDescriptor, t);
            standardFOS.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (standardFOS != null) {
                    standardFOS.close();
                }
                file = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        DomProcessor.serialize(document, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJeusDescriptor() {
        Document document = this.jeusElement.getOwnerDocument();
        File file = null;
        FileOutputStream jeusFOS = null;
        try {
            String jeusFileName = this.assemblyArchive.getArchiveUri() + FS + this.jeusDDFilePath;
            file = new File(jeusFileName);
            jeusFOS = new FileOutputStream(file);
            ElementOrderTable t = XMLUtil.getElementOrderTable(document, "http://www.tmaxsoft.com/xml/ns/jeus");
            XMLUtil.writeDocument(document, jeusFOS, this.jeusWebserviceDescriptor, t);
            jeusFOS.flush();
            jeusFOS.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (jeusFOS != null) {
                    jeusFOS.close();
                }
                file = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        DomProcessor.serialize(document, System.out);
    }

    public void stateChanged(ChangeEvent e) {
        Component selectedComp = this.mainTabPane.getSelectedComponent();
        if (selectedComp == this.jeusPanel) {
            this.updateXML(this.j2eePanel);
        } else {
            this.updateXML(this.jeusPanel);
        }
    }

    private void updateXML(Component currentComp) {
        if (currentComp == this.j2eePanel) {
            XMLUtil.replaceChildNodes(this.j2eeElement, (Element)this.j2eePanel.getValue());
            try {
                ChangeHistory history = (ChangeHistory)this.j2eePanel.getSession().getAttribute("jeus.tool.xmlui.history");
                history.execute(this.jeusElement.getOwnerDocument());
                this.adjuster.adjust(this.j2eeElement, this.jeusElement);
                this.jeusPanel.setValue(this.jeusElement);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else {
            XMLUtil.replaceChildNodes(this.jeusElement, (Element)this.jeusPanel.getValue());
        }
    }
}

