/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.ui.custom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.enterprise.deploy.shared.ModuleType;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.io.WebservicesDeploymentDescriptorFile;
import jeus.deploy.io.runtime.WebservicesRuntimeDDFile;
import jeus.service.descriptor.DescriptorFile;
import jeus.tool.builder.Constants;
import jeus.tool.builder.JEUSBuilder;
import jeus.tool.builder.module.EmptyDescriptor;
import jeus.tool.builder.ui.DescriptorEditPanel;
import jeus.tool.builder.ui.MessagePanel;
import jeus.tool.builder.ui.WebserviceDlg;
import jeus.tool.builder.util.ArchiveUtil;
import jeus.tool.builder.util.RuntimeDDAdjuster;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.engine.ChangeHistory;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebservicePanel
extends XMLUIComponent
implements FocusListener {
    RuntimeDDAdjuster adjuster;
    AbstractArchive assemblyArchive = null;
    String j2eeDDFilePath = null;
    String jeusDDFilePath = null;
    DescriptorFile standardWebserviceDescriptor = null;
    DescriptorFile jeusWebserviceDescriptor = null;
    Element j2eeElement = null;
    Element jeusElement = null;
    XMLUIPanel j2eePanel;
    XMLUIPanel jeusPanel;
    private static final String FS = Constants.FS;
    private JCheckBox cbEnable = new JCheckBox("");
    private JButton btnWebservice = new JButton("settings...");
    WebserviceDlg webserviceDlg = null;

    public WebservicePanel() {
        this.cbEnable.addFocusListener(this);
        this.btnWebservice.addFocusListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.ipadx = 0;
        constraints.ipady = 5;
        constraints.anchor = 17;
        constraints.fill = 2;
        this.add((Component)this.cbEnable, constraints);
        constraints.insets = new Insets(0, 5, 0, 0);
        constraints.gridx = 1;
        constraints.ipady = 0;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        this.add((Component)this.btnWebservice, constraints);
        this.btnWebservice.setMnemonic('W');
        this.btnWebservice.setEnabled(false);
        this.btnWebservice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebservicePanel.this.showWebserviceDlg();
            }
        });
        this.cbEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebservicePanel.this.setEnableWebservice();
            }
        });
    }

    private void setEnableWebservice() {
        if (this.cbEnable.isSelected()) {
            this.btnWebservice.setEnabled(true);
        } else {
            this.btnWebservice.setEnabled(false);
        }
    }

    private void showWebserviceDlg() {
        if (this.webserviceDlg == null) {
            if (!this.makeWebserviceTabPane()) {
                return;
            }
            this.webserviceDlg = new WebserviceDlg(this.assemblyArchive, this.adjuster, this.j2eeDDFilePath, this.jeusDDFilePath, this.standardWebserviceDescriptor, this.jeusWebserviceDescriptor, this.j2eeElement, this.jeusElement, this.j2eePanel, this.jeusPanel);
        }
        this.webserviceDlg.show();
    }

    private boolean makeWebserviceTabPane() {
        Vector vInfo = DescriptorEditPanel.getCurrentSelectedModuleInfo();
        ModuleType moduleType = (ModuleType)vInfo.elementAt(0);
        String moduleName = (String)vInfo.elementAt(1);
        String embeddedModuleType = (String)vInfo.elementAt(2);
        ModuleType wsModuleType = moduleType;
        if (wsModuleType.equals(ModuleType.EAR)) {
            wsModuleType = "EJBModule".equals(embeddedModuleType) ? ModuleType.EJB : ModuleType.WAR;
        }
        String filename = "META-INF/webservices.xml";
        if (wsModuleType.equals(ModuleType.WAR)) {
            filename = "WEB-INF/webservices.xml";
        }
        this.adjuster = new RuntimeDDAdjuster(JEUSBuilder.dconfsource.getDConfigBeanRootSpecification(wsModuleType, filename));
        InputStream j2eeInputstream = null;
        InputStream jeusInputstream = null;
        try {
            if (moduleType == ModuleType.EAR) {
                String ext = null;
                ext = "EJBModule".equals(embeddedModuleType) ? ".jar" : ".war";
                String archivepath = null;
                AbstractArchive earArchive = ArchiveUtil.getEarArchiveFileArchive();
                Enumeration enum1 = earArchive.entries();
                while (enum1.hasMoreElements()) {
                    String entry = (String)enum1.nextElement();
                    if (!entry.endsWith(moduleName + ext)) continue;
                    archivepath = entry;
                    break;
                }
                String DIR_INF = null;
                this.assemblyArchive = FileArchiveFactory.openArchiveStatic((String)(Constants.JEUS_ASSEMBLY_DIR + FS + archivepath));
                ModuleType tempModuleType = null;
                if ("EJBModule".equals(embeddedModuleType)) {
                    DIR_INF = "META-INF";
                    tempModuleType = ModuleType.EJB;
                } else {
                    DIR_INF = "WEB-INF";
                    tempModuleType = ModuleType.WAR;
                }
                this.j2eeDDFilePath = DIR_INF + FS + "webservices.xml";
                this.jeusDDFilePath = DIR_INF + FS + "jeus-webservices-dd.xml";
                j2eeInputstream = this.assemblyArchive.getEntry(this.j2eeDDFilePath);
                if (j2eeInputstream == null) {
                    EmptyDescriptor.makeJ2eeWebserviceDescriptor(this.assemblyArchive, tempModuleType);
                    j2eeInputstream = this.assemblyArchive.getEntry(this.j2eeDDFilePath);
                }
                if ((jeusInputstream = this.assemblyArchive.getEntry(this.jeusDDFilePath)) == null) {
                    EmptyDescriptor.makeJeusWebserviceDescriptor(this.assemblyArchive, tempModuleType);
                    jeusInputstream = this.assemblyArchive.getEntry(this.jeusDDFilePath);
                }
            } else {
                String DIR_INF = null;
                this.assemblyArchive = ArchiveUtil.getAssemblyFileArchive();
                if (moduleType == ModuleType.EJB) {
                    DIR_INF = "META-INF";
                } else if (moduleType == ModuleType.WAR) {
                    DIR_INF = "WEB-INF";
                }
                this.j2eeDDFilePath = DIR_INF + FS + "webservices.xml";
                this.jeusDDFilePath = DIR_INF + FS + "jeus-webservices-dd.xml";
                j2eeInputstream = this.assemblyArchive.getEntry(this.j2eeDDFilePath);
                if (j2eeInputstream == null) {
                    EmptyDescriptor.makeJ2eeWebserviceDescriptor(this.assemblyArchive, moduleType);
                    j2eeInputstream = this.assemblyArchive.getEntry(this.j2eeDDFilePath);
                }
                if ((jeusInputstream = this.assemblyArchive.getEntry(this.jeusDDFilePath)) == null) {
                    EmptyDescriptor.makeJeusWebserviceDescriptor(this.assemblyArchive, moduleType);
                    jeusInputstream = this.assemblyArchive.getEntry(this.jeusDDFilePath);
                }
            }
            this.standardWebserviceDescriptor = new WebservicesDeploymentDescriptorFile(this.assemblyArchive.getArchiveUri());
            this.jeusWebserviceDescriptor = new WebservicesRuntimeDDFile(this.assemblyArchive.getArchiveUri());
            this.j2eeElement = XMLUtil.getDescriptorElement(this.standardWebserviceDescriptor.getSchemaBasedStream(j2eeInputstream));
            this.jeusElement = XMLUtil.getDescriptorElement(this.jeusWebserviceDescriptor.getSchemaBasedStream(jeusInputstream));
            this.validateDDFiles(this.j2eeElement.getOwnerDocument(), this.jeusElement.getOwnerDocument());
            HashMap<String, ChangeHistory> args = new HashMap<String, ChangeHistory>();
            args.put("jeus.tool.xmlui.history", new ChangeHistory());
            this.j2eePanel = JEUSBuilder.getXMLUIEngine().getXMLUIPanel((Node)this.j2eeElement, "webservices", "/webservices", args);
            this.jeusPanel = JEUSBuilder.getXMLUIEngine().getXMLUIPanel((Node)this.jeusElement, "jeus-webservices-dd", "/jeus-webservices-dd", null);
        }
        catch (Exception ex) {
            MessagePanel.showMessage(ex.getMessage());
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Open Error", 0);
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean validateDDFiles(Document j2eeDocument, Document jeusDocument) throws Exception {
        try {
            XMLUtil.validateDDFile(j2eeDocument, XMLUtil.getElementOrderTable(j2eeDocument, "http://java.sun.com/xml/ns/j2ee"));
        }
        catch (Exception ex) {
            throw new Exception("[ERROR]Openning webservices.xml\n\t" + ex.getMessage());
        }
        try {
            XMLUtil.validateDDFile(jeusDocument, XMLUtil.getElementOrderTable(jeusDocument, "http://www.tmaxsoft.com/xml/ns/jeus"));
        }
        catch (Exception ex) {
            throw new Exception("[ERROR]Openning jeus-webservices-dd.xml\n\t" + ex.getMessage());
        }
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    public JComponent getItemComp() {
        return null;
    }

    public Object getValue() {
        return null;
    }

    public void setValue(Object val) {
    }

    public void resetValue() {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }
}

