/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import jeus.tool.builder.util.ClassFormatException;

public class ClassUtil {
    private static final int BUFSIZE = 8192;
    private static DataInputStream dis;
    private static int this_class_index;
    private static Vector vConstantPool;
    public static final byte CONSTANT_Utf8 = 1;
    public static final byte CONSTANT_Integer = 3;
    public static final byte CONSTANT_Float = 4;
    public static final byte CONSTANT_Long = 5;
    public static final byte CONSTANT_Double = 6;
    public static final byte CONSTANT_Class = 7;
    public static final byte CONSTANT_Fieldref = 9;
    public static final byte CONSTANT_String = 8;
    public static final byte CONSTANT_Methodref = 10;
    public static final byte CONSTANT_InterfaceMethodref = 11;
    public static final byte CONSTANT_NameAndType = 12;
    public static final short ACC_FINAL = 16;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    private int constant_pool_count;

    public static String getClassFilePackageName(File file) throws Throwable {
        return ClassUtil.doWork(file.toString());
    }

    public static String getClassFilePackageName(String file_name) throws Throwable {
        return ClassUtil.doWork(file_name);
    }

    private static String doWork(String file_name) throws Throwable {
        vConstantPool.removeAllElements();
        dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file_name), 8192));
        ClassUtil.readID(file_name);
        ClassUtil.readVersion();
        ClassUtil.readConstantPool();
        ClassUtil.readClassInfo();
        Integer nameIndex = (Integer)vConstantPool.get(this_class_index);
        String className = (String)vConstantPool.get(nameIndex);
        int index = className.lastIndexOf(47);
        String pkgName = className.substring(0, index);
        return pkgName.replace('/', '.');
    }

    private static final void readID(String file_name) throws IOException, ClassFormatException {
        int magic = -889275714;
        if (dis.readInt() != magic) {
            throw new ClassFormatException(file_name + " is not a Java .class file");
        }
    }

    private static final void readVersion() throws IOException, ClassFormatException {
        int minor = dis.readUnsignedShort();
        int major = dis.readUnsignedShort();
    }

    private static final void readConstantPool() throws IOException, ClassFormatException {
        int constant_pool_count = dis.readUnsignedShort();
        vConstantPool.add(null);
        for (int i = 1; i < constant_pool_count; ++i) {
            byte tag = dis.readByte();
            Object item = null;
            switch (tag) {
                case 7: {
                    item = ClassUtil.readUnsignedShort_Once();
                    break;
                }
                case 9: {
                    item = ClassUtil.readUnsignedShort_twice();
                    break;
                }
                case 10: {
                    item = ClassUtil.readUnsignedShort_twice();
                    break;
                }
                case 11: {
                    item = ClassUtil.readUnsignedShort_twice();
                    break;
                }
                case 8: {
                    item = ClassUtil.readUnsignedShort_Once();
                    break;
                }
                case 3: {
                    item = new Integer(dis.readInt());
                    break;
                }
                case 4: {
                    item = new Float(dis.readFloat());
                    break;
                }
                case 5: {
                    item = new Long(dis.readLong());
                    break;
                }
                case 6: {
                    item = new Double(dis.readDouble());
                    break;
                }
                case 12: {
                    item = ClassUtil.readUnsignedShort_twice();
                    break;
                }
                case 1: {
                    item = dis.readUTF();
                }
            }
            vConstantPool.add(item);
            if (tag != 6 && tag != 5) continue;
            vConstantPool.add(null);
            ++i;
        }
    }

    private static Integer readUnsignedShort_Once() throws IOException {
        return new Integer(dis.readUnsignedShort());
    }

    private static Integer[] readUnsignedShort_twice() throws IOException {
        return new Integer[]{new Integer(dis.readUnsignedShort()), new Integer(dis.readUnsignedShort())};
    }

    private static final void readClassInfo() throws IOException, ClassFormatException {
        int access_flags = dis.readUnsignedShort();
        if ((access_flags & 0x200) != 0) {
            access_flags |= 0x400;
        }
        if ((access_flags & 0x400) != 0 && (access_flags & 0x10) != 0) {
            throw new ClassFormatException("Class can't be both final and abstract");
        }
        this_class_index = dis.readUnsignedShort();
        int super_class_index = dis.readUnsignedShort();
    }

    static {
        vConstantPool = new Vector();
    }
}

