/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.wizard.deploy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jeus.tool.builder.deploy.IDeployUnit;
import jeus.tool.builder.inspector.xml.ModuleXMLInspector;
import jeus.tool.builder.inspector.xml.XMLInspector;
import jeus.tool.builder.inspector.xml.XMLInspectorUtils;
import jeus.tool.builder.wizard.WizardEvent;
import jeus.tool.builder.wizard.WizardEventListener;
import jeus.tool.builder.wizard.WizardPanel;
import jeus.tool.builder.wizard.deploy.ModuleTreeCellRenderer;
import jeus.tool.builder.wizard.deploy.ModuleTreeNode;
import jeus.tool.xmlui.XMLUIDialog;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUINotFoundException;
import org.w3c.dom.Element;

public class DescriptorEditPanel
extends JPanel
implements WizardPanel,
WizardEventListener,
TreeSelectionListener,
ChangeListener {
    public static final String ID = "jeus.tool.builder.deploy.edit-descriptor";
    private ModuleXMLInspector insp;
    private XMLUIEngine engine;
    private JSplitPane splitPane = new JSplitPane();
    private JScrollPane treeScrollPane = new JScrollPane();
    private JTree moduleTree = new JTree();
    JTabbedPane configTab = new JTabbedPane();
    private ModuleTreeNode currentNode;
    private TreePath currentSelectionPath;
    private XMLUIPanel currentJ2eePane;
    private XMLUIPanel currentJeusPane;
    private int selectedTabIndex = -1;

    public DescriptorEditPanel(IDeployUnit deployUnit, XMLUIEngine engine) {
        this.insp = XMLInspectorUtils.getModuleXMLInspector(deployUnit);
        this.engine = engine;
        this.initializeUI();
    }

    private void initializeUI() {
        this.moduleTree.setCellRenderer(new ModuleTreeCellRenderer());
        this.moduleTree.setModel(new DefaultTreeModel(new ModuleTreeNode(this.insp), true));
        this.moduleTree.setPreferredSize(new Dimension(200, 0));
        this.moduleTree.setMinimumSize(new Dimension(200, 0));
        this.moduleTree.addTreeSelectionListener(this);
        this.moduleTree.setSelectionRow(0);
        this.currentSelectionPath = this.moduleTree.getSelectionPath();
        this.treeScrollPane.getViewport().add(this.moduleTree);
        this.splitPane.setLeftComponent(this.treeScrollPane);
        this.splitPane.setRightComponent(this.configTab);
        this.splitPane.setDividerSize(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.currentNode = (ModuleTreeNode)this.moduleTree.getModel().getRoot();
        this.updateTab(this.insp);
        if (this.configTab.getTabCount() > 0) {
            this.selectedTabIndex = 0;
        }
    }

    public String getWizardPanelID() {
        return ID;
    }

    public void valueChanged(TreeSelectionEvent e) {
        ModuleTreeNode node = (ModuleTreeNode)e.getPath().getLastPathComponent();
        if (this.currentNode == node) {
            return;
        }
        XMLInspector insp = node.getXMLInspector();
        if (!this.updateXMLTree()) {
            this.moduleTree.setSelectionPath(this.currentSelectionPath);
            return;
        }
        this.selectedTabIndex = -1;
        this.currentNode = node;
        this.currentSelectionPath = this.moduleTree.getSelectionPath();
        this.updateTab(insp);
        this.moduleTree.repaint();
        if (this.configTab.getTabCount() > 0) {
            this.selectedTabIndex = 0;
        }
    }

    private boolean updateXMLTree() {
        Vector message;
        Vector mergedMessages = new Vector();
        Element j2eeElement = null;
        Element jeusElement = null;
        if (this.currentJ2eePane != null) {
            j2eeElement = (Element)this.currentJ2eePane.getValue();
            message = this.currentJ2eePane.getMessage();
            if (message != null && message.size() > 0) {
                mergedMessages.addAll(message);
            }
        }
        if (this.currentJeusPane != null) {
            jeusElement = (Element)this.currentJeusPane.getValue();
            message = this.currentJeusPane.getMessage();
            if (message != null && message.size() > 0) {
                mergedMessages.addAll(message);
            }
        }
        if (mergedMessages.size() > 0) {
            XMLUIDialog dlg = XMLUIDialog.getIgnorableDlg(mergedMessages);
            if (dlg != null) {
                dlg.showDialog();
                return !dlg.getOk();
            }
        } else {
            if (this.currentJ2eePane != null) {
                this.currentNode.getXMLInspector().setJ2eeElement(j2eeElement);
            }
            if (this.currentJeusPane != null) {
                this.currentNode.getXMLInspector().setJeusElement(jeusElement);
            }
        }
        return true;
    }

    private void updateTab(XMLInspector insp) {
        Element jeusTree;
        Element j2eeTree;
        if (this.currentJ2eePane != null) {
            this.configTab.remove(this.currentJ2eePane);
        }
        if ((j2eeTree = insp.getJ2eeElement()) != null) {
            try {
                this.currentJ2eePane = this.engine.getXMLUIPanel(j2eeTree, insp.getJ2eeConfigUIName(), insp.getJ2eeConfigPath());
                this.configTab.add(this.currentJ2eePane.getDisplayName(), this.currentJ2eePane);
            }
            catch (XMLUINotFoundException e1) {
                this.currentJ2eePane = null;
            }
        } else {
            this.currentJ2eePane = null;
        }
        if (this.currentJeusPane != null) {
            this.configTab.remove(this.currentJeusPane);
        }
        if ((jeusTree = insp.getJeusElement()) != null) {
            try {
                this.currentJeusPane = this.engine.getXMLUIPanel(jeusTree, insp.getJeusConfigUIName(), insp.getJeusConfigPath());
                this.configTab.add(this.currentJeusPane.getDisplayName(), this.currentJeusPane);
            }
            catch (XMLUINotFoundException e1) {
                e1.printStackTrace();
                this.currentJeusPane = null;
            }
        } else {
            this.currentJeusPane = null;
        }
        this.configTab.updateUI();
    }

    public void stateChanged(ChangeEvent e) {
        if (this.selectedTabIndex < 0) {
            return;
        }
        XMLUIPanel panel = (XMLUIPanel)this.configTab.getComponentAt(this.selectedTabIndex);
        if (panel == null) {
            return;
        }
        panel.createConfig();
        Vector msg = panel.getMessage();
        if (msg != null && msg.size() > 0) {
            XMLUIDialog dlg = XMLUIDialog.getIgnorableDlg(msg);
            if (dlg != null) {
                dlg.showDialog();
                this.configTab.setSelectedIndex(this.selectedTabIndex);
            }
        } else {
            this.selectedTabIndex = this.configTab.getSelectedIndex();
        }
    }

    public void begin(WizardEvent event) {
    }

    public void cancel(WizardEvent event) {
    }

    public void finish(WizardEvent event) {
    }

    public void previous(WizardEvent event) {
        this.next(event);
    }

    public void next(WizardEvent event) {
        if (!event.getWizardPanelID().equals(ID)) {
            return;
        }
        this.updateXMLTree();
    }

    public XMLInspector getXMLInspector() {
        return this.insp;
    }
}

