/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.builder.wizard.deploy;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import jeus.tool.builder.inspector.xml.XMLInspector;
import org.w3c.dom.Element;

public class ModuleTreeNode
implements MutableTreeNode {
    private XMLInspector insp;
    private ModuleTreeNode parentNode;
    private LinkedList children;

    public ModuleTreeNode(XMLInspector insp) {
        this.insp = insp;
    }

    public ModuleTreeNode(XMLInspector insp, ModuleTreeNode parentNode) {
        this.insp = insp;
        this.parentNode = parentNode;
    }

    public Enumeration children() {
        this.checkChildren();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public TreeNode getChildAt(int childIndex) {
        this.checkChildren();
        return (TreeNode)this.children.get(childIndex);
    }

    public int getChildCount() {
        this.checkChildren();
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        this.checkChildren();
        for (int i = 0; i < this.children.size(); ++i) {
            if (node != this.children.get(i)) continue;
            return i;
        }
        return -1;
    }

    private void checkChildren() {
        if (this.children == null) {
            this.children = new LinkedList();
            XMLInspector[] childInsps = this.insp.getChildren();
            for (int i = 0; i < childInsps.length; ++i) {
                this.children.add(new ModuleTreeNode(childInsps[i], this));
            }
        }
    }

    public TreeNode getParent() {
        return this.parentNode;
    }

    public XMLInspector getXMLInspector() {
        return this.insp;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public void refresh(DefaultTreeModel model) {
        int j;
        boolean found;
        XMLInspector tinsp;
        int i;
        XMLInspector[] childInsps = this.insp.getChildren();
        for (i = this.children.size() - 1; i >= 0; --i) {
            tinsp = ((ModuleTreeNode)this.children.get(i)).getXMLInspector();
            found = false;
            for (j = 0; j < childInsps.length; ++j) {
                if (!childInsps[j].equals(tinsp)) continue;
                found = true;
                break;
            }
            if (found) continue;
            model.removeNodeFromParent((ModuleTreeNode)this.children.get(i));
        }
        for (i = 0; i < childInsps.length; ++i) {
            tinsp = childInsps[i];
            found = false;
            for (j = 0; j < this.children.size(); ++j) {
                XMLInspector myInsp = ((ModuleTreeNode)this.children.get(j)).getXMLInspector();
                if (!myInsp.equals(tinsp)) continue;
                found = true;
                break;
            }
            if (found) continue;
            model.insertNodeInto(new ModuleTreeNode(childInsps[i], this), this, i);
        }
    }

    public void refresh(DefaultTreeModel model, Element newElement) {
        this.insp.setJ2eeElement(newElement);
        this.refresh(model);
    }

    public void removeFromParent() {
        this.parentNode.remove(this);
    }

    public void remove(int index) {
        this.children.remove(index);
    }

    public void setUserObject(Object object) {
        this.insp = (XMLInspector)object;
    }

    public void remove(MutableTreeNode node) {
        this.children.remove(node);
    }

    public void setParent(MutableTreeNode newParent) {
        this.parentNode = (ModuleTreeNode)newParent;
    }

    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
    }

    public boolean equals(Object obj) {
        XMLInspector tinsp = null;
        if (obj instanceof ModuleTreeNode) {
            ModuleTreeNode tnode = (ModuleTreeNode)obj;
            tinsp = tnode.getXMLInspector();
        } else if (obj instanceof XMLInspector) {
            tinsp = (XMLInspector)obj;
        }
        if (tinsp != null) {
            if (tinsp.getType() == null || tinsp.getName() == null) {
                System.err.println(tinsp.getName());
            }
            if (tinsp.getType().equals(this.insp.getType()) && tinsp.getName().equals(this.insp.getName())) {
                return true;
            }
        }
        return false;
    }
}

