/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jeus.tool.common.CancelButtonDialog;

public class MultiCardDialog
extends CancelButtonDialog {
    protected JPanel buttonPane = new JPanel();
    JPanel mainPane = new JPanel();
    JButton cancelBT = new JButton();
    JButton finishBT = new JButton();
    public JButton nextBT = new JButton();
    JButton backBT = new JButton();
    CardLayout cardLayout = new CardLayout();
    private int numOfCard = 0;
    private int currentCard = 0;
    boolean indexManage = false;
    private Dimension dimension = null;

    public MultiCardDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setManageWithIndex(boolean val) {
        this.indexManage = val;
    }

    private void jbInit() throws Exception {
        this.cancelBT.setText("Cancel");
        this.cancelBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiCardDialog.this.cancelBT_actionPerformed(e);
            }
        });
        this.finishBT.setText("Finish");
        this.finishBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiCardDialog.this.finishBT_actionPerformed(e);
            }
        });
        this.enableFinish(false);
        this.buttonPane.setBorder(BorderFactory.createEtchedBorder());
        this.nextBT.setEnabled(false);
        this.nextBT.setText("Next >>");
        this.nextBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiCardDialog.this.nextBT_actionPerformed(e);
            }
        });
        this.backBT.setEnabled(false);
        this.backBT.setText("<< Back");
        this.backBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiCardDialog.this.backBT_actionPerformed(e);
            }
        });
        this.setTitle("Multi Card Dialog");
        this.setModal(true);
        this.mainPane.setLayout(this.cardLayout);
        this.getContentPane().add((Component)this.buttonPane, "South");
        this.buttonPane.add((Component)this.backBT, null);
        this.buttonPane.add((Component)this.nextBT, null);
        this.buttonPane.add((Component)this.cancelBT, null);
        this.buttonPane.add((Component)this.finishBT, null);
        this.getContentPane().add((Component)this.mainPane, "Center");
    }

    public void setDimension(JPanel pane) {
        Dimension newD;
        Dimension d = pane.getPreferredSize();
        if (this.dimension == null) {
            this.dimension = d;
        }
        double width = this.dimension.getWidth();
        double height = this.dimension.getHeight();
        if (this.dimension.getWidth() < d.getWidth()) {
            width = d.getWidth();
        }
        if (this.dimension.getHeight() < d.getHeight()) {
            height = d.getHeight();
        }
        this.dimension = newD = new Dimension((int)width, (int)height);
    }

    void backBT_actionPerformed(ActionEvent e) {
        JPanel currentPane = (JPanel)this.mainPane.getComponent(this.currentCard);
        this.beforeBack(currentPane);
        --this.currentCard;
        currentPane = (JPanel)this.mainPane.getComponent(this.currentCard);
        this.back(currentPane);
        if (!this.indexManage) {
            this.cardLayout.show(this.mainPane, currentPane.getClass().getName());
        } else {
            this.cardLayout.show(this.mainPane, String.valueOf(this.currentCard));
        }
        if (this.currentCard == 0) {
            this.backBT.setEnabled(false);
        }
        if (this.currentCard < this.numOfCard - 1) {
            this.enableFinish(false);
        }
        this.nextBT.setEnabled(true);
    }

    void nextBT_actionPerformed(ActionEvent e) {
        JPanel currentPane = (JPanel)this.mainPane.getComponent(this.currentCard);
        if (!this.beforeNextCheck(currentPane)) {
            return;
        }
        this.beforeNext(currentPane);
        ++this.currentCard;
        currentPane = (JPanel)this.mainPane.getComponent(this.currentCard);
        this.next(currentPane);
        if (!this.indexManage) {
            this.cardLayout.show(this.mainPane, currentPane.getClass().getName());
        } else {
            this.cardLayout.show(this.mainPane, String.valueOf(this.currentCard));
        }
        if (this.currentCard == this.numOfCard - 1) {
            this.nextBT.setEnabled(false);
            this.enableFinish(true);
        }
        this.backBT.setEnabled(true);
    }

    public void addCard(JPanel pane) {
        pane.setPreferredSize(this.dimension);
        if (!this.indexManage) {
            this.mainPane.add((Component)pane, pane.getClass().getName());
        } else {
            this.mainPane.add((Component)pane, String.valueOf(this.numOfCard));
        }
        ++this.numOfCard;
        if (this.numOfCard == 2) {
            this.nextBT.setEnabled(true);
        }
    }

    public void insertCardAt(JPanel pane, int index) {
        if (this.indexManage) {
            return;
        }
        pane.setPreferredSize(this.dimension);
        this.mainPane.add(pane, pane.getClass().getName(), index);
        ++this.numOfCard;
        if (this.numOfCard == 2) {
            this.nextBT.setEnabled(true);
        }
    }

    public void removeCard(JPanel pane) {
        if (this.indexManage) {
            return;
        }
        this.mainPane.remove(pane);
        --this.numOfCard;
        if (this.numOfCard == 1) {
            this.nextBT.setEnabled(false);
        }
    }

    public int getNumOfCard() {
        return this.numOfCard;
    }

    public JPanel getCardAt(int index) {
        return (JPanel)this.mainPane.getComponent(index);
    }

    public int getIndexOfCard(JPanel pane) {
        int index;
        int cardNum = this.getNumOfCard();
        for (index = 0; index < cardNum && !pane.equals(this.getCardAt(index)); ++index) {
        }
        if (index == cardNum) {
            return -1;
        }
        return index;
    }

    public void back(JPanel pane) {
    }

    public void beforeBack(JPanel pane) {
    }

    public void next(JPanel pane) {
    }

    public void beforeNext(JPanel pane) {
    }

    public boolean beforeNextCheck(JPanel pane) {
        return true;
    }

    public void finish() {
    }

    void cancelBT_actionPerformed(ActionEvent e) {
        this.setCanceled();
        this.dispose();
    }

    public void enableFinish(boolean value) {
        this.finishBT.setEnabled(value);
    }

    void finishBT_actionPerformed(ActionEvent e) {
        String message = this.checkInputValidity();
        if (message != null) {
            JOptionPane.showMessageDialog(this, message, "Create Error", 0);
            return;
        }
        this.finish();
        this.setOk();
        this.dispose();
    }

    public String checkInputValidity() {
        return null;
    }
}

