/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml;

import java.util.Enumeration;
import jeus.tool.common.xml.XMLTree;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ConfgParserBase {
    protected void restoreAttributes(Element node, XMLTree xmlTree) {
        Enumeration e = xmlTree.attributes();
        while (e.hasMoreElements()) {
            String attrName = (String)e.nextElement();
            String attrValue = (String)xmlTree.getAttribute(attrName);
            node.setAttribute(attrName, attrValue);
        }
    }

    protected void restoreElements(Element node, XMLTree xmlTree) {
        Enumeration e = xmlTree.elements();
        while (e.hasMoreElements()) {
            XMLTree elementTree = (XMLTree)e.nextElement();
            String elementName = elementTree.getName();
            String elementValue = elementTree.getValue();
            Element elementNode = this.createElement(elementName);
            elementNode.setNodeValue(elementValue);
            this.restoreAttributes(elementNode, elementTree);
            if (elementTree.getElements().isEmpty()) {
                elementNode.appendChild(this.createTextNode(elementValue));
            } else {
                this.restoreElements(elementNode, elementTree);
            }
            node.appendChild(elementNode);
        }
    }

    protected void addAttributes(XMLTree xmlElement, Node node) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                xmlElement.addAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
    }

    protected void addElements(XMLTree xmlElement, Node node) {
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            XMLTree childXMLTree = new XMLTree();
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 8) continue;
            childXMLTree.setName(childNode.getNodeName());
            this.addAttributes(childXMLTree, childNode);
            if (childNode.getNodeType() != 3 && childNode.getNodeType() != 4) {
                this.addElements(childXMLTree, childNode);
                xmlElement.addElement(childXMLTree);
                continue;
            }
            xmlElement.appendValue(childNode.getNodeValue());
        }
    }

    protected abstract Element createElement(String var1);

    protected abstract Text createTextNode(String var1);
}

