/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml;

import java.util.Enumeration;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.schema.ConfigContainer;
import jeus.tool.configui.schema.ConfigExclusiveContainer;
import jeus.tool.configui.schema.ConfigItem;

public class ConfigSchemaConverter
extends XMLConverter {
    public static final String SYSTEM_ID = "jeus-xml.dtd";
    public static final String PUBLIC_ID = "-//Tmax Soft, Inc.//DTD EJB Main Config 1.0//EN";
    public static final String CONFIG_CONTAINER = "ConfigContainer";
    public static final String CONFIG_EXCLUSIVE_CONTAINER = "ConfigExclusiveContainer";
    public static final String CONFIG_ITEM = "ConfigItem";
    public static final String CANDIDATE_VALUE = "CandidateValue";
    public static final String NAME = "Name";
    public static final String DISPLAY_NAME = "DisplayName";
    public static final String MULTI = "Multi";
    public static final String ADVANCED = "Advanced";
    public static final String COMPLEX = "Complex";
    public static final String ITEM_TYPE = "ItemType";
    public static final String DEFAULT_VALUE = "DefaultValue";
    public static final String REQUIRED = "Required";
    public static final String MULTI_DISPLAY_NAME = "MultiDisplayName";
    public static final String MULTI_COLUMN_PARSER = "MultiColumnParser";
    public static final String LAYOUT = "LayOut";
    public static final String SUBLAYOUT = "SubLayOut";
    public static final String SMALL_ICON = "SmallIcon";
    public static final String BIG_ICON = "BigIcon";
    public static final String GENERAL_SMALL_ICON = "GeneralSmallIcon";
    public static final String GENERAL_BIG_ICON = "GeneralBigIcon";
    public static final String CONTAINER_UI_CLASS = "ContainerUIClass";
    public static final String SUB_CONTAINER_UI_CLASS = "SubContainerUIClass";
    public static final String TAB_LISTENER_CLASS = "TabListenerClass";
    public static final String TYPE = "Type";
    public static final String DESCRIPTION = "Description";
    public static final String XML_TYPE = "XMLType";

    public int getType() {
        return -1;
    }

    public String getSystemID() {
        return this.getDTDDir() + SYSTEM_ID;
    }

    public String getPublicID() {
        return PUBLIC_ID;
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        if (!xmlTree.getName().equals(CONFIG_CONTAINER) && !xmlTree.getName().equals(CONFIG_EXCLUSIVE_CONTAINER)) {
            return null;
        }
        ConfigContainer container = null;
        if (xmlTree.getName().equals(CONFIG_CONTAINER)) {
            container = new ConfigContainer();
        } else if (xmlTree.getName().equals(CONFIG_EXCLUSIVE_CONTAINER)) {
            container = new ConfigExclusiveContainer();
        }
        container.setName((String)xmlTree.getAttribute(NAME));
        container.setDisplayName((String)xmlTree.getAttribute(DISPLAY_NAME));
        container.setDescription((String)xmlTree.getAttribute(DESCRIPTION));
        container.setMultiDisplayName((String)xmlTree.getAttribute(MULTI_DISPLAY_NAME));
        container.setMultiColumnParser((String)xmlTree.getAttribute(MULTI_COLUMN_PARSER));
        container.setMulti((String)xmlTree.getAttribute(MULTI));
        container.setComplex((String)xmlTree.getAttribute(COMPLEX));
        container.setRequired((String)xmlTree.getAttribute(REQUIRED));
        container.setAdvanced((String)xmlTree.getAttribute(ADVANCED));
        container.setType((String)xmlTree.getAttribute(TYPE));
        container.setContainerUIClass((String)xmlTree.getAttribute(CONTAINER_UI_CLASS));
        container.setSubContainerUIClass((String)xmlTree.getAttribute(SUB_CONTAINER_UI_CLASS));
        container.setLayOut((String)xmlTree.getAttribute(LAYOUT));
        container.setSubLayOut((String)xmlTree.getAttribute(SUBLAYOUT));
        container.setSmallIcon((String)xmlTree.getAttribute(SMALL_ICON));
        container.setBigIcon((String)xmlTree.getAttribute(BIG_ICON));
        container.setGeneralSmallIcon((String)xmlTree.getAttribute(GENERAL_SMALL_ICON));
        container.setGeneralBigIcon((String)xmlTree.getAttribute(GENERAL_BIG_ICON));
        container.setTabListenerClass((String)xmlTree.getAttribute(TAB_LISTENER_CLASS));
        Enumeration itemEnum = xmlTree.elements(CONFIG_ITEM);
        while (itemEnum.hasMoreElements()) {
            XMLTree itemTree = (XMLTree)itemEnum.nextElement();
            ConfigItem citem = new ConfigItem();
            citem.setName((String)itemTree.getAttribute(NAME));
            citem.setDisplayName((String)itemTree.getAttribute(DISPLAY_NAME));
            citem.setDescription((String)itemTree.getAttribute(DESCRIPTION));
            citem.setMulti((String)itemTree.getAttribute(MULTI));
            citem.setItemType((String)itemTree.getAttribute(ITEM_TYPE));
            citem.setDefaultValue((String)itemTree.getAttribute(DEFAULT_VALUE));
            citem.setRequired((String)itemTree.getAttribute(REQUIRED));
            String xmlType = (String)itemTree.getAttribute(XML_TYPE);
            if (xmlType != null) {
                citem.setXmlType(xmlType);
            }
            Enumeration candidateEnum = itemTree.elements(CANDIDATE_VALUE);
            while (candidateEnum.hasMoreElements()) {
                XMLTree candidateTree = (XMLTree)candidateEnum.nextElement();
                citem.addCandidateValue(candidateTree.getValue());
            }
            container.addConfigItem(citem);
        }
        Enumeration containerEnum = xmlTree.elements(CONFIG_CONTAINER);
        while (containerEnum.hasMoreElements()) {
            XMLTree containerTree = (XMLTree)containerEnum.nextElement();
            ConfigContainer cConfig = (ConfigContainer)this.getUserObject(containerTree);
            container.addConfigContainer(cConfig);
        }
        Enumeration containerExclusiveEnum = xmlTree.elements(CONFIG_EXCLUSIVE_CONTAINER);
        while (containerExclusiveEnum.hasMoreElements()) {
            XMLTree containerExclusiveTree = (XMLTree)containerExclusiveEnum.nextElement();
            ConfigContainer cConfig = (ConfigContainer)this.getUserObject(containerExclusiveTree);
            container.addConfigContainer(cConfig);
        }
        return container;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }
}

