/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBException;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLDocTypeHolder;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;

public abstract class XMLConverter {
    public static final char fsc = System.getProperty("file.separator").charAt(0);
    public static final String DTD_DIR = "/config/dtds/";
    public static final String ERROR1 = "setting required";
    public static final String ERROR2 = "wrong type of value";
    public static final String ERROR3 = "setting duplicated";

    public Object load(String fileName) throws Exception {
        File file = new File(fileName);
        return this.load(file);
    }

    public String getDTDDir() {
        return "http://www.tmaxsoft.com/tmax/forum/DTD/3.1/";
    }

    public Object constructJAXBObject(XMLTree xmlTree) throws JAXBException, IOException {
        return null;
    }

    public Object constructJAXBObject(XMLTree[] xmlTrees) throws JAXBException, IOException {
        return null;
    }

    public Object constructJAXBObjectFromDesc(Object oldDesc) throws JAXBException {
        return null;
    }

    public Object load(File xmlFile) throws Exception {
        try {
            FileInputStream in = new FileInputStream(xmlFile);
            XMLUtil xmlUtil = new XMLUtil();
            boolean validate = WIOParameters.XML_VALIDATION;
            XMLTree xmlTree = xmlUtil.process((InputStream)in, validate, this.getPublicID(), this.getSystemID(), this.getType());
            XMLDocTypeHolder.putPublicID(xmlFile.getPath(), xmlTree.getPublicID());
            XMLDocTypeHolder.putSystemID(xmlFile.getPath(), xmlTree.getSystemID());
            return this.getUserObject(xmlTree);
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg == null || msg.trim().equals("")) {
                ex.printStackTrace();
            } else {
                System.out.println(msg);
            }
            return null;
        }
    }

    public XMLTree loadXMLTree(File xmlFile) throws Exception {
        try {
            FileInputStream in = new FileInputStream(xmlFile);
            XMLUtil xmlUtil = new XMLUtil();
            boolean validate = WIOParameters.XML_VALIDATION;
            XMLTree xmlTree = xmlUtil.process((InputStream)in, validate, this.getPublicID(), this.getSystemID(), this.getType());
            XMLDocTypeHolder.putPublicID(xmlFile.getPath(), xmlTree.getPublicID());
            XMLDocTypeHolder.putSystemID(xmlFile.getPath(), xmlTree.getSystemID());
            return xmlTree;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object load(InputStream in) throws Exception {
        XMLUtil xmlUtil = new XMLUtil();
        boolean validate = WIOParameters.XML_VALIDATION;
        XMLTree xmlTree = xmlUtil.process(in, validate, this.getPublicID(), this.getSystemID(), this.getType());
        return this.getUserObject(xmlTree);
    }

    public void save(String fileName, Object object) throws Exception {
        File file = new File(fileName);
        this.save(file, object);
    }

    public void save(File xmlFile, Object object) throws Exception {
        XMLTree xmlTree = this.constructXMLTree(object);
        XMLUtil xmlUtil = new XMLUtil();
        String publicID = XMLDocTypeHolder.getPublicID(xmlFile.getPath());
        String systemID = XMLDocTypeHolder.getSystemID(xmlFile.getPath());
        if (publicID == null) {
            publicID = this.getPublicID();
        }
        if (systemID == null) {
            systemID = this.getSystemID();
        }
        xmlUtil.generate(xmlTree, publicID, systemID);
        File parentFile = xmlFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        xmlFile.createNewFile();
        FileOutputStream os = new FileOutputStream(xmlFile);
        xmlUtil.write(os);
        os.flush();
        ((OutputStream)os).close();
    }

    public void save(File xmlFile, Object object, boolean forceDefaultID) throws Exception {
        XMLTree xmlTree = this.constructXMLTree(object);
        XMLUtil xmlUtil = new XMLUtil();
        String publicID = this.getPublicID();
        String systemID = this.getSystemID();
        xmlUtil.generate(xmlTree, publicID, systemID);
        File parentFile = xmlFile.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        xmlFile.createNewFile();
        FileOutputStream os = new FileOutputStream(xmlFile);
        xmlUtil.write(os);
        os.flush();
        ((OutputStream)os).close();
    }

    public abstract String getPublicID();

    public abstract String getSystemID();

    public abstract Object getUserObject(XMLTree var1) throws XMLConverterException;

    public abstract XMLTree constructXMLTree(Object var1);

    public abstract int getType();
}

