/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.common.xml.wrappers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import jeus.apache.xerces.dom.DOMImplementationImpl;
import jeus.apache.xerces.parsers.DOMParser;
import jeus.apache.xml.serialize.OutputFormat;
import jeus.apache.xml.serialize.XMLSerializer;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.ConfgParserBase;
import jeus.tool.common.xml.ConfgParserWrapper;
import jeus.tool.common.xml.JeusXMLErrorHandler;
import jeus.tool.common.xml.XMLTree;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ConfgParserJeus
extends ConfgParserBase
implements ConfgParserWrapper {
    Document doc = null;

    public XMLTree parse(InputSource is, boolean validate, int type) throws Exception {
        String finalSystemID;
        String finalPublicID;
        String publicID = WIOParameters.getPublicID(type);
        String systemID = WIOParameters.getSystemID(type);
        String localSystemID = WIOParameters.getLocalSystemID(type);
        String realSystemID = systemID;
        DOMParser domParser = new DOMParser();
        try {
            domParser.setFeature("http://xml.org/sax/features/validation", validate);
            if (validate) {
                if (WIOParameters.LOCAL_DTD_VALIDATION) {
                    domParser.setProperty("JEUS_PARSING_PROPERTY/dtd/publicID", (Object)publicID);
                    domParser.setProperty("JEUS_PARSING_PROPERTY/dtd/systemID", (Object)localSystemID);
                    realSystemID = localSystemID;
                }
                if (WIOParameters.IGNORE_ORDER_VALIDATE) {
                    domParser.setFeature("JEUS_PARSING_PROPERTY/ignore-element-order", true);
                } else {
                    domParser.setFeature("JEUS_PARSING_PROPERTY/ignore-element-order", false);
                }
            }
            domParser.setFeature("http://xml.org/sax/features/namespaces", false);
            domParser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            domParser.setErrorHandler((ErrorHandler)new JeusXMLErrorHandler());
        }
        catch (Exception e) {
            System.out.println("[JspUtil] Error while setting parsing features");
        }
        try {
            domParser.parse(is);
            this.doc = domParser.getDocument();
        }
        catch (Exception e) {
            String systemId = "";
            int lineNumber = -1;
            String message = "";
            String publicId = "";
            int columnNumber = -1;
            if (e instanceof SAXParseException) {
                systemId = ((SAXParseException)e).getSystemId();
                if (systemId == null) {
                    systemId = realSystemID;
                }
                lineNumber = ((SAXParseException)e).getLineNumber();
                message = e.getMessage();
                publicId = ((SAXParseException)e).getPublicId();
                if (publicId == null) {
                    publicId = publicID;
                }
                columnNumber = ((SAXParseException)e).getColumnNumber();
            }
            String msg = "SAXParseException \nline number : " + lineNumber + "\n" + "Validating DTD = " + systemId + "\n" + "msg : " + message;
            throw new SAXParseException(msg, publicId, systemId, lineNumber, columnNumber);
        }
        XMLTree xmlElement = new XMLTree();
        Element element = this.doc.getDocumentElement();
        xmlElement.setName(element.getTagName());
        DocumentType docType = this.doc.getDoctype();
        if (docType != null) {
            finalPublicID = docType.getPublicId() != null ? docType.getPublicId() : publicID;
            finalSystemID = docType.getSystemId() != null ? docType.getSystemId() : systemID;
        } else {
            finalPublicID = publicID;
            finalSystemID = systemID;
        }
        xmlElement.setPublicID(finalPublicID);
        xmlElement.setSystemID(finalSystemID);
        this.addAttributes(xmlElement, element);
        this.addElements(xmlElement, element);
        return xmlElement;
    }

    public XMLTree parse(InputSource is, boolean validate, String publicID, String systemID) throws Exception {
        String finalSystemID;
        String finalPublicID;
        DOMParser domParser = new DOMParser();
        try {
            domParser.setFeature("http://xml.org/sax/features/validation", validate);
            if (validate) {
                if (WIOParameters.LOCAL_DTD_VALIDATION) {
                    domParser.setProperty("JEUS_PARSING_PROPERTY/dtd/publicID", (Object)publicID);
                    domParser.setProperty("JEUS_PARSING_PROPERTY/dtd/systemID", (Object)systemID);
                }
                if (WIOParameters.IGNORE_ORDER_VALIDATE) {
                    domParser.setFeature("JEUS_PARSING_PROPERTY/ignore-element-order", true);
                } else {
                    domParser.setFeature("JEUS_PARSING_PROPERTY/ignore-element-order", false);
                }
            }
            domParser.setFeature("http://xml.org/sax/features/namespaces", false);
            domParser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            domParser.setErrorHandler((ErrorHandler)new JeusXMLErrorHandler());
        }
        catch (Exception e) {
            System.out.println("[JspUtil] Error while setting parsing features");
        }
        try {
            domParser.parse(is);
            this.doc = domParser.getDocument();
        }
        catch (Exception e) {
            String systemId = "";
            int lineNumber = -1;
            String message = "";
            String publicId = "";
            int columnNumber = -1;
            if (e instanceof SAXParseException) {
                systemId = ((SAXParseException)e).getSystemId();
                lineNumber = ((SAXParseException)e).getLineNumber();
                message = e.getMessage();
                publicId = ((SAXParseException)e).getPublicId();
                columnNumber = ((SAXParseException)e).getColumnNumber();
            }
            String msg = "SAXParseException: " + systemId + " : " + lineNumber + "\n  msg : " + message;
            throw new SAXParseException(msg, publicId, systemId, lineNumber, columnNumber);
        }
        XMLTree xmlElement = new XMLTree();
        Element element = this.doc.getDocumentElement();
        xmlElement.setName(element.getTagName());
        DocumentType docType = this.doc.getDoctype();
        if (docType != null) {
            finalPublicID = docType.getPublicId() != null ? docType.getPublicId() : publicID;
            finalSystemID = docType.getSystemId() != null ? docType.getSystemId() : systemID;
        } else {
            finalPublicID = publicID;
            finalSystemID = systemID;
        }
        xmlElement.setPublicID(finalPublicID);
        xmlElement.setSystemID(finalSystemID);
        this.addAttributes(xmlElement, element);
        this.addElements(xmlElement, element);
        return xmlElement;
    }

    public void generate(XMLTree xmlTree, String publicID, String systemID) throws Exception {
        DOMImplementation domImpl = DOMImplementationImpl.getDOMImplementation();
        DocumentType doctype = domImpl.createDocumentType("doctype", publicID, systemID);
        this.doc = domImpl.createDocument(null, xmlTree.getName(), doctype);
        Element root = this.doc.getDocumentElement();
        this.restoreAttributes(root, xmlTree);
        this.restoreElements(root, xmlTree);
    }

    public void generate(XMLTree xmlTree) throws Exception {
        DOMImplementation domImpl = DOMImplementationImpl.getDOMImplementation();
        this.doc = domImpl.createDocument(null, xmlTree.getName(), null);
        Element root = this.doc.getDocumentElement();
        this.restoreAttributes(root, xmlTree);
        this.restoreElements(root, xmlTree);
    }

    public void clear() {
        this.doc = null;
    }

    public void write(OutputStream os) throws IOException {
        if (os == null) {
            os = System.out;
        }
        XMLSerializer xmlSer = new XMLSerializer((Writer)new OutputStreamWriter(os), new OutputFormat("xml", null, true));
        xmlSer.serialize(this.doc);
    }

    protected Text createTextNode(String textNodeName) {
        return this.doc.createTextNode(textNodeName);
    }

    protected Element createElement(String elementName) {
        return this.doc.createElement(elementName);
    }
}

