/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.compiler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.enterprise.deploy.shared.ModuleType;
import jeus.deploy.JeusDeploymentManager;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.InputJarArchive;
import jeus.deploy.io.ApplicationDeploymentDescriptorFile;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.deploy.io.runtime.WebRuntimeDDFile;
import jeus.deploy.util.ModuleTypeResolver;
import jeus.ejb.EJBEngine;
import jeus.ejb.ejbserver.FailedBeanInfo;
import jeus.ejb.util.EJBRootClassLoader;
import jeus.management.j2ee.EJBModule;
import jeus.server.RootClassLoader;
import jeus.server.enginecontainer.EngineContainer;
import jeus.service.archive.ArchiveArrayClassLoader;
import jeus.servlet.jsp2.JspC;
import jeus.tool.ddinit.WEBDDInit;
import jeus.util.JeusRootClassLoader;
import jeus.util.JeusRuntimeException;
import jeus.util.console.AppcompilerConsole;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.file.FileUtils;
import jeus.util.logging.CommanderFormatter;
import jeus.util.logging.FileHandler;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_EJB;
import jeus.util.properties.JeusAppProperties;
import jeus.webservices.api.EWSProvider;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.j2ee.ObjectFactory;
import jeus.xml.binding.j2ee.PathType;
import jeus.xml.binding.j2ee.WebAppType;
import jeus.xml.binding.j2ee.WebType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.EjbComponentType;

public final class AppCompiler {
    private static final String fs = System.getProperty("file.separator");
    private static JeusLogger logger;
    private static EJBModule module;
    private static String clientViewPath;
    private static boolean isKeepGenerated;
    private static boolean isEarApp;
    private static String ejbJarPath;
    private static String jeusEjbDDPath;
    private static boolean isExploded;
    private static boolean isFailed;
    private static boolean isJspMap;

    public static void main(String[] args) {
        File targetFile;
        long time = System.currentTimeMillis();
        try {
            logger = JeusLogger.createDefaultConsoleJeusLogger((String)"jeus");
        }
        catch (Exception e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        JeusRootClassLoader.loader = AppCompiler.class.getClassLoader();
        JeusRootClassLoader.inServer = true;
        JeusRootClassLoader.inModuleCompiler = true;
        Thread.currentThread().setContextClassLoader(JeusRootClassLoader.loader);
        AppcompilerConsole appcompilerConsole = new AppcompilerConsole("appcompiler", "make EJB interface impl and stub classes, jsp servlets and webservice endpoint for application");
        if (args.length == 0) {
            appcompilerConsole.printAppcompilerHelp();
            return;
        }
        try {
            if (!appcompilerConsole.checkArguments(args)) {
                return;
            }
        }
        catch (JeusImproperCommanderException e) {
            logger.directLog(e.getMessage());
            return;
        }
        if (appcompilerConsole.isVerbose()) {
            logger.setLevel(Level.FINEST);
        }
        if (appcompilerConsole.isKeep()) {
            isKeepGenerated = true;
        }
        if (appcompilerConsole.isJspmap()) {
            isJspMap = true;
        }
        clientViewPath = appcompilerConsole.getClientview();
        ejbJarPath = appcompilerConsole.getEjbJarXml();
        jeusEjbDDPath = appcompilerConsole.getJeusEjbDdXml();
        String fileName = appcompilerConsole.getAppFileOrDirName();
        if (fileName == null) {
            logger.directLog("The name of application file or directory is omitted");
            System.exit(1);
        }
        if (!(targetFile = new File(fileName)).exists()) {
            logger.directLog("The filename " + fileName + " does not exist");
            System.exit(1);
        }
        isExploded = targetFile.isDirectory();
        try {
            if (isExploded) {
                FileArchive tempArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((File)targetFile);
                isEarApp = ModuleTypeResolver.getModuleType((AbstractArchive)tempArchive) == ModuleType.EAR;
            } else if (targetFile.getName().endsWith(ModuleType.EAR.getModuleExtension())) {
                isEarApp = true;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(1);
        }
        new EJBEngine();
        try {
            EJBRootClassLoader loader = new EJBRootClassLoader(new URL[0], JeusRootClassLoader.loader, "AppCompiler");
            ((RootClassLoader)JeusRootClassLoader.loader).registerEJBRootClassLoader(loader);
            EngineContainer.rootClassLoader = loader;
        }
        catch (ClassCastException ex) {
            System.out.println("For appcompiler, DO NOT use classpath except bootstrap.jar to aviod this ClassCastException");
            ex.printStackTrace();
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return;
        }
        try {
            module = new EJBModule(null, null);
            module.setCompileOnlyMode(true);
            module.setForcedCompile(true);
            if (logger.isLoggable(JeusMessage_EJB.EJB_32_LEVEL)) {
                logger.log(JeusMessage_EJB.EJB_32_LEVEL, JeusMessage_EJB.EJB_32, (Object)fileName);
            }
            jeus.xml.binding.jeusDD.ObjectFactory of = new jeus.xml.binding.jeusDD.ObjectFactory();
            ApplicationType appType = of.createApplicationType();
            JeusDeploymentManager.setApplicationPath(appType, targetFile.getCanonicalPath());
            appType.getInfoMap().put("absolute-path", targetFile.getAbsolutePath());
            if (isEarApp) {
                module.setDeployType("EAR");
                JeusDeploymentManager.setApplicationDeploymentType(appType, "EAR");
            } else {
                module.setDeployType("COMPONENT");
                JeusDeploymentManager.setApplicationDeploymentType(appType, "COMPONENT");
                appType.getNameAndPathAndDeploymentType().add(of.createApplicationTypeEjbComponent(of.createEjbComponentType()));
            }
            module.setApplicationName(JeusDeploymentManager.getNameFromPath(appType));
            module.setApplicationType(appType);
            if (logger.isLoggable(JeusMessage_EJB.EJB_36_LEVEL)) {
                logger.log(JeusMessage_EJB.EJB_36_LEVEL, JeusMessage_EJB.EJB_36, (Object)String.valueOf(isKeepGenerated));
            }
            if (logger.isLoggable(JeusMessage_EJB.EJB_37_LEVEL)) {
                logger.log(JeusMessage_EJB.EJB_37_LEVEL, JeusMessage_EJB.EJB_37, (Object)String.valueOf(isEarApp));
            }
            if (logger.isLoggable(JeusMessage_EJB.EJB_38_LEVEL)) {
                logger.log(JeusMessage_EJB.EJB_38_LEVEL, JeusMessage_EJB.EJB_38, (Object)ejbJarPath);
            }
            if (logger.isLoggable(JeusMessage_EJB.EJB_39_LEVEL)) {
                logger.log(JeusMessage_EJB.EJB_39_LEVEL, JeusMessage_EJB.EJB_39, (Object)jeusEjbDDPath);
            }
            if (logger.isLoggable(JeusMessage_EJB.EJB_40_LEVEL)) {
                logger.log(JeusMessage_EJB.EJB_40_LEVEL, JeusMessage_EJB.EJB_40, (Object)String.valueOf(isExploded));
            }
            AppCompiler.compile(targetFile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        if (logger.isLoggable(JeusMessage_EJB.EJB_44_LEVEL)) {
            logger.log(JeusMessage_EJB.EJB_44_LEVEL, JeusMessage_EJB.EJB_44, (Object)(System.currentTimeMillis() - time));
        }
    }

    private static void compile(File file) throws Exception {
        String fileName;
        String path = file.getAbsolutePath();
        int pathIndex = path.lastIndexOf(fs);
        if (pathIndex >= 0) {
            fileName = path.substring(pathIndex + 1);
            path = path.substring(0, pathIndex);
        } else {
            fileName = path;
            path = "";
        }
        FileArchive homeArchive = (FileArchive)FileArchiveFactory.openArchiveStatic((String)path);
        String moduleName = isExploded ? fileName : fileName.substring(0, fileName.lastIndexOf("."));
        if (isEarApp) {
            AppCompiler.compileEarApp(homeArchive, fileName, moduleName);
        } else if (!isExploded) {
            if (fileName.toLowerCase().endsWith(".war")) {
                AppCompiler.compileWebWar(fileName, homeArchive, isExploded);
            } else if (fileName.toLowerCase().endsWith(".jar")) {
                AppCompiler.compileEjbJar(fileName, homeArchive, isExploded, "", true);
                AppCompiler.checkFail();
            }
            AppCompiler.deleteWebserviceWar(fileName, homeArchive);
        } else {
            File metainfDir = new File(homeArchive.getArchiveUri() + fs + fileName, "WEB-INF");
            if (metainfDir.exists()) {
                AppCompiler.compileWebWar(fileName, homeArchive, isExploded);
            } else {
                AppCompiler.compileEjbJar(fileName, homeArchive, isExploded, "", true);
                AppCompiler.checkFail();
            }
        }
    }

    private static void compileEarApp(FileArchive homeArchive, String fileName, String moduleName) throws Exception {
        String earTemp = moduleName + "_temp_";
        InputJarArchive earArchive = null;
        FileArchive earFileArchive = null;
        ArchiveArrayClassLoader earClassLoader = null;
        ApplicationType appType = null;
        try {
            if (!isExploded) {
                moduleName = FileUtils.getExtractDirectoryName((String)fileName);
                earArchive = AppCompiler.extractArchivedEarApp(homeArchive, fileName, moduleName, earTemp);
                appType = JeusDeploymentManager.fillApplicationDDInfoFromArchive((AbstractArchive)earArchive, null);
            }
            earFileArchive = (FileArchive)homeArchive.getEmbeddedArchive(moduleName);
            if (isExploded) {
                appType = JeusDeploymentManager.fillApplicationDDInfoFromArchive((AbstractArchive)earFileArchive, null);
            }
            boolean isolated = JeusAppProperties.DEFAULT_CLASSLOADING.equalsIgnoreCase("ISOLATED");
            earClassLoader = AppCompiler.makeEarClassLoaderForEarApp(appType, homeArchive, moduleName, earFileArchive, isolated);
            module.setIsolatedClassloading(isolated);
            module.setAppClassLoader(earClassLoader);
            module.setStandAloneModule(false);
            AppCompiler.compileModules(homeArchive, moduleName, fileName, earArchive, earFileArchive, earTemp, earClassLoader);
        }
        catch (Exception e) {
            block7: {
                if (!isExploded) {
                    try {
                        homeArchive.deleteEntry(moduleName);
                        homeArchive.deleteEntry(earTemp);
                    }
                    catch (IOException ioe) {
                        if (!logger.isLoggable(JeusMessage_EJB.EJB_45_LEVEL)) break block7;
                        logger.log(JeusMessage_EJB.EJB_45_LEVEL, JeusMessage_EJB.EJB_45, (Throwable)ioe);
                    }
                }
            }
            throw e;
        }
    }

    private static InputJarArchive extractArchivedEarApp(FileArchive homeArchive, String fileName, String directory, String earTemp) throws RemoteException {
        InputJarArchive earArchive = null;
        Object moduleName = null;
        try {
            earArchive = homeArchive.getEmbeddedJarArchive(fileName);
            homeArchive.deleteEntry(directory);
            earArchive.extractArchive(homeArchive, directory);
            homeArchive.deleteEntry(earTemp);
            earArchive.extractArchive(homeArchive, earTemp);
            InputJarArchive inputJarArchive = earArchive;
            return inputJarArchive;
        }
        catch (Exception e) {
            throw new RemoteException("Exception occurred", e);
        }
        finally {
            block10: {
                try {
                    if (earArchive != null) {
                        earArchive.close();
                    }
                }
                catch (IOException e) {
                    if (!logger.isLoggable(JeusMessage_EJB.EJB_47_LEVEL)) break block10;
                    logger.log(JeusMessage_EJB.EJB_47_LEVEL, JeusMessage_EJB.EJB_47, (Throwable)e);
                }
            }
        }
    }

    private static ArchiveArrayClassLoader makeEarClassLoaderForEarApp(ApplicationType appType, FileArchive homeArchive, String moduleName, FileArchive earFileArchive, boolean isolated) {
        List modules = null;
        ArrayList classpathArrayList = null;
        ArchiveArrayClassLoader earClassloader = null;
        modules = AppCompiler.getModulesForEarApp(homeArchive, moduleName, earFileArchive);
        classpathArrayList = AppCompiler.makeClasspathForEarApp(appType, modules, homeArchive, moduleName, earFileArchive);
        earClassloader = ArchiveArrayClassLoader.createClassLoader(classpathArrayList.toArray(AbstractArchive.nullArray), EngineContainer.rootClassLoader, isolated, "");
        return earClassloader;
    }

    private static List getModulesForEarApp(FileArchive homeArchive, String moduleName, FileArchive earFileArchive) {
        jeus.xml.binding.j2ee.ApplicationType app;
        ApplicationDeploymentDescriptorFile appDescfile = new ApplicationDeploymentDescriptorFile();
        try {
            if (appDescfile.existsDescriptorFile((AbstractArchive)earFileArchive)) {
                app = (jeus.xml.binding.j2ee.ApplicationType)appDescfile.getDeploymentDescriptor((AbstractArchive)earFileArchive);
            } else {
                app = JeusDeploymentManager.makeApplicationInfo((AbstractArchive)earFileArchive);
                ObjectFactory of = ObjectFactoryHelper.getJ2EEObjectFactory();
                appDescfile.marshalDescriptor((Object)of.createApplication(app), (AbstractArchive)earFileArchive);
            }
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e.getMessage(), (Throwable)e);
        }
        return app.getModule();
    }

    /*
     * Exception decompiling
     */
    private static ArrayList makeClasspathForEarApp(ApplicationType appType, List modules, FileArchive homeArchive, String moduleName, FileArchive earFileArchive) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void deleteTemporaryExtractedModuleDirectoryForEarApp(ArrayList extractedFileArchiveList) {
        boolean isDelete = false;
        if (extractedFileArchiveList == null || extractedFileArchiveList.size() < 1) {
            return;
        }
        for (Object extractedFileArchive : extractedFileArchiveList) {
            isDelete = ((FileArchive)extractedFileArchive).delete();
            if (isDelete || !logger.isLoggable(Level.WARNING)) continue;
            logger.log(Level.WARNING, "Fail to delete the temporary extracted directory \"" + FileUtils.getFileNameFromPath((String)((FileArchive)extractedFileArchive).getArchiveUri()) + "\" of archived modules in EAR application");
        }
    }

    private static void compileModules(FileArchive homeArchive, String moduleName, String fileName, InputJarArchive earArchive, FileArchive earFileArchive, String earTemp, ArchiveArrayClassLoader earClassLoader) throws RemoteException {
        ArrayList changedModuleList = null;
        try {
            changedModuleList = AppCompiler.generateExplodedEarFiles(moduleName, earFileArchive);
            AppCompiler.checkFail();
        }
        catch (Exception e) {
            throw new RemoteException("Exception occurred", e);
        }
        finally {
            if (!isExploded) {
                if (changedModuleList != null && changedModuleList.size() > 0) {
                    AppCompiler.deleteTemporaryFileForArchivedEAR(homeArchive, fileName, earArchive, earFileArchive, changedModuleList, earTemp, earClassLoader);
                }
            } else {
                List moduleList = null;
                moduleList = AppCompiler.getModulesForEarApp(homeArchive, moduleName, earFileArchive);
                AppCompiler.deleteTemporaryFileForExplodedEAR(earFileArchive, moduleList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteTemporaryFileForArchivedEAR(FileArchive homeArchive, String fileName, InputJarArchive earArchive, FileArchive earFileArchive, List changedModuleList, String earTemp, ArchiveArrayClassLoader earClassLoader) {
        block8: {
            try {
                FileArchive tempArchive = (FileArchive)homeArchive.getEmbeddedArchive(earTemp);
                for (Object module : changedModuleList) {
                    String name = (String)module;
                    File subModule = new File(earFileArchive.getArchiveUri() + fs + name);
                    if (subModule.isDirectory()) {
                        FileUtils.copyDirectory((String)(earFileArchive.getArchiveUri() + fs + name), (String)(tempArchive.getArchiveUri() + fs + name));
                        continue;
                    }
                    InputStream is = null;
                    OutputStream os = null;
                    try {
                        is = earFileArchive.getEntry(name);
                        os = tempArchive.addEntry(name);
                        ArchiveHelper.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                        if (os == null) continue;
                        os.close();
                    }
                }
                earArchive.delete();
                tempArchive.jarArchive((AbstractArchive)homeArchive, fileName);
                tempArchive.delete();
                earClassLoader.clear();
                earFileArchive.delete();
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(Level.WARNING)) break block8;
                logger.log(Level.WARNING, "Fail to delete temporary directory : " + module.getModuleUri(), (Throwable)ioe);
            }
        }
    }

    private static void deleteTemporaryFileForExplodedEAR(FileArchive earFileArchive, List moduleList) {
        block6: {
            if (moduleList == null || moduleList.size() < 1) {
                return;
            }
            String moduleUri = "";
            try {
                for (Object module : moduleList) {
                    jeus.xml.binding.j2ee.ModuleType moduleType = (jeus.xml.binding.j2ee.ModuleType)module;
                    PathType modulePath = moduleType.getEjb();
                    if (modulePath != null) {
                        moduleUri = modulePath.getValue();
                        if (!FileUtils.isExploded((String)earFileArchive.getArchiveUri(), (String)moduleUri)) {
                            earFileArchive.deleteEntry(FileUtils.makeFriendlyFileName((String)FileUtils.getPathWithoutExtension((String)moduleUri, (String)".jar")));
                            earFileArchive.deleteEntry(FileUtils.getExtractDirectoryName((String)moduleUri));
                            if (clientViewPath == null) continue;
                            earFileArchive.deleteEntry(FileUtils.makeFriendlyFileName((String)clientViewPath));
                            continue;
                        }
                        earFileArchive.deleteEntry(moduleUri + ".jar");
                        continue;
                    }
                    WebType web = moduleType.getWeb();
                    if (web == null || (modulePath = web.getWebUri()) == null) continue;
                    moduleUri = modulePath.getValue();
                    if (FileUtils.isExploded((String)earFileArchive.getArchiveUri(), (String)moduleUri)) continue;
                    earFileArchive.deleteEntry(FileUtils.getPathWithoutExtension((String)moduleUri, (String)".war"));
                }
            }
            catch (IOException e) {
                if (!logger.isLoggable(JeusMessage_EJB.EJB_46_LEVEL)) break block6;
                logger.log(JeusMessage_EJB.EJB_46_LEVEL, JeusMessage_EJB.EJB_46, (Object)moduleUri, (Throwable)e);
            }
        }
    }

    private static void checkFail() {
        if (isFailed) {
            if (JeusAppProperties.APP_COMPILER_FAILCHECK.equalsIgnoreCase("exception")) {
                throw new RuntimeException("The module compile failed");
            }
            System.exit(1);
        }
    }

    private static void deleteWebserviceWar(String fileName, FileArchive homeArchive) {
        String earDir = homeArchive.getArchiveUri();
        try {
            if (fileName.endsWith(".jar")) {
                String javaFileHome = FileUtils.getPathWithoutExtension((String)fileName, (String)".jar");
                AbstractArchive archive = FileArchiveFactory.openArchiveStatic((String)(earDir + File.separator + javaFileHome + "_ws"));
                archive.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List compileEjbJar(String ejbUriInStandardDd, FileArchive homeFileArchive, boolean isExploded, String reportFilePrefix, boolean isStandaloneEJB) throws Exception {
        int pointIndex = ejbUriInStandardDd.lastIndexOf(46);
        String moduleName = pointIndex >= 0 ? ejbUriInStandardDd.substring(0, pointIndex) : ejbUriInStandardDd;
        String reportFileName = reportFilePrefix + moduleName + "_error.log";
        jeus.xml.binding.jeusDD.ObjectFactory objectFactory = new jeus.xml.binding.jeusDD.ObjectFactory();
        EjbComponentType ejbType = objectFactory.createEjbComponentType();
        ejbType.setClientViewPath(clientViewPath);
        ejbType.setKeepGenerated(Boolean.valueOf(isKeepGenerated));
        ejbType.setEjbJar(ejbJarPath);
        ejbType.setJeusEjbDd(jeusEjbDDPath);
        if (!isStandaloneEJB) {
            module.setAppModuleName(moduleName);
        }
        try {
            FailedBeanInfo[] failedBeanNames = module.compile(ejbType, homeFileArchive, ejbUriInStandardDd);
            if (JeusAppProperties.APP_COMPILER_ERROR_REPORT.equals("true")) {
                FileHandler fileHandler = new FileHandler();
                CommanderFormatter formatter = new CommanderFormatter();
                formatter.setProperty(Collections.EMPTY_MAP);
                fileHandler.setFormatter((Formatter)formatter);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("pattern", reportFileName);
                fileHandler.setProperty(map);
                logger.addHandler((Handler)fileHandler);
                for (FailedBeanInfo failedBeanName : failedBeanNames) {
                    if (logger.isLoggable(JeusMessage_EJB.EJB_48_LEVEL)) {
                        logger.log(JeusMessage_EJB.EJB_48_LEVEL, JeusMessage_EJB.EJB_48, (Object)failedBeanName.getBeanName());
                    }
                    isFailed = true;
                }
                logger.removeHandler((Handler)fileHandler);
            }
        }
        finally {
            if (isStandaloneEJB) {
                if (!isExploded) {
                    homeFileArchive.deleteEntry(FileUtils.getExtractDirectoryName((String)ejbUriInStandardDd));
                    if (clientViewPath != null) {
                        homeFileArchive.deleteEntry(FileUtils.makeFriendlyFileName((String)clientViewPath));
                    }
                } else {
                    String standaloneFileHome = ejbUriInStandardDd + ".jar";
                    homeFileArchive.deleteEntry(standaloneFileHome);
                }
            }
        }
        return module.getAdditionalModuleUris();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compileWebWar(String warFileName, FileArchive homeArchive, boolean isExploded) throws Exception {
        FileArchive rootArchive = null;
        try {
            EWSProvider provider;
            jeus.webservices.spi.EWSProvider provider2;
            String webservices;
            File wsfile;
            String contextDir;
            if (!isExploded) {
                InputJarArchive inputArchive = homeArchive.getEmbeddedJarArchive(warFileName);
                if (inputArchive == null) {
                    throw new JeusRuntimeException("The " + warFileName + " does not exist in the application");
                }
                try {
                    contextDir = FileUtils.getExtractDirectoryName((String)warFileName);
                    homeArchive.deleteEntry(contextDir);
                    inputArchive.extractArchive(homeArchive, contextDir);
                    rootArchive = (FileArchive)homeArchive.getEmbeddedArchive(contextDir);
                }
                finally {
                    inputArchive.close();
                }
            } else {
                contextDir = warFileName;
            }
            contextDir = homeArchive.getArchiveUri() + File.separator + contextDir;
            AbstractArchive archive = FileArchiveFactory.openArchiveStatic((String)contextDir);
            ArrayList<String> argList = new ArrayList<String>();
            String compileMode = JeusAppProperties.APP_COMPILER_MODE;
            if (!"each".equalsIgnoreCase(compileMode)) {
                argList.add("-batchcompile");
            }
            if (isKeepGenerated) {
                argList.add("-keep");
            }
            argList.add("-mode");
            if (isJspMap) {
                argList.add("map");
            } else {
                argList.add("normal");
            }
            argList.add("-exitOnFail");
            argList.add("false");
            argList.add("-ctxroot");
            argList.add(contextDir);
            ClassLoader prevLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (module.getAppClassLoader() != null) {
                    Thread.currentThread().setContextClassLoader(module.getAppClassLoader());
                }
                JspC.main(argList.toArray(new String[argList.size()]));
            }
            finally {
                Thread.currentThread().setContextClassLoader(prevLoader);
            }
            if (!archive.contains("WEB-INF/jeus-web-dd.xml")) {
                WEBDDInit webdd = new WEBDDInit();
                webdd.setContextPath("/" + warFileName);
                webdd.setSourceArchive(archive);
                webdd.writeDescriptor(null, webdd.initJeusDescriptor());
            }
            if ((wsfile = new File(webservices = contextDir + File.separator + "WEB-INF" + File.separator + "webservices.xml")).exists() && (provider2 = jeus.webservices.spi.EWSProvider.getProvider()) != null) {
                if (!archive.contains("WEB-INF/jeus-webservices-dd.xml")) {
                    provider2.writeJeusWebservicesDD(archive);
                }
                provider2.generateService(archive, null, false, isKeepGenerated, null, null);
            }
            WebDeploymentDescriptorFile webXmlFile = new WebDeploymentDescriptorFile();
            WebAppType webApp = (WebAppType)webXmlFile.getDeploymentDescriptor(archive);
            WebRuntimeDDFile webDDFile = new WebRuntimeDDFile(null);
            ContextType webDD = null;
            if (webDDFile.existsDescriptorFile(archive)) {
                webDD = (ContextType)webDDFile.getDeploymentDescriptor(archive);
            }
            if ((provider = EWSProvider.getProvider()) != null) {
                provider.generateWSStub(archive, webApp, webDD, contextDir, false, isKeepGenerated);
            }
            if (!isExploded) {
                FileArchive destArchive = new FileArchive(contextDir);
                destArchive.jarArchive((AbstractArchive)homeArchive, warFileName);
            } else if (isEarApp) {
                try {
                    FileArchive destArchive = new FileArchive(contextDir + "_war");
                    destArchive.delete();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        finally {
            if (!isExploded) {
                rootArchive.delete();
            }
        }
    }

    private static ArrayList generateExplodedEarFiles(String earModuleName, FileArchive earFileArchive) throws Exception {
        ApplicationDeploymentDescriptorFile appFile = new ApplicationDeploymentDescriptorFile();
        jeus.xml.binding.j2ee.ApplicationType app = null;
        try {
            app = (jeus.xml.binding.j2ee.ApplicationType)appFile.getDeploymentDescriptor((AbstractArchive)earFileArchive);
        }
        catch (Exception e) {
            throw new JeusRuntimeException(e.getMessage(), (Throwable)e);
        }
        List modules = app.getModule();
        ArrayList<String> changedModuleList = new ArrayList<String>();
        for (Object module1 : modules) {
            jeus.xml.binding.j2ee.ModuleType moduleType = (jeus.xml.binding.j2ee.ModuleType)module1;
            PathType pathType = moduleType.getEjb();
            if (pathType != null) {
                String ejbUriInStandardDd = pathType.getValue();
                boolean isExplodedEJB = FileUtils.isExploded((String)earFileArchive.getArchiveUri(), (String)ejbUriInStandardDd);
                List additionalModuleList = null;
                additionalModuleList = AppCompiler.compileEjbJar(ejbUriInStandardDd, earFileArchive, isExplodedEJB, earModuleName + "_", false);
                for (Object additionalModule : additionalModuleList) {
                    String module = (String)additionalModule;
                    changedModuleList.add(FileUtils.getFileNameFromPath((String)module));
                }
                changedModuleList.add(ejbUriInStandardDd);
                continue;
            }
            WebType webType = moduleType.getWeb();
            if (webType == null || (pathType = webType.getWebUri()) == null) continue;
            String warFileName = pathType.getValue();
            logger.info("Compiling web module : " + warFileName);
            AppCompiler.compileWebWar(warFileName, earFileArchive, FileUtils.isExploded((String)earFileArchive.getArchiveUri(), (String)warFileName));
            changedModuleList.add(warFileName);
        }
        return changedModuleList;
    }
}

