/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.IColumnParser;
import jeus.tool.configui.schema.ConfigContainer;
import jeus.tool.configui.schema.ConfigItem;

public class DefaultColumnParser
implements IColumnParser {
    private String[] cols;
    private Set empties = new HashSet();
    private static Set AVAILABLE_TYPES = new HashSet();

    public String[] getColumns(ConfigContainer cc) {
        ArrayList<String> columns = new ArrayList<String>();
        ConfigItem[] subItems = cc.getConfigItem();
        for (int i = 0; i < subItems.length; ++i) {
            String itemType;
            if (subItems[i].getName().equals("description") || (itemType = subItems[i].getItemType()) != null && itemType.trim().length() != 0 && !AVAILABLE_TYPES.contains(itemType)) continue;
            columns.add(subItems[i].getName());
            if (itemType == null || !itemType.equals("Empty")) continue;
            this.empties.add(subItems[i].getName());
        }
        if (columns.size() == 0) {
            this.cols = new String[]{null};
            return new String[]{"data"};
        }
        this.cols = columns.toArray(new String[columns.size()]);
        return this.cols;
    }

    public String[] getRow(ConfigContainer cc, XMLTree xmlTree) {
        if (this.cols == null) {
            this.getColumns(cc);
        }
        if (this.cols.length == 1 && this.cols[0] == null) {
            String elementName;
            if (cc != null && (elementName = cc.getMultiDisplayName()) != null) {
                xmlTree.setDisplayItemName(elementName);
            }
            return new String[]{xmlTree.toString()};
        }
        String[] data = new String[this.cols.length];
        for (int i = 0; i < this.cols.length; ++i) {
            String elementName = this.cols[i];
            Vector elements = xmlTree.getElement(elementName);
            if (this.empties.contains(elementName)) {
                if (elements.size() > 0) {
                    data[i] = "true";
                    continue;
                }
                data[i] = "false";
                continue;
            }
            StringBuffer buf = new StringBuffer();
            for (int j = 0; j < elements.size(); ++j) {
                XMLTree element = (XMLTree)elements.get(j);
                buf.append(element.getValue());
                if (j + 1 >= elements.size()) continue;
                buf.append(", ");
            }
            data[i] = buf.toString();
        }
        return data;
    }

    static {
        AVAILABLE_TYPES.add("String");
        AVAILABLE_TYPES.add("Empty");
        AVAILABLE_TYPES.add("Choice");
        AVAILABLE_TYPES.add("Boolean");
        AVAILABLE_TYPES.add("Integer");
    }
}

