/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JTabbedPane;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.ConfigContainerPanel;
import jeus.tool.configui.ConfigPanel;
import jeus.tool.configui.schema.ConfigContainer;

public class DoubleConfigPanel
extends ConfigPanel {
    ConfigContainer configContainer;
    String title;
    String displayName;
    JTabbedPane tabPane;
    ConfigContainerPanel panelA;
    ConfigContainerPanel panelB;

    public DoubleConfigPanel(ConfigContainer anyConfig) {
        this.title = anyConfig.getName();
        this.displayName = anyConfig.getDisplayName() != null && !anyConfig.getDisplayName().trim().equals("") ? anyConfig.getDisplayName() : anyConfig.getName();
        this.configContainer = anyConfig;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        this.tabPane = new JTabbedPane();
        this.panelA = new ConfigContainerPanel(this.configContainer);
        this.panelB = new ConfigContainerPanel(this.configContainer);
        this.tabPane.addTab(this.displayName + " A ", this.panelA);
        this.tabPane.addTab(this.displayName + " B ", this.panelB);
        this.add((Component)this.tabPane, "Center");
    }

    public Object getValue() {
        Vector<Object> treeList = new Vector<Object>();
        treeList.add(this.panelA.getValue());
        treeList.add(this.panelB.getValue());
        return treeList;
    }

    public Vector getMessage() {
        return null;
    }

    public void resetValue() {
        this.panelA.resetValue();
        this.panelB.resetValue();
    }

    public void setValue(Object val) {
        this.resetValue();
        if (val instanceof Vector) {
            Vector valueList = (Vector)val;
            for (int i = 0; i < 2; ++i) {
                XMLTree itemTree = (XMLTree)valueList.get(i);
                if (i == 0) {
                    this.panelA.setValue(itemTree);
                }
                if (i != 1) continue;
                this.panelB.setValue(itemTree);
            }
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

