/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.configui.ConfigPanel;

public class MultiSelectTable
extends ConfigPanel {
    JTable listTable;
    ListTableModel myModel;
    private Hashtable hiddenObjectMap = new Hashtable();

    public MultiSelectTable(Hashtable listWithSelection) {
        Vector<String> candidateValues = new Vector<String>();
        Vector<String> selectedValues = new Vector<String>();
        if (listWithSelection.size() == 0) {
            this.setLayout(new BorderLayout());
            System.out.println("no selection available!!!");
            JLabel myLabel = new JLabel("no selection available");
            this.add((Component)myLabel, "Center");
            return;
        }
        if (listWithSelection != null) {
            Enumeration keyEnum = listWithSelection.keys();
            while (keyEnum.hasMoreElements()) {
                String keyVal = (String)keyEnum.nextElement();
                candidateValues.add(keyVal);
                Boolean selectedVal = (Boolean)listWithSelection.get(keyVal);
                if (!selectedVal.booleanValue()) continue;
                selectedValues.add(keyVal);
            }
        }
        this.listTable = new JTable();
        this.myModel = new ListTableModel(candidateValues);
        this.setTitle("Selection Table");
        try {
            this.listTable.setModel(this.myModel);
            JScrollPane scroll = new JScrollPane(this.listTable);
            scroll.setPreferredSize(new Dimension(200, 200));
            this.setLayout(new BorderLayout());
            Border titleB = BorderFactory.createEmptyBorder(3, 3, 3, 3);
            this.add((Component)scroll, "Center");
            this.myModel.setInitSelection(selectedValues);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public MultiSelectTable(Vector candidateValues) {
        this.listTable = new JTable();
        this.myModel = new ListTableModel(candidateValues);
        this.setTitle("Selection Table");
        try {
            this.listTable.setModel(this.myModel);
            JScrollPane scroll = new JScrollPane(this.listTable);
            scroll.setPreferredSize(new Dimension(200, 200));
            this.setLayout(new BorderLayout());
            JLabel titleLB = new JLabel(" Selection List ");
            Border titleB = BorderFactory.createEmptyBorder(3, 3, 3, 3);
            titleLB.setBorder(titleB);
            this.add((Component)titleLB, "North");
            Border raisedbevel = BorderFactory.createRaisedBevelBorder();
            Border loweredbevel = BorderFactory.createLoweredBevelBorder();
            CompoundBorder empty = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
            scroll.setBorder(empty);
            this.add((Component)scroll, "Center");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Hashtable getHiddenObjectMapping() {
        return this.hiddenObjectMap;
    }

    public void setHiddenObjectMapping(Hashtable table) {
        this.hiddenObjectMap = table;
    }

    public void setCandidateValue(Vector candidateValues) {
        this.myModel.setCandidateValue(candidateValues);
    }

    public Object getValue() {
        return this.myModel.getSelectedValues();
    }

    public void setValue(Object val) {
        if (val instanceof Vector) {
            Vector mySelection = (Vector)val;
            this.myModel.setInitSelection(mySelection);
        }
    }

    public void resetValue() {
        this.myModel.clear();
    }

    public Vector getMessage() {
        return null;
    }

    class ListTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"name", "select"};
        Vector data = null;
        Vector selectionList = null;
        Hashtable candidateValues = new Hashtable();

        public ListTableModel(Vector vals) {
            this.data = new Vector();
            this.selectionList = new Vector();
            if (vals == null) {
                return;
            }
            this.setInit(vals);
        }

        public void setCandidateValue(Vector candidateValues) {
            this.setInit(candidateValues);
            MultiSelectTable.this.repaint();
        }

        public void setInit(Vector vals) {
            Enumeration enum1 = vals.elements();
            int i = 0;
            while (enum1.hasMoreElements()) {
                String val = (String)enum1.nextElement();
                this.candidateValues.put(val, new Integer(i));
                this.addItem(val);
                ++i;
            }
        }

        public void setInitSelection(Vector selectedVal) {
            Enumeration enum1 = selectedVal.elements();
            while (enum1.hasMoreElements()) {
                String val = null;
                Object valObject = enum1.nextElement();
                if (valObject instanceof XMLTree) {
                    XMLTree valTree = (XMLTree)valObject;
                    val = valTree.getValue();
                } else if (valObject instanceof String) {
                    val = (String)valObject;
                }
                if (val == null) {
                    return;
                }
                Integer index = (Integer)this.candidateValues.get(val);
                if (index == null) continue;
                int indexNum = index;
                this.setValueAt(new Boolean(true), indexNum, 1);
            }
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.size();
        }

        public void clear() {
            if (this.selectionList != null) {
                for (int i = 0; i < this.selectionList.size(); ++i) {
                    this.selectionList.setElementAt(new Boolean(false), i);
                }
            }
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Vector getSelectedValues() {
            Vector value = new Vector();
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Boolean selVal = (Boolean)this.selectionList.get(i);
                if (!selVal.booleanValue()) continue;
                value.add(this.data.get(i));
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                String strValue = (String)value;
                this.data.setElementAt(strValue, row);
            }
            if (col == 1) {
                Boolean boolVal = (Boolean)value;
                this.selectionList.setElementAt(boolVal, row);
            }
            this.fireTableCellUpdated(row, col);
        }

        public Object getValueAt(int row, int col) {
            if (col == 0) {
                String selectedOne = (String)this.data.get(row);
                return selectedOne;
            }
            if (col == 1) {
                Boolean selectedBool = (Boolean)this.selectionList.get(row);
                return selectedBool;
            }
            return "";
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public void addItem(String value) {
            this.data.add(value);
            this.selectionList.add(new Boolean(false));
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }
    }
}

