/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.configui.schema;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jeus.tool.configui.schema.ConfigElement;
import jeus.tool.configui.schema.ConfigItem;

public class ConfigContainer
implements Serializable,
ConfigElement,
Cloneable {
    public static final String LAYOUT_TAB = "Tab";
    public static final String LAYOUT_LIST = "List";
    public static final String LAYOUT_FLAT = "Flat";
    public static final String GENERAL_NAME = "$general$";
    private String _name;
    private String _displayName;
    private String _multi = "false";
    private String _complex = "false";
    private String _multiDisplayName;
    private String _multiColumnParser;
    private Vector _configItemList;
    private Vector _configContainerList;
    private String _required = "false";
    private String _containerUIClass;
    private String _subContainerUIClass;
    private String _tabListenerClass;
    private String _advanced = "false";
    private String _type;
    private String _globalID;
    private String _description;
    private String _layOut;
    private String _subLayOut;
    private String _parentLayOut;
    private String _smallIcon;
    private String _bigIcon;
    private String _generalSmallIcon;
    private String _generalBigIcon;

    public ConfigContainer() {
        this.setMulti("false");
        this.setComplex("false");
        this._configItemList = new Vector();
        this._configContainerList = new Vector();
    }

    public String getParentLayOut() {
        return this._parentLayOut;
    }

    public void setParentLayOut(String parentLayOut) {
        this._parentLayOut = parentLayOut;
    }

    public String getBigIcon() {
        return this._bigIcon;
    }

    public void setBigIcon(String _bigIcon) {
        this._bigIcon = _bigIcon;
    }

    public String getSmallIcon() {
        return this._smallIcon;
    }

    public void setSmallIcon(String _smallIcon) {
        this._smallIcon = _smallIcon;
    }

    public String getGeneralBigIcon() {
        return this._generalBigIcon;
    }

    public void setGeneralBigIcon(String _bigIcon) {
        this._generalBigIcon = _bigIcon;
    }

    public String getGeneralSmallIcon() {
        return this._generalSmallIcon;
    }

    public void setGeneralSmallIcon(String _smallIcon) {
        this._generalSmallIcon = _smallIcon;
    }

    public void addConfigContainer(ConfigContainer vConfigContainer) throws IndexOutOfBoundsException {
        this._configContainerList.addElement(vConfigContainer);
        vConfigContainer.setParentLayOut(this.getLayOut());
    }

    public void addConfigContainer(int index, ConfigContainer vConfigContainer) throws IndexOutOfBoundsException {
        this._configContainerList.insertElementAt(vConfigContainer, index);
    }

    public void addConfigItem(ConfigItem vConfigItem) throws IndexOutOfBoundsException {
        this._configItemList.addElement(vConfigItem);
    }

    public void addConfigItem(int index, ConfigItem vConfigItem) throws IndexOutOfBoundsException {
        this._configItemList.insertElementAt(vConfigItem, index);
    }

    public Enumeration enumerateConfigContainer() {
        return this._configContainerList.elements();
    }

    public Enumeration enumerateConfigItem() {
        return this._configItemList.elements();
    }

    public String getComplex() {
        return this._complex;
    }

    public String getRequired() {
        return this._required;
    }

    public String getAdvanced() {
        return this._advanced;
    }

    public String getType() {
        return this._type;
    }

    public String getGlobalID() {
        return this._globalID;
    }

    public ConfigContainer getConfigContainer(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configContainerList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ConfigContainer)this._configContainerList.elementAt(index);
    }

    public ConfigContainer[] getConfigContainer() {
        int size = this._configContainerList.size();
        ConfigContainer[] mArray = new ConfigContainer[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (ConfigContainer)this._configContainerList.elementAt(index);
        }
        return mArray;
    }

    public int getConfigContainerCount() {
        return this._configContainerList.size();
    }

    public ConfigItem getConfigItem(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (ConfigItem)this._configItemList.elementAt(index);
    }

    public ConfigItem[] getConfigItem() {
        int size = this._configItemList.size();
        ConfigItem[] mArray = new ConfigItem[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (ConfigItem)this._configItemList.elementAt(index);
        }
        return mArray;
    }

    public int getConfigItemCount() {
        return this._configItemList.size();
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            this._displayName = this.createDisplayName();
        }
        return this._displayName;
    }

    private String createDisplayName() {
        StringBuffer buf = new StringBuffer();
        char[] arr = this._name.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == '$') continue;
            buf.append(arr[i]);
        }
        return buf.toString();
    }

    public String getDescription() {
        return this._description;
    }

    public String getMulti() {
        return this._multi;
    }

    public String getMultiDisplayName() {
        return this._multiDisplayName;
    }

    public String getMultiColumnParser() {
        return this._multiColumnParser;
    }

    public String getName() {
        return this._name;
    }

    public String getContainerUIClass() {
        return this._containerUIClass;
    }

    public String getSubContainerUIClass() {
        return this._subContainerUIClass;
    }

    public String getTabListenerClass() {
        return this._tabListenerClass;
    }

    public void removeAllConfigContainer() {
        this._configContainerList.removeAllElements();
    }

    public void removeAllConfigItem() {
        this._configItemList.removeAllElements();
    }

    public ConfigContainer removeConfigContainer(int index) {
        Object obj = this._configContainerList.elementAt(index);
        this._configContainerList.removeElementAt(index);
        return (ConfigContainer)obj;
    }

    public ConfigItem removeConfigItem(int index) {
        Object obj = this._configItemList.elementAt(index);
        this._configItemList.removeElementAt(index);
        return (ConfigItem)obj;
    }

    public void setComplex(String complex) {
        this._complex = complex;
    }

    public void setConfigContainer(int index, ConfigContainer vConfigContainer) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configContainerList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._configContainerList.setElementAt(vConfigContainer, index);
    }

    public void setConfigContainer(ConfigContainer[] configContainerArray) {
        this._configContainerList.removeAllElements();
        for (int i = 0; i < configContainerArray.length; ++i) {
            this._configContainerList.addElement(configContainerArray[i]);
        }
    }

    public void setConfigItem(int index, ConfigItem vConfigItem) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._configItemList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._configItemList.setElementAt(vConfigItem, index);
    }

    public void setConfigItem(ConfigItem[] configItemArray) {
        this._configItemList.removeAllElements();
        for (int i = 0; i < configItemArray.length; ++i) {
            this._configItemList.addElement(configItemArray[i]);
        }
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public void setDescription(String value) {
        this._description = value;
    }

    public void setMultiDisplayName(String multiDisplayName) {
        this._multiDisplayName = multiDisplayName;
    }

    public void setMultiColumnParser(String multiColumnParser) {
        this._multiColumnParser = multiColumnParser;
    }

    public void setMulti(String multi) {
        this._multi = multi;
    }

    public void setRequired(String required) {
        this._required = required;
    }

    public void setAdvanced(String val) {
        this._advanced = val;
    }

    public void setType(String val) {
        this._type = val;
    }

    public String getLayOut() {
        if (this._layOut == null || this._layOut.trim().length() == 0) {
            return LAYOUT_TAB;
        }
        return this._layOut;
    }

    public void setLayOut(String _layOut) {
        this._layOut = _layOut;
    }

    public String getSubLayOut() {
        if (this._subLayOut == null || this._subLayOut.trim().length() == 0) {
            return LAYOUT_TAB;
        }
        return this._subLayOut;
    }

    public void setSubLayOut(String subLayOut) {
        this._subLayOut = subLayOut;
    }

    public void setGlobalID(String val) {
        Enumeration enum1;
        this._globalID = val;
        if (this._configContainerList != null) {
            enum1 = this._configContainerList.elements();
            while (enum1.hasMoreElements()) {
                ConfigContainer childContainer = (ConfigContainer)enum1.nextElement();
                childContainer.setGlobalID(this._globalID);
            }
        }
        if (this._configItemList != null) {
            enum1 = this._configItemList.elements();
            while (enum1.hasMoreElements()) {
                ConfigItem childItem = (ConfigItem)enum1.nextElement();
                childItem.setGlobalID(this._globalID);
            }
        }
    }

    public void setContainerUIClass(String name) {
        this._containerUIClass = name;
    }

    public void setSubContainerUIClass(String name) {
        this._subContainerUIClass = name;
    }

    public void setTabListenerClass(String name) {
        this._tabListenerClass = name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public ConfigContainer cloneMe() {
        return (ConfigContainer)this.clone();
    }

    public Object clone() {
        try {
            int i;
            ConfigContainer cc2 = (ConfigContainer)super.clone();
            if (this._configContainerList != null) {
                for (i = 0; i < this.getConfigContainerCount(); ++i) {
                    cc2.setConfigContainer(i, this.getConfigContainer(i).cloneMe());
                }
            }
            if (this._configItemList != null) {
                for (i = 0; i < this.getConfigItemCount(); ++i) {
                    cc2.setConfigItem(i, (ConfigItem)this.getConfigItem(i).clone());
                }
            }
            return cc2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getAnySubName() {
        if (this.getConfigItemCount() > 0) {
            return this.getConfigItem(0).getName();
        }
        if (this.getConfigContainerCount() > 0) {
            return this.getConfigContainer(0).getName();
        }
        return null;
    }
}

