/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version;

import java.util.logging.Level;
import jeus.tool.common.WIOParameters;
import jeus.tool.converter.common.ConsolToolUtil;
import jeus.tool.converter.version.process.ProcessConversion;
import jeus.util.JeusException;
import jeus.util.JeusProperties;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Converter;

public class XMLVersionConverter {
    public static String[] versionTypeString = new String[]{"from 4.x to 5.0"};
    public static int JEUS_CONFIG = 0;
    public static int EJB_MAIN = 1;
    public static int WEB_MAIN = 2;
    public static int JMS_MAIN = 3;
    public static int REALM_MAIN = 4;
    public static int JEUS_EJB_DD = 5;
    public static int JEUS_WEB_DD = 6;
    public static int JEUS_CLIENT_DD = 7;
    public static int ALL = 8;
    public static int EAR = 9;
    public static int EJB = 10;
    public static int SERVLET = 11;
    public static int CLIENT = 12;
    static String[] type_arg_list = new String[]{"jeus_main", "ejb_main", "web_main", "jms_main", "realm", "jeus_ejb_dd", "jeus_web_dd", "jeus_client_dd", "all", "ear", "ejb", "servlet", "client"};
    public static String JEUS_HOME = WIOParameters.JEUS_HOME;
    public static String JEUS4_HOME = System.getProperty("jeus4.home");
    public static String JEUS4_EJB_HOME = null;
    public static String JEUS4_SERVLET_HOME = null;
    public static String JEUS4_CLIENT_HOME = null;
    public static String JEUS4_EJB_CLASS_LODING_MODE = null;
    public static String JEUS4_DEPLOY_HOME = null;
    private static String sourcePath = null;
    private static String targetPath = null;
    private static int conversionType = -1;
    public static String FS = System.getProperty("file.separator");
    public static ProcessConversion con = new ProcessConversion();
    private static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.converter");

    public static void main(String[] args) {
        block4: {
            try {
                System.out.println("##############");
                XMLVersionConverter.initVariable();
                if (XMLVersionConverter.parseArgs(args)) {
                    ConsolToolUtil.checkContinue();
                    XMLVersionConverter.processConversion(conversionType, sourcePath, targetPath);
                }
            }
            catch (JeusException e) {
                logger.log(Level.SEVERE, "", (Throwable)e);
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Converter._6501_LEVEL)) break block4;
                logger.log(JeusMessage_Converter._6501_LEVEL, JeusMessage_Converter._6501, (Throwable)e);
            }
        }
    }

    private static boolean parseArgs(String[] args) {
        if (args.length == 0) {
            XMLVersionConverter.printUsage();
            return false;
        }
        conversionType = XMLVersionConverter.findingType(args[0]);
        if (conversionType == -1) {
            System.out.println("Doc Type is not appropriate.");
            return false;
        }
        if (args.length == 1) {
            if (conversionType != ALL) {
                XMLVersionConverter.printUsage();
                return false;
            }
        } else if (args.length == 2) {
            sourcePath = FileUtils.getAbsolutePath((String)args[1]);
        } else if (args.length == 3) {
            sourcePath = FileUtils.getAbsolutePath((String)args[1]);
            targetPath = FileUtils.getAbsolutePath((String)args[2]);
        } else {
            XMLVersionConverter.printUsage();
            return false;
        }
        return true;
    }

    public static void processConversion(int type, String sourcePath, String targetPath) {
        block6: {
            WIOParameters.XML_VALIDATION = false;
            WIOParameters.LOCAL_DTD_VALIDATION = true;
            try {
                if (type == ALL) {
                    con.convertAll();
                } else if (EAR <= type && type <= CLIENT) {
                    String finalTargetPth = con.convertModule(XMLVersionConverter.convertType(type), sourcePath, targetPath, false);
                    System.out.println("Conversion Success - " + sourcePath + " to " + finalTargetPth + "\n");
                } else {
                    con.doConvertDD(type, sourcePath, targetPath);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(JeusMessage_Converter._6502_LEVEL)) break block6;
                logger.log(JeusMessage_Converter._6502_LEVEL, JeusMessage_Converter._6502, (Object)sourcePath, (Throwable)e);
            }
        }
    }

    private static int convertType(int type) {
        if (type == EJB) {
            con.getClass();
            return 1;
        }
        if (type == SERVLET) {
            con.getClass();
            return 2;
        }
        if (type == CLIENT) {
            con.getClass();
            return 3;
        }
        if (type == EAR) {
            con.getClass();
            return 0;
        }
        return -1;
    }

    private static void initVariable() throws JeusException {
        if (JEUS4_HOME == null || JEUS4_HOME.trim().equals("")) {
            throw new JeusException("You must set jeus4.home as the home directory for JEUS version 4 that you want to convert from.");
        }
        if (JEUS_HOME == null) {
            throw new JeusException("JEUS Home must be set first..");
        }
        JEUS4_EJB_HOME = System.getProperty("jeus4.ejbhome");
        if (JEUS4_EJB_HOME == null || JEUS4_EJB_HOME.trim().equals("")) {
            JEUS4_EJB_HOME = JEUS4_HOME + FS + "webhome" + FS + "ejb_home";
        }
        if ((JEUS4_SERVLET_HOME = System.getProperty("jeus4.servlethome")) == null || JEUS4_SERVLET_HOME.trim().equals("")) {
            JEUS4_SERVLET_HOME = JEUS4_HOME + FS + "webhome" + FS + "servlet_home";
        }
        if ((JEUS4_CLIENT_HOME = System.getProperty("jeus4.clienthome")) == null || JEUS4_CLIENT_HOME.trim().equals("")) {
            JEUS4_CLIENT_HOME = JEUS4_HOME + FS + "webhome" + FS + "clienthome";
        }
        if ((JEUS4_EJB_CLASS_LODING_MODE = System.getProperty("jeus4.ejb.classloadingmode")) == null || JEUS4_EJB_CLASS_LODING_MODE.trim().equals("")) {
            JEUS4_EJB_CLASS_LODING_MODE = "DIR";
        }
        if ((JEUS4_DEPLOY_HOME = System.getProperty("jeus4.deployhome")) == null || JEUS4_DEPLOY_HOME.trim().equals("")) {
            JEUS4_DEPLOY_HOME = JEUS4_HOME + FS + "webhome" + FS + "deploy_home";
        }
        XMLVersionConverter.printInitValues();
    }

    private static void printInitValues() {
        System.out.println("check if the followings are what you want ");
        System.out.println("------------------------------------------------------");
        System.out.println("JEUS4_HOME : " + JEUS4_HOME);
        System.out.println("JEUS5_HOME : " + JeusProperties.JEUS_HOME);
        System.out.println("JEUS4_EJB_HOME : " + JEUS4_EJB_HOME);
        System.out.println("JEUS5_EJB_HOME : " + JeusProperties.JEUS_EJB_HOME);
        System.out.println("JEUS4_SERVLET_HOME : " + JEUS4_SERVLET_HOME);
        System.out.println("JEUS4_CLIENT_HOME : " + JEUS4_CLIENT_HOME);
        System.out.println("JEUS5_CLIENT_HOME : " + JeusProperties.JEUS_CLIENT_HOME);
        System.out.println("JEUS4_DEPLOY_HOME : " + JEUS4_DEPLOY_HOME);
        System.out.println("JEUS5_DEPLOY_HOME : " + JeusProperties.AUTO_DEPLOY_DIR);
        System.out.println("JEUS4_EJB_CLASS_LODING_MODE : " + JEUS4_EJB_CLASS_LODING_MODE);
        System.out.println("------------------------------------------------------");
    }

    private static void printUsage() {
        System.out.println("\nusage: <> is required argument, [] is optional argument. ");
        System.out.println("--------------------------------------------------------------------");
        System.out.println("xmlconverter <DocType> <SourcePath> [TargetPath]");
        System.out.println("For 'all' DocType, the last 2 arguments is not needed.");
        System.out.println("DocType :  ");
        StringBuffer str = new StringBuffer();
        for (int i = 1; i < type_arg_list.length; ++i) {
            str.append(type_arg_list[i] + "\n");
        }
        System.out.println(str.toString());
        System.out.println("if [TargetPath] not specified, ear, ejb and ear module is saved in APP_HOME");
        System.out.println("------------------------------------------------------");
    }

    public static int findingType(String docType) {
        int type = -1;
        for (int kk = 0; kk < type_arg_list.length; ++kk) {
            if (!type_arg_list[kk].equalsIgnoreCase(docType)) continue;
            type = kk;
            return type;
        }
        return -1;
    }
}

