/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.desctojaxb;

import javax.xml.bind.JAXBException;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.ValidString;
import jeus.util.message.JeusMessage_Converter;
import jeus.xml.binding.jeusDD.ActiveManagementType;
import jeus.xml.binding.jeusDD.EjbEngineType;
import jeus.xml.binding.jeusDD.InvokeHttpType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.SmtpSenderType;

public class EJBMainJaxbConverter
extends XMLConverter {
    public static final String EJB_MAIN_CONFIG = "ejb-engine";
    public static final String RESOLUTION = "resolution";
    public static final String GC_LEVEL = "gc-level";
    public static final String MODULE_LIST = "module-list";
    public static final String FAST_DEPLOY = "fast-deploy";
    public static final String ENABLE_USER_NOTIFY = "enable-user-notify";
    public static final String WS_PORT = "ws-port";
    public static final String LOGGING = "system-log";
    public static final String USER_CLASSPATH = "user-class-path";
    public static final String ACTIVE_MANAGEMENT = "active-management";
    public static final String MAX_BLOCKED_THREAD = "max-blocked-thread";
    public static final String MAX_IDLE_TIME = "max-idle-time";
    public static final String ENABLE_INTEROP = "enable-interop";
    public static final String TARGET = "target";
    public static final String BUFFER_SIZE = "buffer-size";
    public static final String LEVEL = "level";
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int FATAL_LEVEL = 0;
    public static final int NOTICE_LEVEL = 1;
    public static final int INFORMATION_LEVEL = 2;
    public static final int DEBUG_LEVEL = 3;
    public static final int DEFAULT_PORT = 9739;
    public static final String EMAIL_NOTIFICATION = "email-notify";
    public static final String EMAIL_SMTP_ADDRESS = "smtp-address";
    public static final String EMAIL_TO_ADDRESS = "to-address";
    public static final String EMAIL_FROM_ADDRESS = "from-address";
    public static final String EMAIL_CC_ADDRESS = "cc-address";
    public static final String EMAIL_BCC_ADDRESS = "bcc-address";
    public static final String INVOKE_HTTP = "invoke-http";
    public static final String URL = "url";
    public static final String HTTP_PORT = "http-port";
    private ObjectFactory ejbMainFactory = new ObjectFactory();

    public Object constructJAXBObject(XMLTree xmlTree) throws JAXBException, XMLConverterException {
        XMLTree httpInvokeTree;
        Boolean enableInterop;
        XMLTree activeManageTree;
        Boolean enableUserNotify;
        EjbEngineType ejbEngine = this.ejbMainFactory.createEjbEngineType();
        if (xmlTree == null || !xmlTree.getName().equals(EJB_MAIN_CONFIG)) {
            return null;
        }
        Integer resolution = (Integer)ValidString.getProperTypeFromString(xmlTree, RESOLUTION, 0, false, "300000");
        if (resolution != null) {
            ejbEngine.setResolution(Long.valueOf(resolution.intValue()));
        }
        if ((enableUserNotify = (Boolean)ValidString.getProperTypeFromString(xmlTree, ENABLE_USER_NOTIFY, 2, false, "false")) != null) {
            ejbEngine.setEnableUserNotify(Boolean.valueOf(enableUserNotify));
        }
        if ((activeManageTree = xmlTree.getFirstElement(ACTIVE_MANAGEMENT)) != null) {
            XMLTree emailTree;
            Long maxIdleTime;
            ActiveManagementType activeManagement = this.ejbMainFactory.createActiveManagementType();
            Integer maxBolckedThread = (Integer)ValidString.getProperTypeFromString(activeManageTree, MAX_BLOCKED_THREAD, 0, false, "-1");
            if (maxBolckedThread != null) {
                activeManagement.setMaxBlockedThread(Integer.valueOf(maxBolckedThread));
            }
            if ((maxIdleTime = (Long)ValidString.getProperTypeFromString(activeManageTree, MAX_IDLE_TIME, 3, false, "300000")) != null) {
                activeManagement.setMaxIdleTime(Long.valueOf(maxIdleTime));
            }
            if ((emailTree = activeManageTree.getFirstElement(EMAIL_NOTIFICATION)) != null) {
                activeManagement.setEmailNotify(this.fillEmailNotify(emailTree));
            }
            ejbEngine.setActiveManagement(activeManagement);
        }
        if ((enableInterop = (Boolean)ValidString.getProperTypeFromString(xmlTree, ENABLE_INTEROP, 2, false, "false")) != null) {
            System.out.println("===> you should set enable-interop by yourself");
        }
        if ((httpInvokeTree = xmlTree.getFirstElement(INVOKE_HTTP)) != null) {
            InvokeHttpType invokeHttp = this.ejbMainFactory.createInvokeHttpType();
            String url = XMLUtil.getSubtreeValue(httpInvokeTree, URL);
            if (!ValidString.notEmptyString(url)) {
                throw new XMLConverterException(JeusMessage_Converter._6001, URL);
            }
            invokeHttp.setUrl(url);
            Integer httpPort = (Integer)ValidString.getProperTypeFromString(httpInvokeTree, HTTP_PORT, 0, true, null);
            if (httpPort != null) {
                invokeHttp.setHttpPort(Integer.valueOf(httpPort));
            }
            ejbEngine.setInvokeHttp(invokeHttp);
        }
        ObjectFactory fac = new ObjectFactory();
        return fac.createEjbEngine(ejbEngine);
    }

    public int getType() {
        return 2;
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(2);
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(2);
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        return null;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }

    private SmtpSenderType fillEmailNotify(XMLTree emailTree) throws XMLConverterException, JAXBException {
        String bcc;
        SmtpSenderType smtpHandler = this.ejbMainFactory.createSmtpSenderType();
        String smtp = XMLUtil.getSubtreeValue(emailTree, EMAIL_SMTP_ADDRESS);
        if (smtp == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, EMAIL_SMTP_ADDRESS);
        }
        smtpHandler.setSmtpHostAddress(smtp);
        String from = XMLUtil.getSubtreeValue(emailTree, EMAIL_FROM_ADDRESS);
        if (from == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, EMAIL_FROM_ADDRESS);
        }
        smtpHandler.setFromAddress(from);
        String to = XMLUtil.getSubtreeValue(emailTree, EMAIL_TO_ADDRESS);
        if (to == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, EMAIL_TO_ADDRESS);
        }
        smtpHandler.setToAddress(to);
        String cc = XMLUtil.getSubtreeValue(emailTree, EMAIL_CC_ADDRESS);
        if (cc != null) {
            smtpHandler.setCcAddress(cc);
        }
        if ((bcc = XMLUtil.getSubtreeValue(emailTree, EMAIL_BCC_ADDRESS)) != null) {
            smtpHandler.setBccAddress(bcc);
        }
        return smtpHandler;
    }
}

