/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.desctojaxb;

import java.io.File;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import jeus.security.util.Base64Coder;
import jeus.security.util.EncryptionUtil;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.version.XMLVersionConverter;
import jeus.tool.converter.version.desctojaxb.JeusMainJaxbConverter;
import jeus.util.VirtualDNS;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.jeusDD.AccountsType;
import jeus.xml.binding.jeusDD.GroupType;
import jeus.xml.binding.jeusDD.GroupsType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PoliciesType;
import jeus.xml.binding.jeusDD.PolicyType;
import jeus.xml.binding.jeusDD.ResourcePermissionType;
import jeus.xml.binding.jeusDD.ResourcePermissionsType;
import jeus.xml.binding.jeusDD.RolePermissionType;
import jeus.xml.binding.jeusDD.RolePermissionsType;
import jeus.xml.binding.jeusDD.UserType;
import jeus.xml.binding.jeusDD.UsersType;

public class FileRealmJaxbConverter
extends XMLConverter {
    public static final String FILE_REALM = "file-realm";
    public static final String ROLE = "role";
    public static final String ACL = "acl";
    public static final String USER = "user";
    public static final String GROUP = "group";
    public static final String ROLE_NAME = "role-name";
    public static final String DESCRIPTION = "description";
    public static final String GROUP_NAME = "group-name";
    public static final String USER_NAME = "user-name";
    public static final String PASSWORD = "password";
    public static final String RESOURCE_TYPE = "resource-type";
    public static final String RESOURCE_NAME = "resource-name";
    public static final String RESOURCE_ACTION = "resource-action";
    File xmlFile = null;
    Hashtable groupToRoles = new Hashtable();
    Hashtable roleToPrincipals = new Hashtable();

    public String getSystemID() {
        return WIOParameters.getSystemID(7);
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(7);
    }

    public int getType() {
        return 7;
    }

    public Object constructJAXBObject(XMLTree xmlTree) throws JAXBException {
        Vector groupTrees;
        int i;
        Vector<Object> twoObject = new Vector<Object>();
        if (!xmlTree.getName().equals(FILE_REALM)) {
            return null;
        }
        ObjectFactory subFactory = new ObjectFactory();
        ObjectFactory polFactory = new ObjectFactory();
        AccountsType subs = subFactory.createAccountsType();
        Vector userTrees = xmlTree.getElements(USER);
        if (userTrees.size() > 0) {
            String cipherAlgorithm = XMLUtil.getSubtreeValueDefault(xmlTree, "cipher-algorithm", "base64");
            UsersType usersType = subFactory.createUsersType();
            subs.setUsers(usersType);
            List users = usersType.getUser();
            for (i = 0; i < userTrees.size(); ++i) {
                String[] rolenames;
                int j;
                XMLTree userTree = (XMLTree)userTrees.get(i);
                String username = XMLUtil.getSubtreeValue(userTree, USER_NAME);
                String password = XMLUtil.getSubtreeValue(userTree, PASSWORD);
                UserType user = subFactory.createUserType();
                user.setName(username);
                String finalPassword = password;
                if (cipherAlgorithm != null) {
                    if (cipherAlgorithm.equalsIgnoreCase("base64")) {
                        finalPassword = Base64Coder.decode(password);
                    } else if (cipherAlgorithm.equalsIgnoreCase("3des") || cipherAlgorithm.equalsIgnoreCase("DESede")) {
                        if (EncryptionUtil.isCreated()) {
                            EncryptionUtil.setSecretKeyDir(XMLVersionConverter.JEUS4_HOME + JeusMainJaxbConverter.FS + "config" + JeusMainJaxbConverter.FS + "security");
                        } else {
                            EncryptionUtil.init(XMLVersionConverter.JEUS4_HOME + JeusMainJaxbConverter.FS + "config" + JeusMainJaxbConverter.FS + "security");
                        }
                        cipherAlgorithm = "DESede";
                        finalPassword = EncryptionUtil.decryptPassword(cipherAlgorithm, password);
                        if (finalPassword == null) {
                            cipherAlgorithm = "plain";
                            finalPassword = password;
                        }
                    }
                    EncryptionUtil.setSecretKeyDir(JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + VirtualDNS.LOCAL_VIRTUALNAME + JeusPropertyValues.fs + "security");
                    if (cipherAlgorithm.equals("plain")) {
                        user.setPassword(EncryptionUtil.encryptPassword(null, finalPassword));
                    } else {
                        user.setPassword("{" + cipherAlgorithm + "}" + EncryptionUtil.encryptPasswordForConverter(cipherAlgorithm, finalPassword, JeusPropertyValues.JEUS_CONFIG_HOME + JeusPropertyValues.fs + VirtualDNS.LOCAL_VIRTUALNAME + JeusPropertyValues.fs + "security"));
                    }
                } else {
                    user.setPassword("{base64}" + finalPassword);
                }
                users.add(user);
                String[] groupnames = XMLUtil.getSubtreeValues(userTree, GROUP_NAME);
                if (groupnames != null) {
                    List groupList = user.getGroup();
                    for (j = 0; j < groupnames.length; ++j) {
                        groupList.add(groupnames[j]);
                    }
                }
                if ((rolenames = XMLUtil.getSubtreeValues(userTree, ROLE_NAME)) == null) continue;
                for (j = 0; j < rolenames.length; ++j) {
                    Vector<String> principals = (Vector<String>)this.roleToPrincipals.get(rolenames[j]);
                    if (principals == null) {
                        principals = new Vector<String>();
                    }
                    if (!principals.contains(username)) {
                        principals.add(username);
                    }
                    this.roleToPrincipals.put(rolenames[j], principals);
                }
            }
        }
        if ((groupTrees = xmlTree.getElements(GROUP)).size() > 0) {
            GroupsType groupsType = subFactory.createGroupsType();
            subs.setGroups(groupsType);
            List groups = groupsType.getGroup();
            for (i = 0; i < groupTrees.size(); ++i) {
                XMLTree groupTree = (XMLTree)groupTrees.get(i);
                String groupname = XMLUtil.getSubtreeValue(groupTree, GROUP_NAME);
                GroupType group = subFactory.createGroupType();
                group.setName(groupname);
                groups.add(group);
                String[] rolenames = XMLUtil.getSubtreeValues(groupTree, ROLE_NAME);
                for (int j = 0; j < rolenames.length; ++j) {
                    Vector<String> principals = (Vector<String>)this.roleToPrincipals.get(rolenames[j]);
                    if (principals == null) {
                        principals = new Vector<String>();
                    }
                    if (!principals.contains(groupname)) {
                        principals.add(groupname);
                    }
                    this.roleToPrincipals.put(rolenames[j], principals);
                }
            }
        }
        PoliciesType pols = polFactory.createPoliciesType();
        PolicyType polObject = polFactory.createPolicyType();
        pols.setPolicy(polObject);
        RolePermissionsType rolePermsType = polFactory.createRolePermissionsType();
        polObject.setRolePermissions(rolePermsType);
        List rolePermList = rolePermsType.getRolePermission();
        Vector roleTrees = xmlTree.getElements(ROLE);
        if (roleTrees.size() > 0) {
            for (int i2 = 0; i2 < roleTrees.size(); ++i2) {
                XMLTree roleTree = (XMLTree)roleTrees.get(i2);
                String rolename = XMLUtil.getSubtreeValue(roleTree, ROLE_NAME);
                String desc = XMLUtil.getSubtreeValue(roleTree, DESCRIPTION);
                Vector principals = (Vector)this.roleToPrincipals.get(rolename);
                if (principals == null) continue;
                RolePermissionType roleperm = polFactory.createRolePermissionType();
                roleperm.setRole(rolename);
                roleperm.getPrincipal().addAll(principals);
                rolePermList.add(roleperm);
            }
        }
        ResourcePermissionsType resPermsType = polFactory.createResourcePermissionsType();
        resPermsType.setContextId("default");
        ResourcePermissionType resourcePermission = polFactory.createResourcePermissionType();
        resourcePermission.getRole().add("system");
        resourcePermission.setResource("jeus.*");
        resourcePermission.setActions("*");
        resourcePermission.setClassname("jeus.security.resource.ResourcePermission");
        List resPermList = resPermsType.getResourcePermission();
        resPermList.add(resourcePermission);
        Vector aclTrees = xmlTree.getElements(ACL);
        if (aclTrees.size() > 0) {
            for (int i3 = 0; i3 < aclTrees.size(); ++i3) {
                XMLTree aclTree = (XMLTree)aclTrees.get(i3);
                String resourcname = XMLUtil.getSubtreeValue(aclTree, RESOURCE_NAME);
                String resourceaction = XMLUtil.getSubtreeValue(aclTree, RESOURCE_ACTION);
                ResourcePermissionType resPerm = polFactory.createResourcePermissionType();
                resPerm.setResource(resourcname);
                resPerm.setActions(resourceaction);
                List roleList = resPerm.getRole();
                String[] rolenames = XMLUtil.getSubtreeValues(aclTree, ROLE_NAME);
                if (rolenames != null) {
                    for (int j = 0; j < rolenames.length; ++j) {
                        roleList.add(rolenames[j]);
                    }
                }
                resPermList.add(resPerm);
            }
        }
        polObject.getResourcePermissions().add(resPermsType);
        twoObject.add(subs);
        twoObject.add(pols);
        return twoObject;
    }

    public Object constructJAXBObjectFromDesc(Object oldDesc) throws JAXBException {
        return null;
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        return null;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }
}

