/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.desctojaxb;

import java.util.Enumeration;
import javax.xml.bind.JAXBException;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.ValidString;
import jeus.util.JeusPort;
import jeus.util.message.JeusMessage_Converter;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.xml.binding.jeusDD.ConnectionFactoryType;
import jeus.xml.binding.jeusDD.ConsoleHandlerType;
import jeus.xml.binding.jeusDD.DbStorageType;
import jeus.xml.binding.jeusDD.DestinationType;
import jeus.xml.binding.jeusDD.DestinationTypeType;
import jeus.xml.binding.jeusDD.DurableSubscriberType;
import jeus.xml.binding.jeusDD.FactoryTypeType;
import jeus.xml.binding.jeusDD.FileHandlerType;
import jeus.xml.binding.jeusDD.FileStorageType;
import jeus.xml.binding.jeusDD.HandlerType;
import jeus.xml.binding.jeusDD.JmsServerClusterType;
import jeus.xml.binding.jeusDD.JmsServerInfoType;
import jeus.xml.binding.jeusDD.JmsServerType;
import jeus.xml.binding.jeusDD.JmsThreadPoolType;
import jeus.xml.binding.jeusDD.LoggingLevelType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.ServiceConfig;
import jeus.xml.binding.jeusDD.StorageType;
import jeus.xml.binding.jeusDD.SystemLoggingType;

public class JMSMainJaxbConverter
extends XMLConverter {
    public static final String JMS_SERVER = "jms-server";
    public static final String PORT = "port";
    public static final String SERVER_NUMBER = "server-number";
    public static final String TOTAL_SERVER_NUMBER = "total-server-number";
    public static final String MAX_THREAD_NUMBER = "max-thread-number";
    public static final String DURABLE_SUBSCRIBER = "durable-subscriber";
    public static final String CLIENT_ID = "client-id";
    public static final String DESTINATION_NAME = "destination-name";
    public static final String MESSAGE_SELECTOR = "message-selector";
    public static final String CONNECTION_FACTORY = "connection-factory";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String JNDI_NAME = "export-name";
    public static final String CONNECTION_NUMBER = "connection-number";
    public static final String DESTINATION = "destination";
    public static final String MAX_BYTES = "max-bytes";
    public static final String ERROR_LOG = "error-log";
    public static final String LEVEL = "level";
    public static final String BUFFER_SIZE = "buffer-size";
    public static final String VALID_DAY = "valid-day";
    public static final String ACCESS_LOG = "access-log";
    public static final String TARGET = "target";
    public static final String QUEUE = "queue";
    public static final String TOPIC = "topic";
    public static final String STORAGE = "storage";
    public static final String DATA_SOURCE = "data-source-name";
    public static final String FILE_STORAGE = "file-storage";
    public static final String PATH = "path";
    public static final String FILE_UNIT = "file-unit";
    public static final String FILE_TYPE = "file-type";
    public static final String FILE_COUNT = "file-count";
    public static final String INIT_CAPACITY = "init-capacity";
    public static final String MIN_HOLE_NUMBER = "min-hole-number";
    public static final String PACKING_RATE = "packing-rate";
    public static final int QUEUE_INDEX = 1;
    public static final int TOPIC_INDEX = 2;
    public static final String STD_OUT = "stdout";
    public static final String FILE = "file";
    public static final String FILE_NAME = "file-name";
    public static final String DEFAULT = "default";
    public static final String SERVER_CLUSTER = "jms-server-cluster";
    public static final String LOAD_BALANCE_MODE = "load-balance-mode";
    public static final String JMS_SERVER_INFO = "jms-server-info";
    public static final String IP_ADDRESS = "ip-address";
    public static final String DATA_PROVIDING = "is-data-providing";
    public static final String WEIGHT = "weight";
    public static final int DEFAULT_FilesInitCap = 1000;
    public static final int DEFAULT_FilesMinHoleNumber = 700;
    public static final float DEFAULT_FilesPackingRate = 0.7f;
    public static final int DEFAULT_MESSAGE_FilesCount = 5;
    public static final int DEFAULT_CONSUMER_FilesCount = 1;
    public static final int DEFAULT_DELIVER_FilesCount = 5;
    public static final String BOTH = "stdout:file";
    public static final String FATAL = "fatal";
    public static final String NOTICE = "notice";
    public static final String INFORMATION = "information";
    public static final String DEBUG = "debug";
    public static final String DEFAULT_BUFFER_SIZE = "4096";
    private ObjectFactory jmsMainfactory = new ObjectFactory();

    public int getType() {
        return 3;
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(3);
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        return null;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(3);
    }

    public Object constructJAXBObject(XMLTree xmlTree) throws JAXBException, XMLConverterException {
        Integer max;
        XMLTree serverClusterTree;
        XMLTree accessLogTree;
        if (xmlTree == null || !xmlTree.getName().equals(JMS_SERVER)) {
            return null;
        }
        JmsServerType jmsServer = this.jmsMainfactory.createJmsServerType();
        Integer port = (Integer)ValidString.getProperTypeFromString(xmlTree, PORT, 0, false, String.valueOf(JeusPort.JMS));
        if (port != null) {
            ServiceConfig service = this.jmsMainfactory.createServiceConfig();
            service.setServerUrl("tcp://127.0.0.1:" + port);
            service.setName("JEUSMQ");
            jmsServer.getServiceConfig().add(service);
        }
        if ((accessLogTree = xmlTree.getFirstElement(ACCESS_LOG)) != null) {
            jmsServer.setAccessLog(this.fillAccessLog(accessLogTree));
        }
        if ((serverClusterTree = xmlTree.getFirstElement(SERVER_CLUSTER)) != null) {
            String severNum = xmlTree.getFirstElement(SERVER_NUMBER).getValue();
            jmsServer.setJmsServerCluster(this.fillServerCluster(serverClusterTree, severNum));
        }
        Enumeration enum1 = xmlTree.elements(DURABLE_SUBSCRIBER);
        while (enum1.hasMoreElements()) {
            XMLTree serverSubscriberTree = (XMLTree)enum1.nextElement();
            jmsServer.getDurableSubscriber().add(this.fillDurableSubscriber(serverSubscriberTree));
        }
        Enumeration connections = xmlTree.elements(CONNECTION_FACTORY);
        while (connections.hasMoreElements()) {
            XMLTree connectionTree = (XMLTree)connections.nextElement();
            jmsServer.getConnectionFactory().add(this.fillConnectionFactory(connectionTree));
        }
        Enumeration destinations = xmlTree.elements(DESTINATION);
        while (destinations.hasMoreElements()) {
            XMLTree destinationTree = (XMLTree)destinations.nextElement();
            jmsServer.getDestination().add(this.fillDestination(destinationTree));
        }
        XMLTree storageTree = xmlTree.getFirstElement(STORAGE);
        if (storageTree != null) {
            jmsServer.setStorage(this.fillStorage(storageTree));
        }
        if ((max = (Integer)ValidString.getProperTypeFromString(xmlTree, MAX_THREAD_NUMBER, 0, false, "10")) != null) {
            JmsThreadPoolType threadPool = this.jmsMainfactory.createJmsThreadPoolType();
            threadPool.setMin(Integer.valueOf(0));
            threadPool.setMax(Integer.valueOf(max));
            jmsServer.setThreadPool(threadPool);
        }
        return jmsServer;
    }

    private StorageType fillStorage(XMLTree stTree) throws JAXBException, XMLConverterException {
        StorageType storage = this.jmsMainfactory.createStorageType();
        String datasource = XMLUtil.getSubtreeValue(stTree, DATA_SOURCE);
        if (datasource != null) {
            DbStorageType storageType = this.jmsMainfactory.createDbStorageType();
            storageType.setDataSourceName(datasource);
            storage.setDbStorage(storageType);
            return storage;
        }
        XMLTree fsTree = stTree.getFirstElement(FILE_STORAGE);
        if (fsTree != null) {
            FileStorageType fileStorage = this.jmsMainfactory.createFileStorageType();
            String path = XMLUtil.getSubtreeValue(fsTree, PATH);
            if (path == null) {
                throw new XMLConverterException(JeusMessage_Converter._6001, "file-storage/path");
            }
            fileStorage.setPath(path);
            storage.setFileStorage(fileStorage);
        }
        return storage;
    }

    public SystemLoggingType fillAccessLog(XMLTree accessLogTree) throws XMLConverterException, JAXBException {
        SystemLoggingType accessLog = this.jmsMainfactory.createSystemLoggingType();
        String level = XMLUtil.getSubtreeValueDefault(accessLogTree, LEVEL, INFORMATION);
        String resultLevel = ValidString.restrictChoice("access-log/level", level, FATAL, NOTICE, INFORMATION, DEBUG);
        if (resultLevel != null) {
            accessLog.setLevel(LoggingLevelType.fromValue((String)resultLevel));
        }
        HandlerType handler = this.jmsMainfactory.createHandlerType();
        String target = XMLUtil.getSubtreeValueDefault(accessLogTree, TARGET, STD_OUT);
        if (target.equalsIgnoreCase(STD_OUT)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
            accessLog.setHandler(handler);
        } else if (target.equalsIgnoreCase(FILE)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(accessLogTree));
            accessLog.setHandler(handler);
        } else if (target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("default:stdout") || target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("file:stdout")) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsolHandler());
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(accessLogTree));
            accessLog.setHandler(handler);
        } else {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{"access-log/target", "stdout|file"});
        }
        return accessLog;
    }

    private ConsoleHandlerType commonFillConsolHandler() throws JAXBException {
        ConsoleHandlerType consoleHandler = this.jmsMainfactory.createConsoleHandlerType();
        consoleHandler.setName("console");
        return consoleHandler;
    }

    private FileHandlerType commonFillFileHandler(XMLTree logTree) throws JAXBException, XMLConverterException {
        Integer validDay;
        FileHandlerType fileHandler = this.jmsMainfactory.createFileHandlerType();
        fileHandler.setName(FILE);
        Integer buffersize = (Integer)ValidString.getProperTypeFromString(logTree, BUFFER_SIZE, 0, false, DEFAULT_BUFFER_SIZE);
        if (buffersize != null) {
            fileHandler.setBufferSize(Integer.valueOf(buffersize));
        }
        if ((validDay = (Integer)ValidString.getProperTypeFromString(logTree, VALID_DAY, 0, false, "-1")) != null) {
            fileHandler.setValidDay(Integer.valueOf(validDay));
        }
        return fileHandler;
    }

    public JmsServerClusterType fillServerCluster(XMLTree clusterTree, String serverNum) throws XMLConverterException, JAXBException {
        JmsServerClusterType jmsServerCluster = this.jmsMainfactory.createJmsServerClusterType();
        Enumeration serverInfos = clusterTree.elements(JMS_SERVER_INFO);
        while (serverInfos.hasMoreElements()) {
            XMLTree svInfoTree = (XMLTree)serverInfos.nextElement();
            JmsServerInfoType jmsServerInfo = this.jmsMainfactory.createJmsServerInfoType();
            String localHost = JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
            jmsServerInfo.setBrokerName(System.getProperty(localHost + "_" + serverNum));
            String ipaddr = XMLUtil.getSubtreeValue(svInfoTree, IP_ADDRESS);
            if (!ValidString.notEmptyString(ipaddr)) {
                throw new XMLConverterException(JeusMessage_Converter._6001, IP_ADDRESS);
            }
            jmsServerInfo.setIpAddress(ipaddr);
            Integer port = (Integer)ValidString.getProperTypeFromString(svInfoTree, PORT, 0, true, null);
            if (port != null) {
                jmsServerInfo.setJmsPort(Integer.valueOf(port));
            }
            jmsServerCluster.getJmsServerInfo().add(jmsServerInfo);
        }
        return jmsServerCluster;
    }

    public DurableSubscriberType fillDurableSubscriber(XMLTree durableSubscriberTree) throws JAXBException, XMLConverterException {
        DurableSubscriberType durableSubscriber = this.jmsMainfactory.createDurableSubscriberType();
        String clientId = XMLUtil.getSubtreeValue(durableSubscriberTree, CLIENT_ID);
        if (clientId == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, CLIENT_ID);
        }
        durableSubscriber.setClientId(clientId);
        String name = XMLUtil.getSubtreeValue(durableSubscriberTree, NAME);
        if (name == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "durable-subscriber/name");
        }
        durableSubscriber.setName(name);
        String destination = XMLUtil.getSubtreeValue(durableSubscriberTree, DESTINATION_NAME);
        if (destination == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, DESTINATION_NAME);
        }
        durableSubscriber.setDestinationName(destination);
        String selector = XMLUtil.getSubtreeValue(durableSubscriberTree, MESSAGE_SELECTOR);
        if (selector != null) {
            durableSubscriber.setMessageSelector(selector);
        }
        return durableSubscriber;
    }

    public ConnectionFactoryType fillConnectionFactory(XMLTree connectionFactoryTree) throws XMLConverterException, JAXBException {
        Long max;
        String clientId;
        String name;
        ConnectionFactoryType connectionFactory = this.jmsMainfactory.createConnectionFactoryType();
        String type = XMLUtil.getSubtreeValueDefault(connectionFactoryTree, TYPE, QUEUE);
        if (type == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "connection-factory/type");
        }
        String resultType = ValidString.restrictChoice("connection-factory/type", type, QUEUE, TOPIC);
        if (resultType != null) {
            connectionFactory.setType(FactoryTypeType.fromValue((String)resultType));
        }
        if ((name = XMLUtil.getSubtreeValue(connectionFactoryTree, NAME)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "connection-factory/name");
        }
        connectionFactory.setName(name);
        String exportName = XMLUtil.getSubtreeValue(connectionFactoryTree, JNDI_NAME);
        if (exportName != null) {
            connectionFactory.setExportName(exportName);
        }
        if ((clientId = XMLUtil.getSubtreeValue(connectionFactoryTree, CLIENT_ID)) != null) {
            connectionFactory.setClientId(clientId);
        }
        if ((max = (Long)ValidString.getProperTypeFromString(connectionFactoryTree, MAX_THREAD_NUMBER, 3, false, "10")) != null) {
            JmsThreadPoolType threadPool = this.jmsMainfactory.createJmsThreadPoolType();
            threadPool.setMin(Integer.valueOf(0));
            threadPool.setMax(Integer.valueOf(max.intValue()));
            connectionFactory.setThreadPool(threadPool);
        }
        return connectionFactory;
    }

    public DestinationType fillDestination(XMLTree destinationTree) throws XMLConverterException, JAXBException {
        String name;
        DestinationType destination = this.jmsMainfactory.createDestinationType();
        String type = XMLUtil.getSubtreeValueDefault(destinationTree, TYPE, QUEUE);
        if (type == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "destination/type");
        }
        String resultType = ValidString.restrictChoice("destination/type", type, QUEUE, TOPIC);
        if (resultType != null) {
            destination.setType(DestinationTypeType.fromValue((String)resultType));
        }
        if ((name = XMLUtil.getSubtreeValue(destinationTree, NAME)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "destination/name");
        }
        destination.setName(name);
        String jndiName = XMLUtil.getSubtreeValueDefault(destinationTree, JNDI_NAME, name);
        if (jndiName != null) {
            destination.setExportName(jndiName);
        }
        Integer max = (Integer)ValidString.getProperTypeFromString(destinationTree, MAX_BYTES, 0, false, String.valueOf(destination.getDefaultLimit()));
        destination.setLimit(Integer.valueOf(max));
        return destination;
    }
}

