/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.version.desctojaxb;

import java.io.IOException;
import java.util.Enumeration;
import javax.xml.bind.JAXBException;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.common.xml.XMLUtil;
import jeus.tool.converter.common.ValidString;
import jeus.util.message.JeusMessage_Converter;
import jeus.xml.binding.jeusDD.AccessLogType;
import jeus.xml.binding.jeusDD.Ajp13ListenerType;
import jeus.xml.binding.jeusDD.ConsoleHandlerType;
import jeus.xml.binding.jeusDD.ContextGroupType;
import jeus.xml.binding.jeusDD.CustomHeaderType;
import jeus.xml.binding.jeusDD.EncodingSubType;
import jeus.xml.binding.jeusDD.EncodingType;
import jeus.xml.binding.jeusDD.FileHandlerType;
import jeus.xml.binding.jeusDD.HandlerType;
import jeus.xml.binding.jeusDD.HeaderFieldType;
import jeus.xml.binding.jeusDD.HttpListenerType;
import jeus.xml.binding.jeusDD.JspEngineType;
import jeus.xml.binding.jeusDD.LoggingLevelType;
import jeus.xml.binding.jeusDD.LoggingType;
import jeus.xml.binding.jeusDD.MonitoringType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.ResponseHeaderType;
import jeus.xml.binding.jeusDD.SchemeType;
import jeus.xml.binding.jeusDD.TcpListenerType;
import jeus.xml.binding.jeusDD.ThreadPoolType;
import jeus.xml.binding.jeusDD.ThreadStateNotifyType;
import jeus.xml.binding.jeusDD.TmaxListenerType;
import jeus.xml.binding.jeusDD.UserLogType;
import jeus.xml.binding.jeusDD.VirtualHostType;
import jeus.xml.binding.jeusDD.WebContainerType;
import jeus.xml.binding.jeusDD.WebserverConnectionType;
import jeus.xml.binding.jeusDD.WebtobBackupType;
import jeus.xml.binding.jeusDD.WebtobListenerType;

public class WEBMainJaxbConverter
extends XMLConverter {
    public static final String WEB_MAIN_CONFIG = "web-container";
    public static final String SECURITY_SWITCH = "security-switch";
    public static final String MONITORING = "monitoring";
    public static final String REDIRECT_STDOUT = "redirect-stdout";
    public static final String REDIRECT_STDERR = "redirect-stderr";
    public static final String SHUTDOWN_TIMEOUT = "shutdown-timeout";
    public static final String THREAD_POOL_CHECK = "check-thread-pool";
    public static final String SERVLET_RELOAD_CHECK = "check-class-reload";
    public static final String SESSION_CHECK = "check-session";
    public static final String DB_POOL_CHECK = "check-db-connection-pool";
    public static final String CONTEXT_GROUP = "context-group";
    public static final String GROUP_NAME = "group-name";
    public static final String SESSION_TIMEOUT = "timeout";
    public static final String SERVLET_HOME = "servlet-home";
    public static final String SHARED_SESSION = "shared";
    public static final String ATTACH_STACKTRACE_ON_ERROR = "attach-stacktrace-on-error";
    public static final String PERSISTENT_SESSION = "persistent";
    public static final String NOT_SERIALIZABLE_SESSION = "allow-not-serializable";
    public static final String ENCODING = "encoding";
    public static final String REQUEST_ENCODING = "request-encoding";
    public static final String RESPONSE_ENCODING = "response-encoding";
    public static final String REQUEST_URL_ENCODING = "request-url-encoding";
    public static final String DEFAULT = "default";
    public static final String FORCED = "forced";
    public static final String JSP_ENGINE = "jsp-engine";
    public static final String KEEP_GENERATED = "keep-generated";
    public static final String JAVA_COMPILER = "java-compiler";
    public static final String JSPWORK_DIR = "jsp-work-dir";
    public static final String COMPILE_OUTPUT_DIR = "compile-output-dir";
    public static final String COMPILE_OPTION = "compile-option";
    public static final String COMPILE_ENCODING = "compile-encoding";
    public static final String LOGGING = "logging";
    public static final String USER_LOG = "user-log";
    public static final String ACCESS_LOG = "access-log";
    public static final String TARGET = "target";
    public static final String LOG_FORMAT = "log=farmat";
    public static final String BUFFER_SIZE = "buffer-size";
    public static final String FILE_NAME = "file-name";
    public static final String VALID_DAY = "valid-day";
    public static final String FILE_PER_DAY = "file-per-day";
    public static final String VIRTUAL_HOST = "virtual-host";
    public static final String VIRTUAL_HOST_NAME = "virtual-host-name";
    public static final String HOST_LIST = "host-list";
    public static final String CONTEXT = "context";
    public static final String CONTEXT_NAME = "context-name";
    public static final String CONTEXT_PATH = "context-path";
    public static final String WEBSERVER_CONNECTION = "webserver-connection";
    public static final String WEBTOB_LISTENER = "webtob-listener";
    public static final String HTTP_LISTENER = "http-listener";
    public static final String TCP_LISTENER = "tcp-listener";
    public static final String SECURE_LISTENER = "secure-listener";
    public static final String AJP13_LISTENER = "ajp13-listener";
    public static final String TMAX_LISTENER = "tmax-listener";
    public static final String LISTENER_ID = "listener-id";
    public static final String PORT = "port";
    public static final String INPUT_BUFFER_SIZE = "input-buffer-size";
    public static final String OUTPUT_BUFFER_SIZE = "output-buffer-size";
    public static final String POSTDATA_READ_TIMEOUT = "postdata-read-timeout";
    public static final String SCHEME = "scheme";
    public static final String HTH_COUNT = "hth-count";
    public static final String ADMIN_CHANNEL = "admin-channel";
    public static final String DISABLE_PIPE = "disable-pipe";
    public static final String READ_TIMEOUT = "read-timeout";
    public static final String RECONNECT_TIMEOUT = "reconnect-timeout";
    public static final String REQUEST_QUEUEING = "request-queueing";
    public static final String REGISTRATION_ID = "registration-id";
    public static final String WEBTOB_HOME = "webtob-home";
    public static final String WEBTOB_BACKUP_SERVER = "webtob-backup";
    public static final String WEBTOB_ADDRESS = "webtob-address";
    public static final String BACK_LOG = "back-log";
    public static final String BUSY_NOTIFY_PAGE = "busy-notify-page";
    public static final String ACCESS_CONTROL = "server-access-control";
    public static final String ALLOWED_SERVER = "allowed-server";
    public static final String DISPATCHER_CONFIG_CLASS = "dispatcher-config-class";
    public static final String TMAX_ADDRESS = "tmax-address";
    public static final String TMAX_SERVER_GROUP_NAME = "server-group-name";
    public static final String TMAX_SERVER_NAME = "server-name";
    public static final String TMAX_BACKUP_ADDRESS = "tmax-backup-address";
    public static final String TMAX_BACKUP_PORT = "tmax-backup-port";
    public static final String TMAX_SERVER_TYPE = "server-type";
    public static final String TMAX_VERSION = "tmax-version";
    public static final String XARESOURCE_CLASS = "xaresource-class";
    public static final String RESPONSE_HEADER = "response-header";
    public static final String SESSION_ID_COOKIE = "session-id-cookie";
    public static final String VERSION = "version";
    public static final String DOMAIN = "domain";
    public static final String MAX_AGE = "max-age";
    public static final String PATH = "path";
    public static final String SECURE = "secure";
    public static final String CUSTOM_HEADER = "custom-header";
    public static final String HEADER_FIELD = "header-field";
    public static final String FIELD_NAME = "field-name";
    public static final String FIELD_VALUE = "field-value";
    public static final String EMAIL_NOTIFY = "email-notify";
    public static final String NOTIFY_LOG_LEVEL = "level";
    public static final String SMTP_ADDRESS = "smtp-address";
    public static final String FROM_ADDRESS = "from-address";
    public static final String TO_ADDRESS = "to-address";
    public static final String CC_ADDRESS = "cc-address";
    public static final String BCC_ADDRESS = "bcc-address";
    public static final String THREAD_POOL = "thread-pool";
    public static final String MIN_THREAD = "min";
    public static final String MAX_THREAD = "max";
    public static final String CHANGE_RATE = "step";
    public static final String MAX_IDLE = "max-idle-time";
    public static final String MAX_WAIT_QUEUE = "max-wait-queue";
    public static final String MAX_QUEUE = "max-queue";
    public static final String THREAD_STATE_NOTIFY = "thread-state-notify";
    public static final String AUTO_RESTART = "auto-restart";
    public static final String THREAD_STATE = "thread-state";
    public static final String MAX_THREAD_ACTIVE_TIME = "max-thread-active-time";
    public static final String MAX_BLOCKED_THREADS = "max-blocked-thread";
    public static final String MAX_BLOCKED_THREAD_RATE = "max-blocked-thread-rate";
    public static final String NOTIFY_THRESHOLD = "notify-threshold";
    public static final String RESTART_THRESHOLD = "restart-threshold";
    public static final String NOTIFY_SUBJECT = "notify-subject";
    public static final String RESTART_SUBJECT = "restart-subject";
    public static final String STD_OUT = "stdout";
    public static final String FILE = "file";
    public static final String BOTH = "stdout:file";
    public static final String DEFAULT_BUFFER_SIZE = "4096";
    public static final String DEFAULT_FILE_PER_DAY = "1";
    private ObjectFactory webMainFactory = new ObjectFactory();

    public Object constructJAXBObject(XMLTree xmlTree) throws JAXBException, IOException {
        Long shutdownTimeout;
        Boolean redirectStderr;
        Boolean redirectStdout;
        if (xmlTree == null || !xmlTree.getName().equals(WEB_MAIN_CONFIG)) {
            return null;
        }
        WebContainerType webContainer = this.webMainFactory.createWebContainerType();
        XMLTree monitoringTree = xmlTree.getFirstElement(MONITORING);
        if (monitoringTree != null) {
            webContainer.setMonitoring(this.superFillMonitoring(monitoringTree));
        }
        if ((redirectStdout = (Boolean)ValidString.getProperTypeFromString(xmlTree, REDIRECT_STDOUT, 2, false, "false")) != null) {
            webContainer.setRedirectStdout(Boolean.valueOf(redirectStdout));
        }
        if ((redirectStderr = (Boolean)ValidString.getProperTypeFromString(xmlTree, REDIRECT_STDERR, 2, false, "false")) != null) {
            webContainer.setRedirectStderr(Boolean.valueOf(redirectStderr));
        }
        if ((shutdownTimeout = (Long)ValidString.getProperTypeFromString(xmlTree, SHUTDOWN_TIMEOUT, 3, false, "-1")) != null) {
            webContainer.setShutdownTimeout(Long.valueOf(shutdownTimeout));
        }
        Enumeration ctxGrps = xmlTree.elements(CONTEXT_GROUP);
        while (ctxGrps.hasMoreElements()) {
            XMLTree ctxGrp = (XMLTree)ctxGrps.nextElement();
            webContainer.getContextGroup().add(this.superFillContextGroup(ctxGrp));
        }
        ObjectFactory fac = new ObjectFactory();
        return fac.createWebContainer(webContainer);
    }

    public int getType() {
        return 4;
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(4);
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(4);
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        return null;
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }

    private MonitoringType superFillMonitoring(XMLTree monitoringTree) throws JAXBException, XMLConverterException {
        Integer checkSession;
        Integer ceckClassReload;
        MonitoringType monitoring = this.webMainFactory.createMonitoringType();
        Integer checkThreadPool = (Integer)ValidString.getProperTypeFromString(monitoringTree, THREAD_POOL_CHECK, 0, false, "300000");
        if (checkThreadPool != null) {
            monitoring.setCheckThreadPool(Long.valueOf(checkThreadPool.intValue()));
        }
        if ((ceckClassReload = (Integer)ValidString.getProperTypeFromString(monitoringTree, SERVLET_RELOAD_CHECK, 0, false, "300000")) != null) {
            monitoring.setCheckClassReload(Long.valueOf(ceckClassReload.intValue()));
        }
        if ((checkSession = (Integer)ValidString.getProperTypeFromString(monitoringTree, SESSION_CHECK, 0, false, "300000")) != null) {
            monitoring.setCheckSession(Long.valueOf(checkSession.intValue()));
        }
        return monitoring;
    }

    private ContextGroupType superFillContextGroup(XMLTree ctxGrp) throws XMLConverterException, JAXBException {
        XMLTree responceHeaderTree;
        XMLTree loggingTree;
        XMLTree jspEngineTree;
        Boolean attachStacktraceOnError;
        XMLTree encodingTree;
        ContextGroupType contextGroup = this.webMainFactory.createContextGroupType();
        String groupName = XMLUtil.getSubtreeValue(ctxGrp, GROUP_NAME);
        if (ValidString.notEmptyString(groupName)) {
            contextGroup.setGroupName(groupName);
        }
        if ((encodingTree = ctxGrp.getFirstElement(ENCODING)) != null) {
            contextGroup.setEncoding(this.fillEncoding(encodingTree));
        }
        if ((attachStacktraceOnError = (Boolean)ValidString.getProperTypeFromString(ctxGrp, ATTACH_STACKTRACE_ON_ERROR, 2, false, "false")) != null) {
            contextGroup.setAttachStacktraceOnError(Boolean.valueOf(attachStacktraceOnError));
        }
        if ((jspEngineTree = ctxGrp.getFirstElement(JSP_ENGINE)) != null) {
            contextGroup.setJspEngine(this.fillJspEngine(jspEngineTree));
        }
        if ((loggingTree = ctxGrp.getFirstElement(LOGGING)) != null) {
            contextGroup.setLogging(this.fillLogging(loggingTree));
        }
        Enumeration virtualList = ctxGrp.elements(VIRTUAL_HOST);
        while (virtualList.hasMoreElements()) {
            XMLTree virtualTree = (XMLTree)virtualList.nextElement();
            contextGroup.getVirtualHost().add(this.fillVirtualHost(virtualTree));
        }
        XMLTree webserverConnectionTree = ctxGrp.getFirstElement(WEBSERVER_CONNECTION);
        if (webserverConnectionTree != null) {
            contextGroup.setWebserverConnection(this.fillWebServerConnection(webserverConnectionTree));
        }
        if ((responceHeaderTree = ctxGrp.getFirstElement(RESPONSE_HEADER)) != null) {
            contextGroup.setResponseHeader(this.fillResponseHeader(responceHeaderTree));
        }
        return contextGroup;
    }

    private WebserverConnectionType fillWebServerConnection(XMLTree webserverConnectionTree) throws JAXBException, XMLConverterException {
        WebserverConnectionType webserverConnection = this.webMainFactory.createWebserverConnectionType();
        Enumeration webtobEnum = webserverConnectionTree.elements(WEBTOB_LISTENER);
        while (webtobEnum.hasMoreElements()) {
            XMLTree webtobTree = (XMLTree)webtobEnum.nextElement();
            webserverConnection.getWebtobListenerOrHttpListenerOrTcpListener().add(this.fillWebToBListener(webtobTree));
        }
        Enumeration httpEnum = webserverConnectionTree.elements(HTTP_LISTENER);
        while (httpEnum.hasMoreElements()) {
            XMLTree httpTree = (XMLTree)httpEnum.nextElement();
            webserverConnection.getWebtobListenerOrHttpListenerOrTcpListener().add(this.fillHttpListener(httpTree));
        }
        Enumeration tcpEnum = webserverConnectionTree.elements(TCP_LISTENER);
        while (tcpEnum.hasMoreElements()) {
            XMLTree tcpTree = (XMLTree)tcpEnum.nextElement();
            webserverConnection.getWebtobListenerOrHttpListenerOrTcpListener().add(this.fillTCPListener(tcpTree));
        }
        Enumeration secEnum = webserverConnectionTree.elements(SECURE_LISTENER);
        while (secEnum.hasMoreElements()) {
            XMLTree secTree = (XMLTree)secEnum.nextElement();
            webserverConnection.getWebtobListenerOrHttpListenerOrTcpListener().add(this.fillSecureListener(secTree));
        }
        Enumeration ajpEnum = webserverConnectionTree.elements(AJP13_LISTENER);
        while (ajpEnum.hasMoreElements()) {
            XMLTree ajpTree = (XMLTree)ajpEnum.nextElement();
            webserverConnection.getWebtobListenerOrHttpListenerOrTcpListener().add(this.fillAjp13Listener(ajpTree));
        }
        Enumeration tmaxEnum = webserverConnectionTree.elements(TMAX_LISTENER);
        while (tmaxEnum.hasMoreElements()) {
            XMLTree tmaxTree = (XMLTree)tmaxEnum.nextElement();
            webserverConnection.getWebtobListenerOrHttpListenerOrTcpListener().add(this.fillTmaxListener(tmaxTree));
        }
        return webserverConnection;
    }

    private VirtualHostType fillVirtualHost(XMLTree virtualTree) throws JAXBException, XMLConverterException {
        VirtualHostType virtualHost = this.webMainFactory.createVirtualHostType();
        String vhName = XMLUtil.getSubtreeValue(virtualTree, VIRTUAL_HOST_NAME);
        if (!ValidString.notEmptyString(vhName)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "virtual-host/virtual-host-name");
        }
        virtualHost.setVirtualHostName(vhName);
        Enumeration hostListEnum = virtualTree.elements(HOST_LIST);
        while (hostListEnum.hasMoreElements()) {
            XMLTree hostTree = (XMLTree)hostListEnum.nextElement();
            String hostName = hostTree.getValue();
            if (!ValidString.notEmptyString(hostName)) continue;
            virtualHost.getHostList().add(hostName);
        }
        return virtualHost;
    }

    private JspEngineType fillJspEngine(XMLTree jspEngineTree) throws JAXBException, XMLConverterException {
        Boolean checkIncludedJspfile;
        String compileOption;
        String compileOutputDir;
        String jspWorkDir;
        String javaCompiler;
        String compileEncoding;
        JspEngineType jspEngine = this.webMainFactory.createJspEngineType();
        Boolean keepJenerated = (Boolean)ValidString.getProperTypeFromString(jspEngineTree, KEEP_GENERATED, 2, false, "true");
        if (keepJenerated != null) {
            jspEngine.setKeepGenerated(Boolean.valueOf(keepJenerated));
        }
        if (ValidString.notEmptyString(compileEncoding = XMLUtil.getSubtreeValue(jspEngineTree, COMPILE_ENCODING))) {
            jspEngine.setCompileEncoding(compileEncoding);
        }
        if (ValidString.notEmptyString(javaCompiler = XMLUtil.getSubtreeValue(jspEngineTree, JAVA_COMPILER))) {
            jspEngine.setJavaCompiler(javaCompiler);
        }
        if (ValidString.notEmptyString(jspWorkDir = XMLUtil.getSubtreeValue(jspEngineTree, JSPWORK_DIR))) {
            jspEngine.setJspWorkDir(jspWorkDir);
        }
        if (ValidString.notEmptyString(compileOutputDir = XMLUtil.getSubtreeValue(jspEngineTree, COMPILE_OUTPUT_DIR))) {
            jspEngine.setCompileOutputDir(compileOutputDir);
        }
        if (ValidString.notEmptyString(compileOption = XMLUtil.getSubtreeValue(jspEngineTree, COMPILE_OPTION))) {
            jspEngine.setCompileOption(compileOption);
        }
        if ((checkIncludedJspfile = (Boolean)ValidString.getProperTypeFromString(jspEngineTree, COMPILE_OPTION, 2, false, null)) != null) {
            jspEngine.setCheckIncludedJspfile(Boolean.valueOf(checkIncludedJspfile));
        }
        return jspEngine;
    }

    private LoggingType fillLogging(XMLTree loggingTree) throws JAXBException, XMLConverterException {
        XMLTree accessLogTree;
        LoggingType logging = this.webMainFactory.createLoggingType();
        XMLTree userLogTree = loggingTree.getFirstElement(USER_LOG);
        if (userLogTree != null) {
            logging.setUserLog(this.subFillUserLog(userLogTree));
        }
        if ((accessLogTree = loggingTree.getFirstElement(ACCESS_LOG)) != null) {
            logging.setAccessLog(this.subFillAccessLog(accessLogTree));
        }
        return logging;
    }

    private EncodingType fillEncoding(XMLTree encodingTree) throws JAXBException {
        XMLTree requestUrlEncodingTree;
        XMLTree responseEncodingTree;
        EncodingType encoding = this.webMainFactory.createEncodingType();
        XMLTree requestEncodingTree = encodingTree.getFirstElement(REQUEST_ENCODING);
        if (requestEncodingTree != null) {
            encoding.setRequestEncoding(this.setEncoding(requestEncodingTree));
        }
        if ((responseEncodingTree = encodingTree.getFirstElement(RESPONSE_ENCODING)) != null) {
            encoding.setResponseEncoding(this.setEncoding(responseEncodingTree));
        }
        if ((requestUrlEncodingTree = encodingTree.getFirstElement(REQUEST_URL_ENCODING)) != null) {
            encoding.setRequestUrlEncoding(this.setEncoding(requestUrlEncodingTree));
        }
        return encoding;
    }

    private EncodingSubType setEncoding(XMLTree requestEncodingTree) throws JAXBException {
        String defaultEnc;
        EncodingSubType requestEncoding = this.webMainFactory.createEncodingSubType();
        String forced = XMLUtil.getSubtreeValue(requestEncodingTree, FORCED);
        if (ValidString.notEmptyString(forced)) {
            requestEncoding.setForced(forced);
        }
        if (ValidString.notEmptyString(defaultEnc = XMLUtil.getSubtreeValue(requestEncodingTree, DEFAULT))) {
            requestEncoding.setDefault(defaultEnc);
        }
        return requestEncoding;
    }

    private WebtobListenerType fillWebToBListener(XMLTree webtobTree) throws JAXBException, XMLConverterException {
        Boolean requestQueueing;
        Integer reconnectTimeout;
        String webtobHome;
        String registrationId;
        XMLTree pool;
        Long readTimeout;
        Boolean disablePipe;
        Long hthCount;
        String scheme;
        Long postdataReadTimeout;
        Long outputBufferSize;
        WebtobListenerType webtobListener = this.webMainFactory.createWebtobListenerType();
        String listenerID = XMLUtil.getSubtreeValue(webtobTree, LISTENER_ID);
        if (!ValidString.notEmptyString(listenerID)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "webtob-listener/listener-id");
        }
        webtobListener.setListenerId(listenerID);
        Long port = (Long)ValidString.getProperTypeFromString(webtobTree, PORT, 3, true, null);
        if (port != null) {
            webtobListener.setPort(port.longValue());
        }
        if ((outputBufferSize = (Long)ValidString.getProperTypeFromString(webtobTree, OUTPUT_BUFFER_SIZE, 3, false, "8192")) != null) {
            webtobListener.setOutputBufferSize(Long.valueOf(outputBufferSize));
        }
        if ((postdataReadTimeout = (Long)ValidString.getProperTypeFromString(webtobTree, POSTDATA_READ_TIMEOUT, 3, false, "30000")) != null) {
            webtobListener.setPostdataReadTimeout(Long.valueOf(postdataReadTimeout));
        }
        if (ValidString.notEmptyString(scheme = XMLUtil.getSubtreeValueDefault(webtobTree, SCHEME, "http"))) {
            webtobListener.setScheme(SchemeType.valueOf((String)scheme));
        }
        if ((hthCount = (Long)ValidString.getProperTypeFromString(webtobTree, HTH_COUNT, 3, false, DEFAULT_FILE_PER_DAY)) != null) {
            webtobListener.setHthCount(Long.valueOf(hthCount));
        }
        if ((disablePipe = (Boolean)ValidString.getProperTypeFromString(webtobTree, DISABLE_PIPE, 2, false, "false")) != null) {
            webtobListener.setDisablePipe(Boolean.valueOf(disablePipe));
        }
        if ((readTimeout = (Long)ValidString.getProperTypeFromString(webtobTree, READ_TIMEOUT, 3, false, "0")) != null) {
            webtobListener.setReadTimeout(Long.valueOf(readTimeout));
        }
        if ((pool = webtobTree.getFirstElement(THREAD_POOL)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "webtob-listener/thread-pool");
        }
        webtobListener.setThreadPool(this.commonFillThreadPool(pool));
        String webtobAddress = XMLUtil.getSubtreeValue(webtobTree, WEBTOB_ADDRESS);
        if (ValidString.notEmptyString(webtobAddress)) {
            webtobListener.setWebtobAddress(webtobAddress);
        }
        if (ValidString.notEmptyString(registrationId = XMLUtil.getSubtreeValue(webtobTree, REGISTRATION_ID))) {
            webtobListener.setRegistrationId(registrationId);
        }
        if (ValidString.notEmptyString(webtobHome = XMLUtil.getSubtreeValue(webtobTree, WEBTOB_HOME))) {
            webtobListener.setWebtobHome(webtobHome);
        }
        if ((reconnectTimeout = (Integer)ValidString.getProperTypeFromString(webtobTree, RECONNECT_TIMEOUT, 0, false, "-1")) != null) {
            webtobListener.setReconnectTimeout(Integer.valueOf(reconnectTimeout));
        }
        if ((requestQueueing = (Boolean)ValidString.getProperTypeFromString(webtobTree, REQUEST_QUEUEING, 2, false, "true")) != null) {
            webtobListener.setRequestPrefetch(Boolean.valueOf(requestQueueing));
        }
        Enumeration descs = webtobTree.elements(WEBTOB_BACKUP_SERVER);
        while (descs.hasMoreElements()) {
            XMLTree backup = (XMLTree)descs.nextElement();
            webtobListener.getWebtobBackup().add(this.fillWebTobBackup(backup));
        }
        return webtobListener;
    }

    private TmaxListenerType fillTmaxListener(XMLTree tmaxTree) throws JAXBException, XMLConverterException {
        XMLTree pool;
        Long backupPort;
        String backupAddress;
        String serverName;
        String XAResourceClass;
        String tmaxVersion;
        String serverType;
        String serverGroupName;
        String webserverAddress;
        Integer reconnectTimeout;
        Long postdataReadTimeout;
        Long outputBufferSize;
        TmaxListenerType tmaxListener = this.webMainFactory.createTmaxListenerType();
        String listenerID = XMLUtil.getSubtreeValue(tmaxTree, LISTENER_ID);
        if (!ValidString.notEmptyString(listenerID)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "tmax-listener/listener-id");
        }
        tmaxListener.setListenerId(listenerID);
        Long port = (Long)ValidString.getProperTypeFromString(tmaxTree, PORT, 3, true, null);
        if (port != null) {
            tmaxListener.setPort(port.longValue());
        }
        if ((outputBufferSize = (Long)ValidString.getProperTypeFromString(tmaxTree, OUTPUT_BUFFER_SIZE, 3, false, "8192")) != null) {
            tmaxListener.setOutputBufferSize(Long.valueOf(outputBufferSize));
        }
        if ((postdataReadTimeout = (Long)ValidString.getProperTypeFromString(tmaxTree, POSTDATA_READ_TIMEOUT, 3, false, "30000")) != null) {
            tmaxListener.setPostdataReadTimeout(Long.valueOf(postdataReadTimeout));
        }
        if ((reconnectTimeout = (Integer)ValidString.getProperTypeFromString(tmaxTree, RECONNECT_TIMEOUT, 0, false, "-1")) != null) {
            tmaxListener.setReconnectTimeout(Integer.valueOf(reconnectTimeout));
        }
        if ((webserverAddress = XMLUtil.getSubtreeValueDefault(tmaxTree, TMAX_ADDRESS, "127.0.0.1")) != null) {
            tmaxListener.setTmaxAddress(webserverAddress);
        }
        if ((serverGroupName = XMLUtil.getSubtreeValue(tmaxTree, TMAX_SERVER_GROUP_NAME)) != null) {
            tmaxListener.setServerGroupName(serverGroupName);
        }
        if ((serverType = XMLUtil.getSubtreeValue(tmaxTree, TMAX_SERVER_TYPE)) != null) {
            tmaxListener.setServerType(serverType);
        }
        if ((tmaxVersion = XMLUtil.getSubtreeValue(tmaxTree, TMAX_VERSION)) != null) {
            tmaxListener.setTmaxVersion(tmaxVersion);
        }
        if ((XAResourceClass = XMLUtil.getSubtreeValue(tmaxTree, XARESOURCE_CLASS)) != null) {
            tmaxListener.setXaresourceClass(XAResourceClass);
        }
        if ((serverName = XMLUtil.getSubtreeValue(tmaxTree, TMAX_SERVER_NAME)) != null) {
            tmaxListener.setServerName(serverName);
        }
        if ((backupAddress = XMLUtil.getSubtreeValueDefault(tmaxTree, TMAX_BACKUP_ADDRESS, "127.0.0.1")) != null) {
            tmaxListener.setTmaxBackupAddress(backupAddress);
        }
        if ((backupPort = (Long)ValidString.getProperTypeFromString(tmaxTree, TMAX_BACKUP_PORT, 3, false, null)) != null) {
            tmaxListener.setTmaxBackupPort(Long.valueOf(backupPort));
        }
        if ((pool = tmaxTree.getFirstElement(THREAD_POOL)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "tmax-listener/thread-pool");
        }
        tmaxListener.setThreadPool(this.commonFillThreadPool(pool));
        return tmaxListener;
    }

    private HttpListenerType fillHttpListener(XMLTree httpTree) throws JAXBException, XMLConverterException {
        Boolean serverAccessControl;
        XMLTree pool;
        String scheme;
        Long postdataReadTimeout;
        Long outputBufferSize;
        HttpListenerType httpListener = this.webMainFactory.createHttpListenerType();
        String listenerID = XMLUtil.getSubtreeValue(httpTree, LISTENER_ID);
        if (!ValidString.notEmptyString(listenerID)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "http-listener/listener-id");
        }
        httpListener.setListenerId(listenerID);
        Long port = (Long)ValidString.getProperTypeFromString(httpTree, PORT, 3, true, null);
        if (port != null) {
            httpListener.setPort(port.longValue());
        }
        if ((outputBufferSize = (Long)ValidString.getProperTypeFromString(httpTree, OUTPUT_BUFFER_SIZE, 3, false, "8192")) != null) {
            httpListener.setOutputBufferSize(Long.valueOf(outputBufferSize));
        }
        if ((postdataReadTimeout = (Long)ValidString.getProperTypeFromString(httpTree, POSTDATA_READ_TIMEOUT, 3, false, "30000")) != null) {
            httpListener.setPostdataReadTimeout(Long.valueOf(postdataReadTimeout));
        }
        if (ValidString.notEmptyString(scheme = XMLUtil.getSubtreeValueDefault(httpTree, SCHEME, "http"))) {
            httpListener.setScheme(SchemeType.valueOf((String)scheme));
        }
        if ((pool = httpTree.getFirstElement(THREAD_POOL)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "http-listener/thread-pool");
        }
        httpListener.setThreadPool(this.commonFillThreadPool(pool));
        Long backLog = (Long)ValidString.getProperTypeFromString(httpTree, BACK_LOG, 3, false, null);
        if (backLog != null) {
            httpListener.setBackLog(Long.valueOf(backLog));
        }
        if ((serverAccessControl = (Boolean)ValidString.getProperTypeFromString(httpTree, ACCESS_CONTROL, 2, false, "false")) != null) {
            httpListener.setServerAccessControl(Boolean.valueOf(serverAccessControl));
        }
        Enumeration servers = httpTree.getElements(ALLOWED_SERVER).elements();
        while (servers.hasMoreElements()) {
            XMLTree server = (XMLTree)servers.nextElement();
            httpListener.getAllowedServer().add(server.getValue());
        }
        return httpListener;
    }

    private TcpListenerType fillTCPListener(XMLTree tcpTree) throws JAXBException, XMLConverterException {
        Boolean serverAccessControl;
        XMLTree pool;
        String scheme;
        Long postdataReadTimeout;
        Long outputBufferSize;
        TcpListenerType tcpListener = this.webMainFactory.createTcpListenerType();
        String listenerID = XMLUtil.getSubtreeValue(tcpTree, LISTENER_ID);
        if (!ValidString.notEmptyString(listenerID)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "tcp-listener/listener-id");
        }
        tcpListener.setListenerId(listenerID);
        Long port = (Long)ValidString.getProperTypeFromString(tcpTree, PORT, 3, true, null);
        if (port != null) {
            tcpListener.setPort(port.longValue());
        }
        if ((outputBufferSize = (Long)ValidString.getProperTypeFromString(tcpTree, OUTPUT_BUFFER_SIZE, 3, false, "8192")) != null) {
            tcpListener.setOutputBufferSize(Long.valueOf(outputBufferSize));
        }
        if ((postdataReadTimeout = (Long)ValidString.getProperTypeFromString(tcpTree, POSTDATA_READ_TIMEOUT, 3, false, "30000")) != null) {
            tcpListener.setPostdataReadTimeout(Long.valueOf(postdataReadTimeout));
        }
        if (ValidString.notEmptyString(scheme = XMLUtil.getSubtreeValueDefault(tcpTree, SCHEME, "http"))) {
            tcpListener.setScheme(SchemeType.valueOf((String)scheme));
        }
        if ((pool = tcpTree.getFirstElement(THREAD_POOL)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "tcp-listener/thread-pool");
        }
        tcpListener.setThreadPool(this.commonFillThreadPool(pool));
        Long backLog = (Long)ValidString.getProperTypeFromString(tcpTree, BACK_LOG, 3, false, null);
        if (backLog != null) {
            tcpListener.setBackLog(Long.valueOf(backLog));
        }
        if ((serverAccessControl = (Boolean)ValidString.getProperTypeFromString(tcpTree, ACCESS_CONTROL, 2, false, "false")) != null) {
            tcpListener.setServerAccessControl(Boolean.valueOf(serverAccessControl));
        }
        Enumeration servers = tcpTree.getElements(ALLOWED_SERVER).elements();
        while (servers.hasMoreElements()) {
            XMLTree server = (XMLTree)servers.nextElement();
            tcpListener.getAllowedServer().add(server.getValue());
        }
        String dispatcher = XMLUtil.getSubtreeValue(tcpTree, DISPATCHER_CONFIG_CLASS);
        if (ValidString.notEmptyString(dispatcher)) {
            tcpListener.setDispatcherConfigClass(dispatcher);
        }
        return tcpListener;
    }

    private HttpListenerType fillSecureListener(XMLTree secureTree) throws JAXBException, XMLConverterException {
        Boolean serverAccessControl;
        XMLTree pool;
        String scheme;
        Long postdataReadTimeout;
        Long outputBufferSize;
        HttpListenerType secureListener = this.webMainFactory.createHttpListenerType();
        String listenerID = XMLUtil.getSubtreeValue(secureTree, LISTENER_ID);
        if (!ValidString.notEmptyString(listenerID)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "secure-listener/listener-id");
        }
        secureListener.setListenerId(listenerID);
        Long port = (Long)ValidString.getProperTypeFromString(secureTree, PORT, 3, true, null);
        if (port != null) {
            secureListener.setPort(port.longValue());
        }
        if ((outputBufferSize = (Long)ValidString.getProperTypeFromString(secureTree, OUTPUT_BUFFER_SIZE, 3, false, "8192")) != null) {
            secureListener.setOutputBufferSize(Long.valueOf(outputBufferSize));
        }
        if ((postdataReadTimeout = (Long)ValidString.getProperTypeFromString(secureTree, POSTDATA_READ_TIMEOUT, 3, false, "30000")) != null) {
            secureListener.setPostdataReadTimeout(Long.valueOf(postdataReadTimeout));
        }
        if (ValidString.notEmptyString(scheme = XMLUtil.getSubtreeValueDefault(secureTree, SCHEME, "http"))) {
            secureListener.setScheme(SchemeType.valueOf((String)scheme));
        }
        if ((pool = secureTree.getFirstElement(THREAD_POOL)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "secure-listener/thread-pool");
        }
        secureListener.setThreadPool(this.commonFillThreadPool(pool));
        Long backLog = (Long)ValidString.getProperTypeFromString(secureTree, BACK_LOG, 3, false, null);
        if (backLog != null) {
            secureListener.setBackLog(Long.valueOf(backLog));
        }
        if ((serverAccessControl = (Boolean)ValidString.getProperTypeFromString(secureTree, ACCESS_CONTROL, 2, false, "false")) != null) {
            secureListener.setServerAccessControl(Boolean.valueOf(serverAccessControl));
        }
        Enumeration servers = secureTree.getElements(ALLOWED_SERVER).elements();
        while (servers.hasMoreElements()) {
            XMLTree server = (XMLTree)servers.nextElement();
            secureListener.getAllowedServer().add(server.getValue());
        }
        return secureListener;
    }

    private Ajp13ListenerType fillAjp13Listener(XMLTree ajpTree) throws JAXBException, XMLConverterException {
        Boolean serverAccessControl;
        XMLTree pool;
        String scheme;
        Long postdataReadTimeout;
        Long outputBufferSize;
        Ajp13ListenerType ajp13Listener = this.webMainFactory.createAjp13ListenerType();
        String listenerID = XMLUtil.getSubtreeValue(ajpTree, LISTENER_ID);
        if (!ValidString.notEmptyString(listenerID)) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "ajp13-listener/listener-id");
        }
        ajp13Listener.setListenerId(listenerID);
        Long port = (Long)ValidString.getProperTypeFromString(ajpTree, PORT, 3, true, null);
        if (port != null) {
            ajp13Listener.setPort(port.longValue());
        }
        if ((outputBufferSize = (Long)ValidString.getProperTypeFromString(ajpTree, OUTPUT_BUFFER_SIZE, 3, false, "8192")) != null) {
            ajp13Listener.setOutputBufferSize(Long.valueOf(outputBufferSize));
        }
        if ((postdataReadTimeout = (Long)ValidString.getProperTypeFromString(ajpTree, POSTDATA_READ_TIMEOUT, 3, false, "30000")) != null) {
            ajp13Listener.setPostdataReadTimeout(Long.valueOf(postdataReadTimeout));
        }
        if (ValidString.notEmptyString(scheme = XMLUtil.getSubtreeValueDefault(ajpTree, SCHEME, "http"))) {
            ajp13Listener.setScheme(SchemeType.valueOf((String)scheme));
        }
        if ((pool = ajpTree.getFirstElement(THREAD_POOL)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "ajp13-listener/thread-pool");
        }
        ajp13Listener.setThreadPool(this.commonFillThreadPool(pool));
        Long backLog = (Long)ValidString.getProperTypeFromString(ajpTree, BACK_LOG, 3, false, null);
        if (backLog != null) {
            ajp13Listener.setBackLog(Long.valueOf(backLog));
        }
        if ((serverAccessControl = (Boolean)ValidString.getProperTypeFromString(ajpTree, ACCESS_CONTROL, 2, false, "false")) != null) {
            ajp13Listener.setServerAccessControl(Boolean.valueOf(serverAccessControl));
        }
        Enumeration servers = ajpTree.getElements(ALLOWED_SERVER).elements();
        while (servers.hasMoreElements()) {
            XMLTree server = (XMLTree)servers.nextElement();
            ajp13Listener.getAllowedServer().add(server.getValue());
        }
        return ajp13Listener;
    }

    private ResponseHeaderType fillResponseHeader(XMLTree responceHeaderTree) throws JAXBException, XMLConverterException {
        ResponseHeaderType responseHeader = this.webMainFactory.createResponseHeaderType();
        XMLTree customHeaderInfo = responceHeaderTree.getFirstElement(CUSTOM_HEADER);
        if (customHeaderInfo != null) {
            Enumeration enum1 = customHeaderInfo.elements(HEADER_FIELD);
            CustomHeaderType customHeader = this.webMainFactory.createCustomHeaderType();
            while (enum1.hasMoreElements()) {
                String hfValue;
                XMLTree hfTree = (XMLTree)enum1.nextElement();
                HeaderFieldType headerField = this.webMainFactory.createHeaderFieldType();
                String hfName = XMLUtil.getSubtreeValue(hfTree, FIELD_NAME);
                if (hfName != null) {
                    headerField.setFieldName(hfName);
                }
                if ((hfValue = XMLUtil.getSubtreeValue(hfTree, FIELD_VALUE)) != null) {
                    headerField.setFieldValue(hfValue);
                }
                customHeader.getHeaderField().add(headerField);
            }
            responseHeader.setCustomHeader(customHeader);
        }
        return responseHeader;
    }

    private WebtobBackupType fillWebTobBackup(XMLTree backup) throws JAXBException, XMLConverterException {
        Integer reconnectTimeout;
        String webtobHome;
        String registrationId;
        XMLTree pool;
        Long readTimeout;
        Boolean disablePipe;
        Long hthCount;
        String scheme;
        Long postdataReadTimeout;
        Long outputBufferSize;
        WebtobBackupType webtobBackup = this.webMainFactory.createWebtobBackupType();
        Long port = (Long)ValidString.getProperTypeFromString(backup, PORT, 3, true, null);
        if (port != null) {
            webtobBackup.setPort(port.longValue());
        }
        if ((outputBufferSize = (Long)ValidString.getProperTypeFromString(backup, OUTPUT_BUFFER_SIZE, 3, false, "8192")) != null) {
            webtobBackup.setOutputBufferSize(Long.valueOf(outputBufferSize));
        }
        if ((postdataReadTimeout = (Long)ValidString.getProperTypeFromString(backup, POSTDATA_READ_TIMEOUT, 3, false, "30000")) != null) {
            webtobBackup.setPostdataReadTimeout(Long.valueOf(postdataReadTimeout));
        }
        if (ValidString.notEmptyString(scheme = XMLUtil.getSubtreeValueDefault(backup, SCHEME, "http"))) {
            webtobBackup.setScheme(SchemeType.valueOf((String)scheme));
        }
        if ((hthCount = (Long)ValidString.getProperTypeFromString(backup, HTH_COUNT, 3, false, DEFAULT_FILE_PER_DAY)) != null) {
            webtobBackup.setHthCount(Long.valueOf(hthCount));
        }
        if ((disablePipe = (Boolean)ValidString.getProperTypeFromString(backup, DISABLE_PIPE, 2, false, "false")) != null) {
            webtobBackup.setDisablePipe(Boolean.valueOf(disablePipe));
        }
        if ((readTimeout = (Long)ValidString.getProperTypeFromString(backup, READ_TIMEOUT, 3, false, "0")) != null) {
            webtobBackup.setReadTimeout(Long.valueOf(readTimeout));
        }
        if ((pool = backup.getFirstElement(THREAD_POOL)) == null) {
            throw new XMLConverterException(JeusMessage_Converter._6001, "webtob-backup/thread-pool");
        }
        webtobBackup.setThreadPool(this.commonFillThreadPool(pool));
        String webtobAddress = XMLUtil.getSubtreeValue(backup, WEBTOB_ADDRESS);
        if (ValidString.notEmptyString(webtobAddress)) {
            webtobBackup.setWebtobAddress(webtobAddress);
        }
        if (ValidString.notEmptyString(registrationId = XMLUtil.getSubtreeValue(backup, REGISTRATION_ID))) {
            webtobBackup.setRegistrationId(registrationId);
        }
        if (ValidString.notEmptyString(webtobHome = XMLUtil.getSubtreeValue(backup, WEBTOB_HOME))) {
            webtobBackup.setWebtobHome(webtobHome);
        }
        if ((reconnectTimeout = (Integer)ValidString.getProperTypeFromString(backup, RECONNECT_TIMEOUT, 0, false, "-1")) != null) {
            webtobBackup.setReconnectTimeout(Integer.valueOf(reconnectTimeout));
        }
        return webtobBackup;
    }

    private AccessLogType subFillAccessLog(XMLTree accessLogTree) throws JAXBException, XMLConverterException {
        AccessLogType accessLog = this.webMainFactory.createAccessLogType();
        String target = XMLUtil.getSubtreeValueDefault(accessLogTree, TARGET, STD_OUT);
        if (target.equalsIgnoreCase("none")) {
            accessLog.setEnable(Boolean.valueOf(false));
        }
        accessLog.setLevel(LoggingLevelType.INFO);
        HandlerType handler = this.webMainFactory.createHandlerType();
        if (target.equalsIgnoreCase(STD_OUT)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsoleHandler());
            accessLog.setHandler(handler);
        } else if (target.equalsIgnoreCase(FILE)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(accessLogTree));
            accessLog.setHandler(handler);
        } else if (target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("default:stdout") || target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("file:stdout")) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsoleHandler());
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsoleHandler());
            accessLog.setHandler(handler);
        } else if (!target.equalsIgnoreCase("none")) {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{TARGET, "stdout|file"});
        }
        accessLog.setLevel(LoggingLevelType.INFO);
        String format = XMLUtil.getSubtreeValueDefault(accessLogTree, LOG_FORMAT, STD_OUT);
        if (format != null) {
            accessLog.setFormat(format);
        }
        return accessLog;
    }

    private UserLogType subFillUserLog(XMLTree userLogTree) throws JAXBException, XMLConverterException {
        UserLogType userLog = this.webMainFactory.createUserLogType();
        userLog.setLevel(LoggingLevelType.INFO);
        HandlerType handler = this.webMainFactory.createHandlerType();
        String target = XMLUtil.getSubtreeValueDefault(userLogTree, TARGET, STD_OUT);
        if (target.equalsIgnoreCase(STD_OUT)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsoleHandler());
            userLog.setHandler(handler);
        } else if (target.equalsIgnoreCase(FILE)) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillFileHandler(userLogTree));
            userLog.setHandler(handler);
        } else if (target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("default:stdout") || target.equalsIgnoreCase(BOTH) || target.equalsIgnoreCase("file:stdout")) {
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsoleHandler());
            handler.getConsoleHandlerOrFileHandlerOrSmtpHandler().add(this.commonFillConsoleHandler());
            userLog.setHandler(handler);
        } else if (!target.equalsIgnoreCase("none")) {
            throw new XMLConverterException(JeusMessage_Converter._6002, new String[]{TARGET, "stdout|file"});
        }
        return userLog;
    }

    private FileHandlerType commonFillFileHandler(XMLTree userLogTree) throws JAXBException, XMLConverterException {
        Integer validHour;
        Integer validDay;
        Integer buffersize;
        FileHandlerType fileHandler = this.webMainFactory.createFileHandlerType();
        fileHandler.setName(FILE);
        String fileName = XMLUtil.getSubtreeValue(userLogTree, FILE_NAME);
        if (fileName != null) {
            fileHandler.setFileName(fileName);
        }
        if ((buffersize = (Integer)ValidString.getProperTypeFromString(userLogTree, BUFFER_SIZE, 0, false, DEFAULT_BUFFER_SIZE)) != null) {
            fileHandler.setBufferSize(Integer.valueOf(buffersize));
        }
        if ((validDay = (Integer)ValidString.getProperTypeFromString(userLogTree, VALID_DAY, 0, false, "-1")) != null) {
            fileHandler.setValidDay(Integer.valueOf(validDay));
        }
        if ((validHour = (Integer)ValidString.getProperTypeFromString(userLogTree, FILE_PER_DAY, 0, false, DEFAULT_FILE_PER_DAY)) != null) {
            fileHandler.setValidHour(Integer.valueOf(validHour));
        }
        return fileHandler;
    }

    private ConsoleHandlerType commonFillConsoleHandler() throws JAXBException {
        ConsoleHandlerType consoleHandler = this.webMainFactory.createConsoleHandlerType();
        consoleHandler.setName("console");
        return consoleHandler;
    }

    private ThreadPoolType commonFillThreadPool(XMLTree pool) throws XMLConverterException, JAXBException {
        XMLTree tnTree;
        Integer maxQueue;
        Integer maxWait;
        Integer maxIdle;
        Long step;
        Long max;
        ThreadPoolType threadPool = this.webMainFactory.createThreadPoolType();
        Long min = (Long)ValidString.getProperTypeFromString(pool, MIN_THREAD, 3, true, null);
        if (min != null) {
            threadPool.setMin(min.longValue());
        }
        if ((max = (Long)ValidString.getProperTypeFromString(pool, MAX_THREAD, 3, false, null)) != null) {
            threadPool.setMax(Long.valueOf(max));
        }
        if ((step = (Long)ValidString.getProperTypeFromString(pool, CHANGE_RATE, 3, false, DEFAULT_FILE_PER_DAY)) != null) {
            threadPool.setStep(Long.valueOf(step));
        }
        if ((maxIdle = (Integer)ValidString.getProperTypeFromString(pool, MAX_IDLE, 0, false, "30000")) != null) {
            threadPool.setMaxIdleTime(Integer.valueOf(maxIdle));
        }
        if ((maxWait = (Integer)ValidString.getProperTypeFromString(pool, MAX_WAIT_QUEUE, 0, false, "4")) != null) {
            threadPool.setMaxWaitQueue(Integer.valueOf(maxWait));
        }
        if ((maxQueue = (Integer)ValidString.getProperTypeFromString(pool, MAX_QUEUE, 0, false, "-1")) != null) {
            threadPool.setMaxQueue(Integer.valueOf(maxQueue));
        }
        if ((tnTree = pool.getFirstElement(THREAD_STATE_NOTIFY)) != null) {
            String restartSubject;
            ThreadStateNotifyType threadStateNotify = this.webMainFactory.createThreadStateNotifyType();
            String notifySubject = XMLUtil.getSubtreeValue(tnTree, NOTIFY_SUBJECT);
            if (ValidString.notEmptyString(notifySubject)) {
                threadStateNotify.setNotifySubject(notifySubject);
            }
            if (ValidString.notEmptyString(restartSubject = XMLUtil.getSubtreeValue(tnTree, RESTART_SUBJECT))) {
                threadStateNotify.setRestartSubject(restartSubject);
            }
            threadPool.setThreadStateNotify(threadStateNotify);
        }
        return threadPool;
    }
}

