/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.desctojaxb;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import jeus.deploy.JeusDeploymentManager;
import jeus.descriptor.bind.JeusMainDescriptorJB;
import jeus.tool.common.WIOParameters;
import jeus.tool.converter.weblogic.descriptor.WLApplication;
import jeus.tool.converter.weblogic.descriptor.WLDBConnPoolDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLDataSourceDescriptor;
import jeus.tool.converter.weblogic.descriptor.WLDomainConfigDescriptor;
import jeus.tool.converter.weblogic.process.ProcessConversion;
import jeus.util.JeusException;
import jeus.util.JeusProperties;
import jeus.util.file.FileUtils;
import jeus.util.logging.JeusLogger;
import jeus.xml.binding.jeusDD.AppTargetType;
import jeus.xml.binding.jeusDD.ApplicationType;
import jeus.xml.binding.jeusDD.DataSourceType;
import jeus.xml.binding.jeusDD.DataSourceTypeType;
import jeus.xml.binding.jeusDD.DatabaseConnectionPoolType;
import jeus.xml.binding.jeusDD.DatabaseType;
import jeus.xml.binding.jeusDD.DeploymentTargetType;
import jeus.xml.binding.jeusDD.DeploymentTypeType;
import jeus.xml.binding.jeusDD.EngineCommandType;
import jeus.xml.binding.jeusDD.EngineContainerType;
import jeus.xml.binding.jeusDD.EngineTypeType;
import jeus.xml.binding.jeusDD.InvocationType;
import jeus.xml.binding.jeusDD.InvocationTypeType;
import jeus.xml.binding.jeusDD.JeusNodeType;
import jeus.xml.binding.jeusDD.JeusSystemType;
import jeus.xml.binding.jeusDD.LifecycleInvocationType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.MethodParamsType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.OldPoolingType;
import jeus.xml.binding.jeusDD.ResourceType;
import jeus.xml.binding.jeusDD.TypePropertyType;
import jeus.xml.binding.jeusDD.VendorType;

public class JeusMainJaxbConverter {
    private String FS = System.getProperty("file.separator");
    private final String PR_DRIVER_CLASS_NAME = "DriverClassName";
    private final String PR_URL = "URL";
    private JeusSystemType jeusMainJaxb = null;
    public String JEUS_MAIN_PATH = null;
    private String JEUS_HOME = ProcessConversion.JEUS_HOME;
    private String NODE_NAME = WIOParameters.HOST_NAME;
    private boolean is_jeus_main_info = false;
    private ObjectFactory jeusMainFactory = new ObjectFactory();
    private WLDomainConfigDescriptor wlDomainDesc = ProcessConversion.wlDomainInfo;

    public void constructJaxbObject() throws Exception {
        String domainName = this.wlDomainDesc.getDomainName();
        this.getJeusMainInfo();
        if (domainName == null) {
            throw new JeusException("Domain Name can't be null");
        }
        this.createEngineContainer(domainName);
        System.out.println("(step0-4) JEUSMain.xml modification successful : registration of Engines");
        this.createJDBCInfo();
        System.out.println("(step5 )database addition finish..");
        this.createApplication();
        System.out.println("(step6) Application Deployment finish..");
        JeusMainDescriptorJB.marshalJeusMain();
        System.out.println("(step7) saving JEUS Main to = " + this.JEUS_MAIN_PATH);
    }

    private void getJeusMainInfo() throws Exception {
        if (this.is_jeus_main_info) {
            return;
        }
        String msg = "";
        this.JEUS_MAIN_PATH = this.JEUS_HOME + this.FS + "config" + this.FS + this.NODE_NAME + this.FS + "JEUSMain.xml";
        File jeusMainFile = new File(this.JEUS_MAIN_PATH);
        if (!jeusMainFile.exists()) {
            throw new JeusException("JEUSMain.xml not exists");
        }
        this.jeusMainJaxb = JeusMainDescriptorJB.getJeusMainDescriptor();
        this.is_jeus_main_info = true;
    }

    private void createEngineContainer(String domainName) throws Exception {
        if (this.jeusMainJaxb == null) {
            throw new JeusException("JEUSMain.xml is not reachable..");
        }
        if (this.jeusMainJaxb.getNode() == null) {
            throw new JeusException("NODE CONFIG is not reachable in JEUSMain.xml");
        }
        for (int i = 0; i < this.jeusMainJaxb.getNode().size(); ++i) {
            JeusNodeType node = (JeusNodeType)this.jeusMainJaxb.getNode().get(i);
            if (!node.getName().equals(this.NODE_NAME)) continue;
            List engineContainerList = node.getEngineContainer();
            for (int k = 0; k < engineContainerList.size(); ++k) {
                EngineContainerType engineContainer = (EngineContainerType)engineContainerList.get(k);
                if (!domainName.equals(engineContainer.getName())) continue;
                engineContainerList.remove(engineContainer);
            }
            EngineContainerType engineContainer = this.jeusMainFactory.createEngineContainerType();
            engineContainer.setName(domainName);
            EngineCommandType ejbEngineCommand = this.jeusMainFactory.createEngineCommandType();
            ejbEngineCommand.setType(EngineTypeType.EJB);
            ejbEngineCommand.setName(domainName);
            engineContainer.getEngineCommand().add(ejbEngineCommand);
            EngineCommandType webEngineCommand = this.jeusMainFactory.createEngineCommandType();
            webEngineCommand.setType(EngineTypeType.SERVLET);
            webEngineCommand.setName(domainName);
            engineContainer.getEngineCommand().add(webEngineCommand);
            EngineCommandType jmsEngineCommand = this.jeusMainFactory.createEngineCommandType();
            jmsEngineCommand.setType(EngineTypeType.JMS);
            jmsEngineCommand.setName(domainName);
            engineContainer.getEngineCommand().add(jmsEngineCommand);
            if (this.wlDomainDesc == null) continue;
            Vector methods = this.wlDomainDesc.getShutdownMethods();
            Vector arguments = this.wlDomainDesc.getShutdownParameters();
            String invocationType = "BEFORE_UNDEPLOY";
            if (methods != null) {
                this.fillLifecycleInvocation(methods, arguments, invocationType, engineContainer);
                node.getEngineContainer().add(engineContainer);
            }
            methods = this.wlDomainDesc.getStartupMethods();
            arguments = this.wlDomainDesc.getStartupParameters();
            invocationType = "BEFORE_DEPLOY";
            if (methods == null) continue;
            this.fillLifecycleInvocation(methods, arguments, invocationType, engineContainer);
            node.getEngineContainer().add(engineContainer);
        }
    }

    private void createJDBCInfo() throws Exception {
        if (this.jeusMainJaxb == null) {
            throw new JeusException("JEUSMain.xml is not reachable..");
        }
        Vector wlDSList = this.wlDomainDesc.getTxDataSourceList();
        if (wlDSList == null || wlDSList.size() == 0) {
            return;
        }
        Enumeration enum1 = wlDSList.elements();
        while (enum1.hasMoreElements()) {
            String driverString;
            String urlString;
            WLDataSourceDescriptor wldsInfo = (WLDataSourceDescriptor)enum1.nextElement();
            DatabaseType database = this.jeusMainFactory.createDatabaseType();
            database.setVendor(VendorType.OTHERS);
            database.setExportName(wldsInfo.getJNDIName());
            database.setDataSourceClassName("jeus.jdbc.driver.blackbox.BlackboxConnectionPoolDataSource");
            if (wldsInfo.getType() == WLDataSourceDescriptor.DATA_TYPE) {
                database.setDataSourceType(DataSourceTypeType.CONNECTION_POOL_DATA_SOURCE);
            } else {
                database.setDataSourceType(DataSourceTypeType.LOCAL_XA_DATA_SOURCE);
            }
            if (this.jeusMainJaxb.getResource() == null) {
                ResourceType resource = this.jeusMainFactory.createResourceType();
                this.jeusMainJaxb.setResource(resource);
            }
            if (this.jeusMainJaxb.getResource().getDataSource() == null) {
                DataSourceType datasource = this.jeusMainFactory.createDataSourceType();
                this.jeusMainJaxb.getResource().setDataSource(datasource);
            }
            if (this.jeusMainJaxb.getResource().getDataSource().getDatabase() != null && this.isAlreadyInDSList(this.jeusMainJaxb.getResource().getDataSource().getDatabase(), wldsInfo.getJNDIName())) continue;
            this.jeusMainJaxb.getResource().getDataSource().getDatabase().add(database);
            WLDBConnPoolDescriptor wlpoolInfo = null;
            String poolName = wldsInfo.getPoolName();
            if (poolName == null || (wlpoolInfo = this.wlDomainDesc.getPoolInfoWithName(poolName)) == null) continue;
            String propString = wlpoolInfo.getPropertyString();
            if (propString != null && propString.indexOf("user=") >= 0) {
                int userIndex = propString.indexOf("user=") + 5;
                int userLastIndex = propString.indexOf(";", userIndex);
                String user = "";
                user = userLastIndex == -1 ? propString.substring(userIndex) : propString.substring(userIndex, userLastIndex);
                database.setUser(user);
                database.setPassword("undefined");
            }
            if ((urlString = wlpoolInfo.getURLString()) != null) {
                TypePropertyType propertyUrl = this.jeusMainFactory.createTypePropertyType();
                propertyUrl.setName("URL");
                propertyUrl.setType("java.lang.String");
                propertyUrl.setValue(urlString);
                database.getProperty().add(propertyUrl);
            }
            if ((driverString = wlpoolInfo.getDriverName()) != null) {
                TypePropertyType propertyD = this.jeusMainFactory.createTypePropertyType();
                propertyD.setName("DriverClassName");
                propertyD.setType("java.lang.String");
                propertyD.setValue(driverString);
                database.getProperty().add(propertyD);
            }
            DatabaseConnectionPoolType connectionPool = this.jeusMainFactory.createDatabaseConnectionPoolType();
            OldPoolingType pooling = this.jeusMainFactory.createOldPoolingType();
            if ((wlpoolInfo.getMax() == null || wlpoolInfo.getMax().trim().equals("")) && (wlpoolInfo.getMin() == null || wlpoolInfo.getMin().trim().equals(""))) continue;
            if (wlpoolInfo.getMax() != null && !wlpoolInfo.getMax().trim().equals("")) {
                pooling.setMax(Integer.valueOf(Integer.valueOf(wlpoolInfo.getMax())));
            }
            if (wlpoolInfo.getMin() != null && !wlpoolInfo.getMin().trim().equals("")) {
                pooling.setMin(Integer.valueOf(Integer.valueOf(wlpoolInfo.getMin())));
            }
            connectionPool.setPooling(pooling);
            database.setConnectionPool(connectionPool);
        }
    }

    private void createApplication() throws Exception, JeusException {
        Vector wlAppList = this.wlDomainDesc.getAppList();
        if (wlAppList == null) {
            System.out.println("No Application exist in config.xml");
            return;
        }
        for (int i = 0; i < wlAppList.size(); ++i) {
            WLApplication wlApp = (WLApplication)wlAppList.elementAt(i);
            if (wlApp.getType() == WLApplication.NOTSUPPORTED) {
                System.out.println(wlApp.getName() + " is not supported type - check if the <Application> element is correct and module actually exists");
                continue;
            }
            ApplicationType application = this.jeusMainFactory.createApplicationType();
            DeploymentTargetType deploymentTarget = this.jeusMainFactory.createDeploymentTargetType();
            AppTargetType target = this.jeusMainFactory.createAppTargetType();
            target.setEngineContainerName(this.NODE_NAME + "_" + this.wlDomainDesc.getDomainName());
            deploymentTarget.getAllTargetsOrTarget().add(target);
            application.setDeploymentTarget(deploymentTarget);
            ProcessConversion con = new ProcessConversion();
            String sourcePath = wlApp.getPath();
            if (sourcePath == null) {
                System.out.println(wlApp.getName() + " has no path");
                continue;
            }
            String[] sourceDirectoryAndFileName = FileUtils.separateDirAndFile((String)sourcePath);
            String targetPath = JeusProperties.JEUS_APP_HOME + this.FS + sourceDirectoryAndFileName[1];
            try {
                if (wlApp.getType() == WLApplication.EAR_TYPE) {
                    con.getClass();
                    con.convertModule(0, sourcePath, targetPath, false);
                    JeusDeploymentManager.setApplicationPath(application, targetPath);
                    application.getNameAndPathAndDeploymentType().add(this.jeusMainFactory.createApplicationTypeDeploymentType(DeploymentTypeType.EAR));
                } else {
                    if (wlApp.getType() == WLApplication.EJB_TYPE) {
                        con.getClass();
                        con.convertModule(1, sourcePath, targetPath, false);
                    } else if (wlApp.getType() == WLApplication.EJB_TYPE_DIR) {
                        targetPath = JeusProperties.JEUS_APP_HOME + this.FS + wlApp.getName();
                        con.getClass();
                        con.convertModuleDir(1, sourcePath, wlApp.getName(), targetPath);
                    } else if (wlApp.getType() == WLApplication.WEB_TYPE) {
                        con.getClass();
                        con.convertModule(2, sourcePath, targetPath, false);
                    } else if (wlApp.getType() == WLApplication.WEB_TYPE_DIR) {
                        targetPath = JeusProperties.JEUS_APP_HOME + this.FS + wlApp.getName();
                        con.getClass();
                        con.convertModuleDir(2, sourcePath, wlApp.getName(), targetPath);
                    }
                    JeusDeploymentManager.setApplicationPath(application, targetPath);
                    application.getNameAndPathAndDeploymentType().add(this.jeusMainFactory.createApplicationTypeDeploymentType(DeploymentTypeType.COMPONENT));
                }
            }
            catch (JeusException e) {
                JeusLogger.getLogger((String)"jeus.converter").log(Level.SEVERE, "Fail to convet " + sourcePath, e);
                continue;
            }
            System.out.println("Conversion Success - " + sourcePath + " To " + targetPath + "\n");
            this.jeusMainJaxb.getApplication().add(application);
        }
    }

    private void fillLifecycleInvocation(Vector methods, Vector arguments, String invocationType, EngineContainerType engineContainer) throws JAXBException {
        for (int j = 0; j < methods.size(); ++j) {
            LifecycleInvocationType lifecycleInvocation = this.jeusMainFactory.createLifecycleInvocationType();
            String className = (String)methods.elementAt(j);
            lifecycleInvocation.setClassName(className);
            InvocationType invocation = this.jeusMainFactory.createInvocationType();
            MethodParamType invocationMethod = this.jeusMainFactory.createMethodParamType();
            invocationMethod.setMethodName("main");
            MethodParamsType methodParams = this.jeusMainFactory.createMethodParamsType();
            methodParams.getMethodParam().add("java.lang.String[]");
            invocationMethod.setMethodParams(methodParams);
            invocation.setInvocationMethod(invocationMethod);
            String parameter = (String)arguments.elementAt(j);
            if (parameter != null) {
                Vector paramsVector = this.parseParameters(parameter);
                for (int y = 0; y < paramsVector.size(); ++y) {
                    String param = (String)paramsVector.elementAt(y);
                    invocation.getInvocationArgument().add(param);
                }
            }
            invocation.setInvocationType(InvocationTypeType.valueOf((String)invocationType));
            lifecycleInvocation.getInvocation().add(invocation);
            engineContainer.getLifecycleInvocation().add(lifecycleInvocation);
        }
    }

    private Vector parseParameters(String parameters) {
        Vector<String> paramVector = new Vector<String>();
        int index = parameters.indexOf(",");
        if (index == -1) {
            paramVector.add(parameters);
            return paramVector;
        }
        int temp = 0;
        while (index != -1) {
            paramVector.add(parameters.substring(temp, index));
            temp = index + 1;
            index = parameters.indexOf(",", temp);
        }
        paramVector.add(parameters.substring(temp));
        return paramVector;
    }

    private boolean isAlreadyInDSList(List dsList, String exportName) {
        for (int i = 0; i < dsList.size(); ++i) {
            DatabaseType database = (DatabaseType)dsList.get(i);
            if (!database.getExportName().equals(exportName)) continue;
            return true;
        }
        return false;
    }
}

