/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.desctojaxb;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import jeus.servlet.deployment.descriptor.RoleMappingDescriptor;
import jeus.tool.converter.common.ModuleConversion;
import jeus.tool.converter.weblogic.descriptor.WLWEBDescriptor;
import jeus.tool.converter.weblogic.xmltowldesc.WLWEBConverter;
import jeus.xml.binding.jeusDD.ContextType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.RoleMappingType;
import jeus.xml.binding.jeusDD.RolePermissionType;

public class WEBDDJaxbConverter {
    private static String FS = System.getProperty("file.separator");
    private ObjectFactory webDDfactory = new ObjectFactory();
    private WLWEBDescriptor wlWebDdInfo = null;

    public String constructJaxbObject(String sourcePath, String targetDir, String moduleName, boolean webDDOnly) throws JAXBException, IOException {
        this.wlWebDdInfo = (WLWEBDescriptor)WLWEBConverter.readConfigureValue(sourcePath);
        if (this.wlWebDdInfo != null) {
            return null;
        }
        ContextType context = this.webDDfactory.createContextType();
        context.setEjbRef(this.fillEjbRef());
        context.setResRef(this.fillResRef());
        context.setResEnvRef(this.fillResEnvRef());
        context.setRoleMapping(this.fillRoleMapping());
        return this.saveDD(context, moduleName, targetDir, webDDOnly);
    }

    private String saveDD(ContextType webDD, String moduleName, String targetDir, boolean DDOnly) throws JAXBException, IOException {
        File targetFile = DDOnly ? new File(targetDir + FS + "jeus-web-dd_" + moduleName + ".xml") : new File(targetDir + FS + "jeus-web-dd.xml");
        ObjectFactory fac = new ObjectFactory();
        ModuleConversion.marshalDescriptor(fac.createJeusWebDd(webDD), "jeus.xml.binding.jeusDD", targetFile);
        return targetFile.getAbsolutePath();
    }

    private JndiRefType fillResEnvRef() throws JAXBException {
        Hashtable refTable = this.wlWebDdInfo.getResourceEnvRefs();
        Enumeration refNames = refTable.keys();
        JndiRefType resEnvRef = this.webDDfactory.createJndiRefType();
        while (refNames.hasMoreElements()) {
            String refName = (String)refNames.nextElement();
            JndiInfoType jndiInfo = this.webDDfactory.createJndiInfoType();
            jndiInfo.setRefName(refName);
            jndiInfo.setExportName((String)refTable.get(refName));
            resEnvRef.getJndiInfo().add(jndiInfo);
        }
        return resEnvRef;
    }

    private JndiRefType fillResRef() throws JAXBException {
        Hashtable refTable = this.wlWebDdInfo.getResourceRefs();
        Enumeration refNames = refTable.keys();
        JndiRefType resRef = this.webDDfactory.createJndiRefType();
        while (refNames.hasMoreElements()) {
            String refName = (String)refNames.nextElement();
            JndiInfoType jndiInfo = this.webDDfactory.createJndiInfoType();
            jndiInfo.setRefName(refName);
            jndiInfo.setExportName((String)refTable.get(refName));
            resRef.getJndiInfo().add(jndiInfo);
        }
        return resRef;
    }

    private JndiRefType fillEjbRef() throws JAXBException {
        Hashtable refTable = this.wlWebDdInfo.getEJBRefs();
        Enumeration refNames = refTable.keys();
        JndiRefType ejbRef = this.webDDfactory.createJndiRefType();
        while (refNames.hasMoreElements()) {
            String refName = (String)refNames.nextElement();
            JndiInfoType jndiInfo = this.webDDfactory.createJndiInfoType();
            jndiInfo.setRefName(refName);
            jndiInfo.setExportName((String)refTable.get(refName));
            ejbRef.getJndiInfo().add(jndiInfo);
        }
        return ejbRef;
    }

    private RoleMappingType fillRoleMapping() throws JAXBException {
        RoleMappingDescriptor roleMappingDes = this.wlWebDdInfo.getRoleMapping();
        RoleMappingType roleMapping = this.webDDfactory.createRoleMappingType();
        Hashtable roleAndPrincipalTable = roleMappingDes.getRoleMappings();
        Enumeration roles = roleAndPrincipalTable.keys();
        while (roles.hasMoreElements()) {
            String roleName = (String)roles.nextElement();
            RolePermissionType rolePermission = this.webDDfactory.createRolePermissionType();
            rolePermission.setRole(roleName);
            Vector principals = (Vector)roleAndPrincipalTable.get(roleName);
            for (int i = 0; i < principals.size(); ++i) {
                String principal = (String)principals.elementAt(i);
                rolePermission.getPrincipal().add(principal);
            }
            roleMapping.getRolePermission().add(rolePermission);
        }
        return roleMapping;
    }
}

