/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.desctojaxb;

import javax.xml.bind.JAXBException;
import jeus.tool.converter.common.ValidString;
import jeus.tool.converter.weblogic.descriptor.WLDomainConfigDescriptor;
import jeus.xml.binding.jeusDD.ContextGroupType;
import jeus.xml.binding.jeusDD.HttpListenerType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.ThreadPoolType;
import jeus.xml.binding.jeusDD.WebContainerType;
import jeus.xml.binding.jeusDD.WebserverConnectionType;

public class WEBMainJaxbConverter {
    public static String CONTEXT_GROUP_PREFIX = "CtxGrp_";
    public static String CONTEXT_GROUP_DOC_PREFIX = "GroupDoc_";

    public static WebContainerType constructJaxbObject(String domainName, WLDomainConfigDescriptor wlDomainInfo) throws JAXBException {
        ObjectFactory webMainFactory = new ObjectFactory();
        WebContainerType webContainer = webMainFactory.createWebContainerType();
        if (wlDomainInfo == null) {
            return null;
        }
        ContextGroupType contextGroup = webMainFactory.createContextGroupType();
        String ctxGroupName = CONTEXT_GROUP_PREFIX + domainName;
        String ctxGroupDocBase = CONTEXT_GROUP_DOC_PREFIX + domainName;
        if (ValidString.notEmptyString(ctxGroupName)) {
            contextGroup.setGroupName(ctxGroupName);
        }
        WebserverConnectionType webserverConnection = webMainFactory.createWebserverConnectionType();
        HttpListenerType httpListener = webMainFactory.createHttpListenerType();
        httpListener.setListenerId("http1");
        httpListener.setPort((long)wlDomainInfo.getPortNumber());
        ThreadPoolType threadPool = webMainFactory.createThreadPoolType();
        threadPool.setMin(5L);
        httpListener.setThreadPool(threadPool);
        webserverConnection.getWebtobListenerOrHttpListenerOrTcpListener().add(httpListener);
        contextGroup.setWebserverConnection(webserverConnection);
        webContainer.getContextGroup().add(contextGroup);
        return webContainer;
    }
}

