/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.process;

import java.io.File;
import jeus.server.NodeControllerStub;
import jeus.tool.converter.weblogic.descriptor.WLDomainConfigDescriptor;
import jeus.tool.converter.weblogic.process.ProcessConversion;
import jeus.tool.converter.weblogic.xmltowldesc.WLDomainConfigConverter;
import jeus.util.JeusException;

public class ConversionUtil {
    private static String FS = System.getProperty("file.separator");

    public static void checkAliveNode(String nodeName) throws Exception {
        try {
            NodeControllerStub test = new NodeControllerStub();
            test.connectTo(nodeName);
            test.disconnect();
        }
        catch (Exception e) {
            throw new JeusException("NODE : " + nodeName + " is not alive, jeusmanager should be on", (Throwable)e);
        }
    }

    public static void getWLConfigInfo() throws Exception {
        String msg = "";
        if (ProcessConversion.is_domain_info) {
            return;
        }
        String domainPath = ProcessConversion.DOMAIN_DIR + FS + "config.xml";
        File domainFile = new File(domainPath);
        if (!domainFile.exists()) {
            throw new JeusException("config.xml not exists");
        }
        ProcessConversion.wlDomainInfo = (WLDomainConfigDescriptor)WLDomainConfigConverter.readConfigValue(domainPath);
        ProcessConversion.is_domain_info = true;
    }

    public static String createEnginDir(String domainName, String enginType) throws Exception {
        String engineName = ProcessConversion.NODE_NAME + enginType + domainName;
        String ENGINE_DIR = ProcessConversion.JEUS_HOME + FS + "config" + FS + ProcessConversion.NODE_NAME + FS + engineName;
        File engineDirFile = new File(ENGINE_DIR);
        try {
            engineDirFile.mkdir();
        }
        catch (SecurityException e) {
            throw new JeusException("creation of directory for Engine failed : " + ENGINE_DIR, (Throwable)e);
        }
        return ENGINE_DIR;
    }
}

