/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.converter.weblogic.process;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import jeus.tool.common.WIOParameters;
import jeus.tool.converter.common.ModuleConversion;
import jeus.tool.converter.weblogic.descriptor.WLDomainConfigDescriptor;
import jeus.tool.converter.weblogic.desctojaxb.EJBDDJaxbConverter;
import jeus.tool.converter.weblogic.desctojaxb.JMSMainJaxbConverter;
import jeus.tool.converter.weblogic.desctojaxb.JeusMainJaxbConverter;
import jeus.tool.converter.weblogic.desctojaxb.WEBDDJaxbConverter;
import jeus.tool.converter.weblogic.desctojaxb.WEBMainJaxbConverter;
import jeus.tool.converter.weblogic.process.ConversionUtil;
import jeus.util.JeusBootstrapProperties;
import jeus.util.JeusException;
import jeus.util.file.FileUtils;
import jeus.xml.binding.jeusDD.EjbEngineType;
import jeus.xml.binding.jeusDD.JmsServerType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.WebContainerType;

public class ProcessConversion
extends ModuleConversion {
    public static String JEUS_HOME = JeusBootstrapProperties.JEUS_HOME;
    public static WLDomainConfigDescriptor wlDomainInfo = null;
    public static boolean is_domain_info = false;
    private static String FS = System.getProperty("file.separator");
    public static String NODE_NAME = WIOParameters.HOST_NAME;
    public static String DOMAIN_DIR = "";

    public void convertDomainToJeus(String domainDIR) throws Exception {
        if (domainDIR == null) {
            throw new JeusException("Domain Directory must be set");
        }
        if (JEUS_HOME == null) {
            throw new JeusException("JEUS HOME must be set");
        }
        DOMAIN_DIR = domainDIR;
        ConversionUtil.checkAliveNode(NODE_NAME);
        ConversionUtil.getWLConfigInfo();
        JeusMainJaxbConverter jeusMainCon = new JeusMainJaxbConverter();
        jeusMainCon.constructJaxbObject();
        String domainName = wlDomainInfo.getDomainName();
        this.createEngineDirectory(domainName);
        System.out.println("(step8)Engine Directory creation succesful");
        System.out.println("FINISH!!");
    }

    private void createEngineDirectory(String domainName) throws Exception {
        String EJB_ENGINE_DIR = ConversionUtil.createEnginDir(domainName, "_ejb_");
        String WEB_ENGINE_DIR = ConversionUtil.createEnginDir(domainName, "_servlet_");
        String JMS_ENGINE_DIR = ConversionUtil.createEnginDir(domainName, "_jms_");
        ObjectFactory fac = new ObjectFactory();
        String EJB_MAIN_PATH = EJB_ENGINE_DIR + FS + "EJBMain.xml";
        ObjectFactory ejbMainFactory = new ObjectFactory();
        EjbEngineType ejbEngine = ejbMainFactory.createEjbEngineType();
        File ejbMainFile = new File(EJB_MAIN_PATH);
        ProcessConversion.marshalDescriptor(fac.createEjbEngine(ejbEngine), "jeus.xml.binding.jeusDD", ejbMainFile);
        String JMS_MAIN_PATH = JMS_ENGINE_DIR + FS + "JMSMain.xml";
        JmsServerType jmsServer = JMSMainJaxbConverter.constructJaxbObject(wlDomainInfo);
        if (jmsServer != null) {
            File jsmMainFile = new File(JMS_MAIN_PATH);
            ObjectFactory factory = new ObjectFactory();
            ProcessConversion.marshalDescriptor(jmsServer, "jeus.xml.binding.jeusDD", jsmMainFile);
        }
        String WEB_MAIN_PATH = WEB_ENGINE_DIR + FS + "WEBMain.xml";
        WebContainerType webContainer = WEBMainJaxbConverter.constructJaxbObject(domainName, wlDomainInfo);
        if (webContainer != null) {
            File webMainFile = new File(WEB_MAIN_PATH);
            ProcessConversion.marshalDescriptor(fac.createWebContainer(webContainer), "jeus.xml.binding.jeusDD", webMainFile);
        }
    }

    public void convertJeusDD(int moduleType, File workingSpace, String jarFileName) throws JAXBException, IOException {
        File META_INF = null;
        String WEBLOGIC_DD = null;
        String ModuleExtension = null;
        if (moduleType == 1) {
            META_INF = new File(workingSpace.getAbsolutePath() + FS + "META-INF");
            WEBLOGIC_DD = "weblogic-ejb-jar.xml";
            ModuleExtension = ".jar";
        } else if (moduleType == 2) {
            META_INF = new File(workingSpace.getAbsolutePath() + FS + "WEB-INF");
            WEBLOGIC_DD = "weblogic.xml";
            ModuleExtension = ".war";
        }
        File[] fileList = META_INF.listFiles();
        if (fileList == null) {
            System.out.println(META_INF + " does not have any files");
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (!file.getName().startsWith(WEBLOGIC_DD)) continue;
            String moduleName = null;
            int index = jarFileName.lastIndexOf(ModuleExtension);
            moduleName = index != -1 ? jarFileName.substring(0, index) : jarFileName;
            String ddTargetDir = FileUtils.separateDirAndFile((String)file.getAbsolutePath())[0];
            this.doConvertJeusDD(moduleType, file.getAbsolutePath(), ddTargetDir, moduleName, false);
        }
    }

    public String doConvertJeusDD(int moduleType, String sourcePath, String targetDir, String moduleName, boolean ddOnly) throws JAXBException, IOException {
        if (targetDir == null) {
            targetDir = new File(".").getAbsolutePath();
        }
        if (moduleType == 1) {
            EJBDDJaxbConverter con = new EJBDDJaxbConverter();
            return con.constructJaxbObject(sourcePath, targetDir, moduleName, ddOnly);
        }
        if (moduleType == 2) {
            WEBDDJaxbConverter con = new WEBDDJaxbConverter();
            return con.constructJaxbObject(sourcePath, targetDir, moduleName, ddOnly);
        }
        return null;
    }

    public void convertModuleDir(int type, String sourcePath, String moduleName, String targetPath) throws IOException, JAXBException {
        this.convertJeusDD(type, new File(sourcePath), moduleName);
        ProcessConversion.copyDirectory(sourcePath, targetPath);
    }
}

