/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.ddinit;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchiveFactory;
import jeus.deploy.archivist.JarArchiveFactory;
import jeus.tool.ddinit.DDInitializer;
import jeus.util.JeusRuntimeException;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Converter;
import jeus.util.properties.JeusManagerProperties;
import jeus.util.properties.JeusPropertyValues;
import jeus.xml.binding.JeusJAXBException;

public abstract class JeusBaseDDInit
implements DDInitializer {
    public static String SOURCE;
    public static final String KEY_SOURCE = "source";
    public static final String KEY_LOG_LEVEL = "logging-level";
    protected JeusLogger logger;
    protected File destDir;
    protected String moduleName;
    protected String contextPath;
    protected Vector classes;
    protected URLClassLoader classLoader;
    protected AbstractArchive sourceArchive;
    protected Properties p;
    private boolean isDDFileAdded;
    Object[] j2eeDescriptors;
    private boolean bFileArchive;

    public JeusBaseDDInit() {
        try {
            this.logger = JeusPropertyValues.JEUS_CATEGORY == 0 ? JeusLogger.createDefaultConsoleJeusLogger((String)"jeus") : (JeusLogger)JeusLogger.getLogger((String)"jeus.ddinit");
        }
        catch (Exception e) {
            throw new JeusRuntimeException((Throwable)e);
        }
        this.classes = new Vector();
        this.isDDFileAdded = false;
        this.bFileArchive = false;
    }

    public void execute() throws Exception {
        if (this.logger.isLoggable(JeusMessage_Converter._6510_LEVEL)) {
            this.logger.log(JeusMessage_Converter._6510_LEVEL, JeusMessage_Converter._6510);
        }
        boolean needWriteJ2EEDesc = false;
        Object[] j2eeDesc = this.getJ2EEDescriptor();
        if (this.doesAllJ2EEDDExist(j2eeDesc)) {
            this.logger.log(JeusMessage_Converter._6511_LEVEL, JeusMessage_Converter._6511);
        } else {
            needWriteJ2EEDesc = true;
            this.loadContent();
            j2eeDesc = this.initJ2EEDescriptor(j2eeDesc);
            this.isDDFileAdded = true;
        }
        Object[] jeusDesc = null;
        boolean needWriteJEUSDesc = false;
        jeusDesc = this.getJEUSDescriptor();
        if (this.doesAllJEUSDDExist(jeusDesc)) {
            this.logger.log(JeusMessage_Converter._6512_LEVEL, JeusMessage_Converter._6512);
        } else {
            needWriteJEUSDesc = true;
            jeusDesc = this.initJeusDescriptor(j2eeDesc, jeusDesc);
            this.isDDFileAdded = true;
        }
        this.writeDescriptor((Object[])(needWriteJ2EEDesc ? j2eeDesc : null), (Object[])(needWriteJEUSDesc ? jeusDesc : null));
        if (this.logger.isLoggable(JeusMessage_Converter._6513_LEVEL)) {
            this.logger.log(JeusMessage_Converter._6513_LEVEL, JeusMessage_Converter._6513);
        }
    }

    public boolean isDDFileAdded() {
        return this.isDDFileAdded;
    }

    protected abstract boolean doesAllJ2EEDDExist(Object[] var1);

    protected abstract boolean doesAllJEUSDDExist(Object[] var1);

    public void setJ2EEDescriptor(Object[] objects) {
        this.j2eeDescriptors = objects;
    }

    protected abstract Object[] getJ2EEDescriptor() throws JAXBException, JeusJAXBException;

    protected abstract Object[] getJEUSDescriptor() throws JAXBException, JeusJAXBException;

    protected abstract Object[] initJeusDescriptor(Object[] var1, Object[] var2) throws IOException, JAXBException;

    protected abstract Object[] initJ2EEDescriptor(Object[] var1) throws JAXBException;

    public void loadClasses() throws IOException {
        if (this.logger.isLoggable(JeusMessage_Converter._6514_LEVEL)) {
            this.logger.log(JeusMessage_Converter._6514_LEVEL, JeusMessage_Converter._6514);
        }
        Enumeration entries = this.sourceArchive.entries();
        ArrayList<String> list = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            String aClass = (String)entries.nextElement();
            int index = aClass.lastIndexOf(".class");
            if (index < 0) continue;
            aClass = aClass.substring(0, index).replace('/', '.');
            list.add(aClass);
        }
        URL[] urls = this.makeClasspathURL();
        this.classLoader = new URLClassLoader(urls, JeusBaseDDInit.class.getClassLoader());
        this.classes = new Vector();
        if (list.size() == 0) {
            this.logger.log(JeusMessage_Converter._6515_LEVEL, JeusMessage_Converter._6515, (Object)this.sourceArchive.getArchiveUri());
        } else {
            this.logger.log(JeusMessage_Converter._6516_LEVEL, JeusMessage_Converter._6516, (Object)this.sourceArchive.getArchiveUri());
        }
        for (int i = 0; i < list.size(); ++i) {
            String s = (String)list.get(i);
            try {
                Class<?> class1 = this.classLoader.loadClass(s);
                this.classes.add(class1);
                this.logger.log(Level.FINE, "Found class '{0}'", (Object)class1.getName());
                continue;
            }
            catch (ClassNotFoundException classnotfoundexception) {
                this.logger.log(JeusMessage_Converter._6517_LEVEL, JeusMessage_Converter._6517, (Throwable)classnotfoundexception);
                continue;
            }
            catch (NoClassDefFoundError noclassdeffounderror) {
                this.logger.log(JeusMessage_Converter._6518_LEVEL, JeusMessage_Converter._6518, (Throwable)noclassdeffounderror);
            }
        }
    }

    private URL[] makeClasspathURL() {
        ArrayList<URL> list = new ArrayList<URL>();
        list.add(this.sourceArchive.getArchiveUrl());
        return list.toArray(new URL[list.size()]);
    }

    protected void loadContent() throws IOException {
        this.loadClasses();
    }

    public boolean setParameters(String propertyPath) throws IOException {
        int index;
        File loadFile;
        if (propertyPath == null) {
            propertyPath = JeusManagerProperties.DDINIT_PROPERTY_PATH;
        }
        if ((loadFile = new File(propertyPath)).exists()) {
            System.out.println("loadFile : " + loadFile.toString());
            FileInputStream is = new FileInputStream(loadFile);
            this.p.load(is);
        } else {
            this.p = new Properties();
        }
        if (SOURCE == null) {
            SOURCE = this.p.getProperty(KEY_SOURCE);
        }
        if (SOURCE == null) {
            this.logger.log(JeusMessage_Converter._6519_LEVEL, JeusMessage_Converter._6519);
            this.printUsage();
            return false;
        }
        String logLevel = (String)this.p.get(KEY_LOG_LEVEL);
        if (logLevel != null) {
            this.logger.setLevel(JeusLevel.parse((String)logLevel));
        }
        this.logger.log(Level.FINE, "Source={0}", (Object)SOURCE);
        this.sourceArchive = this.bFileArchive ? FileArchiveFactory.openArchiveStatic((String)SOURCE) : ((index = SOURCE.lastIndexOf(this.getModuleExtension())) >= 0 ? JarArchiveFactory.openArchiveStatic((String)SOURCE) : FileArchiveFactory.openArchiveStatic((String)SOURCE));
        if (this.moduleName == null) {
            this.moduleName = SOURCE.substring(SOURCE.lastIndexOf(File.separator) + 1);
            index = this.moduleName.lastIndexOf(this.getModuleExtension());
            if (index >= 0) {
                this.moduleName = this.moduleName.substring(0, index);
            }
        }
        this.logger.log(JeusMessage_Converter._6521_LEVEL, JeusMessage_Converter._6521);
        return true;
    }

    public void setSourceArchive(AbstractArchive archive) {
        this.sourceArchive = archive;
    }

    protected abstract String getModuleExtension();

    protected boolean parseArgs(String[] arg) throws IOException {
        if (arg.length == 0) {
            this.printUsage();
            return false;
        }
        this.p = new Properties();
        String propertyPath = null;
        while (arg.length > 0) {
            if (arg[0].equals("-property")) {
                if (arg.length < 2) {
                    this.printUsage();
                    return false;
                }
                propertyPath = arg[1];
                arg = AbstractConsoleUtil.removeElements((String[])arg, (int[])new int[]{0, 1});
                continue;
            }
            if (arg[0].equals("-level")) {
                this.p.put(KEY_LOG_LEVEL, arg[1]);
                arg = AbstractConsoleUtil.removeElements((String[])arg, (int[])new int[]{0, 1});
                continue;
            }
            if (arg[0].equals("-webcontext")) {
                this.moduleName = arg[1];
                arg = AbstractConsoleUtil.removeElements((String[])arg, (int[])new int[]{0, 1});
                continue;
            }
            if (!arg[0].equals("-filearchive")) break;
            this.bFileArchive = true;
            arg = AbstractConsoleUtil.removeElements((String[])arg, (int[])new int[]{0});
        }
        if (arg.length == 0) {
            return this.setParameters(propertyPath);
        }
        SOURCE = arg[0];
        return this.setParameters(propertyPath);
    }

    protected void printUsage() {
        if (this.logger.isLoggable(JeusMessage_Converter._6520_LEVEL)) {
            this.logger.log(JeusMessage_Converter._6520_LEVEL, JeusMessage_Converter._6520);
        }
    }

    public int getIntegerDefaultValue(String propertyName, int defaultValue) {
        if (this.p == null) {
            return defaultValue;
        }
        String value = (String)this.p.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            int intValue = Integer.parseInt(value);
            return intValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getStringDefaultValue(String propertyName, String defaultValue) {
        if (this.p == null) {
            return defaultValue;
        }
        String value = (String)this.p.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public long getLongDefaultValue(String propertyName, long defaultValue) {
        if (this.p == null) {
            return defaultValue;
        }
        String value = (String)this.p.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            long longValue = Long.parseLong(value);
            return longValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBooleanDefaultValue(String propertyName, boolean defaultValue) {
        if (this.p == null) {
            return defaultValue;
        }
        String value = (String)this.p.get(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setContextPath(String contextRoot) {
        this.contextPath = contextRoot;
        if (this.contextPath != null) {
            this.contextPath = this.contextPath.trim();
            if (!this.contextPath.startsWith("/")) {
                this.contextPath = "/" + this.contextPath;
            }
        }
    }
}

