/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.deployment;

import java.util.Hashtable;
import java.util.Vector;
import jeus.descriptor.tool.ApplicationDescriptor;
import jeus.descriptor.tool.Descriptor;
import jeus.descriptor.tool.ModuleInfo;
import jeus.tool.common.WIOParameters;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.deployment.ApplicationClientModule;
import jeus.tool.deployment.DeployUnit;
import jeus.tool.deployment.EJBModule;
import jeus.tool.deployment.RARModule;
import jeus.tool.deployment.WEBModule;
import jeus.tool.manager.common.FileDirMapDescriptor;

public class Application
extends DeployUnit {
    public static final String DESCRIPTOR = "application.xml";
    public static final String DD_DESCRIPTOR = null;
    private String moduleName = null;
    Hashtable URI_MODULE_Map = null;

    public Application(String source) {
        super(source);
    }

    public String getDescriptorPath() {
        return this.root + fs + "META-INF" + fs + DESCRIPTOR;
    }

    public String getJeusDDToBePath() {
        return DD_DESCRIPTOR;
    }

    public void openPackage() throws Exception {
        super.openPackage();
        this.openModulesInPackage();
    }

    public void openEARPackageOnly() throws Exception {
        super.openPackage();
    }

    private void openModulesInPackage() throws Exception {
        Vector modules = ((ApplicationDescriptor)this.descriptor).getModules();
        if (modules == null) {
            return;
        }
        for (int i = 0; i < modules.size(); ++i) {
            ModuleInfo moduleInfo = (ModuleInfo)modules.get(i);
            String source = this.getRoot() + fs + moduleInfo.getURI().replace('/', fs.charAt(0));
            int type = moduleInfo.getType();
            String altDD = moduleInfo.getAltDD();
            if (type == 1) {
                EJBModule ejbModule = new EJBModule(source);
                ejbModule.openPackage();
                if (altDD != null) {
                    ejbModule.setDescriptor(this.descriptor);
                }
                moduleInfo.setDeployUnit(ejbModule);
                continue;
            }
            if (type == 2) {
                WEBModule webModule = new WEBModule(source);
                webModule.openPackage();
                if (altDD != null) {
                    webModule.setDescriptor(this.descriptor);
                }
                moduleInfo.setDeployUnit(webModule);
                continue;
            }
            if (type != 3) continue;
            ApplicationClientModule appClientModule = new ApplicationClientModule(source);
            appClientModule.openPackage();
            if (altDD != null) {
                // empty if block
            }
            moduleInfo.setDeployUnit(appClientModule);
        }
    }

    public void modifyPackage() throws Exception {
        super.modifyPackage();
        this.openModulesInPackage();
    }

    public void deleteDeployedFiles() {
        super.deleteDeployedFiles();
    }

    public Application(String source, boolean isWIO) throws Exception {
        super(source, isWIO);
        this.moduleName = this.getSourceName();
        this.loadInternalModuleMap();
    }

    public void loadInternalModuleMap() {
        this.URI_MODULE_Map = new Hashtable();
        Vector modules = ((ApplicationDescriptor)this.descriptor).getModules();
        for (int i = 0; i < modules.size(); ++i) {
            ModuleInfo moduleInfo = (ModuleInfo)modules.get(i);
            String source = this.getRoot() + fs + moduleInfo.getURI().replace('/', fs.charAt(0));
            int type = moduleInfo.getType();
            String altDD = moduleInfo.getAltDD();
            try {
                if (type == 1) {
                    EJBModule ejbModule = new EJBModule(source, true);
                    if (altDD != null) {
                        ejbModule.setDescriptor(this.descriptor);
                    }
                    moduleInfo.setDeployUnit(ejbModule);
                } else if (type == 2) {
                    WEBModule webModule = new WEBModule(source, true);
                    if (altDD != null) {
                        webModule.setDescriptor(this.descriptor);
                    }
                    moduleInfo.setDeployUnit(webModule);
                } else if (type == 3) {
                    ApplicationClientModule appClientModule = new ApplicationClientModule(source, true);
                    if (altDD != null) {
                        // empty if block
                    }
                    moduleInfo.setDeployUnit(appClientModule);
                } else if (type == 4) {
                    RARModule rarModule = new RARModule(source, true);
                    if (altDD != null) {
                        rarModule.setDescriptor(this.descriptor);
                    }
                    moduleInfo.setDeployUnit(rarModule);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null || msg.trim().equals("")) {
                    e.printStackTrace();
                }
                System.out.println(msg);
            }
            this.URI_MODULE_Map.put(moduleInfo.getURI(), moduleInfo);
        }
    }

    public Hashtable getURIMapTable() {
        return this.URI_MODULE_Map;
    }

    public DeployUnit getSubDeployUnit(String uri) {
        ModuleInfo moduleInfo = (ModuleInfo)this.URI_MODULE_Map.get(uri);
        return moduleInfo.getDeployUnit();
    }

    public Application(String source, FileDirMapDescriptor fileDesc, XMLTree xmldescriptor) throws Exception {
        super(source, fileDesc, xmldescriptor);
        this.moduleName = this.getSourceName();
        this.descriptor = (Descriptor)this.converter.getUserObject(this.getDescriptorTree());
    }

    public void setModuleName(String name) {
        this.moduleName = name;
    }

    public String getPublicID() {
        return WIOParameters.getPublicID(1103);
    }

    public String getSystemID() {
        return WIOParameters.getSystemID(1103);
    }

    public int getUnitType() {
        return 1103;
    }

    public int getJeusDDType() {
        return -1;
    }

    public String getSourceName() {
        String source = this.getSource();
        String name = source.substring(source.lastIndexOf(fsc) + 1);
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(0, index);
        }
        return name;
    }
}

