/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.manager.common;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import jeus.tool.common.WIOParameters;
import jeus.tool.deployment.FileInfo;

public class FileDirMapDescriptor {
    private Hashtable fileDirectoryMap;
    private Set externalFiles;
    Set webinfList = new HashSet();

    public FileDirMapDescriptor() {
        this.fileDirectoryMap = new Hashtable();
        this.externalFiles = new HashSet();
    }

    public FileDirMapDescriptor(String baseDirectory, Vector files) {
        this.fileDirectoryMap = new Hashtable();
        this.externalFiles = new HashSet();
        File directory = new File(baseDirectory);
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            Object next = e.nextElement();
            if (next instanceof File) {
                this.fileDirectoryMap.put(next, directory);
                continue;
            }
            File nextFile = new File((String)next);
            this.fileDirectoryMap.put(nextFile, directory);
        }
    }

    public int getNumOfFile() {
        return this.fileDirectoryMap.size();
    }

    public void add(File file, File directory) {
        this.fileDirectoryMap.put(file, directory);
    }

    public static File relativize(File parent, File child) {
        String baseDir = parent.getAbsolutePath();
        String baseDirAndChild = child.getAbsolutePath();
        String relative = baseDirAndChild.substring(baseDir.length(), baseDirAndChild.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return new File(relative);
    }

    public void addExternalFile(File file) {
        this.getExternalFiles().add(file);
    }

    public Set getExternalFiles() {
        if (this.externalFiles == null) {
            this.externalFiles = new HashSet();
        }
        return this.externalFiles;
    }

    public void removeExternalFiles(File file) {
        this.getExternalFiles().remove(file);
    }

    public ArrayList getClassList() {
        Set classSet = this.getClassNamesSet();
        ArrayList<String> classList = new ArrayList<String>();
        if (classSet == null) {
            return classList;
        }
        for (String className : classSet) {
            classList.add(className);
        }
        return classList;
    }

    public ArrayList getJSPList() {
        ArrayList<String> jspList = new ArrayList<String>();
        Enumeration e = this.getFiles();
        while (e.hasMoreElements()) {
            File f = (File)e.nextElement();
            if (f == null || !f.toString().endsWith(".jsp")) continue;
            jspList.add(f.toString());
        }
        return jspList;
    }

    public Set getClassNamesSet() {
        String WEB_INF_PREFIX = "WEB-INF" + WIOParameters.FS + "classes" + WIOParameters.FS;
        HashSet<String> classNamesSet = new HashSet<String>();
        this.webinfList = new HashSet();
        Enumeration e = this.getFiles();
        while (e.hasMoreElements()) {
            File f = (File)e.nextElement();
            if (!f.toString().endsWith(".class")) continue;
            if (f.toString().startsWith(WEB_INF_PREFIX)) {
                File directory = (File)this.fileDirectoryMap.get(f);
                this.webinfList.add(new File(directory, WEB_INF_PREFIX));
                f = new File(f.toString().substring(WEB_INF_PREFIX.length()));
            }
            classNamesSet.add(FileDirMapDescriptor.classNameFromFile(f));
        }
        return classNamesSet;
    }

    public Iterator getWEBINFDirectories() {
        return this.webinfList.iterator();
    }

    public Iterator getDirectories() {
        HashSet directories = new HashSet();
        Enumeration e = this.fileDirectoryMap.elements();
        while (e.hasMoreElements()) {
            directories.add(e.nextElement());
        }
        return directories.iterator();
    }

    public File getDirectoryFor(File file) {
        Object o = this.fileDirectoryMap.get(file);
        if (o == null) {
            return null;
        }
        return (File)o;
    }

    public Enumeration getFiles() {
        return this.fileDirectoryMap.keys();
    }

    public Set getFilesSet() {
        HashSet<File> s = new HashSet<File>();
        Enumeration e = this.getFiles();
        while (e.hasMoreElements()) {
            File f = (File)e.nextElement();
            s.add(f);
        }
        return s;
    }

    public File getFullFileFor(File file) {
        Object o = this.fileDirectoryMap.get(file);
        if (o == null) {
            return null;
        }
        return new File((File)o, file.toString());
    }

    public void removeFile(File file) {
        this.fileDirectoryMap.remove(file);
    }

    public String toString() {
        return this.fileDirectoryMap.toString();
    }

    public static String classNameFromFile(File file) {
        String className = file.toString();
        if (className.endsWith(".class")) {
            String contentFileStr = className.replace(File.separatorChar, '.');
            int cutOffPoint = contentFileStr.lastIndexOf(".class");
            className = contentFileStr.substring(0, cutOffPoint);
        }
        return className;
    }

    public static String getFileURI(File file) {
        String uriName = file.toString();
        String contentFileStr = uriName.replace(File.separatorChar, '/');
        return contentFileStr;
    }

    public Vector getFileInfos() {
        Vector<FileInfo> fileInfos = new Vector<FileInfo>();
        Enumeration e = this.getFiles();
        while (e.hasMoreElements()) {
            File f = (File)e.nextElement();
            File fullFile = this.getFullFileFor(f);
            String fileURI = FileDirMapDescriptor.getFileURI(f);
            fileInfos.add(new FileInfo(fullFile, fileURI));
        }
        return fileInfos;
    }
}

