/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.monitorapi;

import java.util.Iterator;
import jeus.server.NodeControllerStub;
import jeus.tool.monitorapi.ClusterMonitorManager;
import jeus.tool.monitorapi.EJBEngineMonitorManager;
import jeus.tool.monitorapi.EngineContainerMonitorManager;
import jeus.tool.monitorapi.GroupMonitorManager;
import jeus.tool.monitorapi.JMSEngineMonitorManager;
import jeus.tool.monitorapi.MonitorManager;
import jeus.tool.monitorapi.NodeMonitorManager;
import jeus.tool.monitorapi.ServletEngineMonitorManager;
import jeus.tool.monitorapi.exceptions.MonitorException;
import jeus.tool.monitorapi.monitorinfo.ClusterMonitorInfo;
import jeus.tool.monitorapi.monitorinfo.NodeMonitorInfo;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusBootstrapProperties;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Monitor;
import jeus.util.properties.JeusNetProperties;

public class JeusMonitorFactory {
    public static final int NODE = 1;
    public static final int GROUP = 2;
    public static final int CLUSTER = 3;
    public static final int ENGINE_CONTAINER = 4;
    public static final int EJB_ENGINE = 5;
    public static final int JMS_ENGINE = 6;
    public static final int SERVLET_ENGINE = 7;
    private String nodeName;
    private String userid;
    private String password;
    private NodeControllerStub controller = new NodeControllerStub();
    public static JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.tool.monitorapi");

    public JeusMonitorFactory(String nodeName, String userid, String password) {
        String jeusHome = JeusBootstrapProperties.JEUS_HOME;
        if (jeusHome == null || jeusHome.equals("")) {
            if (logger.isLoggable(JeusMessage_Monitor._2_LEVEL)) {
                logger.log(JeusMessage_Monitor._2_LEVEL, JeusMessage_Monitor._2);
            }
            return;
        }
        String jeusPort = String.valueOf(JeusNetProperties.JEUS_BASE_PORT);
        if (jeusPort == null || jeusPort.equals("")) {
            if (logger.isLoggable(JeusMessage_Monitor._3_LEVEL)) {
                logger.log(JeusMessage_Monitor._3_LEVEL, JeusMessage_Monitor._3);
            }
            return;
        }
        this.nodeName = nodeName;
        this.userid = userid;
        this.password = password;
    }

    private void verifySecurity() throws MonitorException {
    }

    public NodeMonitorInfo getNodeMonitorInfo() {
        NodeMonitorInfo nodeMonitorInfo = new NodeMonitorInfo();
        return null;
    }

    public ClusterMonitorInfo getClusterMonitorInfo() throws MonitorException {
        return null;
    }

    public Iterator getGroupMonitorInfo() {
        return null;
    }

    private MonitorManager getMonitorManager(int monitorType, String[] args) throws MonitorException {
        switch (monitorType) {
            case 1: {
                return new NodeMonitorManager(this.nodeName, args);
            }
            case 2: {
                return new GroupMonitorManager(this.nodeName, args);
            }
            case 3: {
                return new ClusterMonitorManager(this.nodeName);
            }
            case 4: {
                return new EngineContainerMonitorManager(this.nodeName, args);
            }
            case 5: {
                return new EJBEngineMonitorManager(this.nodeName, args);
            }
            case 6: {
                return new JMSEngineMonitorManager(this.nodeName, args);
            }
            case 7: {
                return new ServletEngineMonitorManager(this.nodeName, args);
            }
        }
        throw new MonitorException(ErrorMsgManager.getLocalizedString((int)JeusMessage_Monitor._1, (Object)String.valueOf(monitorType)));
    }
}

