/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.serializer;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import jeus.tool.common.WIOParameters;
import jeus.tool.util.JeusDirectoryScanner;
import jeus.tool.util.SerializeManager;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.schema.XMLUIConverter;
import jeus.util.ErrorMsgManager;
import jeus.util.JeusException;

public class serializer {
    File sourcePath = null;
    File destPath = null;
    static int CONFIG_TYPE = 0;
    static int MONITOR_TYPE = 1;
    int conversionType = CONFIG_TYPE;

    public int getConversionType() {
        return this.conversionType;
    }

    public void setConversionType(int value) {
        this.conversionType = value;
    }

    public void setSourcePath(File path) {
        this.sourcePath = path;
    }

    public void setDestPath(File path) {
        this.destPath = path;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("serializer <-monitor|-config> [source_path] [dest_path]");
            return;
        }
        serializer sm = new serializer();
        for (int i = 0; i < args.length; ++i) {
            if (i == 0) {
                String convertTypeString = args[0];
                if (convertTypeString.equals("-monitor")) continue;
                sm.setConversionType(CONFIG_TYPE);
            }
            if (i == 1) {
                sm.setSourcePath(new File(args[1]));
            }
            if (i != 2) continue;
            sm.setDestPath(new File(args[2]));
        }
        sm.executeGeneration();
    }

    public void executeGeneration() {
        block11: {
            String name;
            int index;
            block10: {
                WIOParameters.XML_VALIDATION = false;
                if (!this.sourcePath.isDirectory()) break block10;
                if (this.destPath == null) {
                    this.destPath = this.sourcePath;
                }
                JeusDirectoryScanner ds = new JeusDirectoryScanner();
                String[] xmlList = null;
                String[] acceptableExt = new String[]{".xml"};
                xmlList = ds.getIncludedFiles(this.sourcePath, acceptableExt);
                if (xmlList == null) {
                    JOptionPane.showMessageDialog(null, "Can't find any XML file");
                    return;
                }
                for (int i = 0; i < xmlList.length; ++i) {
                    File sFile = new File(this.sourcePath, xmlList[i]);
                    String name2 = xmlList[i].replaceAll(".xml", ".conf");
                    File targetFile = new File(this.destPath, name2);
                    if (this.getConversionType() != 0) continue;
                    XMLUIConverter converter = new XMLUIConverter();
                    try {
                        XMLUIContainer schemaConfig = (XMLUIContainer)converter.load(sFile);
                        SerializeManager.serialize(targetFile, (Object)schemaConfig);
                        System.out.println("serialization (config) success :" + xmlList[i]);
                        continue;
                    }
                    catch (JeusException je) {
                        String msg = ErrorMsgManager.getLocalizedString((Throwable)je);
                        System.out.println("serialization (Config) fail for = " + xmlList[i] + " msg:" + msg);
                        je.printStackTrace();
                        continue;
                    }
                    catch (Exception e2) {
                        System.out.println("serialization (Config) fail for = " + xmlList[i]);
                        e2.printStackTrace();
                    }
                }
                break block11;
            }
            String sourcePathURI = this.sourcePath.getPath();
            if (this.destPath == null) {
                this.destPath = new File(sourcePathURI.substring(0, sourcePathURI.lastIndexOf(System.getProperty("file.separator"))));
            }
            if ((index = (name = sourcePathURI.substring(sourcePathURI.lastIndexOf(System.getProperty("file.separator")) + 1)).lastIndexOf(46)) >= 0) {
                name = name.substring(0, index);
            }
            name = name + ".conf";
            File targetFile = new File(this.destPath, name);
            if (this.getConversionType() != 0) break block11;
            XMLUIConverter converter = new XMLUIConverter();
            try {
                XMLUIContainer schemaConfig = (XMLUIContainer)converter.load(this.sourcePath);
                SerializeManager.serialize(targetFile, (Object)schemaConfig);
                System.out.println("serialization (config) success :" + name);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    class ExtThread
    extends Thread {
        String command = new String("no command");

        ExtThread() {
        }

        public void setCommand(String str) {
            this.command = str;
        }

        public void run() {
            try {
                Runtime rt = Runtime.getRuntime();
                Process execProcess = rt.exec(this.command);
                BufferedInputStream outStream = new BufferedInputStream(execProcess.getInputStream(), 4096);
                BufferedInputStream errStream = new BufferedInputStream(execProcess.getErrorStream(), 4096);
                ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int err = 0;
                int avail = 0;
                int exitVal = 0;
                while (true) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        String errorMessage;
                        exitVal = execProcess.exitValue();
                        if (exitVal == 0) {
                            return;
                        }
                        try {
                            while ((avail = outStream.available()) > 0) {
                                buffer = new byte[avail];
                                err = outStream.read(buffer, 0, avail);
                                byteOutStream.write(buffer, 0, err);
                            }
                            errorMessage = " " + byteOutStream.toString();
                            System.out.println(errorMessage);
                            while ((avail = errStream.available()) > 0) {
                                buffer = new byte[avail];
                                err = errStream.read(buffer, 0, avail);
                                byteOutStream.write(buffer, 0, err);
                            }
                        }
                        catch (IOException exIO) {
                            // empty catch block
                        }
                        errorMessage = " " + byteOutStream.toString();
                        System.out.println(errorMessage);
                        return;
                    }
                    catch (IllegalThreadStateException ex) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ee) {
                ee.printStackTrace();
                return;
            }
        }
    }
}

