/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.util;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;
import jeus.util.JeusBootstrapProperties;
import jeus.util.Logger;

public class GUIUtil {
    public static JWindow splashPanel;

    public static void showSplashPanel(ImageIcon myIcon) {
        if (splashPanel == null) {
            splashPanel = new JWindow();
            splashPanel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    splashPanel.setVisible(false);
                }
            });
            splashPanel.getContentPane().setLayout(new BorderLayout());
            splashPanel.getContentPane().add(new JLabel(myIcon));
            int splashWidth = myIcon.getIconWidth();
            int splashHeight = myIcon.getIconHeight();
            Dimension screenRectangle = Toolkit.getDefaultToolkit().getScreenSize();
            double splashX = (screenRectangle.getWidth() - (double)splashWidth) / 2.0;
            double splashY = (screenRectangle.getHeight() - (double)splashHeight) / 2.0;
            splashPanel.setBounds((int)splashX, (int)splashY, splashWidth, splashHeight);
        }
        splashPanel.setVisible(true);
    }

    public static void showSplashPanel(String iconName) {
        if (splashPanel == null) {
            splashPanel = new JWindow();
            splashPanel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent me) {
                    splashPanel.setVisible(false);
                }
            });
            splashPanel.getContentPane().setLayout(new BorderLayout());
            ImageIcon imageIcon = GUIUtil.getImageIconFor(iconName);
            splashPanel.getContentPane().add(new JLabel(imageIcon));
            int splashWidth = imageIcon.getIconWidth();
            int splashHeight = imageIcon.getIconHeight();
            Dimension screenRectangle = Toolkit.getDefaultToolkit().getScreenSize();
            double splashX = (screenRectangle.getWidth() - (double)splashWidth) / 2.0;
            double splashY = (screenRectangle.getHeight() - (double)splashHeight) / 2.0;
            splashPanel.setBounds((int)splashX, (int)splashY, splashWidth, splashHeight);
        }
        splashPanel.setVisible(true);
    }

    public static void hideSplashPanel() {
        if (splashPanel != null) {
            splashPanel.setVisible(false);
            splashPanel = null;
        }
    }

    public static ImageIcon getImageIconFor(String filename) {
        String fs = System.getProperty("file.separator");
        File f = new File(JeusBootstrapProperties.JEUS_HOME);
        f = new File(f, "classes");
        f = new File(f, "jeus");
        f = new File(f, "tool");
        f = new File(f, "util");
        f = new File(f, "resource");
        f = new File(f, filename);
        return new ImageIcon(f.toString());
    }

    public static void showHelp() {
        String fs = System.getProperty("file.separator");
        String command = null;
        String strUrl = JeusBootstrapProperties.JEUS_HOME + fs + "webhome" + fs + "admin_home" + fs + "help" + fs + "help_main.html";
        command = System.getProperty("os.name").startsWith("Windows") ? "rundll32 url.dll,FileProtocolHandler " + strUrl : "netscape -remote openURL(" + strUrl + ")";
        try {
            Runtime.getRuntime().exec(command);
        }
        catch (Exception ex) {
            Logger.log("Help is not available", (Throwable)ex, 3);
        }
    }
}

