/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.xmlui.Blind;
import jeus.tool.xmlui.ChoiceXMLUIPanel;
import jeus.tool.xmlui.XMLUIComponentList;
import jeus.tool.xmlui.XMLUIConstants;
import jeus.tool.xmlui.XMLUIDialog;
import jeus.tool.xmlui.XMLUIManager;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.XMLUIPanelFactory;
import jeus.tool.xmlui.XMLUIPanelList;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.component.XMLUIComponentFactory;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.schema.XMLUIChoice;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.schema.XMLUIElement;
import jeus.tool.xmlui.util.MessageUtil;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class TabXMLUIPanel
extends XMLUIPanel {
    protected XMLUIContainer mySchema;
    protected Element myTree;
    Vector xmlChildTrees;
    protected String externalID = "";
    protected Vector msgVector = new Vector();
    protected XMLUIManager xmluimgr = new XMLUIManager();
    TabXMLUIPanel multiChildPanel;
    protected boolean _OnlyOneSubContainer = false;
    protected int pane_xml_y = -1;
    protected int xml_x_max = 2;
    private int selectedTabIndex = 0;
    protected JTabbedPane tabPane = new JTabbedPane();
    protected JCheckBox enable = new JCheckBox();
    protected boolean containsEnable = false;
    protected JPanel basicPane;
    protected boolean eating = false;

    public TabXMLUIPanel(XMLUIEngine engine, Object descriptor) {
        super(engine, descriptor);
    }

    public TabXMLUIPanel(XMLUISession session, Object descriptor) {
        super(session, descriptor);
    }

    public XMLUIContainer getConfigContainer() {
        return this.mySchema;
    }

    public String getExternalID() {
        return this.externalID;
    }

    public void setExternalID(String val) {
        this.externalID = val;
    }

    public XMLUIManager getXMLUIManager() {
        return this.xmluimgr;
    }

    public void resetValue() {
        if (this.containsEnable) {
            this.enable.setSelected(false);
            this.setInnerEnabled(false);
        }
        if (this.tabPane.getComponentCount() >= 1) {
            this.tabPane.setSelectedIndex(0);
        }
        Enumeration elementEnum = this.xmluimgr.getUIKeys();
        while (elementEnum.hasMoreElements()) {
            String itemName = (String)elementEnum.nextElement();
            XMLUIPanel confElementPane = this.xmluimgr.getPanel(itemName);
            confElementPane.resetValue();
        }
    }

    private void setInnerEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Enumeration keys = this.xmluimgr.getUIKeys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.xmluimgr.getPanel(key).setEnabled(enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enable.setEnabled(enabled);
        if (this.containsEnable && !this.enable.isSelected()) {
            this.setInnerEnabled(false);
        } else {
            this.setInnerEnabled(enabled);
        }
    }

    public void setConfigurationValue(Element element) {
        this.myTree = element;
        if (element == null || element.getChildNodes().getLength() == 0) {
            if (Boolean.valueOf(this.mySchema.getSelectable()).booleanValue()) {
                this.enable.setSelected(false);
                this.setInnerEnabled(false);
            }
            this.resetValue();
            return;
        }
        this.resetValue();
        Hashtable elementTable = XMLUtil.getElementMapping(element);
        int elementCount = element.getChildNodes().getLength();
        int eleTmpCount = 0;
        if (Boolean.valueOf(this.mySchema.getSelectable()).booleanValue()) {
            if (elementCount == 0) {
                this.enable.setSelected(false);
                this.setInnerEnabled(false);
            } else {
                this.enable.setSelected(true);
                this.setInnerEnabled(true);
            }
        }
        Enumeration keyEnum2 = elementTable.keys();
        while (keyEnum2.hasMoreElements()) {
            XMLUIPanel confElementPane;
            String elementName = (String)keyEnum2.nextElement();
            Vector elementVector = (Vector)elementTable.get(elementName);
            Element elementTree = null;
            if (elementVector != null && elementVector.size() == 1) {
                elementTree = (Element)elementVector.get(0);
            }
            if ((confElementPane = this.xmluimgr.getPanel(elementName)) == null) continue;
            if (confElementPane instanceof XMLUIComponentList) {
                XMLUIComponentList mTablePane = (XMLUIComponentList)confElementPane;
                String[] tmpList = new String[elementVector.size()];
                for (int x = 0; x < tmpList.length; ++x) {
                    Element tmpTree = (Element)elementVector.get(x);
                    tmpList[x] = XMLUtil.getValue(tmpTree);
                }
                mTablePane.setValue(tmpList);
                continue;
            }
            if (confElementPane instanceof ChoiceXMLUIPanel) {
                ChoiceXMLUIPanel exPane = (ChoiceXMLUIPanel)confElementPane;
                exPane.setValue(elementVector);
                continue;
            }
            if (confElementPane instanceof XMLUIPanelList) {
                XMLUIPanelList mListPane = (XMLUIPanelList)confElementPane;
                if (mListPane.isExclusive()) {
                    mListPane.setValueExclusive(elementVector);
                    if (elementVector != null) {
                        eleTmpCount += elementVector.size();
                    }
                    if (eleTmpCount != elementCount) continue;
                    mListPane.setValueFinish();
                    continue;
                }
                mListPane.setValue(elementVector);
                continue;
            }
            confElementPane.setValue(elementTree);
        }
    }

    public String checkInputValidity() {
        return this.checkInputValidity(this.getMessage());
    }

    public String checkInputValidity(Vector msgVector) {
        XMLUIDialog dlg = XMLUIDialog.getDlg(msgVector);
        if (dlg != null) {
            dlg.showDialog();
            return "XML Configuration is not complete";
        }
        return null;
    }

    public void setChanged(XMLUIPanel panel) {
        if (panel.isChanged() && !this.isChanged()) {
            this.setChanged(true);
        }
    }

    public Element getConfigurationValue() throws XMLConverterException {
        this.clearMessage();
        if (!this.isEnabled() || this.containsEnable && !this.enable.isSelected()) {
            return null;
        }
        String rootName = this.mySchema.getName();
        if (rootName.startsWith("$") && rootName.endsWith("$")) {
            if (this.myTree == null) {
                this.myTree = XMLUtil.createElement(this.getSession().getDocument(), rootName.substring(1, rootName.length() - 1));
            }
        } else {
            this.myTree = XMLUtil.createElement(this.getSession().getDocument(), rootName);
        }
        Enumeration elements = this.xmluimgr.getElementConfigObjects();
        while (elements.hasMoreElements()) {
            XMLUIElement subItem = (XMLUIElement)elements.nextElement();
            String itemName = subItem.getName();
            boolean isMulti = Boolean.valueOf(subItem.getMulti());
            XMLUIPanel configPanel = this.xmluimgr.getPanel(itemName);
            if (isMulti) {
                XMLUIComponentList multiItemTable = (XMLUIComponentList)configPanel;
                String[] valueList = (String[])multiItemTable.getValue();
                if (valueList != null && valueList.length > 0) {
                    for (int k = 0; k < valueList.length; ++k) {
                        Element elementTree = XMLUtil.createElement(this.getSession().getDocument(), itemName, valueList[k]);
                        if (valueList[k] == null || valueList[k].trim().equals("")) continue;
                        this.myTree.appendChild(elementTree);
                    }
                }
            } else {
                XMLUIComponent confItemPane = (XMLUIComponent)configPanel;
                Element xmlTree = (Element)confItemPane.getValue();
                if (xmlTree != null) {
                    this.myTree.appendChild(xmlTree);
                }
            }
            this.addMessage(configPanel.getMessage());
            this.setChanged(configPanel);
        }
        Enumeration containers = this.xmluimgr.getContainerConfigObjects();
        while (containers.hasMoreElements()) {
            XMLUIContainer subContainer = (XMLUIContainer)containers.nextElement();
            String containerName = subContainer.getName();
            boolean isRequired = Boolean.valueOf(subContainer.getRequired());
            boolean isMulti = Boolean.valueOf(subContainer.getMulti());
            if (isMulti) {
                XMLUIPanelList newMultiPanel = (XMLUIPanelList)this.xmluimgr.getPanel(containerName);
                Vector multiValue = (Vector)newMultiPanel.getValue();
                this.setChanged(newMultiPanel);
                this.addMessage(newMultiPanel.getMessage());
                if (multiValue == null) continue;
                XMLUtil.appendChildNodes(this.myTree, multiValue);
                continue;
            }
            if (subContainer instanceof XMLUIChoice) {
                XMLUIPanel panel = this.xmluimgr.getPanel(containerName);
                if (!(panel instanceof ChoiceXMLUIPanel)) {
                    System.err.println("[XMLUI] ChoiceXMLUIPanel is expected." + panel.getName() + ":" + panel.getClass().getName());
                    continue;
                }
                ChoiceXMLUIPanel exPane = (ChoiceXMLUIPanel)this.xmluimgr.getPanel(containerName);
                Object exPaneValue = exPane.getValue();
                if (exPaneValue != null) {
                    if (exPaneValue instanceof Vector) {
                        Vector exVector = (Vector)exPaneValue;
                        XMLUtil.appendChildNodes(this.myTree, exVector);
                    } else if (exPaneValue instanceof Element) {
                        this.myTree.appendChild((Element)exPaneValue);
                    }
                } else if (isRequired) {
                    this.addMessage(this.buildRequiredElementMessage(containerName));
                }
                this.setChanged(exPane);
                this.addMessage(exPane.getMessage());
                continue;
            }
            TabXMLUIPanel newPanel = (TabXMLUIPanel)this.xmluimgr.getPanel(containerName);
            Element newTree = (Element)newPanel.getValue();
            this.setChanged(newPanel);
            this.addMessage(newPanel.getMessage());
            if (newTree != null) {
                if (newTree.getChildNodes().getLength() == 0) {
                    if (!"empty".equals(subContainer.getType()) && !isRequired) continue;
                    this.myTree.appendChild(newTree);
                    continue;
                }
                String name = XMLUtil.getName(newTree);
                if (name.startsWith("$") && name.endsWith("$")) {
                    XMLUtil.appendChildNodes(this.myTree, XMLUtil.getChildNodes(newTree));
                    continue;
                }
                this.myTree.appendChild(newTree);
                continue;
            }
            if (!isRequired) continue;
            this.addMessage(this.buildRequiredElementMessage(containerName));
        }
        return this.myTree;
    }

    protected String buildRequiredElementMessage(String name) {
        return "@XPATH@ is a required element.";
    }

    public void createConfig() {
        this.getValue();
    }

    public Object getValue() {
        Element val = null;
        try {
            val = this.getConfigurationValue();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
        return val;
    }

    public void setValue(Object val) {
        this.eating = true;
        if (this.containsEnable) {
            this.enable.setSelected(false);
            this.setInnerEnabled(false);
        }
        if (val instanceof Element) {
            Element valTree = (Element)val;
            this.setConfigurationValue(valTree);
        }
        this.eating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitExclusiveSingle(XMLUIContainer anyConfig) {
        ChoiceXMLUIPanel exPane = null;
        if (anyConfig.getContainerUIClass() != null && !anyConfig.getContainerUIClass().trim().equals("")) {
            try {
                String uri = anyConfig.getContainerUIClass();
                Class<?> containerPanelClass = Class.forName(uri);
                Constructor<?> c = containerPanelClass.getConstructor(XMLUISession.class, XMLUIContainer.class);
                exPane = (ChoiceXMLUIPanel)c.newInstance(this.getSession(), anyConfig);
            }
            catch (ClassNotFoundException e) {
                System.out.println("class not found : " + anyConfig.getContainerUIClass());
            }
            catch (InstantiationException e2) {
                System.out.println("class instantiation error : " + anyConfig.getContainerUIClass());
            }
            catch (IllegalAccessException e3) {
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (exPane == null) {
                    exPane = new ChoiceXMLUIPanel(this.getSession(), (Object)anyConfig);
                }
            }
        } else {
            exPane = new ChoiceXMLUIPanel(this.getSession(), (Object)anyConfig);
        }
        this.xmluimgr.setPanel(anyConfig.getName(), exPane);
        exPane.prepareResources(anyConfig);
        ++this.pane_xml_y;
        this.addConfigPane(anyConfig, exPane, this.xml_x_max, 1, 0, this.pane_xml_y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitExclusiveMulti(XMLUIContainer anyConfig) {
        XMLUIContainer childConfig = anyConfig.cloneMe();
        XMLUIPanelList mList = null;
        if (anyConfig.getContainerUIClass() != null && !anyConfig.getContainerUIClass().trim().equals("")) {
            try {
                String uri = anyConfig.getContainerUIClass();
                Class<?> containerPanelClass = Class.forName(uri);
                Constructor<?> c = containerPanelClass.getConstructor(XMLUISession.class, XMLUIContainer.class);
                mList = (XMLUIPanelList)c.newInstance(this.getSession(), childConfig);
            }
            catch (ClassNotFoundException e) {
                System.out.println("class not found : " + anyConfig.getContainerUIClass());
            }
            catch (InstantiationException e2) {
                System.out.println("class instantiation error : " + anyConfig.getContainerUIClass());
            }
            catch (IllegalAccessException e3) {
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (mList == null) {
                    mList = new XMLUIPanelList(this.getSession(), (Object)childConfig);
                }
            }
        } else {
            mList = new XMLUIPanelList(this.getSession(), (Object)childConfig);
        }
        ++this.pane_xml_y;
        this.xmluimgr.setPanel(anyConfig.getName(), mList);
        mList.prepareResources(anyConfig);
        mList.setMinOccurs(anyConfig.getMinOccurs());
        mList.setMaxOccurs(anyConfig.getMaxOccurs());
        this.addConfigPane(anyConfig, mList, this.xml_x_max, 1, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitMulti(XMLUIContainer anyConfig) {
        XMLUIContainer childConfig = anyConfig.cloneMe();
        childConfig.setMulti("false");
        XMLUIPanelList mList = null;
        if (anyConfig.getContainerUIClass() != null && !anyConfig.getContainerUIClass().trim().equals("")) {
            try {
                String uri = anyConfig.getContainerUIClass();
                Class<?> containerPanelClass = Class.forName(uri);
                Constructor<?> c = containerPanelClass.getConstructor(XMLUISession.class, XMLUIContainer.class);
                mList = (XMLUIPanelList)c.newInstance(this.getSession(), childConfig);
            }
            catch (ClassNotFoundException e) {
                System.out.println("class not found : " + anyConfig.getContainerUIClass());
            }
            catch (InstantiationException e2) {
                System.out.println("class instantiation error : " + anyConfig.getContainerUIClass());
            }
            catch (IllegalAccessException e3) {
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (mList == null) {
                    mList = new XMLUIPanelList(this.getSession(), (Object)anyConfig);
                }
            }
        } else {
            mList = new XMLUIPanelList(this.getSession(), (Object)childConfig);
        }
        mList.prepareResources(anyConfig);
        mList.setMinOccurs(anyConfig.getMinOccurs());
        mList.setMaxOccurs(anyConfig.getMaxOccurs());
        mList.setName(anyConfig.getName());
        mList.setDisplayName(anyConfig.getDisplayName());
        ++this.pane_xml_y;
        this.xmluimgr.setPanel(anyConfig.getName(), mList);
        this.addConfigPane(anyConfig, mList, this.xml_x_max, 1, 0, 0);
    }

    private static String getMessage(XMLUIEngine engine, String key, String[] args) {
        if (!key.startsWith("message:")) {
            return key;
        }
        key = key.substring(8);
        if (engine == null || engine.getResourceBundle() == null) {
            return key;
        }
        try {
            String pattern = engine.getResourceBundle().getString(key);
            return MessageFormat.format(pattern, args);
        }
        catch (Exception e) {
            return key;
        }
    }

    public static XMLUIPanel attatchConfigItem(XMLUISession session, JPanel contentPane, XMLUIElement element, int x, int y) {
        XMLUIPanel confPanel = null;
        String itemName = element.getName();
        String itemDisplayName = MessageUtil.getMessage(session.getEngine(), element.getDisplayName());
        boolean isMulti = Boolean.valueOf(element.getMulti());
        boolean isRequired = Boolean.valueOf(element.getRequired());
        if (isMulti) {
            XMLUIComponentList mTable = new XMLUIComponentList(session, (Object)element);
            String multiItemDisplay = itemName;
            if (itemDisplayName != null && !itemDisplayName.trim().equals("")) {
                multiItemDisplay = itemDisplayName;
            }
            mTable.setTitle(multiItemDisplay);
            String[] colNames = new String[]{multiItemDisplay};
            mTable.setColumnNames(colNames);
            mTable.setMinOccurs(element.getMinOccurs());
            mTable.setMaxOccurs(element.getMaxOccurs());
            mTable.setName(element.getName());
            mTable.setDisplayName(element.getDisplayName());
            contentPane.add((Component)mTable, new GridBagConstraints(x, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            confPanel = mTable;
        } else {
            JLabel itemLB;
            String labelName = "";
            labelName = itemDisplayName != null && !itemDisplayName.trim().equals("") ? itemDisplayName : itemName;
            if (isRequired) {
                itemLB = new JLabel(labelName + " *");
                itemLB.setForeground(XMLUIConstants.REQUIRED_COLOR);
            } else {
                itemLB = new JLabel(labelName);
            }
            XMLUIComponent itemPanel = XMLUIComponentFactory.createXMLUIComponent(session, element);
            contentPane.add((Component)itemLB, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            contentPane.add((Component)itemPanel, new GridBagConstraints(x + 1, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            confPanel = itemPanel;
        }
        return confPanel;
    }

    public void setInitSubItems(XMLUIElement[] subItems) {
        for (int i = 0; i < subItems.length; ++i) {
            XMLUIElement subItem = subItems[i];
            if (this.externalID != null) {
                subItem.setGlobalID(this.externalID);
            }
            XMLUIPanel confPanel = TabXMLUIPanel.attatchConfigItem(this.getSession(), this.basicPane, subItem, 0, ++this.pane_xml_y);
            this.xmluimgr.setPanel(subItem.getName(), confPanel);
        }
    }

    public void setInitSimple(XMLUIContainer container) {
        XMLUIContainer[] children = container.getConfigContainer();
        if (children == null || children.length == 0) {
            XMLUIElement[] subItems = container.getConfigItem();
            if (subItems.length > 0) {
                this.setInitSubItems(subItems);
                if (container.getParentLayOut() == null || !container.getParentLayOut().equals("flat")) {
                    ++this.pane_xml_y;
                    this.basicPane.add(Box.createVerticalGlue(), new GridBagConstraints(0, this.pane_xml_y, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
                }
            }
        } else {
            XMLUIElement[] subItems = container.getConfigItem();
            XMLUIContainer generalContainer = null;
            XMLUIContainer[] allContainers = container.getConfigContainer();
            if (subItems.length > 0) {
                int i;
                generalContainer = new XMLUIContainer();
                generalContainer.setName("$general$");
                generalContainer.setSmallIcon(container.getGeneralSmallIcon());
                generalContainer.setBigIcon(container.getGeneralBigIcon());
                generalContainer.setRequired(container.getRequired());
                generalContainer.setLayOut(container.getGeneralLayOut());
                for (i = 0; i < subItems.length; ++i) {
                    generalContainer.addConfigItem(subItems[i]);
                }
                allContainers = new XMLUIContainer[children.length + 1];
                allContainers[0] = generalContainer;
                for (i = 0; i < children.length; ++i) {
                    allContainers[i + 1] = children[i];
                }
            }
            ++this.pane_xml_y;
            this.setInitSubContainers(allContainers, this.pane_xml_y);
        }
    }

    public void setInitSubContainers(XMLUIContainer[] subContainers, int y_index) {
        this.beginInitSubContainers(subContainers);
        for (int i = 0; i < subContainers.length; ++i) {
            XMLUIContainer subContainer = subContainers[i];
            if (this.externalID != null) {
                subContainer.setGlobalID(this.externalID);
            }
            XMLUIPanel configPanel = null;
            if (Boolean.valueOf(subContainer.getMulti()).booleanValue()) {
                if (subContainer instanceof XMLUIChoice) {
                    this.setInitExclusiveMulti(subContainer);
                    continue;
                }
                this.setInitMulti(subContainer);
                continue;
            }
            if (subContainer instanceof XMLUIChoice) {
                this.setInitExclusiveSingle(subContainer);
                continue;
            }
            configPanel = XMLUIPanelFactory.createXMLUIPanel(subContainer, this.getSession());
            this.xmluimgr.setPanel(subContainer.getName(), configPanel);
            this.addConfigPane(subContainer, configPanel, this.xml_x_max, 1, 0, y_index);
        }
        this.endInitSubContainers(subContainers, 0, y_index, this.xml_x_max, 1);
    }

    public void isItOneSubContainer(XMLUIContainer anyConfig) {
        if (anyConfig.getConfigItem() == null || anyConfig.getConfigContainer() == null) {
            return;
        }
        if (anyConfig.getConfigItem().length == 0 && anyConfig.getConfigContainer().length == 1) {
            this._OnlyOneSubContainer = true;
            return;
        }
        this._OnlyOneSubContainer = false;
    }

    protected void addConfigPane(XMLUIContainer subContainer, XMLUIPanel newPanel, int colspan, int rowspan, int x, int y) {
        if (!this._OnlyOneSubContainer) {
            if (newPanel.getSmallIcon() != null) {
                this.tabPane.addTab(MessageUtil.getMessage(this.getEngine(), subContainer.getDisplayName()), newPanel.getSmallIcon(), newPanel);
            } else {
                this.tabPane.addTab(MessageUtil.getMessage(this.getEngine(), subContainer.getDisplayName()), newPanel);
            }
        } else {
            this.basicPane.add((Component)newPanel, new GridBagConstraints(x, y, colspan, rowspan, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    protected void beginInitSubContainers(XMLUIContainer[] subContainers) {
    }

    protected void endInitSubContainers(XMLUIContainer[] subContainers, int x, int y, int colspan, int rowspan) {
        if (!this._OnlyOneSubContainer && this.tabPane.getTabCount() > 0) {
            this.basicPane.add((Component)this.tabPane, new GridBagConstraints(x, y, colspan, rowspan, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
    }

    public void initialize(Map sessionAttrs) {
        super.initialize(sessionAttrs);
        this.mySchema = (XMLUIContainer)this.descriptor;
        this.basicPane = this.mySchema.getBlind() != null && this.mySchema.getBlind().equals(Boolean.TRUE.toString()) ? new Blind(super.getEngine()) : new JPanel();
        this.enable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TabXMLUIPanel.this.setInnerEnabled(TabXMLUIPanel.this.enable.isSelected());
            }
        });
        this.enable.setText(MessageUtil.getMessage(this.getEngine(), "message:xmlui.enable", "Enable"));
        this.enable.setBackground(Color.decode("#B2B2B2"));
        if (this.mySchema.getGlobalID() != null) {
            this.externalID = this.mySchema.getGlobalID();
        }
        this.setLayout(new BorderLayout());
        if (this.mySchema == null) {
            return;
        }
        this.basicPane.setLayout(new GridBagLayout());
        this.isItOneSubContainer(this.mySchema);
        this.setInitSimple(this.mySchema);
        this.setLayout(new BorderLayout());
        if (Boolean.valueOf(this.mySchema.getSelectable()).booleanValue()) {
            this.add((Component)this.enable, "North");
            this.enable.setSelected(false);
            this.setInnerEnabled(false);
            this.containsEnable = true;
        }
        this.add((Component)this.basicPane, "Center");
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (TabXMLUIPanel.this.eating) {
                    TabXMLUIPanel.this.selectedTabIndex = TabXMLUIPanel.this.tabPane.getSelectedIndex();
                    return;
                }
                if (TabXMLUIPanel.this.selectedTabIndex == TabXMLUIPanel.this.tabPane.getSelectedIndex()) {
                    return;
                }
                XMLUIPanel panel = (XMLUIPanel)TabXMLUIPanel.this.tabPane.getComponentAt(TabXMLUIPanel.this.selectedTabIndex);
                if (panel instanceof TabXMLUIPanel) {
                    panel.createConfig();
                    Vector msg = panel.getMessage();
                    if (msg != null && msg.size() > 0) {
                        XMLUIDialog dlg = XMLUIDialog.getDlg(msg);
                        dlg.removeCancel();
                        if (dlg != null) {
                            dlg.showDialog();
                            TabXMLUIPanel.this.tabPane.setSelectedIndex(TabXMLUIPanel.this.selectedTabIndex);
                            return;
                        }
                    }
                }
                TabXMLUIPanel.this.selectedTabIndex = TabXMLUIPanel.this.tabPane.getSelectedIndex();
            }
        });
    }

    public void commitChanges() {
        Enumeration elements = this.xmluimgr.getElementConfigObjects();
        while (elements.hasMoreElements()) {
            XMLUIElement subItem = (XMLUIElement)elements.nextElement();
            XMLUIPanel configPanel = this.xmluimgr.getPanel(subItem.getName());
            configPanel.commitChanges();
        }
        Enumeration containers = this.xmluimgr.getContainerConfigObjects();
        while (containers.hasMoreElements()) {
            XMLUIContainer subContainer = (XMLUIContainer)containers.nextElement();
            XMLUIPanel configPanel = this.xmluimgr.getPanel(subContainer.getName());
            configPanel.commitChanges();
        }
    }
}

