/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jeus.tool.common.CancelButtonDialog;
import jeus.tool.xmlui.ListXMLUIPanel;
import jeus.tool.xmlui.XMLUIMessage;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;

public class XMLUIDialog
extends CancelButtonDialog {
    public boolean SHOW_ERROR_DEFAULT_DLG = true;
    JPanel confPane;
    JPanel jPanel1 = new JPanel();
    JButton cancelBT = new JButton();
    JButton okBT = new JButton();
    JButton viewBT = new JButton();
    JButton ignoreBT = new JButton();
    Component strut = Box.createHorizontalStrut(20);
    Object value;
    private static final int FIXED_WIDTH = 400;
    private static final int LIST_FIXED_WIDTH = 600;
    private static final int LIST_FIXED_HEIGHT = 500;

    public XMLUIDialog(JPanel confPane) {
        this.confPane = confPane;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean showDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getPreferredSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
        this.isCanceled = false;
        this.isOk = false;
        this.pack();
        if (this.confPane instanceof ListXMLUIPanel && ((ListXMLUIPanel)this.confPane).getItemCount() > 0) {
            if (this.getWidth() < 600) {
                this.setSize(600, this.getHeight());
            }
            if (this.getHeight() < 500) {
                this.setSize(this.getWidth(), 500);
            }
        } else if (this.getWidth() < 400) {
            this.setSize(400, this.getHeight());
        }
        this.show();
        return this.getCanceled();
    }

    public void setCustomizeErrorDlg() {
        this.SHOW_ERROR_DEFAULT_DLG = false;
    }

    private void jbInit() throws Exception {
        if (this.confPane instanceof XMLUIPanel) {
            this.setTitle(((XMLUIPanel)this.confPane).getTitle());
        }
        this.setModal(true);
        this.cancelBT.setText("Cancel");
        this.cancelBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLUIDialog.this.cancelBT_actionPerformed(e);
            }
        });
        this.okBT.setText("  Ok  ");
        this.okBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLUIDialog.this.okBT_actionPerformed(e);
            }
        });
        this.viewBT.setText("  XML  ");
        this.viewBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLUIDialog.this.viewBT_actionPerformed(e);
            }
        });
        this.ignoreBT.setText(" Ignore ");
        this.ignoreBT.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                XMLUIDialog.this.ignoreBT_actionPerformed(e);
            }
        });
        if (this.confPane instanceof ListXMLUIPanel) {
            this.getContentPane().add((Component)this.confPane, "Center");
        } else {
            JScrollPane scroll = new JScrollPane(this.confPane);
            this.getContentPane().add((Component)scroll, "Center");
        }
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel1.add((Component)this.okBT, null);
        this.jPanel1.add((Component)this.cancelBT, null);
        this.jPanel1.add(this.strut, null);
        this.jPanel1.add((Component)this.viewBT, null);
    }

    public Object getValue() {
        return this.value;
    }

    void cancelBT_actionPerformed(ActionEvent e) {
        this.setCanceled();
        this.dispose();
    }

    void okBT_actionPerformed(ActionEvent e) {
        String message;
        if (this.confPane instanceof XMLUIPanel) {
            this.value = ((XMLUIPanel)this.confPane).getValue();
        }
        if ((message = this.checkInputValidity()) != null) {
            return;
        }
        this.setOk();
        this.dispose();
    }

    void ignoreBT_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void viewBT_actionPerformed(ActionEvent e) {
        Element element = (Element)((XMLUIPanel)this.confPane).getValue();
        String xmldoc = null;
        try {
            xmldoc = XMLUtil.unmarshall(element);
        }
        catch (Exception e1) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bout);
            e1.printStackTrace(out);
            xmldoc = bout.toString();
        }
        CancelButtonDialog dlg = new CancelButtonDialog(null, true);
        JTextArea textArea = new JTextArea(xmldoc);
        textArea.setRows(15);
        textArea.setColumns(40);
        JScrollPane sp = new JScrollPane(textArea);
        dlg.getContentPane().add((Component)sp, "Center");
        dlg.setTitle("XML Document for " + XMLUtil.getName(element));
        dlg.showDialog();
    }

    public void removeCancel() {
        this.jPanel1.remove(this.cancelBT);
    }

    public void removeXML() {
        this.jPanel1.remove(this.strut);
        this.jPanel1.remove(this.viewBT);
    }

    public void addIgnore() {
        this.jPanel1.add(this.ignoreBT);
    }

    public String checkInputValidity() {
        if (!(this.confPane instanceof XMLUIPanel)) {
            return null;
        }
        try {
            return ((XMLUIPanel)this.confPane).checkInputValidity();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static XMLUIDialog getDlg(Vector msgVector) {
        if (msgVector == null || msgVector.size() == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < msgVector.size(); ++i) {
            str.append("[" + (i + 1) + "] ");
            str.append(((XMLUIMessage)msgVector.get(i)).getMessage());
            str.append("\n");
        }
        JTextArea msgArea = new JTextArea(str.toString());
        msgArea.setLineWrap(true);
        msgArea.setWrapStyleWord(true);
        msgArea.setEditable(false);
        msgArea.setBackground(Color.WHITE);
        msgArea.setOpaque(true);
        msgArea.setRows(10);
        msgArea.setColumns(30);
        msgArea.setFont(new Font("Dialog", 0, 12));
        msgArea.setForeground(Color.BLACK);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)msgArea, "Center");
        XMLUIDialog dlg = new XMLUIDialog(panel);
        dlg.setTitle("Message Dialog");
        dlg.removeCancel();
        dlg.removeXML();
        return dlg;
    }

    public static XMLUIDialog getIgnorableDlg(Vector msgVector) {
        if (msgVector == null || msgVector.size() == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < msgVector.size(); ++i) {
            str.append("[" + (i + 1) + "]");
            str.append(((XMLUIMessage)msgVector.get(i)).getMessage());
            str.append("\n");
        }
        JTextArea msgArea = new JTextArea(str.toString());
        msgArea.setLineWrap(true);
        msgArea.setWrapStyleWord(true);
        msgArea.setEditable(false);
        msgArea.setBackground(Color.WHITE);
        msgArea.setOpaque(true);
        msgArea.setFont(new Font("Dialog", 0, 12));
        msgArea.setForeground(Color.BLACK);
        msgArea.setRows(10);
        msgArea.setColumns(40);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)msgArea, "Center");
        XMLUIDialog dlg = new XMLUIDialog(panel);
        dlg.setTitle("Message Dialog");
        dlg.removeCancel();
        dlg.removeXML();
        dlg.addIgnore();
        return dlg;
    }
}

