/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui;

import java.awt.Container;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import jeus.tool.common.ConfigPane;
import jeus.tool.xmlui.XMLUIMessage;
import jeus.tool.xmlui.engine.XMLUIEngine;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.util.MessageUtil;

public abstract class XMLUIPanel
extends ConfigPane {
    protected Icon smallIcon;
    protected Icon bigIcon;
    protected Vector message;
    protected boolean changed;
    protected XMLUISession session;

    public XMLUIPanel() {
    }

    public XMLUIPanel(Object descriptor) {
        super(descriptor);
    }

    public XMLUIPanel(XMLUIEngine engine, Object descriptor) {
        super(descriptor);
        this.session = new XMLUISession(engine);
    }

    public XMLUIPanel(XMLUISession session, Object descriptor) {
        super(descriptor);
        this.session = session;
    }

    public abstract Object getValue();

    public abstract void setValue(Object var1);

    public abstract void resetValue();

    public void initialize(Map sessionAttrs) {
        if (sessionAttrs == null) {
            return;
        }
        for (Map.Entry entry : sessionAttrs.entrySet()) {
            this.session.addAttribute(entry.getKey().toString(), entry.getValue());
        }
    }

    public XMLUISession getSession() {
        return this.session;
    }

    public void setSession(XMLUISession session) {
        this.session = session;
    }

    public XMLUIEngine getEngine() {
        if (this.session != null) {
            return this.session.getEngine();
        }
        return null;
    }

    public void commitChanges() {
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void replaceValueWithCurrentValue() {
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        Container parentContainer = this;
        while ((parentContainer = parentContainer.getParent()) != null) {
            if (!(parentContainer instanceof XMLUIPanel)) continue;
            ((XMLUIPanel)parentContainer).setChanged(changed);
        }
    }

    public Vector getMessage() {
        return this.message;
    }

    protected void addMessage(Vector messages) {
        if (messages == null) {
            return;
        }
        for (int i = 0; i < messages.size(); ++i) {
            this.addMessage((XMLUIMessage)messages.get(i));
        }
    }

    protected void addMessage(XMLUIMessage msg) {
        if (this.message == null) {
            this.message = new Vector();
        }
        if (this.getName() != null && !this.getName().startsWith("$") && !this.getName().endsWith("$")) {
            msg.addPath(this.getName());
        }
        this.message.add(msg);
    }

    protected void addMessage(String msg) {
        if (msg == null) {
            return;
        }
        this.addMessage(new XMLUIMessage(msg));
    }

    protected void clearMessage() {
        if (this.message != null) {
            this.message.clear();
        }
    }

    public Icon getSmallIcon() {
        return this.smallIcon;
    }

    public Icon getBigIcon() {
        return this.bigIcon;
    }

    public void setBigIcon(String resourcePath) {
        this.bigIcon = this.createIcon(resourcePath);
    }

    public void setSmallIcon(String resourcePath) {
        this.smallIcon = this.createIcon(resourcePath);
    }

    protected Icon createIcon(String resourcePath) {
        try {
            return new ImageIcon(this.getClass().getResource(resourcePath));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void prepareResources(XMLUIContainer subContainer) {
        this.setSmallIcon(subContainer.getSmallIcon());
        this.setBigIcon(subContainer.getBigIcon());
        this.setTitle(MessageUtil.getMessage(this.getEngine(), subContainer.getDisplayName()));
        this.setName(subContainer.getName());
        this.setDisplayName(subContainer.getDisplayName());
    }

    public String getMessage(String key, String alternative) {
        return this.getMessage(key, new String[0], alternative);
    }

    public String getMessage(String key, String[] args, String alternative) {
        String pattern = null;
        if (key.startsWith("message:")) {
            key = key.substring(8);
        } else {
            pattern = alternative;
        }
        XMLUIEngine engine = this.getEngine();
        try {
            if (pattern == null && engine.getResourceBundle() != null) {
                pattern = engine.getResourceBundle().getString(key);
            }
            return MessageFormat.format(pattern, args);
        }
        catch (Exception e) {
            return alternative;
        }
    }

    public String getMessage(String key) {
        return this.getMessage(key, new String[0]);
    }

    public String getMessage(String key, String[] args) {
        String alternative = null;
        alternative = key.startsWith("message:") ? key.substring(8) : key;
        return this.getMessage(key, args, alternative);
    }
}

