/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jeus.tool.xmlui.component.AdaptorRegistry;
import jeus.tool.xmlui.component.BaseValidator;
import jeus.tool.xmlui.component.ValidationException;

public class NumberValidator
extends BaseValidator {
    private static final Map TYPES = new HashMap();
    private static final Set INT_TYPES;
    private Class _valueTypeClass = Integer.TYPE;
    private boolean _zeroIsNull;
    private Number _minimum;
    private Number _maximum;
    private String _pattern;
    private String _invalidNumericFormatMessage;
    private String _invalidIntegerFormatMessage;
    private String _numberTooSmallMessage;
    private String _numberTooLargeMessage;
    private String _numberRangeMessage;
    private static AdaptorRegistry _numberAdaptors;
    public static final int NUMBER_TYPE_INTEGER = 0;
    public static final int NUMBER_TYPE_REAL = 1;

    private NumberAdaptor getAdaptor(String name) {
        NumberAdaptor result = NumberValidator.getAdaptor(this._valueTypeClass);
        if (result == null) {
            throw new RuntimeException("No adaptor for field " + name);
        }
        return result;
    }

    public static NumberAdaptor getAdaptor(Class type) {
        return (NumberAdaptor)_numberAdaptors.getAdaptor(type);
    }

    public void validate(String name, String value) throws ValidationException {
        if (this.checkRequired(name, value)) {
            return;
        }
        NumberAdaptor adaptor = this.getAdaptor(name);
        Number result = null;
        try {
            result = adaptor.parse(value);
        }
        catch (NumberFormatException ex) {
            throw new ValidationException(this.buildInvalidNumericFormatMessage(name));
        }
        if (this._minimum != null && adaptor.compare(result, this._minimum) < 0) {
            throw new ValidationException(this.buildNumberTooSmallMessage(name));
        }
        if (this._maximum != null && adaptor.compare(result, this._maximum) > 0) {
            throw new ValidationException(this.buildNumberTooLargeMessage(name));
        }
        if (this._pattern != null && this._pattern.trim().length() > 0 && !result.toString().matches(this._pattern)) {
            throw new ValidationException(this.buildPatternMismatchMessage(name));
        }
    }

    public Number getMaximum() {
        return this._maximum;
    }

    public boolean getHasMaximum() {
        return this._maximum != null;
    }

    public void setMaximum(Number maximum) {
        this._maximum = maximum;
    }

    public Number getMinimum() {
        return this._minimum;
    }

    public boolean getHasMinimum() {
        return this._minimum != null;
    }

    public void setMinimum(Number minimum) {
        this._minimum = minimum;
    }

    public boolean getZeroIsNull() {
        return this._zeroIsNull;
    }

    public void setZeroIsNull(boolean zeroIsNull) {
        this._zeroIsNull = zeroIsNull;
    }

    private String buildRangeMessage(String name) {
        if (this._minimum != null && this._maximum != null) {
            return this.buildNumberRangeMessage(name);
        }
        if (this._maximum != null) {
            return this.buildNumberTooLargeMessage(name);
        }
        return this.buildNumberTooSmallMessage(name);
    }

    public void setValueType(String typeName) {
        Class typeClass = (Class)TYPES.get(typeName);
        if (typeClass == null) {
            throw new RuntimeException("Unknown value type " + typeName);
        }
        this._valueTypeClass = typeClass;
    }

    public void setValueTypeClass(Class valueTypeClass) {
        this._valueTypeClass = valueTypeClass;
    }

    public Class getValueTypeClass() {
        return this._valueTypeClass;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String _pattern) {
        this._pattern = _pattern;
    }

    public String getInvalidNumericFormatMessage() {
        return this._invalidNumericFormatMessage;
    }

    public String getInvalidIntegerFormatMessage() {
        return this._invalidIntegerFormatMessage;
    }

    public String getNumberRangeMessage() {
        return this._numberRangeMessage;
    }

    public String getNumberTooLargeMessage() {
        return this._numberTooLargeMessage;
    }

    public String getNumberTooSmallMessage() {
        return this._numberTooSmallMessage;
    }

    public void setInvalidNumericFormatMessage(String string) {
        this._invalidNumericFormatMessage = string;
    }

    public void setInvalidIntegerFormatMessage(String string) {
        this._invalidIntegerFormatMessage = string;
    }

    protected String buildInvalidNumericFormatMessage(String name) {
        return "@XPATH@ must be a numeric value.";
    }

    protected String buildInvalidIntegerFormatMessage(String name) {
        return "@XPATH@ must be an integer value.";
    }

    public void setNumberRangeMessage(String string) {
        this._numberRangeMessage = string;
    }

    protected String buildNumberRangeMessage(String name) {
        String pattern = "@XPATH@ must be between {0} and {1}.";
        return this.formatString(pattern, new Object[]{this._minimum, this._maximum});
    }

    public void setNumberTooLargeMessage(String string) {
        this._numberTooLargeMessage = string;
    }

    protected String buildNumberTooLargeMessage(String name) {
        String pattern = "@XPATH@ must not be larger than {0}.";
        return this.formatString(pattern, this._maximum);
    }

    public void setNumberTooSmallMessage(String string) {
        this._numberTooSmallMessage = string;
    }

    protected String buildNumberTooSmallMessage(String name) {
        String pattern = "@XPATH@ must not be smaller than {0}.";
        return this.formatString(pattern, this._minimum);
    }

    protected String buildPatternMismatchMessage(String name) {
        String pattern = "@XPATH@ must be matched to {0}.";
        return this.formatString(pattern, this._pattern);
    }

    public boolean isIntegerNumber() {
        NumberAdaptor result = (NumberAdaptor)_numberAdaptors.getAdaptor(this._valueTypeClass);
        if (result == null) {
            return false;
        }
        return result.getNumberType() == 0;
    }

    static {
        TYPES.put("boolean", Boolean.TYPE);
        TYPES.put("Boolean", Boolean.class);
        TYPES.put("java.lang.Boolean", Boolean.class);
        TYPES.put("char", Character.TYPE);
        TYPES.put("Character", Character.class);
        TYPES.put("java.lang.Character", Character.class);
        TYPES.put("short", Short.TYPE);
        TYPES.put("Short", Short.class);
        TYPES.put("java.lang.Short", Short.class);
        TYPES.put("int", Integer.TYPE);
        TYPES.put("Integer", Integer.class);
        TYPES.put("java.lang.Integer", Integer.class);
        TYPES.put("long", Long.TYPE);
        TYPES.put("Long", Long.class);
        TYPES.put("java.lang.Long", Long.class);
        TYPES.put("float", Float.TYPE);
        TYPES.put("Float", Float.class);
        TYPES.put("java.lang.Float", Float.class);
        TYPES.put("byte", Byte.TYPE);
        TYPES.put("Byte", Byte.class);
        TYPES.put("java.lang.Byte", Byte.class);
        TYPES.put("double", Double.TYPE);
        TYPES.put("Double", Double.class);
        TYPES.put("java.lang.Double", Double.class);
        TYPES.put("java.math.BigInteger", BigInteger.class);
        TYPES.put("java.math.BigDecimal", BigDecimal.class);
        INT_TYPES = new HashSet();
        _numberAdaptors = new AdaptorRegistry();
        ByteAdaptor byteAdaptor = new ByteAdaptor();
        ShortAdaptor shortAdaptor = new ShortAdaptor();
        IntAdaptor intAdaptor = new IntAdaptor();
        LongAdaptor longAdaptor = new LongAdaptor();
        FloatAdaptor floatAdaptor = new FloatAdaptor();
        DoubleAdaptor doubleAdaptor = new DoubleAdaptor();
        _numberAdaptors.register(Byte.class, byteAdaptor);
        _numberAdaptors.register(Byte.TYPE, byteAdaptor);
        _numberAdaptors.register(Short.class, shortAdaptor);
        _numberAdaptors.register(Short.TYPE, shortAdaptor);
        _numberAdaptors.register(Integer.class, intAdaptor);
        _numberAdaptors.register(Integer.TYPE, intAdaptor);
        _numberAdaptors.register(Long.class, longAdaptor);
        _numberAdaptors.register(Long.TYPE, longAdaptor);
        _numberAdaptors.register(Float.class, floatAdaptor);
        _numberAdaptors.register(Float.TYPE, floatAdaptor);
        _numberAdaptors.register(Double.class, doubleAdaptor);
        _numberAdaptors.register(Double.TYPE, doubleAdaptor);
        _numberAdaptors.register(BigDecimal.class, new BigDecimalAdaptor());
        _numberAdaptors.register(BigInteger.class, new BigIntegerAdaptor());
    }

    private static class BigIntegerAdaptor
    extends IntegerNumberAdaptor {
        private BigIntegerAdaptor() {
        }

        public Number parse(String value) {
            return new BigInteger(value);
        }

        protected Number coerce(Number number) {
            return new BigInteger(number.toString());
        }
    }

    private static class BigDecimalAdaptor
    extends RealNumberAdaptor {
        private BigDecimalAdaptor() {
        }

        public Number parse(String value) {
            return new BigDecimal(value);
        }

        protected Number coerce(Number number) {
            return new BigDecimal(number.doubleValue());
        }
    }

    private static class DoubleAdaptor
    extends RealNumberAdaptor {
        private DoubleAdaptor() {
        }

        public Number parse(String value) {
            return new Double(value);
        }

        protected Number coerce(Number number) {
            return new Double(number.doubleValue());
        }
    }

    private static class FloatAdaptor
    extends RealNumberAdaptor {
        private FloatAdaptor() {
        }

        public Number parse(String value) {
            return new Float(value);
        }

        protected Number coerce(Number number) {
            return new Float(number.floatValue());
        }
    }

    private static class LongAdaptor
    extends IntegerNumberAdaptor {
        private LongAdaptor() {
        }

        public Number parse(String value) {
            return new Long(value);
        }

        protected Number coerce(Number number) {
            return new Long(number.longValue());
        }
    }

    private static class IntAdaptor
    extends IntegerNumberAdaptor {
        private IntAdaptor() {
        }

        public Number parse(String value) {
            return new Integer(value);
        }

        protected Number coerce(Number number) {
            return new Integer(number.intValue());
        }
    }

    private static class ShortAdaptor
    extends IntegerNumberAdaptor {
        private ShortAdaptor() {
        }

        public Number parse(String value) {
            return new Short(value);
        }

        protected Number coerce(Number number) {
            return new Short(number.shortValue());
        }
    }

    private static class ByteAdaptor
    extends IntegerNumberAdaptor {
        private ByteAdaptor() {
        }

        public Number parse(String value) {
            return new Byte(value);
        }

        protected Number coerce(Number number) {
            return new Byte(number.byteValue());
        }
    }

    private static abstract class RealNumberAdaptor
    extends NumberAdaptor {
        private RealNumberAdaptor() {
        }

        public int getNumberType() {
            return 1;
        }
    }

    private static abstract class IntegerNumberAdaptor
    extends NumberAdaptor {
        private IntegerNumberAdaptor() {
        }

        public int getNumberType() {
            return 0;
        }
    }

    public static abstract class NumberAdaptor {
        public abstract Number parse(String var1);

        public abstract int getNumberType();

        public int compare(Number left, Number right) {
            if (!left.getClass().equals(right.getClass())) {
                right = this.coerce(right);
            }
            Comparable lc = (Comparable)((Object)left);
            return lc.compareTo(right);
        }

        protected abstract Number coerce(Number var1);
    }
}

