/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Node;

public class XMLUIBoolean
extends XMLUIComponent
implements FocusListener {
    protected JCheckBox checkbox = new JCheckBox();
    protected String value;

    public XMLUIBoolean() {
        this.checkbox.addFocusListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.checkbox, "West");
    }

    public JComponent getItemComp() {
        return this.checkbox;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setEnabled(boolean val) {
        this.checkbox.setEnabled(val);
    }

    public void resetValue() {
        String item = this.getDefaultValue() == null ? "false" : this.getDefaultValue();
        this.checkbox.setSelected(Boolean.valueOf(item));
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        String currentValue = Boolean.toString(this.checkbox.isSelected());
        if (currentValue != null && currentValue.equals(this.value) || currentValue == this.value) {
            this.setChanged(false);
        } else {
            this.setChanged(true);
        }
    }

    public void setValue(Object value) {
        this.value = value instanceof Node ? XMLUtil.getValue((Node)value) : value.toString();
        this.checkbox.setSelected(Boolean.valueOf(this.value));
    }

    public Object getValue() {
        this.clearMessage();
        String currentValue = Boolean.toString(this.checkbox.isSelected());
        if (!this.getSession().isWriteDefault() && currentValue.equals(this.getDefaultValue())) {
            return null;
        }
        return XMLUtil.createElement(this.getSession().getDocument(), this.getName(), currentValue);
    }

    public void replaceValueWithCurrentValue() {
        this.value = this.checkbox.isSelected() ? "true" : "false";
    }
}

