/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jeus.tool.xmlui.component.ValidationException;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Node;

public class XMLUIChoice
extends XMLUIComponent
implements ItemListener {
    protected JComboBox comboBox = new JComboBox();
    protected String value;

    public XMLUIChoice() {
        this.comboBox.addItemListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.comboBox, "Center");
    }

    public JComponent getItemComp() {
        return this.comboBox;
    }

    public void setEnabled(boolean val) {
        this.comboBox.setEnabled(val);
    }

    public void resetValue() {
        String item = this.getDefaultValue() != null ? this.getDefaultValue() : "";
        this.setSelectedItem(item);
    }

    public void itemStateChanged(ItemEvent e) {
        String currentValue = (String)this.comboBox.getSelectedItem();
        if (!(currentValue != null && currentValue.equals(this.value) || currentValue == this.value)) {
            this.setChanged(true);
        }
    }

    public void setCandidateValues(String[] values) {
        this.addItem("");
        for (int i = 0; i < values.length; ++i) {
            this.addItem(values[i]);
        }
    }

    protected void addItem(Object item) {
        this.comboBox.removeItemListener(this);
        this.comboBox.addItem(item);
        this.comboBox.addItemListener(this);
    }

    public void setValue(Object value) {
        this.value = value instanceof Node ? XMLUtil.getValue((Node)value) : (value != null ? value.toString() : "");
        this.setSelectedItem(this.value);
    }

    protected void setSelectedItem(Object obj) {
        this.comboBox.removeItemListener(this);
        this.comboBox.setSelectedItem(obj);
        this.comboBox.addItemListener(this);
    }

    public void setDefaultValue(String defaultValue) {
        super.setDefaultValue(defaultValue);
        this.setSelectedItem(defaultValue);
    }

    public Object getValue() {
        this.clearMessage();
        String currentValue = (String)this.comboBox.getSelectedItem();
        if (this.getValidator() != null) {
            try {
                this.getValidator().validate(this.getName(), currentValue);
            }
            catch (ValidationException e) {
                this.addMessage(e.getMessage());
                return null;
            }
        }
        if (this.getDefaultValue() != null && !this.getSession().isWriteDefault() && this.getDefaultValue().equals(currentValue)) {
            return null;
        }
        if (currentValue != null && currentValue.trim().length() > 0) {
            return XMLUtil.createElement(this.getSession().getDocument(), this.getName(), currentValue);
        }
        return null;
    }
}

