/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.util.Properties;
import java.util.StringTokenizer;
import jeus.tool.common.ConfigPane;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.component.IValidator;
import jeus.tool.xmlui.component.XMLUIBoolean;
import jeus.tool.xmlui.component.XMLUIChoice;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.component.XMLUIEditableChoice;
import jeus.tool.xmlui.component.XMLUIEmpty;
import jeus.tool.xmlui.component.XMLUIQName;
import jeus.tool.xmlui.component.XMLUIReferredTextField;
import jeus.tool.xmlui.component.XMLUITextArea;
import jeus.tool.xmlui.engine.XMLUISession;
import jeus.tool.xmlui.schema.XMLUIElement;
import jeus.tool.xmlui.util.BeanUtil;

public class XMLUIComponentFactory {
    public static XMLUIComponent createXMLUIComponent(XMLUISession session, XMLUIElement element) {
        IValidator validator;
        String name = element.getName();
        String defaultValue = element.getDefaultValue();
        ConfigPane component = null;
        String uiclass = element.getElementUIClass();
        String componentType = element.getItemType();
        Properties props = new Properties();
        String target = uiclass;
        if (uiclass == null || uiclass.trim().length() == 0) {
            target = componentType;
        }
        if (target != null) {
            if (target.indexOf("[") > 0 && target.endsWith("]")) {
                String propsString = target.substring(target.indexOf("[") + 1, target.length() - 1);
                StringTokenizer stk = new StringTokenizer(propsString, ",");
                while (stk.hasMoreTokens()) {
                    String token = stk.nextToken();
                    int ep = token.indexOf("=");
                    if (ep < 0) continue;
                    String propname = token.substring(0, ep);
                    String propvalue = token.substring(ep + 1);
                    props.put(propname, propvalue);
                }
                target = target.substring(0, target.indexOf("["));
            }
            if (uiclass != null && uiclass.trim().length() > 0) {
                uiclass = target;
            } else {
                componentType = target;
            }
        }
        if (uiclass != null) {
            try {
                component = (XMLUIComponent)Class.forName(uiclass).newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (component == null) {
            if (componentType == null) {
                componentType = "string";
            }
            if (componentType.equals("textarea")) {
                component = new XMLUITextArea();
            } else if (componentType.equals("boolean")) {
                component = new XMLUIBoolean();
            } else if (componentType.equals("empty")) {
                component = new XMLUIEmpty();
            } else if (componentType.equals("choice") || componentType.equals("echoice")) {
                XMLUIChoice choice = null;
                choice = componentType.equals("choice") ? new XMLUIChoice() : new XMLUIEditableChoice();
                choice.setCandidateValues(element.getCandidateValue());
                component = choice;
            } else {
                component = componentType.equals("qname") ? new XMLUIQName() : new XMLUIReferredTextField();
            }
        }
        component.setConfigObject(element);
        ((XMLUIPanel)component).setSession(session);
        component.setTitle(element.getDisplayName());
        ((XMLUIComponent)component).setType(componentType);
        component.setName(name);
        ((XMLUIComponent)component).setDefaultValue(defaultValue);
        BeanUtil.setProperties(component, props);
        String readonly = element.getReadonly();
        if (readonly != null && readonly.equals("true")) {
            ((XMLUIComponent)component).setEnabled(false);
        } else {
            ((XMLUIComponent)component).setEnabled(true);
        }
        ((XMLUIComponent)component).setConstraints(element);
        String validatorString = element.getValidator();
        if (validatorString != null && validatorString.trim().length() > 0 && (validator = XMLUIComponentFactory.createValidator(validatorString)) != null) {
            ((XMLUIComponent)component).setValidator(validator);
        }
        ((XMLUIComponent)component).init();
        return component;
    }

    private static IValidator createValidator(String validatorString) {
        int beg = validatorString.indexOf("[");
        int end = validatorString.indexOf("]");
        String className = validatorString;
        Properties params = null;
        if (beg < end) {
            className = validatorString.substring(0, beg);
            String paramsString = validatorString.substring(beg + 1, end);
            StringTokenizer stk = new StringTokenizer(paramsString, ",");
            params = new Properties();
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken();
                int assign = token.indexOf("=");
                if (assign <= 0) continue;
                String key = token.substring(0, assign);
                String value = token.substring(assign + 1);
                params.put(key, value);
            }
        }
        try {
            IValidator validator = (IValidator)Class.forName(className).newInstance();
            validator.setParameters(params);
            return validator;
        }
        catch (Exception e) {
            return null;
        }
    }
}

