/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import jeus.tool.xmlui.component.ValidationException;
import jeus.tool.xmlui.component.XMLUIComponent;
import jeus.tool.xmlui.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUITextField
extends XMLUIComponent
implements FocusListener {
    private JTextField textField = new JTextField();
    protected String value;

    public XMLUITextField() {
        this.textField.addFocusListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.textField, "Center");
        this.textField.setColumns(10);
    }

    public JComponent getItemComp() {
        return this.textField;
    }

    public void setEnabled(boolean val) {
        this.textField.setEditable(val);
    }

    public void resetValue() {
        String item = this.getDefaultValue() != null ? this.getDefaultValue() : "";
        this.textField.setText(item);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        String currentValue = this.textField.getText();
        if (!(currentValue != null && currentValue.equals(this.value) || currentValue != null && currentValue.length() == 0 && this.value == null || this.value != null && this.value.length() == 0 && currentValue == null || this.value == currentValue)) {
            this.setChanged(true);
        }
    }

    public void setValue(Object value) {
        this.value = value instanceof Node ? XMLUtil.getValue((Node)value) : (value != null ? value.toString() : "");
        this.textField.setText(this.value);
    }

    public Object getValue() {
        this.clearMessage();
        String currentValue = this.textField.getText();
        if (this.getValidator() != null) {
            try {
                this.getValidator().validate(this.getName(), currentValue);
            }
            catch (ValidationException e) {
                this.addMessage(e.getMessage());
                return null;
            }
        }
        if (currentValue != null && this.value != null && !currentValue.equals(this.value)) {
            this.changed = true;
        }
        if (this.getDefaultValue() != null) {
            if (this.getSession().isWriteDefault()) {
                if (currentValue == null || currentValue.trim().length() == 0) {
                    currentValue = this.getDefaultValue();
                }
            } else if (this.getDefaultValue().equals(currentValue)) {
                return null;
            }
        }
        if (currentValue != null && currentValue.trim().length() > 0) {
            Element element = XMLUtil.createElement(this.getSession().getDocument(), this.getName(), currentValue);
            return element;
        }
        return null;
    }

    public void replaceValueWithCurrentValue() {
        this.value = this.textField.getText();
    }
}

