/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.engine;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import jeus.tool.xmlui.engine.XMLUIRepository;
import jeus.tool.xmlui.schema.XMLUIContainer;

public class ClasspathXMLUIRepository
implements XMLUIRepository {
    private String basePackage;
    private Hashtable cache;

    public ClasspathXMLUIRepository(String basePackage) {
        if (basePackage == null) {
            basePackage = "";
        }
        this.basePackage = basePackage;
        this.cache = new Hashtable();
    }

    public void reset() {
        this.cache.clear();
    }

    public XMLUIContainer getConfigContainer(String name) {
        if (this.cache.contains(name)) {
            return (XMLUIContainer)this.cache.get(name);
        }
        try {
            InputStream is = this.getClass().getResourceAsStream(this.basePackage + "/" + name);
            ObjectInputStream ois = new ObjectInputStream(is);
            XMLUIContainer configContainer = (XMLUIContainer)ois.readObject();
            this.cache.put(name, configContainer);
            return configContainer;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

