/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.engine;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jeus.tool.xmlui.XMLUIPanel;
import jeus.tool.xmlui.XMLUIPanelFactory;
import jeus.tool.xmlui.engine.ClasspathXMLUIRepository;
import jeus.tool.xmlui.engine.OperationType;
import jeus.tool.xmlui.engine.XMLUIEvent;
import jeus.tool.xmlui.engine.XMLUIListener;
import jeus.tool.xmlui.engine.XMLUINotFoundException;
import jeus.tool.xmlui.engine.XMLUIRepository;
import jeus.tool.xmlui.schema.XMLUIContainer;
import org.w3c.dom.Node;

public class XMLUIEngine {
    protected ResourceBundle resourceBundle;
    protected XMLUIRepository repository;
    private String repositoryBasePackage;
    protected Locale locale = Locale.getDefault();
    private EventListenerList lsnrlist = new EventListenerList();
    private Hashtable uicache = new Hashtable();
    private DocumentBuilder builder;
    private boolean namespaceAware;

    public XMLUIEngine(String repositoryBasePackage) {
        this(repositoryBasePackage, true);
    }

    public XMLUIEngine(String repositoryBasePackage, boolean namespaceAware) {
        this.setRespositoryBasePackage(repositoryBasePackage);
        this.namespaceAware = namespaceAware;
        this.initialize();
    }

    public XMLUIEngine() {
        this(null, true);
    }

    public void initialize() {
        this.repository = this.createRepository();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(this.namespaceAware);
            factory.setValidating(false);
            this.builder = factory.newDocumentBuilder();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addXMLUIListener(XMLUIListener lsnr) {
        this.lsnrlist.add(XMLUIListener.class, lsnr);
    }

    public void removeXMLUIListener(XMLUIListener lsnr) {
        this.lsnrlist.remove(XMLUIListener.class, lsnr);
    }

    public void fireXMLUIEvent(XMLUIPanel source, Node node, OperationType op) {
        XMLUIEvent event = new XMLUIEvent(source, op, node);
        Object[] listeners = this.lsnrlist.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != XMLUIListener.class) continue;
            ((XMLUIListener)listeners[i + 1]).xmlChanged(event);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public void setRespositoryBasePackage(String pkg) {
        this.repositoryBasePackage = pkg.endsWith("/") ? pkg.substring(0, pkg.length() - 1) : pkg;
    }

    public XMLUIRepository getRepository() {
        return this.repository;
    }

    protected XMLUIRepository createRepository() {
        ClasspathXMLUIRepository repository = new ClasspathXMLUIRepository(this.repositoryBasePackage);
        return repository;
    }

    public void reset() {
        this.repository.reset();
    }

    public XMLUIPanel getXMLUIPanel(String xmluiName, String cpath) throws XMLUINotFoundException {
        return this.getXMLUIPanel(null, xmluiName, cpath, false);
    }

    public XMLUIPanel getXMLUIPanel(Node node, String xmluiName, String cpath, Map attrs) throws XMLUINotFoundException {
        return this.getXMLUIPanel(node, xmluiName, cpath, attrs, false);
    }

    public XMLUIPanel getXMLUIPanel(Node node, String xmluiName, String cpath, Map attrs, boolean readonly) throws XMLUINotFoundException {
        if (cpath != null && cpath.endsWith("$")) {
            throw new XMLUINotFoundException("$uiname$ format is not allowed as an initial xmlui panel.");
        }
        XMLUIPanel panel = null;
        if (panel == null) {
            XMLUIContainer config = this.repository.getConfigContainer(xmluiName + ".conf");
            StringTokenizer stk = new StringTokenizer(cpath, "/");
            XMLUIContainer fndcnf = config;
            int fcount = 1;
            int i = 0;
            while (stk.hasMoreTokens() && fndcnf != null) {
                String token = stk.nextToken();
                if (i != 0) {
                    XMLUIContainer[] containers = fndcnf.getConfigContainer();
                    for (int j = 0; j < containers.length; ++j) {
                        if (!containers[j].getName().equals(token)) continue;
                        fndcnf = containers[j];
                        ++fcount;
                        break;
                    }
                    if (fcount <= i) {
                        throw new XMLUINotFoundException(cpath);
                    }
                }
                ++i;
            }
            if (fndcnf == null) {
                throw new XMLUINotFoundException(cpath);
            }
            panel = XMLUIPanelFactory.createXMLUIPanel(fndcnf, false, this, attrs);
            panel.setName(fndcnf.getName());
            panel.setDisplayName(fndcnf.getDisplayName());
        }
        if (node != null) {
            panel.getSession().setDocument(node.getOwnerDocument());
        } else {
            panel.getSession().setDocument(this.builder.newDocument());
        }
        panel.setValue(node);
        if (readonly) {
            panel.setEnabled(!readonly);
        }
        return panel;
    }

    public XMLUIPanel getXMLUIPanel(Node node, String xmluiName, String cpath) throws XMLUINotFoundException {
        return this.getXMLUIPanel(node, xmluiName, cpath, false);
    }

    public XMLUIPanel getXMLUIPanel(Node node, String xmluiName, String cpath, boolean readonly) throws XMLUINotFoundException {
        return this.getXMLUIPanel(node, xmluiName, cpath, Collections.EMPTY_MAP, readonly);
    }

    public static void main(String[] args) throws Exception {
        XMLUIEngine engine = new XMLUIEngine("/jeus/tool/resource/ui/builder");
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(800, 600);
        XMLUIPanel pane = engine.getXMLUIPanel("webservices", "/webservices");
        frame.getContentPane().add((Component)pane, "Center");
        frame.show();
    }
}

