/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.schema;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import jeus.tool.common.xml.XMLConverter;
import jeus.tool.common.xml.XMLConverterException;
import jeus.tool.common.xml.XMLTree;
import jeus.tool.xmlui.schema.XMLUIChoice;
import jeus.tool.xmlui.schema.XMLUIContainer;
import jeus.tool.xmlui.schema.XMLUIElement;

public class XMLUIConverter
extends XMLConverter {
    public static final String SYSTEM_ID = "jeus-xml.dtd";
    public static final String PUBLIC_ID = "-//Tmax Soft, Inc.//DTD EJB Main Config 1.0//EN";
    public static final String CONFIG_CONTAINER = "container";
    public static final String CONFIG_EXCLUSIVE_CONTAINER = "choice";
    public static final String CONFIG_ITEM = "element";
    public static final String CANDIDATE_VALUE = "item";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "display-name";
    public static final String MULTI = "list";
    public static final String ADVANCED = "advanced";
    public static final String COMPLEX = "complex";
    public static final String ITEM_TYPE = "type";
    public static final String DEFAULT_VALUE = "default";
    public static final String REQUIRED = "required";
    public static final String BLIND = "blind";
    public static final String EXPERT = "expert";
    public static final String LENGTH = "length";
    public static final String MAX_LENGTH = "max-length";
    public static final String MIN_LENGTH = "min-length";
    public static final String MIN_INCLUSIVE = "min-inclusive";
    public static final String MAX_INCLUSIVE = "max-inclusive";
    public static final String MAX_EXCLUSIVE = "max-exclusive";
    public static final String MIN_EXCLUSIVE = "min-exclusive";
    public static final String PATTERN = "pattern";
    public static final String SELECTABLE = "selectable";
    public static final String VALIDATOR = "validator";
    public static final String FILL = "fill";
    public static final String DIRECTION = "direction";
    public static final String COLUMNS = "columns";
    public static final String MIN_OCCURS = "min-occurs";
    public static final String MAX_OCCURS = "max-occurs";
    public static final String MULTI_DISPLAY_NAME = "multi-display-name";
    public static final String MULTI_COLUMN_PARSER = "column-parser";
    public static final String LAYOUT = "layout";
    public static final String SUBLAYOUT = "sub-layout";
    public static final String SMALL_ICON = "small-icon";
    public static final String BIG_ICON = "big-icon";
    public static final String GENERAL_SMALL_ICON = "general-small-icon";
    public static final String GENERAL_BIG_ICON = "general-big-icon";
    public static final String CONTAINER_UI_CLASS = "container-ui-class";
    public static final String SUB_CONTAINER_UI_CLASS = "subcontainer-ui-class";
    public static final String ELEMENT_UI_CLASS = "element-ui-class";
    public static final String READONLY = "readonly";
    public static final String LIST_MODE = "list-mode";
    public static final String TAB_LISTENER_CLASS = "tab-listener-class";
    public static final String TYPE = "type";
    public static final String DESCRIPTION = "description";
    public static final String XML_TYPE = "xml-type";

    public int getType() {
        return -1;
    }

    public String getSystemID() {
        return this.getDTDDir() + SYSTEM_ID;
    }

    public String getPublicID() {
        return PUBLIC_ID;
    }

    public Object getUserObject(XMLTree xmlTree, String namespaceURI) {
        String columns;
        String maxOccurs;
        String minOccurs;
        if (!(xmlTree.getName().equals(CONFIG_CONTAINER) || xmlTree.getName().equals(CONFIG_EXCLUSIVE_CONTAINER) || xmlTree.getName().equals(BLIND))) {
            System.err.println("invalid element:" + xmlTree.getName());
            return null;
        }
        XMLUIContainer container = null;
        if (xmlTree.getName().equals(CONFIG_CONTAINER)) {
            container = new XMLUIContainer();
        } else if (xmlTree.getName().equals(CONFIG_EXCLUSIVE_CONTAINER)) {
            container = new XMLUIChoice();
        } else if (xmlTree.getName().equals(BLIND)) {
            container = new XMLUIContainer();
            container.setBlind(Boolean.TRUE.toString());
        }
        container.setName((String)xmlTree.getAttribute(NAME));
        container.setNamespaceURI(namespaceURI);
        if (namespaceURI == null) {
            System.err.println(namespaceURI);
        }
        if (container.getBlind() != null && container.getBlind().equals(Boolean.TRUE.toString())) {
            container.setName("$blind_" + System.currentTimeMillis() + "$");
        }
        container.setDisplayName((String)xmlTree.getAttribute(DISPLAY_NAME));
        container.setDescription((String)xmlTree.getAttribute(DESCRIPTION));
        container.setMultiDisplayName((String)xmlTree.getAttribute(MULTI_DISPLAY_NAME));
        container.setMultiColumnParser((String)xmlTree.getAttribute(MULTI_COLUMN_PARSER));
        container.setMulti((String)xmlTree.getAttribute(MULTI));
        container.setComplex((String)xmlTree.getAttribute(COMPLEX));
        container.setRequired((String)xmlTree.getAttribute(REQUIRED));
        container.setExpert((String)xmlTree.getAttribute(EXPERT));
        container.setType((String)xmlTree.getAttribute("type"));
        container.setContainerUIClass((String)xmlTree.getAttribute(CONTAINER_UI_CLASS));
        container.setSubContainerUIClass((String)xmlTree.getAttribute(SUB_CONTAINER_UI_CLASS));
        container.setLayOut((String)xmlTree.getAttribute(LAYOUT));
        container.setSubLayOut((String)xmlTree.getAttribute(SUBLAYOUT));
        if (container.getBlind() != null && container.getBlind().equals(Boolean.TRUE.toString())) {
            container.setLayOut("flat");
        }
        container.setSmallIcon((String)xmlTree.getAttribute(SMALL_ICON));
        container.setBigIcon((String)xmlTree.getAttribute(BIG_ICON));
        container.setGeneralSmallIcon((String)xmlTree.getAttribute(GENERAL_SMALL_ICON));
        container.setGeneralBigIcon((String)xmlTree.getAttribute(GENERAL_BIG_ICON));
        container.setSelectable((String)xmlTree.getAttribute(SELECTABLE));
        container.setFill((String)xmlTree.getAttribute(FILL));
        container.setReadonly((String)xmlTree.getAttribute(READONLY));
        String listmode = (String)xmlTree.getAttribute(LIST_MODE);
        if (listmode == null || listmode.trim().length() == 0) {
            container.setListmode("arm");
        } else {
            container.setListmode(listmode);
        }
        if (Boolean.valueOf((String)xmlTree.getAttribute(REQUIRED)).booleanValue()) {
            container.setMinOccurs(1);
        }
        if (Boolean.valueOf((String)xmlTree.getAttribute(MULTI)).booleanValue()) {
            container.setMaxOccurs(Integer.MAX_VALUE);
        }
        if ((minOccurs = (String)xmlTree.getAttribute(MIN_OCCURS)) != null && minOccurs.length() != 0) {
            container.setMinOccurs(Integer.parseInt(minOccurs));
        }
        if ((maxOccurs = (String)xmlTree.getAttribute(MAX_OCCURS)) != null && maxOccurs.length() != 0) {
            if (maxOccurs.equals("unbounded")) {
                container.setMaxOccurs(Integer.MAX_VALUE);
            } else {
                container.setMaxOccurs(Integer.parseInt(maxOccurs));
            }
        }
        if ((columns = (String)xmlTree.getAttribute(COLUMNS)) != null) {
            StringTokenizer stk = new StringTokenizer(columns, ",");
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<String> columnExprs = new ArrayList<String>();
            while (stk.hasMoreTokens()) {
                String token = stk.nextToken().trim();
                int c = token.indexOf(":");
                String name = null;
                String expr = null;
                if (c < 0) {
                    name = token;
                    expr = token;
                } else {
                    name = token.substring(0, c);
                    expr = token.substring(c + 1);
                }
                columnNames.add(name);
                columnExprs.add(expr);
            }
            container.setColumnNames(columnNames.toArray(new String[columnNames.size()]));
            container.setColumnExprs(columnExprs.toArray(new String[columnExprs.size()]));
        }
        container.setTabListenerClass((String)xmlTree.getAttribute(TAB_LISTENER_CLASS));
        Enumeration itemEnum = xmlTree.elements(CONFIG_ITEM);
        while (itemEnum.hasMoreElements()) {
            String length;
            String maxLength;
            XMLTree itemTree = (XMLTree)itemEnum.nextElement();
            XMLUIElement citem = new XMLUIElement();
            citem.setName((String)itemTree.getAttribute(NAME));
            citem.setDisplayName((String)itemTree.getAttribute(DISPLAY_NAME));
            citem.setDescription((String)itemTree.getAttribute(DESCRIPTION));
            citem.setMulti((String)itemTree.getAttribute(MULTI));
            citem.setItemType((String)itemTree.getAttribute("type"));
            citem.setDefaultValue((String)itemTree.getAttribute(DEFAULT_VALUE));
            citem.setNamespaceURI(namespaceURI);
            String minLength = (String)itemTree.getAttribute(MIN_LENGTH);
            if (minLength != null && minLength.trim().length() > 0) {
                citem.setMinLength(Integer.parseInt(minLength));
            }
            if ((maxLength = (String)itemTree.getAttribute(MAX_LENGTH)) != null && maxLength.trim().length() > 0) {
                citem.setMaxLength(Integer.parseInt(maxLength));
            }
            if ((length = (String)itemTree.getAttribute(LENGTH)) != null && length.trim().length() > 0) {
                citem.setLength(Integer.parseInt(length));
            }
            citem.setMinInclusive((String)itemTree.getAttribute(MIN_INCLUSIVE));
            citem.setMaxInclusive((String)itemTree.getAttribute(MAX_INCLUSIVE));
            citem.setMinExclusive((String)itemTree.getAttribute(MIN_EXCLUSIVE));
            citem.setMaxExclusive((String)itemTree.getAttribute(MAX_EXCLUSIVE));
            citem.setPattern((String)itemTree.getAttribute(PATTERN));
            citem.setElementUIClass((String)itemTree.getAttribute(ELEMENT_UI_CLASS));
            citem.setReadonly((String)itemTree.getAttribute(READONLY));
            if (Boolean.valueOf((String)itemTree.getAttribute(REQUIRED)).booleanValue()) {
                citem.setMinOccurs(1);
            }
            if (Boolean.valueOf((String)itemTree.getAttribute(MULTI)).booleanValue()) {
                citem.setMaxOccurs(Integer.MAX_VALUE);
            }
            if ((minOccurs = (String)itemTree.getAttribute(MIN_OCCURS)) != null && minOccurs.length() != 0) {
                citem.setMinOccurs(Integer.parseInt(minOccurs));
            }
            if ((maxOccurs = (String)itemTree.getAttribute(MAX_OCCURS)) != null && maxOccurs.length() != 0) {
                if (maxOccurs.equals("unbounded")) {
                    citem.setMaxOccurs(Integer.MAX_VALUE);
                } else {
                    citem.setMaxOccurs(Integer.parseInt(maxOccurs));
                }
            }
            citem.setValidator((String)itemTree.getAttribute(VALIDATOR));
            String xmlType = (String)itemTree.getAttribute(XML_TYPE);
            if (xmlType != null) {
                citem.setXmlType(xmlType);
            }
            Enumeration candidateEnum = itemTree.elements(CANDIDATE_VALUE);
            while (candidateEnum.hasMoreElements()) {
                XMLTree candidateTree = (XMLTree)candidateEnum.nextElement();
                citem.addCandidateValue(candidateTree.getValue());
            }
            container.addConfigItem(citem);
        }
        Enumeration containerEnum = xmlTree.elements(CONFIG_CONTAINER);
        while (containerEnum.hasMoreElements()) {
            XMLTree containerTree = (XMLTree)containerEnum.nextElement();
            XMLUIContainer cConfig = (XMLUIContainer)this.getUserObject(containerTree, namespaceURI);
            container.addConfigContainer(cConfig);
        }
        Enumeration containerExclusiveEnum = xmlTree.elements(CONFIG_EXCLUSIVE_CONTAINER);
        while (containerExclusiveEnum.hasMoreElements()) {
            XMLTree containerExclusiveTree = (XMLTree)containerExclusiveEnum.nextElement();
            XMLUIContainer cConfig = (XMLUIContainer)this.getUserObject(containerExclusiveTree, namespaceURI);
            container.addConfigContainer(cConfig);
        }
        Enumeration blindEnum = xmlTree.elements(BLIND);
        while (blindEnum.hasMoreElements()) {
            XMLTree blindTree = (XMLTree)blindEnum.nextElement();
            XMLUIContainer cConfig = (XMLUIContainer)this.getUserObject(blindTree, namespaceURI);
            container.addConfigContainer(cConfig);
        }
        return container;
    }

    public Object getUserObject(XMLTree xmlTree) throws XMLConverterException {
        String namespaceURI = null;
        if (xmlTree.getName().equals("xmlui")) {
            namespaceURI = (String)xmlTree.getAttribute("target-namespace");
            xmlTree = xmlTree.getFirstElement(CONFIG_CONTAINER);
            return this.getUserObject(xmlTree, namespaceURI);
        }
        return this.getUserObject(xmlTree, namespaceURI);
    }

    public XMLTree constructXMLTree(Object object) {
        return null;
    }
}

