/*
 * Decompiled with CFR 0.152.
 */
package jeus.tool.xmlui.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Properties;
import jeus.tool.xmlui.schema.XMLUIContainer;

public class BeanUtil {
    public static boolean setProperties(Object obj, Properties props) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(obj.getClass());
            PropertyDescriptor[] propDescs = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propDescs.length; ++i) {
                Method writeMethod;
                PropertyDescriptor desc = propDescs[i];
                if (!props.containsKey(desc.getName()) || (writeMethod = desc.getWriteMethod()) == null) continue;
                Class<?> type = desc.getPropertyType();
                String prop = props.getProperty(desc.getName());
                Object value = null;
                if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                    value = new Integer(prop);
                } else if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                    value = new Float(prop);
                } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                    value = new Double(prop);
                } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                    value = new Boolean(prop);
                } else if (type.equals(String.class)) {
                    value = prop;
                }
                if (value == null) continue;
                writeMethod.invoke(obj, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        XMLUIContainer container = new XMLUIContainer();
        Properties props = new Properties();
        props.put("name", "myContainer");
        props.put("minOccurs", "1");
        props.put("layOut", "flat");
        BeanUtil.setProperties(container, props);
        System.out.println(container.getName());
        System.out.println(container.getMinOccurs());
        System.out.println(container.getLayOut());
    }
}

