/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Map;
import javax.resource.spi.XATerminator;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jeus.transaction.Coordinator;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TxStatus;
import jeus.transaction.root.RootCoordinator;
import jeus.transaction.util.XidHashTable;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM1;

public final class ConnectorXATerminator
implements XATerminator {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    private Map activeXids;
    private final Map preparedXids;
    private final long timeout = TMConfig.activeTO;
    private static final ConnectorXATerminator singleton = new ConnectorXATerminator();

    public static ConnectorXATerminator getXATerminatorImpl() {
        return singleton;
    }

    private ConnectorXATerminator() {
        this(11);
    }

    private ConnectorXATerminator(int capacity) {
        if (logger.isLoggable(JeusMessage_TM1._3401_LEVEL)) {
            logger.logp(JeusMessage_TM1._3401_LEVEL, "ConnectorXATerminator", "<init>", JeusMessage_TM1._3401);
        }
        this.activeXids = new XidHashTable(capacity);
        this.preparedXids = new XidHashTable(capacity);
    }

    public final void clear() {
        if (logger.isLoggable(JeusMessage_TM1._3402_LEVEL)) {
            logger.logp(JeusMessage_TM1._3402_LEVEL, "ConnectorXATerminator", "clear", JeusMessage_TM1._3402);
        }
        this.activeXids.clear();
        this.activeXids = null;
    }

    private synchronized void setTransactionState(Xid xid, long timeOut) throws XAException {
        TransactionState state = (TransactionState)this.activeXids.get(xid);
        if (state != null) {
            if (logger.isLoggable(JeusMessage_TM1._3403_LEVEL)) {
                logger.logp(JeusMessage_TM1._3403_LEVEL, "ConnectorXATerminator", "setTransactionState", JeusMessage_TM1._3403, (Object)xid);
            }
            System.out.println("----try to join existing transaction");
            if (state.inUse) {
                if (logger.isLoggable(JeusMessage_TM1._3404_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3404_LEVEL, "ConnectorXATerminator", "setTransactionState", JeusMessage_TM1._3404, (Object)xid);
                }
                throw new XAException(-8);
            }
            if (logger.isLoggable(JeusMessage_TM1._3405_LEVEL)) {
                logger.logp(JeusMessage_TM1._3405_LEVEL, "ConnectorXATerminator", "setTransactionState", JeusMessage_TM1._3405, (Object)xid);
            }
            state.inUse = true;
            TMServer.associateThread(((TransactionImpl)state.tx).getGTID());
        } else {
            if (logger.isLoggable(JeusMessage_TM1._3406_LEVEL)) {
                logger.logp(JeusMessage_TM1._3406_LEVEL, "ConnectorXATerminator", "setTransactionState", JeusMessage_TM1._3406);
            }
            System.out.println("----try to make new transaction");
            try {
                TransactionImpl tx = TMServer.create(xid, timeOut).getTransaction();
                state = new TransactionState(tx);
                this.activeXids.put(xid, state);
            }
            catch (Exception nse) {
                if (logger.isLoggable(JeusMessage_TM1._3407_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3407_LEVEL, "ConnectorXATerminator", "setTransactionState", JeusMessage_TM1._3407, (Throwable)nse);
                }
                throw new XAException(-8);
            }
        }
    }

    public final void begin(Xid xid, long timeOut) throws XAException {
        System.out.println("--new Transaction begin : " + xid);
        if (timeOut == -1L) {
            timeOut = this.timeout;
        }
        if (logger.isLoggable(JeusMessage_TM1._3408_LEVEL)) {
            logger.logp(JeusMessage_TM1._3408_LEVEL, "ConnectorXATerminator", "begin", JeusMessage_TM1._3408, new Object[]{xid, String.valueOf(this.timeout)});
        }
        this.setTransactionState(xid, timeOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void end(Xid xid) {
        System.out.println("--end Transaction : " + xid);
        if (logger.isLoggable(JeusMessage_TM1._3409_LEVEL)) {
            logger.logp(JeusMessage_TM1._3409_LEVEL, "ConnectorXATerminator", "end", JeusMessage_TM1._3409, (Object)xid);
        }
        try {
            TransactionState state = (TransactionState)this.activeXids.get(xid);
            if (state == null) {
                return;
            }
            state.inUse = false;
        }
        finally {
            ThreadContexts.dissociateTransactionID();
        }
    }

    public final int prepare(Xid xid) throws XAException {
        if (logger.isLoggable(JeusMessage_TM1._3410_LEVEL)) {
            logger.logp(JeusMessage_TM1._3410_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3410, (Object)xid);
        }
        if (this.activeXids.get(xid) == null) {
            if (logger.isLoggable(JeusMessage_TM1._3411_LEVEL)) {
                logger.logp(JeusMessage_TM1._3411_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3411, (Object)xid);
            }
            throw new XAException(-4);
        }
        if (this.preparedXids.containsKey(xid)) {
            if (logger.isLoggable(JeusMessage_TM1._3412_LEVEL)) {
                logger.logp(JeusMessage_TM1._3412_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3412, (Object)xid);
            }
            return 0;
        }
        TransactionState state = (TransactionState)this.activeXids.get(xid);
        TransactionImpl tx = (TransactionImpl)state.tx;
        RootCoordinator coord = (RootCoordinator)tx.getCoordinator();
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM1._3413_LEVEL)) {
                logger.logp(JeusMessage_TM1._3413_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3413, (Object)xid);
            }
            return this.activeTimeoutOccurred(xid);
        }
        if (logger.isLoggable(JeusMessage_TM1._3414_LEVEL)) {
            logger.logp(JeusMessage_TM1._3414_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3414, new Object[]{coord.getGTID(), xid});
        }
        try {
            if (!coord.disableActiveTO()) {
                coord.setGlobalDecision((byte)1);
                if (logger.isLoggable(JeusMessage_TM1._3415_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3415_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3415, (Object)xid);
                }
                return this.activeTimeoutOccurred(xid);
            }
            coord.beforeCompletion();
            if (coord.isRollbackOnly()) {
                if (logger.isLoggable(JeusMessage_TM1._3416_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3416_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3416, new Object[]{coord.getGTID(), xid});
                }
                coord.setGlobalDecision((byte)1);
                coord.rollback();
                coord.destroy();
                this.activeXids.remove(xid);
                throw new XAException(100);
            }
            if (coord.getNumResources() == 0) {
                if (logger.isLoggable(JeusMessage_TM1._3417_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3417_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3417, new Object[]{coord.getGTID(), xid});
                }
                coord.afterCompletion(3);
                coord.destroy();
                this.activeXids.remove(xid);
                return 3;
            }
            byte result = coord.prepare();
            if (logger.isLoggable(JeusMessage_TM1._3418_LEVEL)) {
                logger.logp(JeusMessage_TM1._3418_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3418, new Object[]{coord.getGTID(), xid, TxStatus.getState((int)result)});
            }
            if (result == 2) {
                if (logger.isLoggable(JeusMessage_TM1._3419_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3419_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3419, new Object[]{coord.getGTID(), xid});
                }
                coord.setGlobalDecision((byte)2);
                coord.afterCompletion(3);
                coord.destroy();
                this.activeXids.remove(xid);
                return 3;
            }
            coord.setGlobalDecision((byte)0);
            this.preparedXids.put(xid, xid);
            return 0;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_TM1._3420_LEVEL)) {
                logger.logp(JeusMessage_TM1._3420_LEVEL, "ConnectorXATerminator", "prepare", JeusMessage_TM1._3420, (Object)xid, t);
            }
            return 3;
        }
    }

    private int activeTimeoutOccurred(Xid xid) throws XAException {
        this.activeXids.remove(xid);
        this.preparedXids.remove(xid);
        ThreadContexts.dissociateTransactionID();
        throw new XAException(-4);
    }

    private int heuristicDecisionOccurred(Xid xid) throws XAException {
        this.activeXids.remove(xid);
        this.preparedXids.remove(xid);
        ThreadContexts.dissociateTransactionID();
        throw new XAException(6);
    }

    public final void commit(Xid xid, boolean isOnePhaseCommit) throws XAException {
        int ret;
        TransactionState state;
        System.out.println("--commit Transaction : " + xid);
        if (logger.isLoggable(JeusMessage_TM1._3421_LEVEL)) {
            logger.logp(JeusMessage_TM1._3421_LEVEL, "ConnectorXATerminator", "commit", JeusMessage_TM1._3421, new Object[]{isOnePhaseCommit ? "one phase " : "", xid});
        }
        if ((state = (TransactionState)this.activeXids.get(xid)) == null) {
            if (logger.isLoggable(JeusMessage_TM1._3422_LEVEL)) {
                logger.logp(JeusMessage_TM1._3422_LEVEL, "ConnectorXATerminator", "commit", JeusMessage_TM1._3422, (Object)xid);
            }
            if (logger.isLoggable(JeusMessage_TM1._3423_LEVEL)) {
                logger.logp(JeusMessage_TM1._3423_LEVEL, "ConnectorXATerminator", "commit", JeusMessage_TM1._3423, (Object)xid);
            }
            try {
                TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, true);
            }
            catch (TMException e) {
                throw new XAException(-3);
            }
        }
        if (isOnePhaseCommit && (ret = this.prepare(xid)) == 3) {
            return;
        }
        if (!this.preparedXids.containsKey(xid)) {
            if (logger.isLoggable(JeusMessage_TM1._3424_LEVEL)) {
                logger.logp(JeusMessage_TM1._3424_LEVEL, "ConnectorXATerminator", "commit", JeusMessage_TM1._3424, (Object)xid);
            }
            throw new XAException(-6);
        }
        TransactionImpl tx = (TransactionImpl)state.tx;
        Coordinator coord = tx.getCoordinator();
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM1._3425_LEVEL)) {
                logger.logp(JeusMessage_TM1._3425_LEVEL, "ConnectorXATerminator", "commit", JeusMessage_TM1._3425, (Object)xid);
            }
            this.heuristicDecisionOccurred(xid);
            return;
        }
        if (logger.isLoggable(JeusMessage_TM1._3426_LEVEL)) {
            logger.logp(JeusMessage_TM1._3426_LEVEL, "ConnectorXATerminator", "commit", JeusMessage_TM1._3426, new Object[]{coord.getGTID(), xid});
        }
        try {
            coord.commit();
            coord.destroy();
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_TM1._3427_LEVEL)) {
                logger.logp(JeusMessage_TM1._3427_LEVEL, "ConnectorXATerminator", "commit", JeusMessage_TM1._3427, (Object)xid, t);
            }
            ThreadContexts.dissociateTransactionID();
            throw new XAException(5);
        }
        finally {
            System.out.println("6");
            this.preparedXids.remove(xid);
            this.activeXids.remove(xid);
        }
    }

    public final void rollback(Xid xid) throws XAException {
        TransactionImpl tx;
        System.out.println("--rollback Transaction : " + xid);
        if (logger.isLoggable(JeusMessage_TM1._3428_LEVEL)) {
            logger.logp(JeusMessage_TM1._3428_LEVEL, "ConnectorXATerminator", "rollback", JeusMessage_TM1._3428, (Object)xid);
        }
        if ((tx = (TransactionImpl)this.activeXids.get(xid)) == null) {
            if (logger.isLoggable(JeusMessage_TM1._3429_LEVEL)) {
                logger.logp(JeusMessage_TM1._3429_LEVEL, "ConnectorXATerminator", "rollback", JeusMessage_TM1._3429, (Object)xid);
            }
            if (logger.isLoggable(JeusMessage_TM1._3430_LEVEL)) {
                logger.logp(JeusMessage_TM1._3430_LEVEL, "ConnectorXATerminator", "rollback", JeusMessage_TM1._3430, (Object)xid);
            }
            try {
                TMServer.setGlobalDecisionForUncompletedExternalTransaction(xid, false);
            }
            catch (TMException e) {
                throw new XAException(-3);
            }
        }
        boolean prepared = this.preparedXids.containsKey(xid);
        Coordinator coord = tx.getCoordinator();
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM1._3431_LEVEL)) {
                logger.logp(JeusMessage_TM1._3431_LEVEL, "ConnectorXATerminator", "rollback", JeusMessage_TM1._3431, (Object)xid);
            }
            this.heuristicDecisionOccurred(xid);
            return;
        }
        try {
            if (!prepared && !coord.disableActiveTO()) {
                if (logger.isLoggable(JeusMessage_TM1._3432_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3432_LEVEL, "ConnectorXATerminator", "rollback", JeusMessage_TM1._3432, (Object)coord.getGTID());
                }
                return;
            }
            if (prepared) {
                return;
            }
            if (logger.isLoggable(JeusMessage_TM1._3433_LEVEL)) {
                logger.logp(JeusMessage_TM1._3433_LEVEL, "ConnectorXATerminator", "rollback", JeusMessage_TM1._3433, new Object[]{coord.getGTID(), xid});
            }
            coord.rollback();
            coord.destroy();
        }
        catch (Throwable t) {
            ThreadContexts.dissociateTransactionID();
            if (logger.isLoggable(JeusMessage_TM1._3434_LEVEL)) {
                logger.logp(JeusMessage_TM1._3434_LEVEL, "ConnectorXATerminator", "rollback", JeusMessage_TM1._3434, (Object)xid, t);
            }
            throw new XAException();
        }
        finally {
            if (prepared) {
                this.preparedXids.remove(xid);
            }
            this.activeXids.remove(xid);
        }
    }

    public final void forget(Xid xid) throws XAException {
        Transaction tx;
        if (logger.isLoggable(JeusMessage_TM1._3435_LEVEL)) {
            logger.logp(JeusMessage_TM1._3435_LEVEL, "ConnectorXATerminator", "forget", JeusMessage_TM1._3435, (Object)xid);
        }
        if ((tx = (Transaction)this.activeXids.remove(xid)) == null) {
            return;
        }
        try {
            if (tx.getStatus() == 2) {
                this.preparedXids.remove(xid);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final Xid[] recover(int flag) throws XAException {
        if (logger.isLoggable(JeusMessage_TM1._3436_LEVEL)) {
            logger.logp(JeusMessage_TM1._3436_LEVEL, "ConnectorXATerminator", "recover", JeusMessage_TM1._3436);
        }
        if (logger.isLoggable(JeusMessage_TM1._3437_LEVEL)) {
            logger.logp(JeusMessage_TM1._3437_LEVEL, "ConnectorXATerminator", "recover", JeusMessage_TM1._3437, (Object)new Integer(this.preparedXids.size()));
        }
        return this.preparedXids.values().toArray(new Xid[0]);
    }

    private String getActiveXids() {
        StringBuffer buf = new StringBuffer("\n");
        Map.Entry[] entries = this.activeXids.entrySet().toArray(new Map.Entry[0]);
        for (int i = 0; i < entries.length; ++i) {
            buf.append(" - key : " + entries[i].getKey() + "[" + ((Object)entries[i]).hashCode() + "]");
            buf.append(", value : " + entries[i].getValue() + "\n");
        }
        return buf.toString();
    }

    final class TransactionState {
        private final Transaction tx;
        private boolean inUse;

        TransactionState(Transaction tran) {
            this.tx = tran;
            this.inUse = true;
        }

        public final String toString() {
            return this.tx.toString() + " using : " + this.inUse;
        }
    }
}

