/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.util.Vector;
import javax.transaction.Synchronization;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import jeus.ejb.container.JeusSynchronization;
import jeus.transaction.ActiveTimerEntry;
import jeus.transaction.GTID;
import jeus.transaction.JTAStatisticsProvider;
import jeus.transaction.PropagationContext;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.TransactionImpl;
import jeus.transaction.TxStatus;
import jeus.transaction.XidImpl;
import jeus.transaction.collector.OnePCommitResponseCollector;
import jeus.transaction.resources.LocalResource;
import jeus.transaction.resources.XAResourceWrapper;
import jeus.util.JeusRuntimeException;
import jeus.util.ScheduledExecutor;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.message.JeusMessage_TM3;

public abstract class Coordinator {
    protected static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    protected long timeout = TMConfig.activeTO;
    protected final long prepareTO = TMConfig.prepareTO;
    protected final GTID gtid;
    private byte bqCount;
    private boolean rollbackOnly;
    protected int status = 0;
    protected boolean isInBeforeCompletion;
    protected final Object statusSync = new Object();
    private final Object bqSync = new Object();
    private final ActiveTimerEntry activeTimer;
    private PropagationContext ctx;
    private TransactionImpl transaction;
    protected Vector localResources = new Vector(5);
    private Vector localSyncs = new Vector(5);
    private Vector<Synchronization> interposedLocalSyncs = new Vector(5);
    private final OnePCommitResponseCollector opcCollector = new OnePCommitResponseCollector();
    private Vector localPrepared;
    protected LocalResource localXAResource;
    private final long startTime;
    private boolean isDisabledActiveTimer;
    protected boolean isPrepareCalled;
    private boolean isAlreadyAssociated;
    private String associatedThread;
    private boolean isPreparedReadOnly;
    public static final int TRANSACTION_ALREADY_TIMEOUT = -1;

    protected Coordinator(GTID gtid, long timeout) {
        this.gtid = gtid;
        this.timeout = timeout;
        this.activeTimer = new ActiveTimerEntry(this);
        this.startTime = System.currentTimeMillis();
        if (logger.isLoggable(JeusMessage_TM3._5201_LEVEL)) {
            long time = this.startTime + timeout;
            logger.logp(JeusMessage_TM3._5201_LEVEL, "TimerEntry", "<init>", JeusMessage_TM3._5201, new Object[]{this, String.valueOf(time)});
        }
        ScheduledExecutor.getInstance().schedule(this.activeTimer, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerResource(LocalResource resource) {
        if (logger.isLoggable(JeusMessage_TM1._3605_LEVEL)) {
            logger.logp(JeusMessage_TM1._3605_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3605, new Object[]{resource, this.gtid});
        }
        this.beforeRegisterResource();
        Object object = this.statusSync;
        synchronized (object) {
            if (this.isNotRunningTransaction() && !this.isInBeforeCompletion) {
                if (logger.isLoggable(JeusMessage_TM1._3612_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3612_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3612, new Object[]{this.gtid, TxStatus.getState(this.status)});
                }
                throw new JeusRuntimeException(JeusMessage_TM1._3612, (Object[])new String[]{this.gtid.toString(), TxStatus.getState(this.status)});
            }
            this.localResources.add(resource);
        }
        if (logger.isLoggable(JeusMessage_TM1._3613_LEVEL)) {
            logger.logp(JeusMessage_TM1._3613_LEVEL, "Coordinator", "registerResource", JeusMessage_TM1._3613, new Object[]{resource, this.gtid});
        }
    }

    protected void beforeRegisterResource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerSynchronization(Object sync) {
        if (logger.isLoggable(JeusMessage_TM1._3614_LEVEL)) {
            logger.logp(JeusMessage_TM1._3614_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3614, new Object[]{sync, this.gtid});
        }
        this.beforeRegisterResource();
        Object object = this.statusSync;
        synchronized (object) {
            if (this.isNotRunningTransaction() && !this.isInBeforeCompletion) {
                if (logger.isLoggable(JeusMessage_TM1._3616_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3616_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3616, new Object[]{this.gtid, TxStatus.getState(this.status)});
                }
                if (sync instanceof JeusSynchronization) {
                    if (logger.isLoggable(JeusMessage_TM1._3617_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3617_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3617);
                    }
                    ((JeusSynchronization)sync).resetTransaction();
                }
                throw new JeusRuntimeException(JeusMessage_TM1._3618, (Object)this.gtid.toString());
            }
            this.localSyncs.add(sync);
        }
        if (logger.isLoggable(JeusMessage_TM1._3619_LEVEL)) {
            logger.logp(JeusMessage_TM1._3619_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3619, new Object[]{sync, this.gtid});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerInterposedSynchronization(Synchronization sync) {
        if (logger.isLoggable(JeusMessage_TM1._3614_LEVEL)) {
            logger.logp(JeusMessage_TM1._3614_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3614, new Object[]{sync, this.gtid});
        }
        this.beforeRegisterResource();
        Object object = this.statusSync;
        synchronized (object) {
            if (this.isNotRunningTransaction() && !this.isInBeforeCompletion) {
                if (logger.isLoggable(JeusMessage_TM1._3616_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3616_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3616, new Object[]{this.gtid, TxStatus.getState(this.status)});
                }
                throw new JeusRuntimeException(JeusMessage_TM1._3618, (Object)this.gtid.toString());
            }
            this.interposedLocalSyncs.add(sync);
        }
        if (logger.isLoggable(JeusMessage_TM1._3619_LEVEL)) {
            logger.logp(JeusMessage_TM1._3619_LEVEL, "Coordinator", "registerSynchronization", JeusMessage_TM1._3619, new Object[]{sync, this.gtid});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean disableActiveTO() {
        if (logger.isLoggable(JeusMessage_TM1._3626_LEVEL)) {
            logger.logp(JeusMessage_TM1._3626_LEVEL, "Coordinator", "disableActiveTO", JeusMessage_TM1._3626, (Object)this.gtid);
        }
        Object object = this.statusSync;
        synchronized (object) {
            if (this.isDisabledActiveTimer) {
                return true;
            }
            if (this.isNotRunningTransaction()) {
                if (logger.isLoggable(JeusMessage_TM1._3627_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3627_LEVEL, "Coordinator", "disableActiveTO", JeusMessage_TM1._3627, (Object)this.gtid);
                }
                return false;
            }
            this.isDisabledActiveTimer = true;
            this.activeTimer.cancel();
            if (logger.isLoggable(JeusMessage_TM1._3628_LEVEL)) {
                logger.logp(JeusMessage_TM1._3628_LEVEL, "Coordinator", "disableActiveTO", JeusMessage_TM1._3628, (Object)this.gtid);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activeTimeout() {
        if (logger.isLoggable(JeusMessage_TM1._3629_LEVEL)) {
            logger.logp(JeusMessage_TM1._3629_LEVEL, "Coordinator", "activeTimeout", JeusMessage_TM1._3629, (Object)this.gtid);
        }
        Object object = this.statusSync;
        synchronized (object) {
            if (this.isNotRunningTransaction()) {
                if (logger.isLoggable(JeusMessage_TM1._3630_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3630_LEVEL, "Coordinator", "activeTimeout", JeusMessage_TM1._3630, (Object)this.gtid);
                }
                return;
            }
            this.status = 9;
        }
        if (logger.isLoggable(JeusMessage_TM1._3632_LEVEL)) {
            logger.logp(JeusMessage_TM1._3632_LEVEL, "Coordinator", "activeTimeout", JeusMessage_TM1._3632, (Object)this.gtid);
        }
        JTAStatisticsProvider.incrementActiveTimeOutCount();
        this.handleCommonTimeOut();
        this.rollback();
        this.destroy();
    }

    protected final boolean isNotRunningTransaction() {
        return this.status != 0 && this.status != 1;
    }

    protected final void handleCommonTimeOut() {
        JTAStatisticsProvider.incrementTimeOutRolledbackCount();
        JTAStatisticsProvider.incrementTimeOutCount();
        this.ejbSynchronizationTimeOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void beforeCompletion() {
        if (logger.isLoggable(JeusMessage_TM1._3633_LEVEL)) {
            logger.logp(JeusMessage_TM1._3633_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3633, (Object)this.gtid);
        }
        this.isInBeforeCompletion = true;
        boolean alreadyAssociated = false;
        try {
            int i;
            alreadyAssociated = this.ensureTransactionContext();
            this.preBeforeCompletion();
            if (logger.isLoggable(JeusMessage_TM1._3637_LEVEL)) {
                logger.logp(JeusMessage_TM1._3637_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3637, (Object)this.gtid);
            }
            Synchronization sync = null;
            int len = this.localSyncs.size();
            for (i = 0; i < len; ++i) {
                try {
                    sync = (Synchronization)this.localSyncs.elementAt(i);
                    if (logger.isLoggable(JeusMessage_TM1._3638_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3638_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3638, new Object[]{sync, this.gtid});
                    }
                    sync.beforeCompletion();
                    continue;
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_TM1._3639_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3639_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3639, new Object[]{sync, this.gtid}, ex);
                    }
                    this.setRollbackOnly();
                }
            }
            len = this.interposedLocalSyncs.size();
            for (i = 0; i < len; ++i) {
                try {
                    sync = this.interposedLocalSyncs.elementAt(i);
                    if (logger.isLoggable(JeusMessage_TM1._3638_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3638_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3638, new Object[]{sync, this.gtid});
                    }
                    sync.beforeCompletion();
                    continue;
                }
                catch (Throwable ex) {
                    if (logger.isLoggable(JeusMessage_TM1._3639_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3639_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3639, new Object[]{sync, this.gtid}, ex);
                    }
                    this.setRollbackOnly();
                }
            }
            this.postBeforeCompletion();
            this.isInBeforeCompletion = false;
            if (logger.isLoggable(JeusMessage_TM1._3644_LEVEL)) {
                logger.logp(JeusMessage_TM1._3644_LEVEL, "Coordinator", "beforeCompletion", JeusMessage_TM1._3644, (Object)this.gtid);
            }
        }
        finally {
            if (!alreadyAssociated) {
                ThreadContexts.dissociateTransactionID();
            }
        }
    }

    private boolean ensureTransactionContext() {
        GTID gtid = ThreadContexts.getAssociatedTransactionID();
        if (gtid != null) {
            return true;
        }
        if (this.gtid == null) {
            throw new IllegalStateException("current coodinator has not a valid gtid");
        }
        ThreadContexts.associateTransactionID(this.gtid);
        return false;
    }

    protected void postBeforeCompletion() {
    }

    protected void preBeforeCompletion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte prepare() {
        if (logger.isLoggable(JeusMessage_TM1._3645_LEVEL)) {
            logger.logp(JeusMessage_TM1._3645_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3645, (Object)this.gtid);
        }
        this.status = 7;
        try {
            byte result;
            int i;
            boolean rollback = this.prePrepare();
            if (logger.isLoggable(JeusMessage_TM1._3649_LEVEL)) {
                logger.logp(JeusMessage_TM1._3649_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3649, (Object)this.gtid);
            }
            int len_localResources = this.localResources.size();
            this.localPrepared = new Vector(len_localResources);
            this.forcelyEndResources(len_localResources);
            block15: for (i = 0; i < len_localResources; ++i) {
                LocalResource rsc = (LocalResource)this.localResources.elementAt(i);
                if (logger.isLoggable(JeusMessage_TM1._3651_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3651_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3651, new Object[]{rsc, this.gtid});
                }
                switch (rsc.prepare()) {
                    case 0: {
                        this.localPrepared.add(rsc);
                        if (!logger.isLoggable(JeusMessage_TM1._3652_LEVEL)) continue block15;
                        logger.logp(JeusMessage_TM1._3652_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3652, new Object[]{rsc, this.gtid});
                        continue block15;
                    }
                    case 1: {
                        this.localPrepared.add(rsc);
                        if (logger.isLoggable(JeusMessage_TM1._3653_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3653_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3653, new Object[]{rsc, this.gtid});
                        }
                        rollback = true;
                        continue block15;
                    }
                    case 2: {
                        if (!logger.isLoggable(JeusMessage_TM1._3654_LEVEL)) continue block15;
                        logger.logp(JeusMessage_TM1._3654_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3654, new Object[]{rsc, this.gtid});
                        continue block15;
                    }
                    case 5: {
                        this.localXAResource = rsc;
                        if (!logger.isLoggable(JeusMessage_TM1._3655_LEVEL)) continue block15;
                        logger.logp(JeusMessage_TM1._3655_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3655, new Object[]{rsc, this.gtid});
                        continue block15;
                    }
                }
            }
            if ((rollback = this.postPrepare(rollback)) || this.rollbackOnly) {
                if (logger.isLoggable(JeusMessage_TM1._3671_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3671_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3671, (Object)this.gtid);
                }
                this.setGlobalDecision((byte)1);
                i = 1;
                return (byte)i;
            }
            if (this.isNoResource()) {
                this.isPreparedReadOnly = true;
                this.setGlobalDecision((byte)2);
                result = this.setReadOnlyStatus();
                if (logger.isLoggable(JeusMessage_TM1._3672_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3672_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3672, new Object[]{this.gtid, TxStatus.getState(result)});
                }
                byte by = result;
                return by;
            }
            this.setGlobalDecision((byte)0);
            result = this.setCommitStatus();
            if (logger.isLoggable(JeusMessage_TM1._3672_LEVEL)) {
                logger.logp(JeusMessage_TM1._3672_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3672, new Object[]{this.gtid, TxStatus.getState(result)});
            }
            byte by = result;
            return by;
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_TM1._3676_LEVEL)) {
                logger.logp(JeusMessage_TM1._3676_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3676, (Object)this.gtid, ex);
            }
            try {
                this.setGlobalDecision((byte)1);
            }
            catch (TMException e) {
                e.printStackTrace();
            }
            byte by = 1;
            return by;
        }
        finally {
            this.status = 2;
        }
    }

    private LocalResource forcelyEndResources(int len_localResources) {
        LocalResource rsc = null;
        for (int i = 0; i < len_localResources; ++i) {
            rsc = (LocalResource)this.localResources.elementAt(i);
            if (logger.isLoggable(JeusMessage_TM1._3650_LEVEL)) {
                logger.logp(JeusMessage_TM1._3650_LEVEL, "Coordinator", "prepare", JeusMessage_TM1._3650, new Object[]{rsc, this.gtid});
            }
            rsc.enforceEnd();
        }
        return rsc;
    }

    protected void setGlobalDecision(byte rollback) throws TMException {
    }

    protected abstract byte setCommitStatus();

    protected abstract byte setReadOnlyStatus();

    protected boolean isNoResource() {
        return this.localPrepared.size() == 0;
    }

    protected abstract boolean postPrepare(boolean var1);

    protected boolean prePrepare() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte commit() {
        if (logger.isLoggable(JeusMessage_TM1._3696_LEVEL)) {
            logger.logp(JeusMessage_TM1._3696_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3696, (Object)this.gtid);
        }
        this.status = 8;
        int response = 3;
        try {
            response = this.preCommit((byte)response);
            if (logger.isLoggable(JeusMessage_TM1._3700_LEVEL)) {
                logger.logp(JeusMessage_TM1._3700_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3700, (Object)this.gtid);
            }
            int len_localPrepared = this.localPrepared.size();
            for (int i = 0; i < len_localPrepared; ++i) {
                LocalResource rsc = (LocalResource)this.localPrepared.elementAt(i);
                if (logger.isLoggable(JeusMessage_TM1._3701_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3701_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3701, new Object[]{rsc, this.gtid});
                }
                if (rsc.commit() != 4) continue;
                response = 4;
                if (!logger.isLoggable(JeusMessage_TM1._3702_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3702_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3702, new Object[]{rsc, this.gtid});
            }
            if (logger.isLoggable(JeusMessage_TM1._3703_LEVEL)) {
                logger.logp(JeusMessage_TM1._3703_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3703, (Object)this.gtid);
            }
            this.afterCompletion(3);
            response = this.postCommit((byte)response);
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_TM1._3710_LEVEL)) {
                logger.logp(JeusMessage_TM1._3710_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3710, (Object)this.gtid, ex);
            }
        }
        finally {
            this.status = 3;
        }
        if (logger.isLoggable(JeusMessage_TM1._3712_LEVEL)) {
            logger.logp(JeusMessage_TM1._3712_LEVEL, "Coordinator", "commit", JeusMessage_TM1._3712, new Object[]{this.gtid, TxStatus.getState((byte)response)});
        }
        return (byte)response;
    }

    protected byte preCommit(byte response) throws TMException {
        return response;
    }

    protected abstract byte postCommit(byte var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte rollback() {
        byte response;
        if (logger.isLoggable(JeusMessage_TM1._3715_LEVEL)) {
            logger.logp(JeusMessage_TM1._3715_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3715, (Object)this.gtid);
        }
        this.status = 9;
        try {
            response = this.preRollback();
            if (logger.isLoggable(JeusMessage_TM1._3719_LEVEL)) {
                logger.logp(JeusMessage_TM1._3719_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3719, new Object[]{this.isPrepareCalled ? "requiring" : "all", this.gtid});
            }
            if (this.isPrepareCalled) {
                int len_localPrepared = this.localPrepared.size();
                for (int i = 0; i < len_localPrepared; ++i) {
                    try {
                        LocalResource rsc = (LocalResource)this.localPrepared.elementAt(i);
                        if (logger.isLoggable(JeusMessage_TM1._3720_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3720_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3720, new Object[]{rsc, this.gtid});
                        }
                        response = rsc.rollback(response);
                        continue;
                    }
                    catch (Throwable ex) {
                        if (!logger.isLoggable(JeusMessage_TM1._3794_LEVEL)) continue;
                        logger.log(JeusMessage_TM1._3794_LEVEL, JeusMessage_TM1._3794);
                    }
                }
                if (this.localXAResource != null) {
                    if (logger.isLoggable(JeusMessage_TM1._3721_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3721_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3721, new Object[]{this.localXAResource, this.gtid});
                    }
                    response = this.localXAResource.rollback(response);
                }
            } else {
                int len_localResources = this.localResources.size();
                this.forcelyEndResources(len_localResources);
                for (int i = 0; i < len_localResources; ++i) {
                    LocalResource rsc = (LocalResource)this.localResources.elementAt(i);
                    if (logger.isLoggable(JeusMessage_TM1._3723_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3723_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3723, new Object[]{rsc, this.gtid});
                    }
                    response = rsc.rollback(response);
                }
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(JeusMessage_TM1._3724_LEVEL)) {
                logger.logp(JeusMessage_TM1._3724_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3724, (Object)this.gtid, ex);
            }
            response = 4;
        }
        finally {
            if (logger.isLoggable(JeusMessage_TM1._3726_LEVEL)) {
                logger.logp(JeusMessage_TM1._3726_LEVEL, "Coordinator", "rollback", JeusMessage_TM1._3726, (Object)this.gtid);
            }
            this.status = 4;
            this.afterCompletion(4);
        }
        return response;
    }

    protected abstract byte preRollback() throws TMException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte onePhaseCommit() {
        if (logger.isLoggable(JeusMessage_TM1._3727_LEVEL)) {
            logger.logp(JeusMessage_TM1._3727_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3727, (Object)this.gtid);
        }
        this.status = 8;
        byte response = 0;
        try {
            try {
                LocalResource rsc = this.forcelyEndResources(1);
                response = rsc.onePhaseCommit();
            }
            catch (Throwable ex) {
                if (logger.isLoggable(JeusMessage_TM1._3730_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3730_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3730, (Object)this.gtid, ex);
                }
                Object var4_5 = null;
                switch (response) {
                    case 0: {
                        if (logger.isLoggable(JeusMessage_TM1._3731_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3731_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3731, (Object)this.gtid);
                        }
                        this.status = 3;
                        break;
                    }
                    case 1: {
                        if (logger.isLoggable(JeusMessage_TM1._3732_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3732_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3732, (Object)this.gtid);
                        }
                        this.status = 4;
                        break;
                    }
                    case 4: {
                        if (logger.isLoggable(JeusMessage_TM1._3733_LEVEL)) {
                            logger.logp(JeusMessage_TM1._3733_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3733, (Object)this.gtid);
                        }
                        this.status = 4;
                        break;
                    }
                }
                if (logger.isLoggable(JeusMessage_TM1._3734_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3734_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3734, (Object)this.gtid);
                }
                this.afterCompletion(this.status);
                return response;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            switch (response) {
                case 0: {
                    if (logger.isLoggable(JeusMessage_TM1._3731_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3731_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3731, (Object)this.gtid);
                    }
                    this.status = 3;
                    break;
                }
                case 1: {
                    if (logger.isLoggable(JeusMessage_TM1._3732_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3732_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3732, (Object)this.gtid);
                    }
                    this.status = 4;
                    break;
                }
                case 4: {
                    if (logger.isLoggable(JeusMessage_TM1._3733_LEVEL)) {
                        logger.logp(JeusMessage_TM1._3733_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3733, (Object)this.gtid);
                    }
                    this.status = 4;
                    break;
                }
            }
            if (logger.isLoggable(JeusMessage_TM1._3734_LEVEL)) {
                logger.logp(JeusMessage_TM1._3734_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3734, (Object)this.gtid);
            }
            this.afterCompletion(this.status);
            throw throwable;
        }
        switch (response) {
            case 0: {
                if (logger.isLoggable(JeusMessage_TM1._3731_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3731_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3731, (Object)this.gtid);
                }
                this.status = 3;
                break;
            }
            case 1: {
                if (logger.isLoggable(JeusMessage_TM1._3732_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3732_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3732, (Object)this.gtid);
                }
                this.status = 4;
                break;
            }
            case 4: {
                if (logger.isLoggable(JeusMessage_TM1._3733_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3733_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3733, (Object)this.gtid);
                }
                this.status = 4;
                break;
            }
        }
        if (logger.isLoggable(JeusMessage_TM1._3734_LEVEL)) {
            logger.logp(JeusMessage_TM1._3734_LEVEL, "Coordinator", "onePhaseCommit", JeusMessage_TM1._3734, (Object)this.gtid);
        }
        this.afterCompletion(this.status);
        return response;
    }

    public final void onePhaseCommitResponse(byte response) {
        if (logger.isLoggable(JeusMessage_TM1._3735_LEVEL)) {
            logger.logp(JeusMessage_TM1._3735_LEVEL, "Coordinator", "onePhaseCommitResponse", JeusMessage_TM1._3735, new Object[]{TxStatus.getState(response), this.gtid});
        }
        this.opcCollector.received(response);
    }

    public final void afterCompletion(int state) {
        if (logger.isLoggable(JeusMessage_TM1._3736_LEVEL)) {
            logger.logp(JeusMessage_TM1._3736_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3736, new Object[]{this.gtid, TxStatus.getState(state)});
        }
        if (state == 3) {
            JTAStatisticsProvider.incrementCommittedCount();
        } else {
            JTAStatisticsProvider.incrementRolledbackCount();
        }
        int len = this.interposedLocalSyncs.size();
        for (int i = 0; i < len; ++i) {
            Synchronization sync = this.interposedLocalSyncs.elementAt(i);
            try {
                if (logger.isLoggable(JeusMessage_TM1._3737_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3737_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3737, new Object[]{sync, this.gtid, TxStatus.getState(state)});
                }
                sync.afterCompletion(state);
                continue;
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_TM1._3738_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3738_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3738, new Object[]{sync, this.gtid, TxStatus.getState(state)}, ex);
            }
        }
        int len_localSyncs = this.localSyncs.size();
        for (int i = 0; i < len_localSyncs; ++i) {
            Synchronization sync = (Synchronization)this.localSyncs.elementAt(i);
            try {
                if (logger.isLoggable(JeusMessage_TM1._3737_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3737_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3737, new Object[]{sync, this.gtid, TxStatus.getState(state)});
                }
                sync.afterCompletion(state);
                continue;
            }
            catch (Throwable ex) {
                if (!logger.isLoggable(JeusMessage_TM1._3738_LEVEL)) continue;
                logger.logp(JeusMessage_TM1._3738_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3738, new Object[]{sync, this.gtid, TxStatus.getState(state)}, ex);
            }
        }
        if (logger.isLoggable(JeusMessage_TM1._3740_LEVEL)) {
            logger.logp(JeusMessage_TM1._3740_LEVEL, "Coordinator", "afterCompletion", JeusMessage_TM1._3740, (Object)this.gtid);
        }
    }

    public final void setRollbackOnly() {
        if (logger.isLoggable(JeusMessage_TM1._3758_LEVEL)) {
            logger.logp(JeusMessage_TM1._3758_LEVEL, "Coordinator", "setRollbackOnly", JeusMessage_TM1._3758, (Object)this.gtid);
        }
        this.rollbackOnly = true;
        this.status = 1;
    }

    public final boolean isRollbackOnly() {
        if (logger.isLoggable(JeusMessage_TM1._3759_LEVEL)) {
            logger.logp(JeusMessage_TM1._3759_LEVEL, "Coordinator", "isRollbackOnly", JeusMessage_TM1._3759, new Object[]{this.gtid, this.rollbackOnly ? "" : "not "});
        }
        return this.rollbackOnly;
    }

    public final int getStatus() {
        return this.status;
    }

    public final TransactionImpl getTransaction() {
        if (logger.isLoggable(JeusMessage_TM1._3761_LEVEL)) {
            logger.logp(JeusMessage_TM1._3761_LEVEL, "Coordinator", "getTransaction", JeusMessage_TM1._3761, (Object)this.gtid);
        }
        if (this.transaction == null) {
            this.transaction = new TransactionImpl(this, this.gtid);
        }
        return this.transaction;
    }

    public final GTID getGTID() {
        if (logger.isLoggable(JeusMessage_TM1._3763_LEVEL)) {
            logger.logp(JeusMessage_TM1._3763_LEVEL, "Coordinator", "getGTID", JeusMessage_TM1._3763, (Object)this.gtid);
        }
        return this.gtid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Xid createXID() {
        byte seq;
        Object object = this.bqSync;
        synchronized (object) {
            byte by = this.bqCount;
            this.bqCount = (byte)(by + 1);
            seq = by;
        }
        byte[] bq = TMServer.makeBQ(this.gtid, seq);
        if (logger.isLoggable(JeusMessage_TM1._3764_LEVEL)) {
            logger.logp(JeusMessage_TM1._3764_LEVEL, "Coordinator", "createXID", JeusMessage_TM1._3764, new Object[]{new Byte(this.bqCount), this.gtid});
        }
        return new XidImpl(this.gtid.toBytes(), bq);
    }

    final LocalResource getLocalResource(XAResource xaResource) {
        if (logger.isLoggable(JeusMessage_TM1._3765_LEVEL)) {
            logger.logp(JeusMessage_TM1._3765_LEVEL, "Coordinator", "getLocalResource", JeusMessage_TM1._3765, new Object[]{xaResource, this.gtid});
        }
        for (int i = 0; i < this.localResources.size(); ++i) {
            LocalResource localResource = (LocalResource)this.localResources.elementAt(i);
            if (localResource == null || localResource.getXAResource() != xaResource) continue;
            return localResource;
        }
        return null;
    }

    public Vector getLocalResources() {
        Vector resources = new Vector();
        resources.addAll(this.localResources);
        return resources;
    }

    final PropagationContext getPropagationContext() {
        if (this.ctx == null) {
            this.ctx = new PropagationContext(this.gtid, this.timeout);
        }
        if (logger.isLoggable(JeusMessage_TM1._3766_LEVEL)) {
            logger.logp(JeusMessage_TM1._3766_LEVEL, "Coordinator", "getPropagationContext", JeusMessage_TM1._3766, new Object[]{this.ctx, this.gtid});
        }
        return this.ctx;
    }

    public final void destroy() {
        if (logger.isLoggable(JeusMessage_TM1._3767_LEVEL)) {
            logger.logp(JeusMessage_TM1._3767_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3767, (Object)this.gtid);
        }
        if (logger.isLoggable(JeusMessage_TM1._3768_LEVEL)) {
            logger.logp(JeusMessage_TM1._3768_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3768);
        }
        this.gtid.invalidate();
        this.innerDestroy();
        this.transaction = null;
        this.activeTimer.cancel();
        if (logger.isLoggable(JeusMessage_TM1._3770_LEVEL)) {
            logger.logp(JeusMessage_TM1._3770_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3770);
        }
        if (this.localResources != null) {
            this.localResources.clear();
            this.localResources = null;
        }
        if (this.localSyncs != null) {
            this.localSyncs.clear();
            this.localSyncs = null;
        }
        if (this.interposedLocalSyncs != null) {
            this.interposedLocalSyncs.clear();
            this.interposedLocalSyncs = null;
        }
        if (logger.isLoggable(JeusMessage_TM1._3771_LEVEL)) {
            logger.logp(JeusMessage_TM1._3771_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3771);
        }
        if (this.localPrepared != null) {
            this.localPrepared.clear();
            this.localPrepared = null;
        }
        JTAStatisticsProvider.decrementActiveCount();
        JTAStatisticsProvider.addExecutionTime(System.currentTimeMillis() - this.startTime);
        if (logger.isLoggable(JeusMessage_TM1._3772_LEVEL)) {
            logger.logp(JeusMessage_TM1._3772_LEVEL, "Coordinator", "destroy", JeusMessage_TM1._3772, (Object)this.gtid);
        }
    }

    protected abstract void innerDestroy();

    public final void flush() throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3773_LEVEL)) {
            logger.logp(JeusMessage_TM1._3773_LEVEL, "Coordinator", "flush", JeusMessage_TM1._3773, (Object)this.gtid);
        }
        ThreadContexts.associateTransactionID(this.gtid);
        this.innerFlush();
    }

    protected abstract void innerFlush() throws TMException;

    public final void flush_subcoordinator() throws TMException {
        if (logger.isLoggable(JeusMessage_TM1._3784_LEVEL)) {
            logger.logp(JeusMessage_TM1._3784_LEVEL, "Coordinator", "flush_subcoordinator", JeusMessage_TM1._3784, (Object)this.gtid);
        }
        int len_localSyncs = this.localSyncs.size();
        for (int i = 0; i < len_localSyncs; ++i) {
            Object sync = null;
            try {
                sync = this.localSyncs.elementAt(i);
                if (logger.isLoggable(JeusMessage_TM1._3785_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3785_LEVEL, "Coordinator", "flush_subcoordinator", JeusMessage_TM1._3785, new Object[]{sync, this.gtid});
                }
                if (!(sync instanceof JeusSynchronization)) continue;
                ((JeusSynchronization)sync).flush();
                continue;
            }
            catch (Throwable ex) {
                throw new TMException(JeusMessage_TM1._3786, new String[]{sync.toString(), this.gtid.toString()}, ex);
            }
        }
        if (logger.isLoggable(JeusMessage_TM1._3787_LEVEL)) {
            logger.logp(JeusMessage_TM1._3787_LEVEL, "Coordinator", "flush_subcoordinator", JeusMessage_TM1._3787, (Object)this.gtid);
        }
    }

    private void ejbSynchronizationTimeOut() {
        int len_localSyncs = this.localSyncs.size();
        for (int i = 0; i < len_localSyncs; ++i) {
            try {
                Object synchronization = this.localSyncs.elementAt(i);
                if (!(synchronization instanceof JeusSynchronization)) continue;
                ((JeusSynchronization)synchronization).timeOut(8);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public final String toString() {
        return this.gtid.toString();
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final int getTimeoutInSeconds() {
        return this.timeout / 1000L < Integer.MAX_VALUE ? (int)(this.timeout / 1000L) : Integer.MAX_VALUE;
    }

    public long getElapseSinceBegin() {
        if (this.startTime <= 0L) {
            throw new IllegalStateException("transaction is not begun");
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public long getRemainingTimeout() {
        long elapse;
        long timeout = this.timeout;
        if (timeout <= 0L) {
            timeout = TMConfig.activeTO;
        }
        if ((elapse = System.currentTimeMillis() - this.startTime) < 0L) {
            elapse = 0L;
        }
        if (timeout >= elapse) {
            return timeout - elapse;
        }
        return -1L;
    }

    public final boolean isPreparedCalled() {
        return this.isPrepareCalled;
    }

    public void setExternalXid(Xid xid) {
    }

    public synchronized void coordinatorAssociated() {
        if (this.isAlreadyAssociated) {
            if (logger.isLoggable(JeusMessage_TM3._5563_LEVEL)) {
                logger.logp(JeusMessage_TM3._5563_LEVEL, "TMServer", "associateThread", JeusMessage_TM3._5563, new Object[]{Thread.currentThread(), this.associatedThread});
            }
            throw new RuntimeException("Two or more threads cannot be associated with one coordinator, associated thread : " + this.associatedThread);
        }
        this.isAlreadyAssociated = true;
        this.associatedThread = Thread.currentThread().getName();
    }

    public synchronized void coordinatorDisassociated() {
        this.isAlreadyAssociated = false;
        this.associatedThread = null;
    }

    public synchronized boolean isAlreadyAssociated() {
        return this.isAlreadyAssociated;
    }

    public String getAssociatedThread() {
        return this.associatedThread;
    }

    public boolean isPreparedReadOnly() {
        return this.isPreparedReadOnly;
    }

    public Xid getXidFromXAResource(XAResource xaResource) {
        if (xaResource == null) {
            return null;
        }
        if (xaResource instanceof XAResourceWrapper) {
            return ((XAResourceWrapper)xaResource).getXID();
        }
        LocalResource localResource = this.getLocalResource(xaResource);
        if (localResource == null) {
            return null;
        }
        return localResource.getXid();
    }
}

