/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import javax.transaction.InvalidTransactionException;
import javax.transaction.xa.Xid;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.Coordinator;
import jeus.transaction.PropagationContext;
import jeus.transaction.TMNotAvailableException;
import jeus.transaction.TMServer;
import jeus.transaction.ThreadContexts;
import jeus.transaction.sub.SubCoordinator;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM1;
import jeus.util.message.JeusMessage_TM3;
import jeus.util.properties.JeusTMProperties;

public final class ServerContextSenderReceiver
extends ContextSenderReceiver {
    protected final boolean processContextPropagated(byte[] ctx, Xid xid) throws TMNotAvailableException {
        if (logger.isLoggable(JeusMessage_TM1._3501_LEVEL)) {
            logger.logp(JeusMessage_TM1._3501_LEVEL, "ContextSenderReceiver", "contextPropagated", JeusMessage_TM1._3501, (Object)Utility.getDump((byte[])ctx));
        }
        if (!TMServer.isInitialized()) {
            if (logger.isLoggable(JeusMessage_TM1._3503_LEVEL)) {
                logger.logp(JeusMessage_TM1._3503_LEVEL, "ContextSenderReceiver", "contextPropagated", JeusMessage_TM1._3503);
            }
            return false;
        }
        if (ctx[0] == -1) {
            if (logger.isLoggable(JeusMessage_TM1._3504_LEVEL)) {
                logger.logp(JeusMessage_TM1._3504_LEVEL, "ContextSenderReceiver", "contextPropagated", JeusMessage_TM1._3504);
            }
            if (logger.isLoggable(JeusMessage_TM3._5556_LEVEL)) {
                logger.logp(JeusMessage_TM3._5556_LEVEL, "TMServer", "contextPropagated", JeusMessage_TM3._5556, (Object)Thread.currentThread());
            }
            ThreadContexts.dissociateTransactionID();
        } else if (ctx[0] == -2) {
            if (logger.isLoggable(JeusMessage_TM1._3505_LEVEL)) {
                logger.logp(JeusMessage_TM1._3505_LEVEL, "ContextSenderReceiver", "contextPropagated", JeusMessage_TM1._3505);
            }
            TMServer.unspecifiedContextPropagated(ctx);
        } else if (ctx[0] == -3) {
            if (logger.isLoggable(JeusMessage_TM1._3505_LEVEL)) {
                logger.logp(JeusMessage_TM1._3505_LEVEL, "ContextSenderReceiver", "contextPropagated", JeusMessage_TM1._3505);
            }
            TMServer.unspecifiedContextPropagated(ctx);
            ThreadContexts.getAssociatedTransactionID().setExternalXid(xid);
        } else {
            if (logger.isLoggable(JeusMessage_TM1._3506_LEVEL)) {
                logger.logp(JeusMessage_TM1._3506_LEVEL, "ContextSenderReceiver", "contextPropagated", JeusMessage_TM1._3506);
            }
            return TMServer.contextPropagated(new PropagationContext(ctx));
        }
        if (logger.isLoggable(JeusMessage_TM1._3507_LEVEL)) {
            logger.logp(JeusMessage_TM1._3507_LEVEL, "ContextSenderReceiver", "contextPropagated", JeusMessage_TM1._3507);
        }
        return false;
    }

    protected final byte[] processGetPropagationContext() {
        Coordinator coord;
        if (logger.isLoggable(JeusMessage_TM1._3508_LEVEL)) {
            logger.logp(JeusMessage_TM1._3508_LEVEL, "ContextSenderReceiver", "getPropagationContext", JeusMessage_TM1._3508, (Object)Thread.currentThread());
        }
        if (!TMServer.isInitialized()) {
            if (logger.isLoggable(JeusMessage_TM1._3512_LEVEL)) {
                logger.logp(JeusMessage_TM1._3512_LEVEL, "ContextSenderReceiver", "getPropagationContext", JeusMessage_TM1._3512);
            }
            return nullTxBytes;
        }
        try {
            coord = TMServer.getCoordinator();
        }
        catch (InvalidTransactionException e) {
            if (logger.isLoggable(JeusMessage_TM1._3513_LEVEL)) {
                logger.logp(JeusMessage_TM1._3513_LEVEL, "ContextSenderReceiver", "getPropagationContext", JeusMessage_TM1._3513, (Object)Thread.currentThread());
            }
            throw new IllegalStateException("this transaction is already timeout");
        }
        if (coord == null) {
            if (logger.isLoggable(JeusMessage_TM1._3514_LEVEL)) {
                logger.logp(JeusMessage_TM1._3514_LEVEL, "ContextSenderReceiver", "getPropagationContext", JeusMessage_TM1._3514, (Object)Thread.currentThread());
            }
            return nullTxBytes;
        }
        byte[] context = coord.getPropagationContext().getBytes();
        if (logger.isLoggable(JeusMessage_TM1._3515_LEVEL)) {
            logger.logp(JeusMessage_TM1._3515_LEVEL, "ContextSenderReceiver", "getPropagationContext", JeusMessage_TM1._3515, new Object[]{Utility.getDump((byte[])context), Thread.currentThread()});
        }
        return context;
    }

    public static void checkRegistration() {
        SubCoordinator coord;
        block7: {
            if (logger.isLoggable(JeusMessage_TM1._3516_LEVEL)) {
                logger.logp(JeusMessage_TM1._3516_LEVEL, "ContextSenderReceiver", "checkRegistration", JeusMessage_TM1._3516);
            }
            if (!JeusTMProperties.reliableRegistration || !TMServer.isInitialized()) {
                if (logger.isLoggable(JeusMessage_TM1._3517_LEVEL)) {
                    logger.logp(JeusMessage_TM1._3517_LEVEL, "ContextSenderReceiver", "checkRegistration", JeusMessage_TM1._3517);
                }
                return;
            }
            coord = null;
            try {
                coord = (SubCoordinator)TMServer.getCoordinator();
            }
            catch (InvalidTransactionException e) {
                if (!logger.isLoggable(JeusMessage_TM1._3518_LEVEL)) break block7;
                logger.logp(JeusMessage_TM1._3518_LEVEL, "ContextSenderReceiver", "checkRegistration", JeusMessage_TM1._3518, (Object)Thread.currentThread());
            }
        }
        if (coord != null) {
            if (logger.isLoggable(JeusMessage_TM1._3520_LEVEL)) {
                logger.logp(JeusMessage_TM1._3520_LEVEL, "ContextSenderReceiver", "checkRegistration", JeusMessage_TM1._3520);
            }
            coord.checkRegistration();
        }
    }
}

