/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;
import jeus.transaction.util.XidToString;
import jeus.util.ByteUtil;

public class XidImpl
implements Xid,
Serializable {
    static final long serialVersionUID = 271670383397224532L;
    private int formatID;
    private byte[] gtid;
    private byte[] bq;
    private int hashcode;

    protected XidImpl() {
    }

    protected final void setXid(byte[] gtid, byte[] bq, int formatID) {
        this.gtid = gtid;
        this.bq = bq;
        this.formatID = formatID;
        this.hashcode = XidImpl.getHashCode(this);
    }

    public XidImpl(byte[] gtid, byte[] bq) {
        this.setXid(gtid, bq, 9736);
    }

    public XidImpl(Xid xid) {
        this.setXid(xid.getGlobalTransactionId(), xid.getBranchQualifier(), xid.getFormatId());
    }

    private static int getHashCode(Xid xid) {
        return ByteUtil.getHashCode((byte[])xid.getGlobalTransactionId()) ^ ByteUtil.getHashCode((byte[])xid.getBranchQualifier()) ^ xid.getFormatId();
    }

    public XidImpl(byte[] gtid, byte[] bq, int formatId) {
        this.setXid(gtid, bq, formatId);
    }

    public XidImpl(byte[] byteArray, int gtidLength, int formatId) {
        byte[] gtid = new byte[gtidLength];
        byte[] bq = new byte[byteArray.length - gtidLength];
        System.arraycopy(byteArray, 0, gtid, 0, gtidLength);
        System.arraycopy(byteArray, gtidLength, bq, 0, byteArray.length - gtidLength);
        this.setXid(gtid, bq, formatId);
    }

    public final byte[] getBranchQualifier() {
        return this.bq;
    }

    public final int getFormatId() {
        return this.formatID;
    }

    public final byte[] getGlobalTransactionId() {
        return this.gtid;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        return XidImpl.equalsXid(this, obj);
    }

    public static boolean equalsXid(Xid thisObject, Object obj) {
        if (obj == thisObject) {
            return true;
        }
        if (obj instanceof Xid) {
            Xid other = (Xid)obj;
            return thisObject.getFormatId() == other.getFormatId() && Arrays.equals(thisObject.getGlobalTransactionId(), other.getGlobalTransactionId()) && Arrays.equals(thisObject.getBranchQualifier(), other.getBranchQualifier());
        }
        return false;
    }

    public String toString() {
        return XidToString.getXidString(this) + "@" + super.toString();
    }
}

