/*
 * Decompiled with CFR 0.152.
 */
package jeus.transaction.client;

import java.util.Hashtable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.Xid;
import jeus.descriptor.jeusserver.TransactionManagerDescriptor;
import jeus.transaction.ContextSenderReceiver;
import jeus.transaction.GTID;
import jeus.transaction.TMConfig;
import jeus.transaction.TMException;
import jeus.transaction.TMServer;
import jeus.transaction.TxStatus;
import jeus.transaction.client.ClientContextSenderReceiver;
import jeus.transaction.client.RemoteGTID;
import jeus.transaction.comm.TMLink;
import jeus.transaction.comm.TMLinkManager;
import jeus.util.ErrorMsgManager;
import jeus.util.logging.JeusLogger;
import jeus.util.logging.Utility;
import jeus.util.message.JeusMessage_TM0;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.properties.JeusTMPropertyValues;

public final class TMClient {
    private static final transient JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.transaction");
    public static ThreadLocal contexts = new ThreadLocal();
    static Hashtable responseCollector;
    static TMLinkManager linkManager;
    private static byte[] ipaddr;
    public static final byte tmClientStartPort = 30;
    private static int port;
    public static boolean initialized;
    private static final Object initialSync;
    private static int tmMin;
    private static int tmMax;
    private static long tmResizingPeriod;
    private static int tmCapacity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(TransactionManagerDescriptor desc) throws TMException {
        Object object = initialSync;
        synchronized (object) {
            if (initialized) {
                if (logger.isLoggable(JeusMessage_TM0._1301_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1301_LEVEL, "TMClient", "init", JeusMessage_TM0._1301);
                }
                return;
            }
            if (TMServer.isInitialized()) {
                return;
            }
            JeusTMPropertyValues.isClientTM = true;
            if (logger.isLoggable(JeusMessage_TM0._1302_LEVEL)) {
                logger.logp(JeusMessage_TM0._1302_LEVEL, "TMClient", "init", JeusMessage_TM0._1302);
            }
            try {
                TMClient.getEnvironments(desc);
                int starttime = (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
                linkManager = new TMLinkManager(TMConfig.nonBlocking, false);
                responseCollector = new Hashtable(tmCapacity);
                contexts = new ThreadLocal();
                port = linkManager.init(ipaddr, port, starttime, -1, tmMin, tmMax, tmResizingPeriod);
                ContextSenderReceiver.setContextSenderReceiver(new ClientContextSenderReceiver());
                initialized = true;
            }
            catch (Throwable ex) {
                throw new TMException(JeusMessage_TM0._1303, ex);
            }
            initialized = true;
        }
        if (logger.isLoggable(JeusMessage_TM0._1304_LEVEL)) {
            logger.logp(JeusMessage_TM0._1304_LEVEL, "TMClient", "init", JeusMessage_TM0._1304);
        }
    }

    private static void getEnvironments(TransactionManagerDescriptor desc) throws Exception {
        block20: {
            if (logger.isLoggable(JeusMessage_TM0._1307_LEVEL)) {
                logger.logp(JeusMessage_TM0._1307_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1307);
            }
            if (logger.isLoggable(JeusMessage_TM0._1308_LEVEL)) {
                logger.logp(JeusMessage_TM0._1308_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1308);
            }
            String s = JeusNetPropertyValues.LOCAL_FULL_HOSTNAME;
            if (logger.isLoggable(JeusMessage_TM0._1309_LEVEL)) {
                logger.logp(JeusMessage_TM0._1309_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1309, (Object)s);
            }
            ipaddr = JeusNetPropertyValues.getLocalInetAddress().getAddress();
            if (logger.isLoggable(JeusMessage_TM0._1310_LEVEL)) {
                logger.logp(JeusMessage_TM0._1310_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1310, (Object)Utility.getDump((byte[])ipaddr));
            }
            if (desc != null) {
                if (logger.isLoggable(JeusMessage_TM0._1311_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1311_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1311);
                }
                TMConfig.configure(desc);
            } else {
                if (logger.isLoggable(JeusMessage_TM0._1312_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1312_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1312);
                }
                try {
                    TMConfig.configure(null);
                    s = System.getProperty("jeus.tm.port");
                    if (s != null) {
                        port = Integer.parseInt(s);
                    }
                    if (logger.isLoggable(JeusMessage_TM0._1313_LEVEL)) {
                        logger.logp(JeusMessage_TM0._1313_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1313, (Object)String.valueOf(port));
                    }
                    if ((s = System.getProperty("jeus.tm.tmMin")) != null) {
                        tmMin = Integer.parseInt(s);
                    }
                    if (logger.isLoggable(JeusMessage_TM0._1317_LEVEL)) {
                        logger.logp(JeusMessage_TM0._1317_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1317, (Object)String.valueOf(tmMin));
                    }
                    if ((s = System.getProperty("jeus.tm.tmMax")) != null) {
                        tmMax = Integer.parseInt(s);
                    }
                    if (logger.isLoggable(JeusMessage_TM0._1319_LEVEL)) {
                        logger.logp(JeusMessage_TM0._1319_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1319, (Object)String.valueOf(tmMax));
                    }
                    if ((s = System.getProperty("jeus.tm.resizingPeriod")) != null) {
                        tmResizingPeriod = Long.parseLong(s);
                    }
                    if (logger.isLoggable(JeusMessage_TM0._1320_LEVEL)) {
                        logger.logp(JeusMessage_TM0._1320_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1320, (Object)String.valueOf(tmResizingPeriod));
                    }
                    if ((s = System.getProperty("jeus.tm.tmCapacity")) != null) {
                        tmCapacity = Integer.parseInt(s);
                    }
                    if (logger.isLoggable(JeusMessage_TM0._1321_LEVEL)) {
                        logger.logp(JeusMessage_TM0._1321_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1321, (Object)String.valueOf(tmCapacity));
                    }
                }
                catch (SecurityException t) {
                    if (!logger.isLoggable(JeusMessage_TM0._1323_LEVEL)) break block20;
                    logger.logp(JeusMessage_TM0._1323_LEVEL, "TMClient", "getEnvironments", JeusMessage_TM0._1323);
                }
            }
        }
    }

    static void create(Xid xid, long timeout) throws NotSupportedException {
        RemoteGTID rgtid;
        if (logger.isLoggable(JeusMessage_TM0._1324_LEVEL)) {
            logger.logp(JeusMessage_TM0._1324_LEVEL, "TMClient", "create", JeusMessage_TM0._1324, (Object)String.valueOf(timeout));
        }
        if ((rgtid = (RemoteGTID)contexts.get()) != null && !rgtid.isInvalid()) {
            if (logger.isLoggable(JeusMessage_TM0._1325_LEVEL)) {
                logger.logp(JeusMessage_TM0._1325_LEVEL, "TMClient", "create", JeusMessage_TM0._1325, contexts.get());
            }
            throw new NotSupportedException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM0._1325, contexts.get()));
        }
        rgtid = new RemoteGTID(xid, timeout);
        if (logger.isLoggable(JeusMessage_TM0._1326_LEVEL)) {
            logger.logp(JeusMessage_TM0._1326_LEVEL, "TMClient", "create", JeusMessage_TM0._1326, (Object)rgtid);
        }
        contexts.set(rgtid);
        if (logger.isLoggable(JeusMessage_TM0._1327_LEVEL)) {
            logger.logp(JeusMessage_TM0._1327_LEVEL, "TMClient", "create", JeusMessage_TM0._1327, (Object)rgtid);
        }
    }

    public static void specifyGTID(byte[] ctx) {
        if (logger.isLoggable(JeusMessage_TM0._1328_LEVEL)) {
            logger.logp(JeusMessage_TM0._1328_LEVEL, "TMClient", "specifyGTID", JeusMessage_TM0._1328, (Object)Utility.getDump((byte[])ctx));
        }
        ((RemoteGTID)contexts.get()).specifyGTID(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void commit() throws RollbackException, HeuristicMixedException, SecurityException, IllegalStateException, SystemException {
        try {
            byte response;
            RemoteGTID rgtid;
            if (logger.isLoggable(JeusMessage_TM0._1329_LEVEL)) {
                logger.logp(JeusMessage_TM0._1329_LEVEL, "TMClient", "commit", JeusMessage_TM0._1329);
            }
            if ((rgtid = (RemoteGTID)contexts.get()) == null) {
                if (!logger.isLoggable(JeusMessage_TM0._1330_LEVEL)) throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM0._1330, (Object)Thread.currentThread()));
                logger.logp(JeusMessage_TM0._1330_LEVEL, "TMClient", "commit", JeusMessage_TM0._1330, (Object)Thread.currentThread());
                throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM0._1330, (Object)Thread.currentThread()));
            }
            if (logger.isLoggable(JeusMessage_TM0._1331_LEVEL)) {
                logger.logp(JeusMessage_TM0._1331_LEVEL, "TMClient", "commit", JeusMessage_TM0._1331, new Object[]{Thread.currentThread(), rgtid});
            }
            rgtid.invalidate();
            if (rgtid.isRollbackOnly()) {
                if (logger.isLoggable(JeusMessage_TM0._1333_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1333_LEVEL, "TMClient", "commit", JeusMessage_TM0._1333);
                }
                TMClient.rollback(rgtid);
                if (!logger.isLoggable(JeusMessage_TM0._1334_LEVEL)) throw new RollbackException();
                logger.logp(JeusMessage_TM0._1334_LEVEL, "TMClient", "commit", JeusMessage_TM0._1334);
                throw new RollbackException();
            }
            if (rgtid.isUnspecified()) {
                if (!logger.isLoggable(JeusMessage_TM0._1335_LEVEL)) return;
                logger.logp(JeusMessage_TM0._1335_LEVEL, "TMClient", "commit", JeusMessage_TM0._1335, (Object)rgtid);
                return;
            }
            try {
                TMLink link = linkManager.getLink(rgtid.getTMInfo());
                responseCollector.put(rgtid, rgtid);
                link.remoteCommit(rgtid.getLTID(), true);
                response = rgtid.collector.waiting(TMConfig.commitTO);
            }
            catch (Throwable t) {
                if (!logger.isLoggable(JeusMessage_TM0._1336_LEVEL)) throw new SystemException();
                logger.logp(JeusMessage_TM0._1336_LEVEL, "TMClient", "commit", JeusMessage_TM0._1336, (Object)rgtid, t);
                throw new SystemException();
            }
            finally {
                responseCollector.remove(rgtid);
            }
            if (logger.isLoggable(JeusMessage_TM0._1337_LEVEL)) {
                logger.logp(JeusMessage_TM0._1337_LEVEL, "TMClient", "commit", JeusMessage_TM0._1337, (Object)TxStatus.getState(response));
            }
            switch (response) {
                case 0: {
                    return;
                }
                case 1: {
                    throw new RollbackException();
                }
                case 4: {
                    throw new HeuristicMixedException();
                }
            }
            return;
        }
        finally {
            contexts.set(null);
        }
    }

    public static void remoteCommitResponse(GTID gtid, byte response) {
        RemoteGTID rgtid;
        if (logger.isLoggable(JeusMessage_TM0._1338_LEVEL)) {
            logger.logp(JeusMessage_TM0._1338_LEVEL, "TMClient", "remoteCommitResponse", JeusMessage_TM0._1338, new Object[]{TxStatus.getState(response), gtid});
        }
        if ((rgtid = (RemoteGTID)responseCollector.get(gtid)) == null) {
            if (logger.isLoggable(JeusMessage_TM0._1339_LEVEL)) {
                logger.logp(JeusMessage_TM0._1339_LEVEL, "TMClient", "remoteCommitResponse", JeusMessage_TM0._1339);
            }
            return;
        }
        rgtid.collector.received(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void rollback(RemoteGTID rgtid) throws IllegalStateException, SecurityException, SystemException {
        try {
            if (rgtid == null) {
                if (logger.isLoggable(JeusMessage_TM0._1340_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1340_LEVEL, "TMClient", "rollback", JeusMessage_TM0._1340, (Object)rgtid);
                }
                if ((rgtid = (RemoteGTID)contexts.get()) == null) {
                    if (logger.isLoggable(JeusMessage_TM0._1341_LEVEL)) {
                        logger.logp(JeusMessage_TM0._1341_LEVEL, "TMClient", "rollback", JeusMessage_TM0._1341, (Object)Thread.currentThread());
                    }
                    throw new IllegalStateException(ErrorMsgManager.getLocalizedString((int)JeusMessage_TM0._1341, (Object)Thread.currentThread()));
                }
                if (logger.isLoggable(JeusMessage_TM0._1342_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1342_LEVEL, "TMClient", "rollback", JeusMessage_TM0._1342, new Object[]{Thread.currentThread(), rgtid});
                }
                rgtid.invalidate();
            }
            if (logger.isLoggable(JeusMessage_TM0._1344_LEVEL)) {
                logger.logp(JeusMessage_TM0._1344_LEVEL, "TMClient", "rollback", JeusMessage_TM0._1344, (Object)rgtid);
            }
            if (rgtid.isUnspecified()) {
                if (logger.isLoggable(JeusMessage_TM0._1345_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1345_LEVEL, "TMClient", "rollback", JeusMessage_TM0._1345, (Object)rgtid);
                }
                return;
            }
            try {
                TMLink link = linkManager.getLink(rgtid.getTMInfo());
                responseCollector.put(rgtid, rgtid);
                link.remoteCommit(rgtid.getLTID(), false);
                rgtid.collector.waiting(TMConfig.commitTO);
            }
            catch (Throwable t) {
                if (logger.isLoggable(JeusMessage_TM0._1346_LEVEL)) {
                    logger.logp(JeusMessage_TM0._1346_LEVEL, "TMClient", "rollback", JeusMessage_TM0._1346, (Object)rgtid, t);
                }
                throw new SystemException();
            }
            finally {
                responseCollector.remove(rgtid);
            }
        }
        finally {
            contexts.set(null);
        }
    }

    public static RemoteGTID getRemoteGTID() {
        RemoteGTID rtgid = (RemoteGTID)contexts.get();
        if (logger.isLoggable(JeusMessage_TM0._1347_LEVEL)) {
            logger.logp(JeusMessage_TM0._1347_LEVEL, "TMClient", "getRemoteGTID", JeusMessage_TM0._1347, new Object[]{Thread.currentThread(), rtgid});
        }
        return rtgid;
    }

    static {
        initialized = false;
        initialSync = new Object();
        tmMin = 2;
        tmMax = 10;
        tmResizingPeriod = 3600000L;
        tmCapacity = 10000;
    }
}

